/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.flameview.tree;

import java.util.ArrayList;
import java.util.List;

public class TraceNode {
    private final int value;
    private final String name;
    private final List<TraceNode> children = new ArrayList<TraceNode>();

    public TraceNode(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public List<TraceNode> getChildren() {
        return this.children;
    }

    public void addChild(TraceNode child) {
        this.children.add(child);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TraceNode other = (TraceNode)obj;
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.value == other.value;
    }

    public String toString() {
        return "TraceNode [name: " + this.name + ", value: " + this.value + ", children: " + this.children.size() + "]";
    }
}

