/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.openjdk.jmc.rjmx.subscription.MRI;

public class SyntheticAttributeToolkit {
    public static Set<ObjectName> lookupMxBeans(MBeanServerConnection connection, String domain, String type) {
        HashSet<ObjectName> mxBeans = new HashSet<ObjectName>();
        try {
            for (ObjectName objectName : connection.queryNames(null, null)) {
                if (!objectName.getDomain().equals(domain) || !type.equals(objectName.getKeyProperty("type"))) continue;
                mxBeans.add(objectName);
            }
        }
        catch (IOException iOException) {}
        return mxBeans;
    }

    public static MRI[] createNotificationDescriptors(MBeanServerConnection connection, Set<ObjectName> mxBeans, String type) {
        ArrayList<MRI> notificationDescriptors = new ArrayList<MRI>();
        block2: for (ObjectName mxBean : mxBeans) {
            try {
                MBeanNotificationInfo[] mBeanNotificationInfoArray = connection.getMBeanInfo(mxBean).getNotifications();
                int n = mBeanNotificationInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MBeanNotificationInfo notification = mBeanNotificationInfoArray[n2];
                    String[] stringArray = notification.getNotifTypes();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String notifType = stringArray[n4];
                        if (notifType.equals(type)) {
                            notificationDescriptors.add(new MRI(MRI.Type.NOTIFICATION, mxBean, type));
                            continue block2;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }
        return notificationDescriptors.toArray(new MRI[notificationDescriptors.size()]);
    }

    public static void subscribeToNotifications(MBeanServerConnection connection, NotificationListener listener, Iterable<? extends ObjectName> beans, String type) {
        for (ObjectName objectName : beans) {
            try {
                connection.addNotificationListener(objectName, listener, SyntheticAttributeToolkit.createNotificationFilter(type), null);
            }
            catch (Exception exception) {}
        }
    }

    private static NotificationFilter createNotificationFilter(String type) {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(type);
        return filter;
    }

    public static void unsubscribeFromNotifications(MBeanServerConnection connection, NotificationListener listener, Iterable<? extends ObjectName> beans) {
        for (ObjectName objectName : beans) {
            try {
                connection.removeNotificationListener(objectName, listener);
            }
            catch (Exception exception) {}
        }
    }
}

