/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.IMRITransformation;
import org.openjdk.jmc.rjmx.subscription.IMRITransformationFactory;
import org.openjdk.jmc.rjmx.subscription.MRI;

public class MRITransformationToolkit {
    static final String TRANSFORMATION_EXTENSION_NAME = "org.openjdk.jmc.rjmx.attributeTransformation";
    static final String TRANSFORMATION_ELEMENT = "attributeTransformation";
    public static final String TRANSFORMATION_NAME_ATTRIBUTE = "transformationName";
    static final String TRANSFORMATION_PROPERTY_ELEMENT = "property";
    static final String TRANSFORMATION_PROPERTY_NAME = "name";
    static final String TRANSFORMATION_PROPERTY_VALUE = "value";
    static final String TRANSFORMATION_PROPERTIES_ELEMENT = "transformationProperties";
    private static final Map<String, IMRITransformationFactory> TRANSFORMATION_FACTORIES = new HashMap<String, IMRITransformationFactory>();

    static {
        MRITransformationToolkit.initializeFromExtensions();
    }

    private MRITransformationToolkit() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    private static void initializeFromExtensions() {
        IExtension[] extensions;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint(TRANSFORMATION_EXTENSION_NAME);
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals(TRANSFORMATION_ELEMENT)) {
                    try {
                        IMRITransformationFactory transformationFactory = (IMRITransformationFactory)config.createExecutableExtension("class");
                        String transformationName = config.getAttribute(TRANSFORMATION_NAME_ATTRIBUTE);
                        Properties props = new Properties();
                        Properties transProps = new Properties();
                        props.put(TRANSFORMATION_NAME_ATTRIBUTE, transformationName);
                        IConfigurationElement[] iConfigurationElementArray2 = config.getChildren();
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement prop = iConfigurationElementArray2[n6];
                            if (prop.getName().equals(TRANSFORMATION_PROPERTY_ELEMENT)) {
                                props.put(prop.getAttribute(TRANSFORMATION_PROPERTY_NAME), prop.getAttribute(TRANSFORMATION_PROPERTY_VALUE));
                            } else if (prop.getName().equals(TRANSFORMATION_PROPERTIES_ELEMENT)) {
                                IConfigurationElement[] iConfigurationElementArray3 = prop.getChildren();
                                int n7 = iConfigurationElementArray3.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IConfigurationElement transProp = iConfigurationElementArray3[n8];
                                    if (transProp.getName().equals(TRANSFORMATION_PROPERTY_ELEMENT)) {
                                        transProps.put(transProp.getAttribute(TRANSFORMATION_PROPERTY_NAME), transProp.getAttribute(TRANSFORMATION_PROPERTY_VALUE));
                                    }
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                        transformationFactory.setFactoryProperties(props, transProps);
                        TRANSFORMATION_FACTORIES.put(transformationName, transformationFactory);
                    }
                    catch (CoreException e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not instantiate attribute transformation factory!", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static IMRITransformation createTransformation(MRI mri) {
        String transformationName = MRITransformationToolkit.getTransformationName(mri);
        if (TRANSFORMATION_FACTORIES.containsKey(transformationName)) {
            Properties properties = MRITransformationToolkit.createProperties(mri);
            return TRANSFORMATION_FACTORIES.get(transformationName).createTransformation(properties);
        }
        RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not instantiate unknown transformation type " + transformationName + "!");
        return null;
    }

    public static Iterable<IMRITransformationFactory> getFactories() {
        return Collections.unmodifiableCollection(TRANSFORMATION_FACTORIES.values());
    }

    private static String getTransformationName(MRI mri) {
        String path = mri.getDataPath();
        int partitionIndex = path.indexOf(63);
        if (partitionIndex >= 0) {
            return path.substring(0, partitionIndex);
        }
        return path;
    }

    private static Properties createProperties(MRI mri) {
        Properties properties = new Properties();
        String path = mri.getDataPath();
        int partitionIndex = path.indexOf(63);
        if (partitionIndex >= 0) {
            path = path.substring(partitionIndex + 1);
            String[] stringArray = path.split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                int equalIndex = property.indexOf(61);
                properties.put(property.substring(0, equalIndex), property.substring(equalIndex + 1));
                ++n2;
            }
        }
        return properties;
    }

    public static void forwardMetadata(IMRIMetadataService metadataService, MRI mri, IMRIMetadata attributeMetadata, String textPattern) {
        metadataService.setMetadata(mri, "DisplayName", NLS.bind((String)textPattern, (Object)attributeMetadata.getMetadata("DisplayName")));
        metadataService.setMetadata(mri, "Description", NLS.bind((String)textPattern, (Object)attributeMetadata.getMetadata("Description")));
        metadataService.setMetadata(mri, "UpdateTime", (String)attributeMetadata.getMetadata("UpdateTime"));
        metadataService.setMetadata(mri, "UnitString", (String)attributeMetadata.getMetadata("UnitString"));
    }
}

