/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FileMRIMetadata {
    private static final String ELEMENT_METADATA_COLLECTION = "metadatacollection";
    private static final String ELEMENT_METADATA = "metadata";
    private static final String ELEMENT_MRI_DATA_PATH = "mri.dataPath";
    private static final String ELEMENT_MRI_OBJECT_NAME = "mri.objectName";
    private static final String ELEMENT_MRI_TYPE = "mri.type";
    private static final String ELEMENT_MRI_QUALIFIED_NAME = "mri.qualifiedName";
    private static final String ELEMENT_DISPLAY_NAME = "displayname";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_UPDATE_TIME = "updatetime";
    private static final String ELEMENT_UNIT_STRING = "unitstring";
    private static final String ELEMENT_COMPOSITE = "composite";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_ARGUMENTS = "arguments";
    private static final String DEFAULT_DISPLAY_NAME = "No name";
    private static final String DEFAULT_DESCRIPTION = "This attribute has no extended description";
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.subscription");
    private final Map<MRI, Map<String, Object>> metadataMap = new HashMap<MRI, Map<String, Object>>();

    FileMRIMetadata() {
    }

    static Map<MRI, Map<String, Object>> readDefaultsFromFile() {
        FileMRIMetadata metadataLoader;
        block9: {
            metadataLoader = new FileMRIMetadata();
            InputStream is = null;
            try {
                try {
                    is = FileMRIMetadata.class.getResourceAsStream("mrimetadata.xml");
                    Document doc = XmlToolkit.loadDocumentFromStream((InputStream)is);
                    List elems = XmlToolkit.getChildElementsByTag((Node)doc.getDocumentElement(), (String)ELEMENT_METADATA_COLLECTION);
                    if (elems.size() != 1 || elems.get(0) == null) {
                        throw new Exception("Could not find the attributes element!");
                    }
                    for (Element e : XmlToolkit.getChildElementsByTag((Node)((Node)elems.get(0)), (String)ELEMENT_METADATA)) {
                        try {
                            metadataLoader.loadMetadataElement(e);
                        }
                        catch (Exception e1) {
                            LOGGER.log(Level.WARNING, "Malformed descriptor in mrimetadata.xml, skipping metadata", e1);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Tried reading mrimetadata.xml, but an exception occurred: " + e.getMessage() + "Extended information about attributes may not be available, " + "and the console will not operate optimally.", e);
                    IOToolkit.closeSilently((Closeable)is);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)is);
        }
        return metadataLoader.metadataMap;
    }

    private void loadMetadataElement(Element e) {
        boolean hasCompositeTag;
        String mriType = XmlToolkit.getSetting((Element)e, (String)ELEMENT_MRI_TYPE, (String)MRI.Type.ATTRIBUTE.getTypeName());
        String mriDataPath = XmlToolkit.getSetting((Element)e, (String)ELEMENT_MRI_DATA_PATH, null);
        String mriObjectName = XmlToolkit.getSetting((Element)e, (String)ELEMENT_MRI_OBJECT_NAME, null);
        String mriQualifiedName = XmlToolkit.getSetting((Element)e, (String)ELEMENT_MRI_QUALIFIED_NAME, null);
        if ((mriDataPath == null || mriObjectName == null) && mriQualifiedName == null) {
            LOGGER.warning("Could not read metadata information properly. [dataPath=" + mriDataPath + ",objectName=" + mriObjectName + "|qualifiedName=null] will not be properly configured.");
            return;
        }
        MRI mri = mriQualifiedName != null ? MRI.createFromQualifiedName(mriQualifiedName) : new MRI(MRI.Type.fromString(mriType), mriObjectName, mriDataPath);
        this.putMetadataForElement(mri, e);
        String updateTime = XmlToolkit.getSetting((Element)e, (String)ELEMENT_UPDATE_TIME, null);
        this.putValue(mri, "UpdateTime", updateTime);
        boolean bl = hasCompositeTag = XmlToolkit.getChildElementOrNull((Element)e, (String)ELEMENT_COMPOSITE) != null;
        if (hasCompositeTag) {
            String rootName = String.valueOf(mri.getDataPath()) + "/";
            for (Element childElement : XmlToolkit.getChildElementsByTag((Node)e, (String)ELEMENT_METADATA)) {
                String childDataPath = XmlToolkit.getSetting((Element)childElement, (String)ELEMENT_MRI_DATA_PATH, (String)"");
                MRI childMri = new MRI(mri.getType(), mri.getObjectName(), String.valueOf(rootName) + childDataPath);
                this.putMetadataForElement(childMri, childElement);
                this.putValue(childMri, "UpdateTime", updateTime);
            }
        }
    }

    private void putMetadataForElement(MRI mri, Element e) {
        List propsList;
        this.putValue(mri, "DisplayName", XmlToolkit.getSetting((Element)e, (String)ELEMENT_DISPLAY_NAME, (String)DEFAULT_DISPLAY_NAME));
        this.putValue(mri, "Description", XmlToolkit.getSetting((Element)e, (String)ELEMENT_DESCRIPTION, (String)DEFAULT_DESCRIPTION));
        String unitString = XmlToolkit.getSetting((Element)e, (String)ELEMENT_UNIT_STRING, null);
        this.putValue(mri, "UnitString", unitString);
        String valueType = XmlToolkit.getSetting((Element)e, (String)ELEMENT_TYPE, null);
        this.putValue(mri, "AttributeType", valueType);
        if (MRIMetadataToolkit.isNumerical(valueType) && unitString == null) {
            LOGGER.warning("Unit is missing for " + mri);
        }
        if ((propsList = XmlToolkit.getChildElementsByTag((Node)e, (String)ELEMENT_ARGUMENTS)).size() != 0) {
            if (propsList.size() != 1) {
                LOGGER.warning("Warning: Found several arguments listings for attribute " + mri.toString() + ". Will use only first.");
            }
            NodeList arguments = ((Element)propsList.get(0)).getChildNodes();
            int i = 0;
            int length = arguments.getLength();
            while (i < length) {
                if (arguments.item(i) instanceof Element) {
                    Element argument = (Element)arguments.item(i);
                    this.putValue(mri, argument.getNodeName(), XmlToolkit.getStringValue((Element)argument));
                }
                ++i;
            }
        }
    }

    private void putValue(MRI mri, String key, Object value) {
        this.metadataMap.computeIfAbsent(mri, k -> new HashMap()).put(key, value);
    }
}

