/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.subscription.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.IPredicate;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.IMRISubscription;
import org.openjdk.jmc.rjmx.subscription.IMRIValueListener;
import org.openjdk.jmc.rjmx.subscription.IUpdatePolicy;
import org.openjdk.jmc.rjmx.subscription.MRIValueEvent;

public abstract class AbstractAttributeSubscription
implements IMRISubscription {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.rjmx.subscription");
    private final IConnectionHandle m_connectionHandle;
    private final Set<IMRIValueListener> m_attributeListenerList = Collections.synchronizedSet(new HashSet(1));
    private final IMRIMetadata m_attributeInfo;
    private MRIValueEvent m_lastEvent;
    private IUpdatePolicy m_updatePolicy;
    private final IPredicate<Object> m_valueFilter;
    private Integer cachedHashCode;

    public AbstractAttributeSubscription(IConnectionHandle connectionHandle, IMRIMetadata info) {
        this.m_connectionHandle = connectionHandle;
        if (info == null || info.getMRI().getObjectName() == null) {
            throw new IllegalArgumentException("Subscriptions may not be created from attribute name references.");
        }
        if (!this.m_connectionHandle.hasService(IMRIMetadataService.class)) {
            throw new IllegalArgumentException("Connection handle must have the IMBeanHelperService for subscriptions to work!");
        }
        this.m_attributeInfo = info;
        this.m_valueFilter = AbstractAttributeSubscription.getValueFilter(info);
    }

    public void addAttributeValueListener(IMRIValueListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener may not be null!");
        }
        if (this.m_attributeListenerList.contains(listener)) {
            throw new IllegalArgumentException("This listener has already been added!");
        }
        this.m_attributeListenerList.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void substituteAttributeValueListener(IMRIValueListener oldListener, IMRIValueListener newListener) {
        if (oldListener == null || newListener == null) {
            throw new NullPointerException("Listeners may not be null!");
        }
        if (oldListener != newListener) {
            Set<IMRIValueListener> set = this.m_attributeListenerList;
            synchronized (set) {
                this.removeAttributeValueListener(oldListener);
                this.addAttributeValueListener(newListener);
            }
        }
    }

    public void removeAttributeValueListener(IMRIValueListener listener) {
        this.m_attributeListenerList.remove(listener);
    }

    public boolean hasAttributeValueListeners() {
        return this.m_attributeListenerList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAttributeChange(MRIValueEvent attributeEvent) {
        IMRIValueListener[] tmpListeners;
        if (attributeEvent == null) {
            return;
        }
        Set<IMRIValueListener> set = this.m_attributeListenerList;
        synchronized (set) {
            tmpListeners = this.m_attributeListenerList.toArray(new IMRIValueListener[this.m_attributeListenerList.size()]);
        }
        IMRIValueListener[] iMRIValueListenerArray = tmpListeners;
        int n = tmpListeners.length;
        int n2 = 0;
        while (n2 < n) {
            IMRIValueListener l = iMRIValueListenerArray[n2];
            l.valueChanged(attributeEvent);
            ++n2;
        }
    }

    @Override
    public IConnectionHandle getConnectionHandle() {
        return this.m_connectionHandle;
    }

    @Override
    public MRIValueEvent getLastMRIValueEvent() {
        return this.m_lastEvent;
    }

    protected void storeAndFireEvent(MRIValueEvent event) {
        if (this.m_valueFilter != null && this.m_valueFilter.evaluate(event.getValue())) {
            LOGGER.log(Level.INFO, "Subscription filtered out value: " + event.getValue());
            return;
        }
        if (this.m_lastEvent != null && event.getTimestamp() < this.m_lastEvent.getTimestamp()) {
            LOGGER.log(Level.INFO, "Subscription dropped attribute event because timestamp was older than last event.");
            return;
        }
        this.m_lastEvent = event;
        this.fireAttributeChange(event);
    }

    @Override
    public IMRIMetadata getMRIMetadata() {
        return this.m_attributeInfo;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractAttributeSubscription) {
            AbstractAttributeSubscription other = (AbstractAttributeSubscription)obj;
            return this.m_connectionHandle.getServerDescriptor().getGUID().equals(other.m_connectionHandle.getServerDescriptor().getGUID()) && this.getMRIMetadata().equals(other.getMRIMetadata());
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = (String.valueOf(this.m_connectionHandle.getServerDescriptor().getGUID()) + this.getMRIMetadata().getMRI().getQualifiedName()).hashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    public IUpdatePolicy getUpdatePolicy() {
        return this.m_updatePolicy;
    }

    @Override
    public void setUpdatePolicy(IUpdatePolicy updatePolicy) {
        this.m_updatePolicy = updatePolicy;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '[' + this.getMRIMetadata() + ']';
    }

    private static IPredicate<Object> getValueFilter(IMRIMetadata metadata) {
        String mri = metadata.getMRI().getQualifiedName();
        if ("attribute://java.lang:type=OperatingSystem/ProcessCpuLoad".equals(mri) || "attribute://java.lang:type=OperatingSystem/SystemCpuLoad".equals(mri) || "attribute://java.lang:type=OperatingSystem/SystemLoadAverage".equals(mri)) {
            return new IPredicate<Object>(){

                public boolean evaluate(Object value) {
                    return !(value instanceof Number) || ((Number)value).doubleValue() < 0.0;
                }
            };
        }
        return null;
    }
}

