/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.rjmx.services.IAttributeInfo;
import org.openjdk.jmc.rjmx.services.IOperation;
import org.openjdk.jmc.rjmx.services.IllegalOperandException;
import org.openjdk.jmc.rjmx.services.internal.AbstractOperation;
import org.openjdk.jmc.rjmx.services.internal.Messages;
import org.openjdk.jmc.rjmx.util.internal.SimpleAttributeInfo;

final class MBeanOperationWrapper
extends AbstractOperation<SimpleAttributeInfo> {
    private static final String IMPACT = ".vmImpact";
    private static final int MAX_DESCRIPTORS = 8;
    private static final int MAX_LINE_LENGTH = 100;
    private static final String ELLIPSIS_STRING = "...";
    private final MBeanServerConnection connection;
    private final ObjectName objectName;

    private MBeanOperationWrapper(MBeanServerConnection connection, ObjectName objectName, MBeanOperationInfo info) {
        super(info.getName(), MBeanOperationWrapper.convertDescription(info), info.getReturnType(), MBeanOperationWrapper.convertArguments(info), MBeanOperationWrapper.convertImpact(info));
        this.connection = connection;
        this.objectName = objectName;
    }

    @Override
    public Callable<?> getInvocator(final Object ... argVals) throws IllegalOperandException {
        List params = this.getSignature();
        final StringBuilder argString = new StringBuilder("(");
        if (argVals.length < params.size()) {
            throw new IllegalOperandException(params.subList(argVals.length, params.size()));
        }
        final String[] sig = new String[params.size()];
        int i = 0;
        while (i < params.size()) {
            sig[i] = ((SimpleAttributeInfo)params.get(i)).getType();
            if (argVals[i] != null) {
                argString.append(' ').append(MBeanOperationWrapper.describeValue(argVals[i])).append(',');
            } else if (TypeHandling.isPrimitive((String)sig[i])) {
                IllegalOperandException ex = new IllegalOperandException((IAttributeInfo)params.get(i));
                while (++i < params.size()) {
                    if (argVals[i] != null || !TypeHandling.isPrimitive((String)((SimpleAttributeInfo)params.get(i)).getType())) continue;
                    ex.addInvalidValue((IAttributeInfo)params.get(i));
                }
                throw ex;
            }
            ++i;
        }
        if (argString.charAt(argString.length() - 1) == ',') {
            argString.deleteCharAt(argString.length() - 1);
        }
        argString.append(" )");
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return MBeanOperationWrapper.this.connection.invoke(MBeanOperationWrapper.this.objectName, MBeanOperationWrapper.this.getName(), argVals, sig);
            }

            public String toString() {
                return String.valueOf(MBeanOperationWrapper.this.getName()) + argString.toString().replace("\n", "\\n").replace("\r", "\\r");
            }
        };
    }

    static Collection<IOperation> createOperations(MBeanServerConnection connection, ObjectName objectName, MBeanOperationInfo[] operations) {
        ArrayList<IOperation> wrappedOperations = new ArrayList<IOperation>();
        MBeanOperationInfo[] mBeanOperationInfoArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanOperationInfo info = mBeanOperationInfoArray[n2];
            wrappedOperations.add(new MBeanOperationWrapper(connection, objectName, info));
            ++n2;
        }
        return wrappedOperations;
    }

    private static String asNonNullNorEmptyString(String string, String defaultString) {
        return string != null && string.trim().length() > 0 ? string : defaultString;
    }

    private static String describeValue(Object o) {
        if (o.getClass().isArray()) {
            return String.valueOf(o.getClass().getComponentType().getName()) + "[" + Array.getLength(o) + "]";
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        return o.toString();
    }

    private static IOperation.OperationImpact convertImpact(MBeanOperationInfo info) {
        String[] stringArray = info.getDescriptor().getFieldNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object impactField;
            String name = stringArray[n2];
            if (name.endsWith(IMPACT) && (impactField = info.getDescriptor().getFieldValue(name)) != null) {
                String impact = impactField.toString();
                if (impact.startsWith("Low")) {
                    return IOperation.OperationImpact.IMPACT_LOW;
                }
                if (impact.startsWith("Medium")) {
                    return IOperation.OperationImpact.IMPACT_MEDIUM;
                }
                if (impact.startsWith("High")) {
                    return IOperation.OperationImpact.IMPACT_HIGH;
                }
            }
            ++n2;
        }
        return IOperation.OperationImpact.IMPACT_UNKNOWN;
    }

    private static List<SimpleAttributeInfo> convertArguments(MBeanOperationInfo info) {
        MBeanParameterInfo[] sign = info.getSignature();
        ArrayList<SimpleAttributeInfo> signature = new ArrayList<SimpleAttributeInfo>(sign.length);
        MBeanParameterInfo[] mBeanParameterInfoArray = sign;
        int n = sign.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanParameterInfo paramInfo = mBeanParameterInfoArray[n2];
            String name = MBeanOperationWrapper.asNonNullNorEmptyString(paramInfo.getName(), MBeanOperationWrapper.asNonNullNorEmptyString(paramInfo.getDescription(), ""));
            signature.add(new SimpleAttributeInfo(name, paramInfo.getType(), MBeanOperationWrapper.convertDescription(paramInfo)));
            ++n2;
        }
        return signature;
    }

    private static String convertDescription(MBeanFeatureInfo info) {
        String[] fields;
        StringBuilder sb = new StringBuilder();
        if (info.getDescriptor() != null && info.getDescriptor().getFields() != null && (fields = info.getDescriptor().getFields()).length > 0) {
            sb.append(Messages.MBeanOperationsWrapper_DESCRIPTOR).append(":\n ");
            int i = 0;
            while (i < Math.min(fields.length, 8)) {
                String str = fields[i];
                int cur = 0;
                int newLine = 0;
                while (cur < str.length() && newLine != -1) {
                    newLine = str.indexOf(10, cur);
                    if (newLine == -1) {
                        sb.append(MBeanOperationWrapper.shorten(str.substring(cur))).append("\n ");
                        continue;
                    }
                    sb.append(MBeanOperationWrapper.shorten(str.substring(cur, newLine))).append("\n ");
                    cur = newLine + 1;
                }
                ++i;
            }
        }
        return String.valueOf(MBeanOperationWrapper.shorten(info.getDescription())) + "\n " + sb.toString().trim();
    }

    private static String shorten(String s) {
        if (s == null) {
            return "";
        }
        if (s.length() > 100) {
            return s.subSequence(0, 100 - ELLIPSIS_STRING.length()) + ELLIPSIS_STRING;
        }
        return s;
    }
}

