/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.descriptorprovider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.remote.JMXServiceURL;
import org.openjdk.jmc.rjmx.IConnectionDescriptor;
import org.openjdk.jmc.rjmx.IServerDescriptor;
import org.openjdk.jmc.rjmx.descriptorprovider.IDescriptorListener;
import org.openjdk.jmc.rjmx.descriptorprovider.IDescriptorProvider;

public abstract class AbstractDescriptorProvider
implements IDescriptorProvider {
    protected List<IDescriptorListener> m_descriptorListeners = Collections.synchronizedList(new ArrayList(1));

    @Override
    public void addDescriptorListener(IDescriptorListener l) {
        this.m_descriptorListeners.add(l);
    }

    @Override
    public void removeDescriptorListener(IDescriptorListener l) {
        this.m_descriptorListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDescriptorDetected(IServerDescriptor serverDescriptor, String path, JMXServiceURL url, IConnectionDescriptor connectionDescriptor) {
        List<IDescriptorListener> list = this.m_descriptorListeners;
        synchronized (list) {
            for (IDescriptorListener listener : this.m_descriptorListeners) {
                if (listener == null) continue;
                listener.onDescriptorDetected(serverDescriptor, path, url, connectionDescriptor, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDescriptorRemoved(String descriptorId) {
        List<IDescriptorListener> list = this.m_descriptorListeners;
        synchronized (list) {
            for (IDescriptorListener listener : this.m_descriptorListeners) {
                if (listener == null) continue;
                listener.onDescriptorRemoved(descriptorId);
            }
        }
    }
}

