/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.openjdk.jmc.greychart.AbstractGreyChart;
import org.openjdk.jmc.greychart.AbstractSeriesPlotRenderer;
import org.openjdk.jmc.greychart.GreyChartPanel;
import org.openjdk.jmc.greychart.SeriesMetadataProvider;
import org.openjdk.jmc.greychart.XYGreyChart;
import org.openjdk.jmc.greychart.XYPlotRenderer;
import org.openjdk.jmc.greychart.YAxis;
import org.openjdk.jmc.greychart.impl.DefaultXYGreyChart;
import org.openjdk.jmc.greychart.impl.LongWorldToDeviceConverter;
import org.openjdk.jmc.greychart.impl.OptimizingProvider;
import org.openjdk.jmc.greychart.impl.WorldToDeviceConverter;
import org.openjdk.jmc.greychart.util.ChartRenderingToolkit;
import org.openjdk.jmc.ui.common.xydata.DataSeries;
import org.openjdk.jmc.ui.common.xydata.IXYData;

public class DefaultXYLineRenderer
extends AbstractSeriesPlotRenderer
implements XYPlotRenderer {
    private Stroke[] m_strokes;
    private boolean m_useClip = true;
    private final Rectangle m_clipRect = new Rectangle(1, 0, 0, 0);
    private boolean drawOnXAxis;
    private boolean extrapolateGraph = true;
    private Paint extrapolationPaint;
    private Stroke extrapolationStroke;
    protected volatile IXYData<? extends Number, ? extends Number> circledValue;
    private int m_circleDiameter = 5;
    private int m_singleValueMarkSize = 4;

    public DefaultXYLineRenderer(XYGreyChart owner) {
        super(owner);
        this.setupDefaultExtrapolationStroke();
        this.setupDefaultExtrapolationPaint();
    }

    @Override
    public void render(Graphics2D ctx, Rectangle targetArea, Rectangle fullgraphArea) {
        if (this.getOwner().getDataProvider() == null) {
            return;
        }
        this.setRenderedBounds(targetArea);
        if (targetArea.width <= 0 || targetArea.height <= 0) {
            return;
        }
        XYGreyChart xychart = (XYGreyChart)this.getOwner();
        Shape clip = ctx.getClip();
        AffineTransform origTrans = ctx.getTransform();
        ctx.translate(targetArea.x, targetArea.y);
        if (this.m_useClip) {
            this.m_clipRect.width = targetArea.width;
            this.m_clipRect.height = targetArea.height;
            ctx.setClip(this.m_clipRect);
        } else if (this.drawOnXAxis) {
            this.m_clipRect.width = targetArea.width;
            this.m_clipRect.height = targetArea.height + 1;
            ctx.setClip(this.m_clipRect);
        }
        this.drawXYChart(ctx, targetArea, (DefaultXYGreyChart)xychart);
        this.drawCircledValue(ctx, (DefaultXYGreyChart)xychart);
        if (GreyChartPanel.DEBUG) {
            ChartRenderingToolkit.markBoundary(ctx, 0, 0, targetArea.width, targetArea.height, Color.RED);
        }
        ctx.setTransform(origTrans);
        ctx.setClip(clip);
    }

    private void setupDefaultExtrapolationPaint() {
        BufferedImage bi = new BufferedImage(5, 5, 1);
        Graphics2D big = bi.createGraphics();
        big.setColor(new Color(255, 255, 255));
        big.fillRect(0, 0, 5, 5);
        big.setColor(new Color(200, 200, 200));
        big.drawLine(0, 0, 5, 5);
        Rectangle rect = new Rectangle(0, 0, 5, 5);
        this.setExtrapolationPaint(new TexturePaint(bi, rect));
    }

    private void setupDefaultExtrapolationStroke() {
        this.setExtrapolationStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{3.0f, 2.0f}, 1.0f));
    }

    private void drawSingleValue(Graphics2D ctx, int x, int y, Color color) {
        int markOffset = this.getSingleValueMarkSize() / 2;
        Color old = ctx.getColor();
        ctx.setColor(color);
        ctx.drawLine(x - markOffset, y - markOffset, x + markOffset, y + markOffset);
        ctx.drawLine(x + markOffset, y - markOffset, x - markOffset, y + markOffset);
        ctx.setColor(old);
    }

    private int getSingleValueMarkSize() {
        return this.m_singleValueMarkSize;
    }

    private void drawCircledValue(Graphics2D ctx, DefaultXYGreyChart xychart) {
        IXYData<? extends Number, ? extends Number> val = this.circledValue;
        if (val != null) {
            int tmpX = ((Number)val.getX()).intValue();
            int tmpY = ((Number)val.getY()).intValue();
            int diameter = this.getCircleDiameter();
            Color old = ctx.getColor();
            ctx.setColor(this.getForeground());
            ctx.drawOval(tmpX - diameter / 2, tmpY - diameter / 2, diameter, diameter);
            ctx.setColor(old);
        }
    }

    private int getCircleDiameter() {
        return this.m_circleDiameter;
    }

    private void drawXYChart(Graphics2D ctx, Rectangle targetArea, DefaultXYGreyChart chart) {
        OptimizingProvider parentOptimizingProvider = chart.getOptimizingProvider();
        LongWorldToDeviceConverter xWorldToDevice = this.createXConverter(parentOptimizingProvider, chart, targetArea.width);
        SeriesMetadataProvider smdp = chart.getMetadataProvider();
        OptimizingProvider[] optimizingProviderArray = parentOptimizingProvider.getChildren();
        int n = optimizingProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider optimizingProvider = optimizingProviderArray[n2];
            DataSeries ds = optimizingProvider.getDataSeries();
            YAxis yAxis = smdp.getYAxis(ds);
            if (yAxis == null) {
                yAxis = chart.getYAxis()[0];
            }
            WorldToDeviceConverter yWorldToDevice = optimizingProvider.getYSampleToDeviceConverterFor(yAxis);
            this.drawSeries(ctx, smdp, yWorldToDevice, xWorldToDevice, optimizingProvider);
            ++n2;
        }
    }

    private void drawSeries(Graphics2D ctx, SeriesMetadataProvider smdp, WorldToDeviceConverter yWorldToDevice, LongWorldToDeviceConverter xWorldToDevice, OptimizingProvider optimizingProvider) {
        Polygon polygon = optimizingProvider.getSamplesPolygon(xWorldToDevice, yWorldToDevice);
        DataSeries ds = optimizingProvider.getDataSeries();
        if (this.extrapolateGraph) {
            this.drawExtrapolatedData(ctx, polygon, smdp, ds, xWorldToDevice, yWorldToDevice);
        }
        if (smdp.getFill(ds)) {
            this.closePolygonToXAxis(polygon, yWorldToDevice.getDeviceCoordinate(0.0));
        }
        this.drawData(ctx, polygon, smdp, ds, xWorldToDevice, yWorldToDevice);
    }

    private LongWorldToDeviceConverter createXConverter(OptimizingProvider optimizingProvider, AbstractGreyChart chart, int width) {
        return new LongWorldToDeviceConverter(0, width, optimizingProvider.getMinX(), optimizingProvider.getMaxX());
    }

    private void drawExtrapolatedData(Graphics2D ctx, Polygon samplesPolygon, SeriesMetadataProvider smdp, DataSeries ds, LongWorldToDeviceConverter xWorldToDeviceConverter, WorldToDeviceConverter yWorldToDeviceConverter) {
        float right = xWorldToDeviceConverter.getDeviceWidth();
        float bottom = yWorldToDeviceConverter.getDeviceCoordinate(0.0);
        if (samplesPolygon.npoints > 0) {
            Color strokeColor;
            int firstY = samplesPolygon.ypoints[0];
            int firstX = samplesPolygon.xpoints[0];
            int lastY = samplesPolygon.ypoints[samplesPolygon.npoints - 1];
            int lastX = samplesPolygon.xpoints[samplesPolygon.npoints - 1];
            Stroke oldStroke = ctx.getStroke();
            Color oldColor = ctx.getColor();
            Color color = strokeColor = smdp.getTopColor(ds) == null ? smdp.getLineColor(ds) : smdp.getTopColor(ds);
            if (smdp.getFill(ds)) {
                ctx.setPaint(this.extrapolationPaint);
                ctx.fillRect(0, firstY, firstX, (int)bottom - firstY);
                ctx.fillRect(lastX, lastY, (int)right - lastX, (int)bottom - lastY);
            }
            ctx.setStroke(this.extrapolationStroke);
            ctx.setColor(strokeColor);
            ctx.drawLine(0, firstY, firstX, firstY);
            ctx.drawLine(lastX, lastY, (int)right, lastY);
            ctx.setStroke(oldStroke);
            ctx.setColor(oldColor);
        }
    }

    private void drawData(Graphics2D ctx, Polygon polygon, SeriesMetadataProvider smdp, DataSeries ds, LongWorldToDeviceConverter xWorldToDeviceConverter, WorldToDeviceConverter yWorldToDeviceConverter) {
        if (polygon.npoints == 1) {
            this.drawSingleValue(ctx, polygon.xpoints[0], polygon.ypoints[0], smdp.getLineColor(ds));
        }
        if (polygon.npoints > 0) {
            if (smdp.getFill(ds)) {
                float top = 0.0f;
                float bottom = yWorldToDeviceConverter.getDeviceCoordinate(0.0);
                ctx.setPaint(new GradientPaint(0.0f, top, smdp.getTopColor(ds), 0.0f, bottom, smdp.getBottomColor(ds)));
                ctx.fillPolygon(polygon);
                if (!smdp.getDrawLine(ds)) {
                    ctx.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
                }
                ctx.setPaint(null);
            }
            if (smdp.getDrawLine(ds)) {
                ctx.setColor(smdp.getLineColor(ds));
                ctx.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
            }
        }
    }

    private void closePolygonToXAxis(Polygon polygon, int xAxisYValue) {
        if (polygon.npoints > 0) {
            polygon.addPoint(polygon.xpoints[polygon.npoints - 1], xAxisYValue);
            polygon.addPoint(polygon.xpoints[0], xAxisYValue);
            polygon.addPoint(polygon.xpoints[0], polygon.ypoints[0]);
        }
    }

    public double getInterpolatedValue(double x, double startX, double endX, double startY, double endY) {
        double x_delta = endX - startX;
        double y_delta = endY - startY;
        if (x_delta > 0.0) {
            return (x - startX) * y_delta / x_delta + startY;
        }
        return 0.0;
    }

    @Override
    public Dimension getPreferredDimensions(Graphics2D ctx, Rectangle totalDrawingArea) {
        return new Dimension(totalDrawingArea.width, totalDrawingArea.height);
    }

    public void setDrawOnXAxis(boolean b) {
        this.drawOnXAxis = b;
    }

    public boolean isDrawOnXAxis() {
        return this.drawOnXAxis;
    }

    public boolean isUseClip() {
        return this.m_useClip;
    }

    public void setUseClip(boolean useClip) {
        this.m_useClip = useClip;
    }

    @Override
    public Stroke getSeriesStroke(int index) {
        if (this.m_strokes == null) {
            return null;
        }
        return this.m_strokes[index % this.m_strokes.length];
    }

    @Override
    public void setSeriesStrokes(Stroke[] strokes) {
        this.m_strokes = strokes;
    }

    public void circleValue(IXYData<? extends Number, ? extends Number> point) {
        this.circledValue = point;
    }

    public void setSingleValueMarkSize(int markSize) {
        this.m_singleValueMarkSize = markSize;
    }

    public void setCircleDiameter(int circleDiameter) {
        this.m_circleDiameter = circleDiameter;
    }

    public void setExtrapolateMissingData(boolean extrapolate) {
        this.extrapolateGraph = extrapolate;
    }

    public boolean getExtrapolateMissnigData() {
        return this.extrapolateGraph;
    }

    public void setExtrapolationPaint(Paint paint) {
        this.extrapolationPaint = paint;
    }

    public Paint getExtrapolationPaint() {
        return this.extrapolationPaint;
    }

    public void setExtrapolationStroke(Stroke stroke) {
        this.extrapolationStroke = stroke;
    }

    public Stroke getExtrapolationStroke() {
        return this.extrapolationStroke;
    }
}

