/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.util;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Environment {
    private static final String OS_NAME = System.getProperty("os.name");
    private static final OSType OS_TYPE = Environment.determineOSType(Environment.getFullOSName());
    private static final boolean IS_DEBUG = Boolean.getBoolean("org.openjdk.jmc.debug");
    private static final int LOCAL_PID = Environment.initPID();

    static {
        if (LOCAL_PID != 0) {
            Logger.getLogger("org.openjdk.jmc.common.mbean").log(Level.FINE, "Acquired local PID. PID resolved to " + LOCAL_PID);
        }
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static String getFullOSName() {
        return OS_NAME;
    }

    public static OSType getOSType() {
        return OS_TYPE;
    }

    public static double getNormalDPI() {
        return OS_TYPE.equals((Object)OSType.MAC) ? 72.0 : 96.0;
    }

    private static OSType determineOSType(String os) {
        if (os == null) {
            return OSType.UNKNOWN;
        }
        if ((os = os.toLowerCase()).contains("win")) {
            return OSType.WINDOWS;
        }
        if (os.contains("mac")) {
            return OSType.MAC;
        }
        if (os.contains("sunos")) {
            return OSType.SOLARIS;
        }
        if (os.contains("linux")) {
            return OSType.LINUX;
        }
        if (os.contains("nix") || os.contains("nux")) {
            return OSType.UNKNOWN_UNIX;
        }
        return OSType.UNKNOWN;
    }

    public static int getThisPID() {
        return LOCAL_PID;
    }

    private static int initPID() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            if (name != null) {
                String s = name.split("@")[0];
                return Integer.parseInt(s);
            }
        }
        catch (Exception e) {
            Logger.getLogger("org.openjdk.jmc.common.mbean").log(Level.FINE, "Could not retrieve PID of this running jvm instance", e);
        }
        return 0;
    }

    public static enum OSType {
        WINDOWS,
        MAC,
        SOLARIS,
        LINUX,
        UNKNOWN_UNIX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

