/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.alert;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.alert.Messages;
import org.openjdk.jmc.alert.TriggerApplicationAlert;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.rjmx.services.IDiagnosticCommandService;
import org.openjdk.jmc.rjmx.triggers.TriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationToolkit;
import org.openjdk.jmc.ui.common.idesupport.IDESupportToolkit;
import org.openjdk.jmc.ui.common.resource.MCFile;

public class TriggerActionThreadStackDump
extends TriggerAction {
    private static final String XML_ELEMENT_LOG_TO_FILE = "log_to_file";
    private static final String XML_ELEMENT_SHOW_APPLICATION_ALERT = "show_application_alert";
    private static final String XML_ELEMENT_APPEND = "append";
    public static final String XML_ELEMENT_LOG_FILE_NAME = "log_filename";
    private TriggerApplicationAlert m_applicationAlertAction;

    public void handleNotificationEvent(TriggerEvent e) throws Exception {
        String stackDump = ((IDiagnosticCommandService)e.getSource().getServiceOrThrow(IDiagnosticCommandService.class)).runCtrlBreakHandlerWithResult("Thread.print");
        TriggerEvent newEvent = new TriggerEvent(e.getSource(), e.getRule(), (Object)stackDump, e.wasTriggered());
        if (this.getShowApplicationAlert()) {
            this.getApplicationAlertAction().handleNotificationEvent(newEvent);
        }
        String data = NotificationToolkit.prettyPrint((TriggerEvent)e);
        data = String.valueOf(data) + stackDump;
        if (this.getLogToFile()) {
            MCFile file = this.getMCFile();
            String jobName = NLS.bind((String)Messages.TriggerActionThreadStackDump_JOB_TITLE_WRITING_STACK_DUMP, (Object)file.getPath());
            if (this.isAppend()) {
                data = String.valueOf(data) + "\n\n";
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            IDESupportToolkit.writeAsJob((String)jobName, (MCFile)file, (InputStream)stream, (boolean)this.isAppend());
        } else {
            System.out.println(data);
        }
    }

    private boolean isAppend() {
        return this.getSetting(XML_ELEMENT_APPEND).getBoolean();
    }

    private TriggerApplicationAlert getApplicationAlertAction() {
        if (this.m_applicationAlertAction == null) {
            this.m_applicationAlertAction = new TriggerApplicationAlert();
        }
        return this.m_applicationAlertAction;
    }

    public boolean getShowApplicationAlert() {
        return this.getSetting(XML_ELEMENT_SHOW_APPLICATION_ALERT).getBoolean();
    }

    public boolean getLogToFile() {
        return this.getSetting(XML_ELEMENT_LOG_TO_FILE).getBoolean();
    }

    public String toString() {
        return this.getName();
    }

    public String getLogFileName() {
        return this.getSetting(XML_ELEMENT_LOG_FILE_NAME).getFileName();
    }

    private MCFile getMCFile() {
        return IDESupportToolkit.createFileResource((String)this.getLogFileName());
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return handle.getServiceOrNull(IDiagnosticCommandService.class) != null;
    }
}

