/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.ui.ItemCollectionToolkit;
import org.openjdk.jmc.flightrecorder.ui.ItemIterableToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.KeyedStream;

public class AggregationGrid {
    private int createdColumns;
    private static final Function<IItem[], IItemIterable> ITEMS_BY_TYPE_CONSTRUCTOR = ia -> ItemIterableToolkit.build(() -> Stream.of(ia), (IType<IItem>)ItemToolkit.getItemType((IItem)ia[0]));

    public static Object getKey(Object row) {
        return row instanceof AggregateRow ? ((AggregateRow)row).key : null;
    }

    public static IQuantity getCount(Object row) {
        return row instanceof AggregateRow ? ((AggregateRow)row).count : null;
    }

    public static IItemCollection getItems(Object row) {
        return ((AggregateRow)row).items;
    }

    public static double getCountFraction(Object row) {
        if (row instanceof AggregateRow) {
            AggregateRow ai = (AggregateRow)row;
            if (ai.model.itemsCount > 0) {
                return ai.count.doubleValue() / (double)ai.model.itemsCount;
            }
        }
        return 0.0;
    }

    public IMemberAccessor<?, Object> addColumn(Function<IItemCollection, ?> valueFunction) {
        return new AggregateColumn(valueFunction, this.createdColumns++);
    }

    private static <T> void addStream(HashMap<T, List<IItem[]>> map, KeyedStream<T, IItem> ks) {
        map.computeIfAbsent(ks.getKey(), k -> new ArrayList()).add((IItem[])ks.getStream().toArray(IItem[]::new));
    }

    private static <T, U extends HashMap<T, List<IItem[]>>> U merge(U map1, U map2) {
        for (Map.Entry<T, List<IItem[]>> e : map2.entrySet()) {
            map1.merge(e.getKey(), e.getValue(), (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            });
        }
        return map1;
    }

    private static <T> Map<T, List<IItem[]>> mapItems(Stream<IItemIterable> items, IAccessorFactory<T> classifier) {
        Stream<HashMap> flatMap = ((Stream)items.parallel()).flatMap(is -> {
            IMemberAccessor accessor = classifier.getAccessor(is.getType());
            if (accessor == null) {
                throw new IllegalArgumentException("Cannot fetch accessor from " + classifier + " for type " + is.getType().getIdentifier());
            }
            Function<IItem, Object> getMemberFunc = arg_0 -> ((IMemberAccessor)accessor).getMember(arg_0);
            return ItemIterableToolkit.parallelStream(is).collect(KeyedStream.collector(getMemberFunc));
        });
        return flatMap.collect(Collector.of(HashMap::new, AggregationGrid::addStream, AggregationGrid::merge, Collector.Characteristics.UNORDERED));
    }

    public static <T, U> Stream<U> mapItems(Stream<IItemIterable> items, IAccessorFactory<T> classifier, BiFunction<T, IItemCollection, U> rowBuilder) {
        return AggregationGrid.mapItems(items, classifier).entrySet().stream().map(e -> rowBuilder.apply(e.getKey(), AggregationGrid.buildItemCollection((List)e.getValue())));
    }

    private static IItemCollection buildItemCollection(List<IItem[]> items) {
        return ItemCollectionToolkit.build(items.stream().map(ITEMS_BY_TYPE_CONSTRUCTOR).collect(Collectors.toList())::stream);
    }

    public <T> Object[] buildRows(Stream<IItemIterable> items, IAccessorFactory<T> classifier) {
        Map<T, List<IItem[]>> itemsMap = AggregationGrid.mapItems(items, classifier);
        AggregationModel model = new AggregationModel(this.createdColumns, itemsMap.size());
        int index = 0;
        for (Map.Entry<T, List<IItem[]>> e : itemsMap.entrySet()) {
            model.addRow(e.getKey(), e.getValue(), index++);
        }
        return model.aggregateItems;
    }

    private static class AggregateColumn
    implements IMemberAccessor<Object, Object> {
        private final Function<IItemCollection, ?> valueFunction;
        private final int columnIndex;

        AggregateColumn(Function<IItemCollection, ?> valueFunction, int columnIndex) {
            this.valueFunction = valueFunction;
            this.columnIndex = columnIndex;
        }

        public Object getMember(Object inObject) {
            if (inObject instanceof AggregateRow) {
                AggregateRow ai = (AggregateRow)inObject;
                if (ai.model.cellData[this.columnIndex] == null) {
                    ai.model.cellData[this.columnIndex] = ((Stream)Arrays.stream(ai.model.aggregateItems).parallel()).map(this::calculateValue).toArray();
                }
                return ai.model.cellData[this.columnIndex][((AggregateRow)inObject).index];
            }
            return null;
        }

        private Object calculateValue(AggregateRow row) {
            return this.valueFunction.apply(row.items);
        }
    }

    public static class AggregateRow {
        final int index;
        final IItemCollection items;
        final Object key;
        final IQuantity count;
        final AggregationModel model;

        AggregateRow(AggregationModel model, Object key, List<IItem[]> itemsByType, int rowIndex) {
            this.model = model;
            this.key = key;
            this.items = AggregationGrid.buildItemCollection(itemsByType);
            this.count = UnitLookup.NUMBER_UNITY.quantity((long)itemsByType.stream().mapToInt(ia -> ((IItem[])ia).length).sum());
            this.index = rowIndex;
        }

        public int hashCode() {
            return Objects.hashCode(this.key);
        }

        public boolean equals(Object obj) {
            return obj instanceof AggregateRow && Objects.equals(this.key, ((AggregateRow)obj).key);
        }
    }

    private static class AggregationModel {
        final Object[][] cellData;
        AggregateRow[] aggregateItems;
        int itemsCount;

        AggregationModel(int columnCount, int rowCount) {
            this.cellData = new Object[columnCount][];
            this.aggregateItems = new AggregateRow[rowCount];
        }

        void addRow(Object key, List<IItem[]> items, int rowIndex) {
            AggregateRow ai;
            this.aggregateItems[rowIndex] = ai = new AggregateRow(this, key, items, rowIndex);
            this.itemsCount = (int)((long)this.itemsCount + ai.count.longValue());
        }
    }
}

