/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.flightrecorder.ui.ItemIterableToolkit;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;

public class ItemCollectionToolkit {
    public static final IItemCollection EMPTY = new StreamBackedItemCollection(() -> Stream.empty());

    public static IItemCollection build(Stream<? extends IItem> items) {
        Map<IType, List<IItem>> byTypeMap = items.collect(Collectors.groupingBy(ItemToolkit::getItemType));
        ArrayList<Map.Entry<IType, List<IItem>>> entryList = new ArrayList<Map.Entry<IType, List<IItem>>>(byTypeMap.entrySet());
        return ItemCollectionToolkit.build(() -> entryList.stream().map(e -> ItemIterableToolkit.build(((List)e.getValue())::stream, (IType<IItem>)((IType)e.getKey()))));
    }

    public static IItemCollection build(Supplier<Stream<IItemIterable>> items) {
        return new StreamBackedItemCollection(items);
    }

    public static IItemCollection merge(Supplier<Stream<IItemCollection>> items) {
        return ItemCollectionToolkit.build(() -> ((Stream)items.get()).flatMap(ItemCollectionToolkit::stream));
    }

    public static <V> Optional<IItemIterable> join(IItemCollection items, String withTypeId) {
        IItemCollection itemsWithType = items.apply(ItemFilters.type((String)withTypeId));
        return ItemCollectionToolkit.stream(itemsWithType).findAny().map(s -> ItemIterableToolkit.build(() -> ItemCollectionToolkit.stream(itemsWithType).flatMap(ItemIterableToolkit::stream), (IType<IItem>)s.getType()));
    }

    public static <T> Supplier<Stream<T>> values(IItemCollection items, IAttribute<T> attribute) {
        return () -> ItemCollectionToolkit.stream(items).flatMap(itemStream -> {
            IMemberAccessor accessor = attribute.getAccessor(itemStream.getType());
            if (accessor != null) {
                return ItemIterableToolkit.stream(itemStream).map(arg_0 -> ((IMemberAccessor)accessor).getMember(arg_0));
            }
            return Stream.empty();
        });
    }

    public static String getDescription(IItemCollection items) {
        Map<IType, Long> itemCountByType = ItemCollectionToolkit.stream(items).filter(IItemIterable::hasItems).collect(Collectors.toMap(IItemIterable::getType, IItemIterable::getItemCount, Long::sum));
        if (itemCountByType.size() < 4) {
            return itemCountByType.entrySet().stream().map(e -> e.getValue() + " " + ((IType)e.getKey()).getName()).sorted().collect(Collectors.joining(", "));
        }
        return MessageFormat.format(Messages.ITEM_COLLECTION_DESC, itemCountByType.values().stream().mapToLong(Long::longValue).sum(), itemCountByType.size());
    }

    public static IItemCollection filterIfNotNull(IItemCollection items, IItemFilter filter) {
        return filter == null ? items : items.apply(filter);
    }

    public static Stream<IItemIterable> stream(IItemCollection items) {
        return StreamSupport.stream(items.spliterator(), false);
    }

    public static Stream<IItemIterable> parallelStream(IItemCollection items) {
        return StreamSupport.stream(items.spliterator(), true);
    }

    private static class StreamBackedItemCollection
    implements IItemCollection {
        private final Supplier<Stream<IItemIterable>> items;

        StreamBackedItemCollection(Supplier<Stream<IItemIterable>> items) {
            this.items = items;
        }

        public Iterator<IItemIterable> iterator() {
            return this.items.get().iterator();
        }

        public Spliterator<IItemIterable> spliterator() {
            return this.items.get().spliterator();
        }

        public StreamBackedItemCollection apply(IItemFilter filter) {
            return new StreamBackedItemCollection(() -> ItemIterableToolkit.filter(this.items.get(), filter));
        }

        public <V, C extends IItemConsumer<C>> V getAggregate(IAggregator<V, C> aggregator) {
            return ItemIterableToolkit.aggregate(aggregator, this.items.get());
        }

        public boolean hasItems() {
            return this.items.get().anyMatch(IItemIterable::hasItems);
        }
    }
}

