/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.IStateful;
import org.openjdk.jmc.common.util.StatefulState;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;

public class DataPageDescriptor
implements IPageDefinition {
    private StatefulState pageState;
    private final String id;
    private final String factoryId;
    private final IDataPageFactory factory;
    private DataPageDescriptor parent = null;
    private final List<DataPageDescriptor> children = new ArrayList<DataPageDescriptor>();

    DataPageDescriptor(DataPageDescriptor source) {
        this(source.id, source.factoryId, source.factory, source.pageState);
    }

    DataPageDescriptor(String id, String factoryId, IDataPageFactory factory, StatefulState pageState) {
        this.id = id;
        this.factoryId = factoryId;
        this.factory = factory;
        this.setPageState(pageState);
    }

    String getId() {
        return this.id;
    }

    String getFactoryId() {
        return this.factoryId;
    }

    String getHelpContextId() {
        int index = this.id.lastIndexOf(46);
        if (index != -1 && Platform.getBundle((String)this.id.substring(0, index)) != null) {
            return this.id;
        }
        return this.factoryId;
    }

    void setPageState(StatefulState state) {
        this.pageState = state == null ? StatefulState.create(writableState -> this.factory.resetToDefault((IState)this.pageState, writableState)) : state;
    }

    DataPageDescriptor getParent() {
        return this.parent;
    }

    void setParent(DataPageDescriptor parent) {
        this.parent = parent;
    }

    List<DataPageDescriptor> getChildList() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public DataPageDescriptor[] getChildren() {
        return this.children.toArray(new DataPageDescriptor[this.children.size()]);
    }

    boolean contains(DataPageDescriptor dpd) {
        return dpd == this || dpd.parent != null && this.contains(dpd.parent);
    }

    @Override
    public IState getState() {
        return this.getPageState();
    }

    StatefulState getPageState() {
        return this.pageState;
    }

    void readPageStateFrom(IStateful page) {
        this.pageState = StatefulState.create((IStateful)page);
    }

    IDisplayablePage createPage(StreamModel items, IPageContainer editor) {
        return this.factory.createPage(this, items, editor);
    }

    @Override
    public String getName() {
        return this.factory.getName((IState)this.pageState);
    }

    @Override
    public String getDescription() {
        return this.factory.getDescription((IState)this.pageState);
    }

    @Override
    public String[] getTopics() {
        return this.factory.getTopics((IState)this.pageState);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.factory.getImageDescriptor((IState)this.pageState);
    }

    public String toString() {
        return String.valueOf(this.getId()) + " children:" + String.valueOf(this.children);
    }
}

