/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.osgi.extension;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWiring;

public class ExtClassLoaderHook
extends ClassLoaderHook {
    private static final String SWT_SYMBOLIC_NAME = "org.eclipse.swt";
    private static final String FX_SWT_SYMBOLIC_NAME = "javafx.swt";
    private static final String JAVAFX_SWT_JAR__NAME = "javafx-swt.jar";
    private BundleContext bundleContext;
    private ClassLoader classLoader;

    public Class<?> postFindClass(String name, ModuleClassLoader moduleClassLoader) throws ClassNotFoundException {
        if (name.startsWith("javafx.embed")) {
            if (this.classLoader == null) {
                Path path = Paths.get(System.getProperty("java.home"), new String[0]).resolve("lib").resolve(JAVAFX_SWT_JAR__NAME);
                ClassLoader defaultClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
                Class<?> moduleFinderClass = defaultClassLoader.loadClass("java.lang.module.ModuleFinder");
                Class<?> moduleLayerClass = defaultClassLoader.loadClass("java.lang.ModuleLayer");
                Class<?> configurationClass = defaultClassLoader.loadClass("java.lang.module.Configuration");
                try {
                    Object discover = moduleFinderClass.getMethod("of", Path[].class).invoke(null, new Object[]{new Path[]{path}});
                    Object bootLayer = moduleLayerClass.getMethod("boot", new Class[0]).invoke(null, new Object[0]);
                    Object configuration = moduleLayerClass.getMethod("configuration", new Class[0]).invoke(bootLayer, new Object[0]);
                    Object of = moduleFinderClass.getMethod("of", Path[].class).invoke(null, new Object[]{new Path[0]});
                    HashSet<String> roots = new HashSet<String>();
                    roots.add(FX_SWT_SYMBOLIC_NAME);
                    Object cf = configurationClass.getMethod("resolve", moduleFinderClass, moduleFinderClass, Collection.class).invoke(configuration, discover, of, roots);
                    Object newModuleLayer = moduleLayerClass.getMethod("defineModulesWithOneLoader", configurationClass, ClassLoader.class).invoke(bootLayer, cf, this.getWiredSWTClassLoader());
                    this.classLoader = (ClassLoader)moduleLayerClass.getMethod("findLoader", String.class).invoke(newModuleLayer, FX_SWT_SYMBOLIC_NAME);
                }
                catch (Throwable t) {
                    System.err.println(t.getMessage());
                }
            }
            return this.classLoader.loadClass(name);
        }
        return super.postFindClass(name, moduleClassLoader);
    }

    public ModuleClassLoader createClassLoader(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
        if (this.bundleContext == null) {
            this.bundleContext = generation.getBundleInfo().getStorage().getModuleContainer().getFrameworkWiring().getBundle().getBundleContext();
        }
        return super.createClassLoader(parent, configuration, delegate, generation);
    }

    private ClassLoader getWiredSWTClassLoader() {
        try {
            Bundle[] bundleArray = this.bundleContext.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (SWT_SYMBOLIC_NAME.equals(bundle.getSymbolicName()) && (bundle.getState() & 2) == 0) {
                    if ((bundle.getState() & 0x20) != 0) {
                        try {
                            bundle.start();
                        }
                        catch (BundleException e) {
                            e.printStackTrace();
                        }
                    }
                    return ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
        }
        return null;
    }
}

