/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.mbeanbrowser.notifications;

import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanNotificationInfo;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.console.ui.mbeanbrowser.notifications.InformationProvider;
import org.openjdk.jmc.console.ui.mbeanbrowser.notifications.Messages;
import org.openjdk.jmc.console.ui.mbeanbrowser.notifications.NotificationsModel;
import org.openjdk.jmc.rjmx.IConnectionHandle;
import org.openjdk.jmc.ui.handlers.CopySelectionAction;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.CopySettings;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.FormatToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;

public class NotificationInfoSectionPart {
    private NotificationsModel m_model;
    private Button m_subscribeButton;
    private final TreeViewer viewer;

    public NotificationInfoSectionPart(Composite parent, FormToolkit toolkit, IConnectionHandle connectionHandle) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.NotificationInfoSectionPart_NOTICATION_INFORMATION_TITLE_TEXT);
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Tree tree = new Tree(container, 68354);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new InformationProvider());
        this.viewer.setAutoExpandLevel(-1);
        ColumnLabelProvider lp = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MBeanNotificationInfo) {
                    MBeanNotificationInfo info = (MBeanNotificationInfo)element;
                    return String.format("%s [%s]", info.getDescription(), info.getName());
                }
                return super.getText(element);
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)lp);
        CopySelectionAction copyAction = new CopySelectionAction((StructuredViewer)this.viewer, FormatToolkit.selectionFormatter((ILabelProvider[])new ILabelProvider[]{lp}));
        InFocusHandlerActivator.install((Control)tree, (IAction)copyAction);
        IContributionItem copyMenu = CopySettings.getInstance().createContributionItem();
        MCContextMenuManager.create((Control)tree).addAll(new IContributionItem[]{new ActionContributionItem((IAction)copyAction), copyMenu});
        Composite buttonContainer = toolkit.createComposite(container);
        buttonContainer.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        Button button = this.createSubscribeButton(toolkit, buttonContainer, connectionHandle);
        button.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false));
        buttonContainer.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        buttonContainer.setLayoutData((Object)new GridData(4, 4, false, true));
    }

    private Button createSubscribeButton(FormToolkit toolkit, Composite parent, final IConnectionHandle connectionHandle) {
        this.m_subscribeButton = toolkit.createButton(parent, Messages.NotificationInfoSectionPart_SUBSCRIBE_BUTTON_TEXT, 32);
        this.m_subscribeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NotificationInfoSectionPart.this.m_model != null) {
                    String errorTitle = Messages.NotificationInfoSectionPart_ERROR_REMOVING_JMX_SUBSCRIPTION_TEXT;
                    if (!NotificationInfoSectionPart.this.m_model.getSubscriptionEnabled()) {
                        errorTitle = Messages.NotificationInfoSectionPart_ERROR_ENABLE_JMX_SUBSCRIPTION_TEXT;
                    }
                    try {
                        NotificationInfoSectionPart.this.m_model.setSubscriptionEnabled(!NotificationInfoSectionPart.this.m_model.getSubscriptionEnabled());
                    }
                    catch (IOException e1) {
                        this.handleException(errorTitle, e1);
                    }
                    catch (JMException e1) {
                        this.handleException(errorTitle, e1);
                    }
                }
            }

            private void handleException(String errorTitle, Exception e) {
                if (connectionHandle.isConnected()) {
                    DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)errorTitle, (String)e.getMessage(), (Throwable)e);
                } else {
                    NotificationInfoSectionPart.this.m_subscribeButton.setSelection(false);
                    NotificationInfoSectionPart.this.m_subscribeButton.setEnabled(false);
                }
            }
        });
        return this.m_subscribeButton;
    }

    public void setModel(NotificationsModel model) {
        this.m_model = model;
        this.viewer.setInput((Object)model);
        this.m_subscribeButton.setSelection(model != null && model.getSubscriptionEnabled());
        this.m_subscribeButton.setEnabled(model != null && model.supportsSubscriptions());
    }
}

