/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.viewers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.ui.model.MemoryStatisticsItem;
import org.openjdk.jmc.joverflow.ui.model.ObjectCluster;
import org.openjdk.jmc.joverflow.ui.swt.ArcItem;
import org.openjdk.jmc.joverflow.ui.swt.FilterList;
import org.openjdk.jmc.joverflow.ui.util.ColorIndexedArcAttributeProvider;
import org.openjdk.jmc.joverflow.ui.viewers.BaseViewer;
import org.openjdk.jmc.joverflow.ui.viewers.MemoryStatisticsTableViewer;
import org.openjdk.jmc.joverflow.ui.viewers.PieChartViewer;

public class ClusterGroupViewer
extends BaseViewer {
    private final SashForm mContainer;
    private final Label mTitle;
    private final PieChartViewer mPieChart;
    private final FilterList<ObjectCluster> mFilterList;
    private final MemoryStatisticsTableViewer mTableViewer;
    private String mQualifierName;
    private final Map<Object, MemoryStatisticsItem> items = new HashMap<Object, MemoryStatisticsItem>();
    private boolean mAllIncluded = false;

    public ClusterGroupViewer(Composite parent, int style) {
        this.mContainer = new SashForm(parent, style);
        Composite leftContainer = new Composite((Composite)this.mContainer, 2048);
        leftContainer.setLayout((Layout)new FormLayout());
        this.mTitle = new Label(leftContainer, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        this.mTitle.setLayoutData((Object)data);
        SashForm container = new SashForm(leftContainer, 512);
        FormData fd_sashForm = new FormData();
        fd_sashForm.top = new FormAttachment((Control)this.mTitle, 10);
        fd_sashForm.right = new FormAttachment(100, -10);
        fd_sashForm.bottom = new FormAttachment(100, -10);
        fd_sashForm.left = new FormAttachment(0, 10);
        container.setLayoutData((Object)fd_sashForm);
        this.mPieChart = new PieChartViewer((Composite)container, 0);
        this.mPieChart.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColorIndexedArcAttributeProvider provider = new ColorIndexedArcAttributeProvider(){

            @Override
            public int getWeight(Object element) {
                return (int)((MemoryStatisticsItem)element).getMemory();
            }
        };
        provider.setMinimumArcAngle(5);
        this.mPieChart.setArcAttributeProvider(provider);
        this.mPieChart.setMinimumArcAngle(5);
        this.mPieChart.getPieChart().setZoomRatio(1.2);
        this.mPieChart.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return (int)(((MemoryStatisticsItem)e2).getMemory() - ((MemoryStatisticsItem)e1).getMemory());
            }
        });
        this.mFilterList = new FilterList((Composite)container, 0);
        this.mFilterList.addFilterChangedListener(this::notifyFilterChangedListeners);
        container.setWeights(new int[]{3, 2});
        Composite tableContainer = new Composite((Composite)this.mContainer, 2048);
        tableContainer.setLayout((Layout)new FillLayout(256));
        this.mTableViewer = new MemoryStatisticsTableViewer(tableContainer, 0);
        final BiConsumer<MemoryStatisticsItem, Boolean> addFilter = (item, exclusion) -> {
            if (item.getId() == null) {
                return;
            }
            this.mFilterList.addFilter(new Predicate<ObjectCluster>(exclusion){
                final String qualifierName;
                final String itemName;
                final boolean excluded;
                {
                    this.qualifierName = ClusterGroupViewer.this.mQualifierName;
                    this.itemName = memoryStatisticsItem.getId().toString();
                    this.excluded = bl;
                }

                @Override
                public boolean test(ObjectCluster oc) {
                    if (this.qualifierName == null) {
                        return this.itemName.equals(oc.getClassName()) ^ this.excluded;
                    }
                    if (oc.getQualifier() == null) {
                        return true;
                    }
                    return this.itemName.equals(oc.getQualifier()) ^ this.excluded;
                }

                public String toString() {
                    return String.valueOf(this.qualifierName == null ? "Class" : ClusterGroupViewer.this.mQualifierName) + (this.excluded ? " \u2260 " : " = ") + item.getId().toString();
                }

                public int hashCode() {
                    return this.itemName.hashCode();
                }

                public boolean equals(Object obj) {
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    return this.hashCode() == obj.hashCode();
                }
            });
        };
        this.mPieChart.getPieChart().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                ArcItem item = ClusterGroupViewer.this.mPieChart.getPieChart().getHighlightedItem();
                if (item == null) {
                    return;
                }
                if (item.getData() == null) {
                    return;
                }
                addFilter.accept((MemoryStatisticsItem)item.getData(), e.button != 1);
            }
        });
        this.mTableViewer.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (e.button != 1 && e.button != 3) {
                    return;
                }
                if (ClusterGroupViewer.this.mTableViewer.getSelection().isEmpty()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)ClusterGroupViewer.this.mTableViewer.getSelection();
                MemoryStatisticsItem item = (MemoryStatisticsItem)selection.getFirstElement();
                addFilter.accept(item, e.button != 1);
            }
        });
        this.mContainer.setWeights(new int[]{1, 2});
        this.mTableViewer.setPieChartViewer(this.mPieChart);
        this.mPieChart.setTableViewer(this.mTableViewer);
    }

    public Control getControl() {
        return this.mContainer;
    }

    public ISelection getSelection() {
        return this.mTableViewer.getSelection();
    }

    public void refresh() {
        this.mTableViewer.refresh();
        this.mPieChart.refresh();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.mTableViewer.setSelection(selection, reveal);
        this.mPieChart.setSelection(selection, reveal);
    }

    @Override
    public void include(ObjectCluster oc, RefChainElement ref) {
        String s;
        MemoryStatisticsItem item;
        if (this.mAllIncluded) {
            for (MemoryStatisticsItem item2 : this.items.values()) {
                item2.reset();
            }
            this.mAllIncluded = false;
        }
        if ((item = this.items.get(s = this.mQualifierName != null ? oc.getQualifier() : oc.getClassName())) == null) {
            item = new MemoryStatisticsItem(s, 0L, 0L, 0);
            this.items.put(s, item);
        }
        item.addObjectCluster(oc);
    }

    @Override
    public void allIncluded() {
        Collection<MemoryStatisticsItem> values = this.items.values();
        ((MemoryStatisticsTableViewer.MemoryStatisticsContentProvider)this.mTableViewer.getContentProvider()).setInput(values);
        this.mPieChart.setInput(values);
        this.mAllIncluded = true;
    }

    public void setQualifierName(String qualifierName) {
        this.mQualifierName = qualifierName;
        String text = qualifierName != null ? qualifierName : "Class";
        this.mTitle.setText(text);
        this.mTableViewer.setPrimaryColumnText(text);
    }

    @Override
    public void setHeapSize(long size) {
        this.mTableViewer.setHeapSize(size);
    }

    @Override
    public boolean filter(ObjectCluster oc) {
        return this.mFilterList.filter(oc);
    }

    @Override
    public void reset() {
        this.mFilterList.reset();
    }
}

