/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaLazyReadObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.HeapDumpReader;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;
import org.openjdk.jmc.joverflow.stats.StandardStatsCalculator;
import org.openjdk.jmc.joverflow.support.Constants;
import org.openjdk.jmc.joverflow.support.HeapStats;
import org.openjdk.jmc.joverflow.support.ProblemRecorder;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.ui.model.ClusterType;
import org.openjdk.jmc.joverflow.ui.model.ModelLoaderListener;
import org.openjdk.jmc.joverflow.ui.model.ObjectClusterImpl;
import org.openjdk.jmc.joverflow.ui.model.ReferenceChain;
import org.openjdk.jmc.joverflow.util.StringInterner;
import org.openjdk.jmc.joverflow.util.VerboseOutputCollector;

public class ModelLoader
implements ProblemRecorder,
Runnable {
    private final String fileName;
    private Map<RefChainElement, Map<ClusterType, Map<String, ObjectClusterImpl>>> clusterMap = new IdentityHashMap<RefChainElement, Map<ClusterType, Map<String, ObjectClusterImpl>>>();
    private HeapDumpReader reader;
    private StandardStatsCalculator calculator;
    private ModelLoaderListener loaderListener;

    static {
        Snapshot.Builder.setObjTableSizePolicy(hprofFileSize -> (int)(Math.pow(hprofFileSize, 0.93) / 70.0));
    }

    public ModelLoader(String fileName, ModelLoaderListener loaderListener) {
        this.fileName = fileName;
        this.loaderListener = loaderListener;
    }

    @Override
    public void run() {
        ScheduledExecutorService es = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> progressUpdater = es.scheduleAtFixedRate(() -> {
            try {
                this.getLoaderListener().onProgressUpdate(this.getProgress());
            }
            catch (HprofParsingCancelledException hprofParsingCancelledException) {}
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        Snapshot snapshot = null;
        try {
            try {
                ReadBuffer.CachedReadBufferFactory factory = new ReadBuffer.CachedReadBufferFactory(this.fileName, ModelLoader.calculateReadBufMemory());
                HeapDumpReader reader = HeapDumpReader.createReader((ReadBuffer.Factory)factory, (int)0, (VerboseOutputCollector)new VerboseOutputCollector());
                this.setReader(reader);
                snapshot = reader.read();
                JavaClass.setFieldBanned((JavaClass)snapshot.getClassForName("java.lang.ref.WeakReference"), (String)"referent");
                StandardStatsCalculator dsc = new StandardStatsCalculator(snapshot, (ProblemRecorder)this, true);
                this.setCalculator(dsc);
                dsc.calculate();
                snapshot.discard();
                snapshot.resetReadBuffer((ReadBuffer.Factory)new ReadBuffer.CachedReadBufferFactory(this.fileName, 0x1900000));
                this.getLoaderListener().onModelLoaded(snapshot, this.buildModel());
            }
            catch (HprofParsingCancelledException hprofParsingCancelledException) {
                if (snapshot != null) {
                    snapshot.discard();
                }
                progressUpdater.cancel(true);
                es.shutdown();
            }
            catch (Throwable e) {
                if (snapshot != null) {
                    snapshot.discard();
                }
                try {
                    this.getLoaderListener().onModelLoadFailed(e);
                }
                catch (HprofParsingCancelledException hprofParsingCancelledException) {}
                progressUpdater.cancel(true);
                es.shutdown();
            }
        }
        finally {
            progressUpdater.cancel(true);
            es.shutdown();
        }
    }

    public synchronized void cancel() {
        if (this.reader != null) {
            this.reader.cancelReading();
        }
        if (this.calculator != null) {
            this.calculator.cancelCalculation();
        }
        this.loaderListener = null;
    }

    public void initialize(Snapshot snapshot, HeapStats hs) {
    }

    public void recordDuplicateArray(JavaValueArray obj, int ovhd, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.DUPLICATE_ARRAY, cn, obj.valueAsString(true));
        p.addObject(obj.getGlobalObjectIndex(), obj.getSize(), ovhd);
        ObjectClusterImpl np = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        np.addObject(obj.getGlobalObjectIndex(), obj.getSize(), 0);
    }

    public void recordDuplicateString(JavaObject obj, String val, int implInclusiveSize, int ovhd, boolean hasDupCharArray, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.DUPLICATE_STRING, cn, obj.valueAsString());
        p.addObject(obj.getGlobalObjectIndex(), implInclusiveSize, ovhd);
        ObjectClusterImpl np = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        np.addObject(obj.getGlobalObjectIndex(), implInclusiveSize, 0);
    }

    public void recordGoodCollection(JavaLazyReadObject obj, CollectionInstanceDescriptor colDesc, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        p.addObject(obj.getGlobalObjectIndex(), colDesc.getImplSize(), 0);
    }

    public void recordGoodInstance(JavaObject obj, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        p.addObject(obj.getGlobalObjectIndex(), obj.getSize(), 0);
    }

    public void recordNonDuplicateArray(JavaValueArray obj, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        p.addObject(obj.getGlobalObjectIndex(), obj.getSize(), 0);
    }

    public void recordNonDuplicateString(JavaObject obj, int implInclusiveSize, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        p.addObject(obj.getGlobalObjectIndex(), implInclusiveSize, 0);
    }

    public void recordProblematicCollection(JavaLazyReadObject obj, CollectionInstanceDescriptor colDesc, Constants.ProblemKind ovhdKind, int ovhd, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.fromProblemKind(ovhdKind), cn, null);
        p.addObject(obj.getGlobalObjectIndex(), colDesc.getImplSize(), ovhd);
        ObjectClusterImpl np = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        np.addObject(obj.getGlobalObjectIndex(), colDesc.getImplSize(), 0);
    }

    public void recordWeakHashMapWithBackRefs(JavaObject obj, CollectionInstanceDescriptor colDesc, int ovhd, String valueTypeAndFieldSample, RefChainElement referer) {
        String cn = obj.getClazz().getHumanFriendlyName();
        ObjectClusterImpl p = this.getObjectCluster(referer, ClusterType.WEAK_MAP_WITH_BACK_REFS, cn, null);
        p.addObject(obj.getGlobalObjectIndex(), obj.getSize(), ovhd);
        ObjectClusterImpl np = this.getObjectCluster(referer, ClusterType.ALL_OBJECTS, cn, null);
        np.addObject(obj.getGlobalObjectIndex(), obj.getSize(), 0);
    }

    private Collection<ReferenceChain> buildModel() {
        ArrayList<ReferenceChain> sums = new ArrayList<ReferenceChain>();
        Iterator<Map.Entry<RefChainElement, Map<ClusterType, Map<String, ObjectClusterImpl>>>> clusterIterator = this.clusterMap.entrySet().iterator();
        while (clusterIterator.hasNext()) {
            Map.Entry<RefChainElement, Map<ClusterType, Map<String, ObjectClusterImpl>>> e = clusterIterator.next();
            ReferenceChain summary = new ReferenceChain(e.getKey());
            for (Map<String, ObjectClusterImpl> s : e.getValue().values()) {
                for (ObjectClusterImpl j : s.values()) {
                    j.trim();
                    summary.add(j);
                }
            }
            clusterIterator.remove();
            summary.trim();
            sums.add(summary);
        }
        this.clusterMap = null;
        sums.trimToSize();
        return sums;
    }

    private ObjectClusterImpl getObjectCluster(RefChainElement referrer, ClusterType type, String className, String qualifier) {
        String id;
        Map m1 = this.clusterMap.computeIfAbsent(referrer, k -> new HashMap());
        Map m2 = m1.computeIfAbsent(type, k -> new HashMap());
        ObjectClusterImpl p = (ObjectClusterImpl)m2.get(id = StringInterner.internString((String)(String.valueOf(className) + "|" + qualifier)));
        if (p == null) {
            p = new ObjectClusterImpl(type, className, qualifier == null ? null : qualifier.intern());
            m2.put(id, p);
        }
        return p;
    }

    private synchronized ModelLoaderListener getLoaderListener() throws HprofParsingCancelledException {
        if (this.loaderListener == null) {
            throw new HprofParsingCancelledException();
        }
        return this.loaderListener;
    }

    private synchronized double getProgress() {
        return (this.reader == null ? 0.0 : (double)this.reader.getProgressPercentage() / 200.0) + (this.calculator == null ? 0.0 : (double)this.calculator.getProgressPercentage() / 200.0);
    }

    private synchronized void setCalculator(StandardStatsCalculator dsc) {
        this.calculator = dsc;
    }

    private synchronized void setReader(HeapDumpReader reader) {
        this.reader = reader;
    }

    private static int calculateReadBufMemory() {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        long availableMemory = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        return (int)Math.min(1048576000L, availableMemory / 3L);
    }

    public boolean shouldRecordGoodInstance(JavaObject obj) {
        return true;
    }
}

