/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui;

import java.io.Closeable;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPathEditorInput;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.actionprovider.IActionFactory;
import org.openjdk.jmc.ui.MCPathEditorInput;
import org.openjdk.jmc.ui.WorkbenchToolkit;
import org.openjdk.jmc.ui.common.CorePlugin;
import org.openjdk.jmc.ui.common.action.Executable;
import org.openjdk.jmc.ui.common.util.Filename;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class HeapDumpAction
implements IActionFactory {
    private static final String DEFAULT_FILENAME = "dump_";
    private static final String HPROF_FILE_EXTENSION = "hprof";

    public Executable createAction(IServerHandle serverHandle) {
        return () -> HeapDumpAction.lambda$0(serverHandle);
    }

    private static FileOpener getFileOpener(boolean forLocalServer) {
        if (forLocalServer) {
            FileOpener opener = new FileOpener();
            File dir = CorePlugin.getDefault().getWorkspaceDirectory();
            Filename filename = new Filename(DEFAULT_FILENAME, HPROF_FILE_EXTENSION);
            opener.file = new File(dir, filename.toString());
            while (opener.file.exists()) {
                opener.file = new File(dir, filename.asRandomFilename().toString());
            }
            return opener;
        }
        FileOpener opener = new FileOpener(){

            @Override
            public void run() {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                if (this.file.exists()) {
                    dialog.setFilterPath(this.file.getPath());
                }
                dialog.setFilterExtensions(new String[]{"*.hprof"});
                dialog.setText("Locate the hprof file on your local filesystem");
                String filePath = dialog.open();
                if (filePath != null) {
                    this.file = new File(filePath);
                    super.run();
                }
            }
        };
        DisplayToolkit.safeSyncExec(() -> {
            InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Enter a destination file", "Enter a path to the destination file in the remote filesystem. You will have to make the file available in the local filesystem manually, for example by moving it or using a shared filesystem.", "", null);
            if (dialog.open() == 0) {
                String s = dialog.getValue();
                fileOpener.file = new File(s.endsWith(HPROF_FILE_EXTENSION) ? s : String.valueOf(s) + "." + HPROF_FILE_EXTENSION);
            }
        });
        return opener;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$0(IServerHandle var0) throws Exception {
        block7: {
            block6: {
                connector = null;
                try {
                    try {
                        jvmInfo = var0.getServerDescriptor().getJvmInfo();
                        opener = HeapDumpAction.getFileOpener(jvmInfo != null && jvmInfo.isAttachable() != false);
                        if (opener.file != null) {
                            connector = var0.connect("Create Heap Dump");
                            connection = (MBeanServerConnection)connector.getServiceOrThrow(MBeanServerConnection.class);
                            params = new Object[]{opener.file.getAbsolutePath(), Boolean.TRUE};
                            sig = new String[]{String.class.getName(), Boolean.TYPE.getName()};
                            connection.invoke(new ObjectName("com.sun.management:type=HotSpotDiagnostic"), "dumpHeap", params, sig);
                            DisplayToolkit.safeAsyncExec((Runnable)opener);
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        root = e;
                        ** while (root.getCause() != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        root = root.getCause();
                        continue;
                    }
lbl20:
                    // 1 sources

                    message = root.getMessage() != null ? root.getMessage() : root.toString();
                    DisplayToolkit.safeAsyncExec((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$1(java.lang.String ), ()V)((String)message));
                }
                catch (Throwable var7_10) {
                    IOToolkit.closeSilently(connector);
                    throw var7_10;
                }
                IOToolkit.closeSilently((Closeable)connector);
                break block7;
            }
            IOToolkit.closeSilently(connector);
        }
    }

    private static /* synthetic */ void lambda$1(String string) {
        DialogToolkit.showError((Shell)Display.getCurrent().getActiveShell(), (String)"Failed to create Heap Dump", (String)string);
    }

    private static class FileOpener
    implements Runnable {
        File file;

        private FileOpener() {
        }

        @Override
        public void run() {
            WorkbenchToolkit.openEditor((IPathEditorInput)new MCPathEditorInput(this.file, false));
        }

        /* synthetic */ FileOpener(FileOpener fileOpener, FileOpener fileOpener2) {
            this();
        }
    }
}

