/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.List;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.stats.InterimRefChain;
import org.openjdk.jmc.joverflow.support.DupArrayStats;
import org.openjdk.jmc.joverflow.util.ValueWitIntIdMap;

public class DupArrayHandler {
    private final ValueWitIntIdMap<DupArrayStats.Entry> dupArrays;
    private final InterimRefChain refChain;

    DupArrayHandler(List<DupArrayStats.Entry> dupArrayList, InterimRefChain refChain) {
        this.dupArrays = new ValueWitIntIdMap(dupArrayList.size());
        for (DupArrayStats.Entry entry : dupArrayList) {
            this.dupArrays.put(entry);
        }
        this.refChain = refChain;
    }

    boolean handleArray(JavaValueArray array) {
        boolean isDuplicate;
        int internalId = array.getInternalId();
        DupArrayStats.Entry ae = this.dupArrays.get(internalId);
        boolean bl = isDuplicate = ae != null;
        if (isDuplicate) {
            int ovhd = ae.getOvhdForNextArrayCopy();
            this.refChain.recordCurrentRefChainForDupArray(array, ovhd);
        } else {
            this.refChain.recordCurrentRefChainForNonDupArray(array);
        }
        return isDuplicate;
    }
}

