/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.stats.HeapScaner;
import org.openjdk.jmc.joverflow.stats.InterimRefChainTree;
import org.openjdk.jmc.joverflow.stats.ProblemChecker;
import org.openjdk.jmc.joverflow.support.ProblemRecorder;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.util.IntArrayList;

public class BreadthFirstHeapScanner
extends HeapScaner {
    private final ProblemChecker objHandler;
    private final InterimRefChainTree refChain;
    private final ArrayList<ObjGroup> nextFrontier;
    private ObjGroup[] curFrontier;
    private int curFrontierEndIdx;
    private int curFrontierStartIdx;
    private final ArrayList<FieldObj> fieldBuf;
    private final IntArrayList elementBuf;
    private final FieldObjComparator fieldObjComparator = new FieldObjComparator();
    private final ObjGroupComparator objGroupComparator = new ObjGroupComparator();
    private boolean sortingDirection;

    BreadthFirstHeapScanner(Snapshot snapshot, ProblemChecker objHandler, ProblemRecorder problemRecorder) {
        super(snapshot, new InterimRefChainTree(problemRecorder));
        this.refChain = (InterimRefChainTree)this.getRefChain();
        this.objHandler = objHandler;
        this.nextFrontier = new ArrayList(1000);
        this.fieldBuf = new ArrayList(100);
        this.elementBuf = new IntArrayList(1000);
    }

    @Override
    protected void scanObjectsFromRootObj(JavaHeapObject obj) {
        while (obj != null) {
            if (obj.setVisitedIfNot()) {
                ++this.currentProcessedObjNo;
                if (this.cancelled) {
                    throw new HprofParsingCancelledException.Runtime();
                }
                JavaClass clazz = obj.getClazz();
                if (clazz.isString()) {
                    this.objHandler.handleString((JavaObject)obj);
                } else if (obj instanceof JavaObject) {
                    JavaObject javaObj = (JavaObject)obj;
                    JavaThing[] fields = javaObj.getFields();
                    CollectionInstanceDescriptor colDesc = this.objHandler.handleInstance(javaObj, fields);
                    if (fields.length > 0 && obj.getClazz().hasReferenceFields()) {
                        int[] bannedFieldIndices = clazz.getBannedFieldIndices();
                        if (bannedFieldIndices != null) {
                            int[] nArray = bannedFieldIndices;
                            int n = bannedFieldIndices.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int bannedFieldIdx = nArray[n2];
                                fields[bannedFieldIdx] = null;
                                ++n2;
                            }
                        }
                        if (colDesc != null) {
                            if (colDesc.getClassDescriptor().isMap()) {
                                colDesc.iterateMap(new CollectionInstanceDescriptor.MapIteratorCallback(){

                                    @Override
                                    public boolean scanMapEntry(JavaHeapObject key, JavaHeapObject value) {
                                        BreadthFirstHeapScanner.this.pushCollectionElement(key);
                                        BreadthFirstHeapScanner.this.pushCollectionElement(value);
                                        return true;
                                    }

                                    @Override
                                    public boolean scanImplementationObject(JavaHeapObject implObj) {
                                        if (implObj.setVisitedIfNot()) {
                                            ++BreadthFirstHeapScanner.this.currentProcessedObjNo;
                                            if (implObj instanceof JavaObject) {
                                                JavaObject implJavaObj = (JavaObject)implObj;
                                                BreadthFirstHeapScanner.this.objHandler.handleInstance(implJavaObj, implJavaObj.getFields());
                                            } else {
                                                BreadthFirstHeapScanner.this.objHandler.handleObjectArray((JavaObjectArray)implObj, null);
                                            }
                                            return true;
                                        }
                                        return false;
                                    }
                                });
                            } else {
                                colDesc.iterateList(new CollectionInstanceDescriptor.ListIteratorCallback(){

                                    @Override
                                    public boolean scanListElement(JavaHeapObject element) {
                                        BreadthFirstHeapScanner.this.pushCollectionElement(element);
                                        return true;
                                    }

                                    @Override
                                    public boolean scanImplementationObject(JavaHeapObject implObj) {
                                        if (implObj.setVisitedIfNot()) {
                                            ++BreadthFirstHeapScanner.this.currentProcessedObjNo;
                                            if (implObj instanceof JavaObject) {
                                                JavaObject implJavaObj = (JavaObject)implObj;
                                                BreadthFirstHeapScanner.this.objHandler.handleInstance(implJavaObj, implJavaObj.getFields());
                                            } else {
                                                BreadthFirstHeapScanner.this.objHandler.handleObjectArray((JavaObjectArray)implObj, null);
                                            }
                                            return true;
                                        }
                                        return false;
                                    }
                                });
                            }
                            this.finishCollectionPush(obj);
                            if (colDesc.hasExtraObjFields()) {
                                colDesc.filterExtraObjFields(fields);
                                this.pushFields(obj, fields, InterimRefChainTree.ParentType.INSTANCE);
                            }
                        } else {
                            this.pushFields(obj, fields, InterimRefChainTree.ParentType.INSTANCE);
                        }
                    }
                } else if (obj instanceof JavaClass) {
                    JavaThing[] staticFields = ((JavaClass)obj).getStaticValues();
                    if (staticFields.length > 0) {
                        this.pushFields(obj, staticFields, InterimRefChainTree.ParentType.CLAZZ);
                    }
                } else if (obj instanceof JavaObjectArray) {
                    JavaObjectArray objArray = (JavaObjectArray)obj;
                    JavaHeapObject[] elements = objArray.getElements();
                    this.objHandler.handleObjectArray(objArray, elements);
                    if (elements.length > 0) {
                        this.pushArrayElements(obj, elements);
                    }
                } else {
                    this.objHandler.handleValueArray((JavaValueArray)obj);
                }
            }
            obj = this.getNextObjFromFrontier();
        }
        this.curFrontier = null;
    }

    private JavaHeapObject getNextObjFromFrontier() {
        int objIdxInCurParent;
        ObjGroup curObjGroup;
        JavaHeapObject result;
        do {
            if (this.curFrontier == null || this.curFrontierEndIdx < this.curFrontierStartIdx) {
                this.curFrontier = this.getNewFrontier();
                if (this.curFrontier == null) {
                    return null;
                }
                this.curFrontierEndIdx = this.curFrontier.length - 1;
                this.curFrontierStartIdx = 0;
            }
            curObjGroup = this.curFrontier[this.curFrontierStartIdx];
            objIdxInCurParent = curObjGroup.getCurChildLogicalIndex();
            result = curObjGroup.getCurChild(this.snapshot);
            ++curObjGroup.curChildIdx;
            if (curObjGroup.hasSingleChild() || curObjGroup.curChildIdx >= curObjGroup.getChildArrayLen()) {
                this.curFrontier[this.curFrontierStartIdx] = null;
                ++this.curFrontierStartIdx;
                continue;
            }
            int nextObjGlobalIdx = curObjGroup.getCurChildGlobalIndex();
            if (nextObjGlobalIdx <= 0 || this.curFrontierEndIdx - this.curFrontierStartIdx <= 0 || !this.ordered(this.curFrontier[this.curFrontierStartIdx + 1].getCurChildGlobalIndex(), nextObjGlobalIdx)) continue;
            int i = this.findPosInCurFrontierToInsert(nextObjGlobalIdx);
            ObjGroup tmp = this.curFrontier[this.curFrontierStartIdx];
            if (i == this.curFrontierStartIdx + 2) {
                this.curFrontier[this.curFrontierStartIdx] = this.curFrontier[this.curFrontierStartIdx + 1];
            } else {
                System.arraycopy(this.curFrontier, this.curFrontierStartIdx + 1, this.curFrontier, this.curFrontierStartIdx, i - 1 - this.curFrontierStartIdx);
            }
            this.curFrontier[i - 1] = tmp;
        } while (result == null || result.isVisited());
        this.refChain.setCurParent(curObjGroup.parentObj, curObjGroup.type, curObjGroup.refererToParent);
        this.refChain.setCurIndexInParent(objIdxInCurParent);
        return result;
    }

    private ObjGroup[] getNewFrontier() {
        if (this.nextFrontier.isEmpty()) {
            return null;
        }
        ObjGroup[] frontier = this.nextFrontier.toArray(new ObjGroup[this.nextFrontier.size()]);
        this.nextFrontier.clear();
        Arrays.sort(frontier, this.objGroupComparator);
        this.sortingDirection = !this.sortingDirection;
        return frontier;
    }

    private int findPosInCurFrontierToInsert(int elGlobalIdx) {
        int i;
        int left = this.curFrontierStartIdx;
        int right = this.curFrontierEndIdx;
        if (this.ordered(this.curFrontier[right].getCurChildGlobalIndex(), elGlobalIdx)) {
            return right + 1;
        }
        while (true) {
            if (this.ordered(this.curFrontier[i = left + right >>> 1].getCurChildGlobalIndex(), elGlobalIdx)) {
                left = i;
                if (this.ordered(this.curFrontier[i + 1].getCurChildGlobalIndex(), elGlobalIdx)) continue;
                break;
            }
            right = i;
        }
        return i;
    }

    private void pushFields(JavaHeapObject obj, JavaThing[] fields, InterimRefChainTree.ParentType parentType) {
        ObjGroupFields nextGroup;
        int i = 0;
        while (i < fields.length) {
            JavaThing field = fields[i];
            if (field != null && field instanceof JavaHeapObject && !((JavaHeapObject)field).isVisited()) {
                this.fieldBuf.add(new FieldObj((JavaHeapObject)field, i));
            }
            ++i;
        }
        if (this.fieldBuf.isEmpty()) {
            return;
        }
        if (this.fieldBuf.size() > 1) {
            FieldObj[] foEls = this.fieldBuf.toArray(new FieldObj[this.fieldBuf.size()]);
            Arrays.sort(foEls, this.fieldObjComparator);
            nextGroup = new ObjGroupFields(this.refChain.getLastRefChainElement(), parentType, obj, foEls);
        } else {
            FieldObj fo = this.fieldBuf.get(0);
            nextGroup = new ObjGroupFields(this.refChain.getLastRefChainElement(), parentType, obj, fo);
        }
        this.nextFrontier.add(nextGroup);
        this.fieldBuf.clear();
    }

    private void pushArrayElements(JavaHeapObject obj, JavaHeapObject[] elements) {
        ObjGroupCol nextGroup;
        JavaHeapObject[] javaHeapObjectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject element = javaHeapObjectArray[n2];
            if (element != null && !element.isVisited()) {
                this.elementBuf.add(element.getGlobalObjectIndex());
            }
            ++n2;
        }
        if (this.elementBuf.isEmpty()) {
            return;
        }
        if (this.elementBuf.size() > 1) {
            int[] els = this.elementBuf.toArray();
            this.sortGlobalObjectIndexesInOrder(els);
            nextGroup = new ObjGroupCol(this.refChain.getLastRefChainElement(), InterimRefChainTree.ParentType.ARRAY, obj, els);
        } else {
            nextGroup = new ObjGroupCol(this.refChain.getLastRefChainElement(), InterimRefChainTree.ParentType.ARRAY, obj, this.elementBuf.get(0));
        }
        this.nextFrontier.add(nextGroup);
        this.elementBuf.clear();
    }

    private void pushCollectionElement(JavaHeapObject element) {
        if (element != null && !element.isVisited()) {
            this.elementBuf.add(element.getGlobalObjectIndex());
        }
    }

    private void finishCollectionPush(JavaHeapObject obj) {
        ObjGroupCol nextGroup;
        if (this.elementBuf.isEmpty()) {
            return;
        }
        if (this.elementBuf.size() > 1) {
            int[] els = this.elementBuf.toArray();
            this.sortGlobalObjectIndexesInOrder(els);
            nextGroup = new ObjGroupCol(this.refChain.getLastRefChainElement(), InterimRefChainTree.ParentType.COLLECTION, obj, els);
        } else {
            nextGroup = new ObjGroupCol(this.refChain.getLastRefChainElement(), InterimRefChainTree.ParentType.COLLECTION, obj, this.elementBuf.get(0));
        }
        this.nextFrontier.add(nextGroup);
        this.elementBuf.clear();
    }

    private boolean ordered(int i1, int i2) {
        if (!this.sortingDirection) {
            return i1 < i2;
        }
        return i1 > i2;
    }

    private void sortGlobalObjectIndexesInOrder(int[] els) {
        Arrays.sort(els);
        if (!this.sortingDirection) {
            int len = els.length;
            int i = 0;
            while (i < len / 2) {
                int tmp = els[i];
                int otherIdx = len - i - 1;
                els[i] = els[otherIdx];
                els[otherIdx] = tmp;
                ++i;
            }
        }
    }

    private static class FieldObj {
        final int objGlobalIdx;
        final int objFieldIdx;

        FieldObj(JavaHeapObject obj, int objFieldIdx) {
            this.objGlobalIdx = obj.getGlobalObjectIndex();
            this.objFieldIdx = objFieldIdx;
        }
    }

    private class FieldObjComparator
    implements Comparator<FieldObj> {
        private FieldObjComparator() {
        }

        @Override
        public int compare(FieldObj o1, FieldObj o2) {
            int idx1 = o1.objGlobalIdx;
            int idx2 = o2.objGlobalIdx;
            if (BreadthFirstHeapScanner.this.sortingDirection) {
                return idx1 - idx2;
            }
            return idx2 - idx1;
        }
    }

    private static abstract class ObjGroup {
        final RefChainElement refererToParent;
        final InterimRefChainTree.ParentType type;
        final JavaHeapObject parentObj;
        protected int curChildIdx;

        ObjGroup(RefChainElement refererToParent, InterimRefChainTree.ParentType type, JavaHeapObject parentObj) {
            this.refererToParent = refererToParent;
            this.type = type;
            this.parentObj = parentObj;
        }

        abstract JavaHeapObject getCurChild(Snapshot var1);

        abstract int getCurChildLogicalIndex();

        abstract int getCurChildGlobalIndex();

        abstract boolean hasSingleChild();

        abstract int getChildArrayLen();

        public String toString() {
            return (Object)((Object)this.type) + ", refererToParent = " + this.refererToParent;
        }
    }

    private static class ObjGroupCol
    extends ObjGroup {
        private final int[] childrenGlobalIndexes;
        private final int singleChildGlobalIndex;

        ObjGroupCol(RefChainElement refererToParent, InterimRefChainTree.ParentType type, JavaHeapObject parentObj, int[] childrenGlobalIndexes) {
            super(refererToParent, type, parentObj);
            this.childrenGlobalIndexes = childrenGlobalIndexes;
            this.singleChildGlobalIndex = Integer.MIN_VALUE;
        }

        ObjGroupCol(RefChainElement refererToParent, InterimRefChainTree.ParentType type, JavaHeapObject parentObj, int singleChildGlobalIndex) {
            super(refererToParent, type, parentObj);
            this.childrenGlobalIndexes = null;
            this.singleChildGlobalIndex = singleChildGlobalIndex;
        }

        @Override
        JavaHeapObject getCurChild(Snapshot snapshot) {
            if (this.childrenGlobalIndexes != null) {
                return snapshot.getObjectAtGlobalIndex(this.childrenGlobalIndexes[this.curChildIdx]);
            }
            if (this.curChildIdx != 0) {
                throw new RuntimeException();
            }
            return snapshot.getObjectAtGlobalIndex(this.singleChildGlobalIndex);
        }

        @Override
        int getCurChildLogicalIndex() {
            return this.curChildIdx;
        }

        @Override
        int getCurChildGlobalIndex() {
            if (this.childrenGlobalIndexes != null) {
                return this.childrenGlobalIndexes[this.curChildIdx];
            }
            return this.singleChildGlobalIndex;
        }

        @Override
        boolean hasSingleChild() {
            return this.childrenGlobalIndexes == null;
        }

        @Override
        int getChildArrayLen() {
            return this.childrenGlobalIndexes.length;
        }
    }

    private class ObjGroupComparator
    implements Comparator<ObjGroup> {
        private ObjGroupComparator() {
        }

        @Override
        public int compare(ObjGroup o1, ObjGroup o2) {
            int firstObjIdx1 = o1.getCurChildGlobalIndex();
            int firstObjIdx2 = o2.getCurChildGlobalIndex();
            if (BreadthFirstHeapScanner.this.sortingDirection) {
                return firstObjIdx1 - firstObjIdx2;
            }
            return firstObjIdx2 - firstObjIdx1;
        }
    }

    private static class ObjGroupFields
    extends ObjGroup {
        private final Object oneOrMoreChildren;

        ObjGroupFields(RefChainElement refererToParent, InterimRefChainTree.ParentType type, JavaHeapObject parentObj, Object oneOrMoreChildren) {
            super(refererToParent, type, parentObj);
            this.oneOrMoreChildren = oneOrMoreChildren;
        }

        @Override
        JavaHeapObject getCurChild(Snapshot snapshot) {
            if (this.oneOrMoreChildren instanceof FieldObj[]) {
                return snapshot.getObjectAtGlobalIndex(((FieldObj[])this.oneOrMoreChildren)[this.curChildIdx].objGlobalIdx);
            }
            return snapshot.getObjectAtGlobalIndex(((FieldObj)this.oneOrMoreChildren).objGlobalIdx);
        }

        @Override
        int getCurChildLogicalIndex() {
            if (this.oneOrMoreChildren instanceof FieldObj[]) {
                return ((FieldObj[])this.oneOrMoreChildren)[this.curChildIdx].objFieldIdx;
            }
            return ((FieldObj)this.oneOrMoreChildren).objFieldIdx;
        }

        @Override
        int getCurChildGlobalIndex() {
            if (this.oneOrMoreChildren instanceof FieldObj[]) {
                FieldObj[] children = (FieldObj[])this.oneOrMoreChildren;
                return children[this.curChildIdx].objGlobalIdx;
            }
            return ((FieldObj)this.oneOrMoreChildren).objGlobalIdx;
        }

        @Override
        boolean hasSingleChild() {
            return this.oneOrMoreChildren instanceof FieldObj;
        }

        @Override
        int getChildArrayLen() {
            return ((FieldObj[])this.oneOrMoreChildren).length;
        }
    }
}

