/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.parser;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;

class MappedReadMultiBuffer
extends ReadBuffer {
    private final MappedByteBuffer[] bufs;
    private final long[] mappedBBEndOfs;
    private final int maxBufSize;

    MappedReadMultiBuffer(MappedByteBuffer[] bufs, long[] mappedBBEndOfs, int maxBufSize) {
        this.bufs = bufs;
        this.mappedBBEndOfs = mappedBBEndOfs;
        this.maxBufSize = maxBufSize;
    }

    private MappedByteBuffer seek(long pos) throws IOException {
        int bufIdx = (int)(pos / (long)this.maxBufSize);
        while (pos > this.mappedBBEndOfs[bufIdx]) {
            ++bufIdx;
        }
        MappedByteBuffer buf = this.bufs[bufIdx];
        if (bufIdx > 0) {
            buf.position((int)(pos - this.mappedBBEndOfs[bufIdx - 1] - 1L));
        } else {
            buf.position((int)pos);
        }
        return buf;
    }

    @Override
    public void get(long pos, byte[] res) throws IOException {
        MappedByteBuffer buf = this.seek(pos);
        buf.get(res);
    }

    @Override
    public void get(long pos, byte[] res, int num) throws IOException {
        MappedByteBuffer buf = this.seek(pos);
        buf.get(res, 0, num);
    }

    @Override
    public int getInt(long pos) throws IOException {
        MappedByteBuffer buf = this.seek(pos);
        return buf.getInt();
    }

    @Override
    public long getLong(long pos) throws IOException {
        MappedByteBuffer buf = this.seek(pos);
        return buf.getLong();
    }

    @Override
    public void close() {
    }
}

