/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.heap.model;

import java.util.ArrayList;
import org.openjdk.jmc.joverflow.heap.model.CollectionClassProperties;
import org.openjdk.jmc.joverflow.heap.model.ImplInclusiveSizeCalculator;
import org.openjdk.jmc.joverflow.heap.model.JavaField;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObjectVisitor;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectRef;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.JavaValueArray;
import org.openjdk.jmc.joverflow.heap.model.Root;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;
import org.openjdk.jmc.joverflow.util.ClassUtils;
import org.openjdk.jmc.joverflow.util.IntArrayList;
import org.openjdk.jmc.joverflow.util.LongToObjectMap;
import org.openjdk.jmc.joverflow.util.StringInterner;

public class JavaClass
extends JavaHeapObject {
    private static final ArrayList<JavaClass> EMPTY_CLASS_LIST = new ArrayList(0);
    public static final JavaField[] NO_FIELDS = new JavaField[0];
    public static final JavaThing[] NO_VALUES = new JavaThing[0];
    private static final int VISITED_MASK = Integer.MIN_VALUE;
    private final long id;
    private int classListIdx;
    private final String name;
    private String humanFriendlyName;
    private final byte numArrayDimensions;
    private JavaThing superclass;
    private JavaThing loader;
    private JavaThing signers;
    private JavaThing protectionDomain;
    private JavaField[] fields;
    private JavaField[] staticFields;
    private JavaThing[] staticValues;
    private ArrayList<JavaClass> subclasses = new ArrayList();
    private Snapshot snapshot;
    private JavaClass nextVersion;
    private int versionNumber;
    private final int fieldsSizeInFile;
    private int instanceSize;
    private int numInstances;
    private long totalShallowInstanceSize;
    private long totalInclusiveInstanceSize;
    private ImplInclusiveSizeCalculator implInclusiveSizeCalculator;
    private int totalNumFields;
    private boolean hasRefFields;
    private Object attachment;
    private int flags;
    private IntArrayList bannedFieldIndices;
    private CollectionClassProperties colProperties;
    private final byte boxedNumberSize;
    private int tags;

    public JavaClass(long id, String name, long superclassId, long loaderId, long signersId, long protDomainId, JavaField[] fields, JavaField[] staticFields, JavaThing[] staticValues, int fieldsSizeInFile, int instanceSize) {
        this.id = id;
        this.name = name;
        this.superclass = new JavaObjectRef(superclassId);
        this.loader = new JavaObjectRef(loaderId);
        this.signers = new JavaObjectRef(signersId);
        this.protectionDomain = new JavaObjectRef(protDomainId);
        this.fields = fields;
        this.staticFields = staticFields;
        this.staticValues = staticValues;
        this.fieldsSizeInFile = fieldsSizeInFile;
        this.instanceSize = instanceSize;
        this.boxedNumberSize = name.startsWith("java.lang.") ? (name.equals("java.lang.Integer") || name.equals("java.lang.Float") ? (byte)4 : (name.equals("java.lang.Long") || name.equals("java.lang.Double") ? (byte)8 : (name.equals("java.lang.Short") || name.equals("java.lang.Character") ? (byte)2 : (name.equals("java.lang.Byte") || name.equals("java.lang.Boolean") ? (byte)1 : 0)))) : (byte)0;
        int numDimensions = 0;
        while (name.charAt(numDimensions) == '[') {
            ++numDimensions;
        }
        this.numArrayDimensions = (byte)numDimensions;
    }

    public JavaClass(String name, long superclassId, long loaderId, long signersId, long protDomainId, JavaField[] fields, JavaField[] staticFields, JavaThing[] staticValues, int fieldsSizeInFile, int instanceSize) {
        this(-1L, name, superclassId, loaderId, signersId, protDomainId, fields, staticFields, staticValues, fieldsSizeInFile, instanceSize);
    }

    @Override
    public final JavaClass getClazz() {
        return this.snapshot.getJavaLangClass();
    }

    @Override
    public final int getGlobalObjectIndex() {
        return -this.classListIdx;
    }

    void setClassListIdx(int classListIdx) {
        this.classListIdx = classListIdx;
    }

    public int getClassListIdx() {
        return this.classListIdx;
    }

    public void addNextVersion(JavaClass cls) {
        JavaClass curClass = this;
        while (curClass.nextVersion != null && curClass.nextVersion != curClass) {
            curClass = curClass.nextVersion;
        }
        curClass.nextVersion = cls;
        cls.nextVersion = cls;
        cls.versionNumber = curClass.versionNumber + 1;
    }

    public JavaClass getNextVersion() {
        return this.nextVersion == this ? null : this.nextVersion;
    }

    public boolean hasMultipleVersions() {
        return this.nextVersion != null;
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public int getFieldsSizeInFile() {
        return this.fieldsSizeInFile;
    }

    void updateInstanceSize(int newInstanceSize) {
        this.instanceSize = newInstanceSize;
    }

    public int getBoxedNumberSize() {
        return this.boxedNumberSize;
    }

    public final int getHprofPointerSize() {
        return this.snapshot.getHprofPointerSize();
    }

    public final int getPointerSize() {
        return this.snapshot.getPointerSize();
    }

    public final int getObjectHeaderSize() {
        return this.snapshot.getObjectHeaderSize();
    }

    public final int getArrayHeaderSize() {
        return this.snapshot.getArrayHeaderSize();
    }

    public final int getObjectAlignment() {
        return this.snapshot.getObjectAlignment();
    }

    void resolve(Snapshot snapshot, ArrayList<Root> roots) {
        JavaField[] allFields;
        if (this.snapshot != null) {
            return;
        }
        this.snapshot = snapshot;
        if (!this.subclasses.isEmpty()) {
            this.subclasses.trimToSize();
        } else {
            this.subclasses = EMPTY_CLASS_LIST;
        }
        JavaField[] javaFieldArray = allFields = this.getFieldsForInstance();
        int n = allFields.length;
        int n2 = 0;
        while (n2 < n) {
            JavaField field = javaFieldArray[n2];
            if (field.isReference()) {
                this.hasRefFields = true;
                break;
            }
            ++n2;
        }
        this.loader = snapshot.dereferenceClassLoader(((JavaObjectRef)this.loader).getId(), this);
        this.signers = snapshot.dereferenceField(((JavaObjectRef)this.signers).getId(), null);
        this.protectionDomain = snapshot.dereferenceField(((JavaObjectRef)this.protectionDomain).getId(), null);
        if (this.signers != null || this.protectionDomain != null) {
            int len = this.staticFields.length;
            this.staticValues[len - 2] = this.signers;
            this.staticValues[len - 1] = this.protectionDomain;
        }
        int i = 0;
        while (i < this.staticFields.length) {
            JavaField field = this.staticFields[i];
            JavaThing value = this.staticValues[i];
            if (value != null && value instanceof JavaObjectRef) {
                long id = ((JavaObjectRef)value).getId();
                if ((value = snapshot.dereferenceField(id, field)) != null && value.isHeapAllocated() && this.getLoader() == null) {
                    String s = "Static reference from " + this.getName() + "." + field.getName();
                    roots.add(new Root(id, this.readId(), 9, s));
                }
                this.staticValues[i] = value;
            }
            ++i;
        }
    }

    void resolveSuperclass(LongToObjectMap<JavaClass> classIdToJavaClass) {
        if (this.superclass == null) {
            this.hasRefFields = false;
            return;
        }
        this.totalNumFields = this.fields.length;
        if (this.superclass instanceof JavaObjectRef) {
            this.superclass = classIdToJavaClass.get(((JavaObjectRef)this.superclass).getId());
        }
        if (this.superclass != null) {
            JavaClass sc = (JavaClass)this.superclass;
            sc.resolveSuperclass(classIdToJavaClass);
            this.totalNumFields += sc.totalNumFields;
            ((JavaClass)this.superclass).addSubclass(this);
        }
    }

    public boolean hasReferenceFields() {
        return this.hasRefFields;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setFlag(int flag) {
        this.flags |= flag;
    }

    public boolean flagIsSet(int flag) {
        return (this.flags & flag) != 0;
    }

    public boolean isString() {
        return this.snapshot.getJavaLangStringClass() == this;
    }

    public boolean isCharArray() {
        return this.snapshot.getCharArrayClass() == this;
    }

    public boolean isByteArray() {
        return this.snapshot.getByteArrayClass() == this;
    }

    public void incNumInstances() {
        ++this.numInstances;
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public void updateShallowInstanceSize(int size) {
        this.totalShallowInstanceSize += (long)size;
    }

    public long getTotalShallowInstanceSize() {
        if (this.isArray()) {
            return this.totalShallowInstanceSize;
        }
        return (long)this.getInstanceSize() * (long)this.getNumInstances();
    }

    public void updateInclusiveInstanceSize(int size) {
        this.totalInclusiveInstanceSize += (long)size;
    }

    public long getTotalInclusiveInstanceSize() {
        return this.totalInclusiveInstanceSize;
    }

    public void addBannedField(int bannedFieldIndex) {
        if (this.bannedFieldIndices == null) {
            this.bannedFieldIndices = new IntArrayList(2);
        }
        this.bannedFieldIndices.add(bannedFieldIndex);
        for (JavaClass subClass : this.getSubclasses()) {
            subClass.addBannedField(bannedFieldIndex);
        }
    }

    public static void setFieldBanned(JavaClass clazz, String fieldName) {
        int fieldIdx;
        if (clazz != null && (fieldIdx = clazz.getInstanceFieldIndexOrMinusOne(fieldName)) != -1) {
            clazz.addBannedField(fieldIdx);
        }
    }

    public int[] getBannedFieldIndices() {
        return this.bannedFieldIndices == null ? null : this.bannedFieldIndices.internalArray();
    }

    public boolean isCollection() {
        return this.colProperties != null;
    }

    public void setCollectionClassProperties(CollectionClassProperties colProperties) {
        this.colProperties = colProperties;
    }

    public CollectionClassProperties getCollectionClassProperties() {
        return this.colProperties;
    }

    public boolean isCollectionWithOtherCollectionInImpl() {
        return this.colProperties != null && this.colProperties.hasOtherCollectionInImpl();
    }

    public boolean isClassLoader() {
        return this.snapshot.getJavaLangClassLoaderClass().isAssignableFrom(this);
    }

    public boolean isSameOrHierarchicallyRelated(JavaClass other) {
        if (this == other) {
            return true;
        }
        JavaThing superClass = this.superclass;
        while (superClass != null && superClass != other) {
            superClass = ((JavaClass)superClass).superclass;
        }
        if (superClass == other) {
            return true;
        }
        superClass = other.superclass;
        while (superClass != null && superClass != this) {
            superClass = ((JavaClass)superClass).superclass;
        }
        return superClass == this;
    }

    public JavaField getDeclaredField(int i) {
        if (i < 0 || i >= this.fields.length) {
            throw new Error("No field for index " + i + " in class " + this.name);
        }
        return this.fields[i];
    }

    public int getNumFieldsForInstance() {
        return this.totalNumFields;
    }

    public JavaField getFieldForInstance(int idx) {
        if (this.superclass != null) {
            JavaClass sc = (JavaClass)this.superclass;
            if (idx < sc.totalNumFields) {
                return sc.getFieldForInstance(idx);
            }
            idx -= sc.totalNumFields;
        }
        return this.getDeclaredField(idx);
    }

    public JavaClass getDeclaringClassForField(int idx) {
        if (idx >= this.totalNumFields) {
            return null;
        }
        if (this.superclass != null) {
            JavaClass sc = (JavaClass)this.superclass;
            if (idx < sc.totalNumFields) {
                return sc.getDeclaringClassForField(idx);
            }
        }
        return this;
    }

    public JavaClass getDeclaringClassForField(String name) {
        JavaField field;
        JavaField[] javaFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            field = javaFieldArray[n2];
            if (field.getName().equals(name)) {
                return this;
            }
            ++n2;
        }
        javaFieldArray = this.staticFields;
        n = this.staticFields.length;
        n2 = 0;
        while (n2 < n) {
            field = javaFieldArray[n2];
            if (field.getName().equals(name)) {
                return this;
            }
            ++n2;
        }
        if (this.superclass != null) {
            return ((JavaClass)this.superclass).getDeclaringClassForField(name);
        }
        return null;
    }

    public static boolean isSameField(JavaClass clz1, JavaClass clz2, int fieldIdx) {
        JavaClass superClz2;
        if (clz1 == clz2) {
            return true;
        }
        if (clz1.getNumFieldsForInstance() <= fieldIdx || clz2.getNumFieldsForInstance() <= fieldIdx) {
            return false;
        }
        JavaClass superClz1 = clz1.getDeclaringClassForField(fieldIdx);
        return superClz1 == (superClz2 = clz2.getDeclaringClassForField(fieldIdx));
    }

    @Override
    public long readId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getHumanFriendlyName() {
        if (this.humanFriendlyName == null) {
            String className = this.getName();
            StringBuilder resultBuf = new StringBuilder(className.length() + 10);
            if (this.isArray()) {
                int numDims = this.getNumArrayDimensions();
                if (this.isAnyDimPrimitiveArray()) {
                    resultBuf.append(JavaValueArray.getElementTypeName(className.charAt(className.length() - 1)));
                } else {
                    resultBuf.append(ClassUtils.getShortNameForPopularClass(className.substring(numDims + 1, className.length() - 1)));
                }
                int i = 0;
                while (i < numDims) {
                    resultBuf.append("[]");
                    ++i;
                }
            } else {
                char nextCharAfterDollar;
                resultBuf.append(ClassUtils.getShortNameForPopularClass(className));
                int dollarIdx = resultBuf.indexOf("$");
                if (dollarIdx != -1 && dollarIdx != resultBuf.length() - 1 && Character.isDigit((int)(nextCharAfterDollar = resultBuf.charAt(dollarIdx + 1)))) {
                    resultBuf.append(" (extends ");
                    resultBuf.append(ClassUtils.getShortNameForPopularClass(this.getSuperclass().getName()));
                    resultBuf.append(')');
                }
            }
            this.humanFriendlyName = StringInterner.internString(resultBuf.toString());
        }
        return this.humanFriendlyName;
    }

    public String getHumanFriendlyNameWithLoaderIfNeeded() {
        String name = this.getHumanFriendlyName();
        if (this.hasMultipleVersions()) {
            name = String.valueOf(name) + " loader " + (this.loader != null ? this.loader.valueAsString() : "null");
        }
        return name;
    }

    public boolean isArray() {
        return this.numArrayDimensions > 0;
    }

    boolean isSingleDimPrimitiveArray() {
        return this.isArray() && this.name.length() == 2;
    }

    public boolean isAnyDimPrimitiveArray() {
        return this.isArray() && this.name.charAt(this.name.length() - 2) == '[';
    }

    public int getNumArrayDimensions() {
        return this.numArrayDimensions;
    }

    public ArrayList<JavaClass> getSubclasses() {
        return this.subclasses;
    }

    public JavaClass getSuperclass() {
        return (JavaClass)this.superclass;
    }

    public JavaThing getLoader() {
        return this.loader;
    }

    public boolean isBootstrap() {
        return this.loader == null;
    }

    public JavaThing getSigners() {
        return this.signers;
    }

    public JavaThing getProtectionDomain() {
        return this.protectionDomain;
    }

    public JavaField[] getDefinedFields() {
        return this.fields;
    }

    public JavaField[] getFieldsForInstance() {
        ArrayList<JavaField> v = new ArrayList<JavaField>(this.totalNumFields);
        this.addFields(v);
        if (v.isEmpty()) {
            return NO_FIELDS;
        }
        return v.toArray(new JavaField[v.size()]);
    }

    public int getInstanceFieldIndex(String fieldName) {
        int result = this.getInstanceFieldIndexOrMinusOne(fieldName);
        if (result == -1) {
            throw new RuntimeException(ClassUtils.getMessageForMissingField(this, fieldName));
        }
        return result;
    }

    public int getInstanceFieldIndexOrMinusOne(String fieldName) {
        JavaField[] fieldDescs = this.getFieldsForInstance();
        int i = 0;
        while (i < fieldDescs.length) {
            if (fieldName.equals(fieldDescs[i].getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public JavaField[] getStaticFields() {
        return this.staticFields;
    }

    public JavaThing[] getStaticValues() {
        return this.staticValues;
    }

    public JavaThing getStaticField(String name) {
        int i = 0;
        while (i < this.staticFields.length) {
            if (this.staticFields[i].getName().equals(name)) {
                return this.staticValues[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isAssignableFrom(JavaClass other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.isAssignableFrom((JavaClass)other.superclass);
    }

    public boolean isOrSubclassOf(String name) {
        JavaClass clazz = this;
        while (clazz != null) {
            if (clazz.getName().equals(name)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    @Override
    public int getSize() {
        JavaClass cl = this.snapshot.getJavaLangClass();
        if (cl == null) {
            return 0;
        }
        return cl.getInstanceSize();
    }

    @Override
    public final int getImplInclusiveSize() {
        return this.getSize();
    }

    public void setImplInclusiveSizeCalculator(ImplInclusiveSizeCalculator implCalc) {
        this.implInclusiveSizeCalculator = implCalc;
    }

    public ImplInclusiveSizeCalculator getImplInclusiveSizeCalculator() {
        return this.implInclusiveSizeCalculator;
    }

    @Override
    public String valueAsString() {
        return StringInterner.internString("class " + this.name + (this.hasMultipleVersions() ? " loader " + this.loader.valueAsString() : ""));
    }

    public final Snapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public boolean isVisited() {
        return (this.tags & Integer.MIN_VALUE) != 0;
    }

    @Override
    public void setVisited() {
        this.tags |= Integer.MIN_VALUE;
    }

    @Override
    public boolean setVisitedIfNot() {
        if (this.isVisited()) {
            return false;
        }
        this.setVisited();
        return true;
    }

    @Override
    public String toString() {
        return this.valueAsString();
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor v) {
        JavaThing other;
        super.visitReferencedObjects(v);
        JavaClass sc = this.getSuperclass();
        if (sc != null) {
            v.visit(this.getSuperclass());
        }
        if ((other = this.getLoader()) instanceof JavaHeapObject) {
            v.visit((JavaHeapObject)other);
        }
        if ((other = this.getSigners()) instanceof JavaHeapObject) {
            v.visit((JavaHeapObject)other);
        }
        if ((other = this.getProtectionDomain()) instanceof JavaHeapObject) {
            v.visit((JavaHeapObject)other);
        }
        int i = 0;
        while (i < this.staticFields.length) {
            JavaField f = this.staticFields[i];
            if (!v.exclude(this, f) && f.isReference() && (other = this.staticValues[i]) instanceof JavaHeapObject) {
                v.visit((JavaHeapObject)other);
            }
            ++i;
        }
    }

    final ReadBuffer getReadBuffer() {
        return this.snapshot.getReadBuffer();
    }

    private void addFields(ArrayList<JavaField> v) {
        if (this.superclass != null) {
            ((JavaClass)this.superclass).addFields(v);
        }
        JavaField[] javaFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            JavaField field = javaFieldArray[n2];
            v.add(field);
            ++n2;
        }
    }

    private void addSubclass(JavaClass sub) {
        this.subclasses.add(sub);
    }
}

