/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.descriptors;

import org.openjdk.jmc.joverflow.descriptors.AbstractCollectionDescriptor;
import org.openjdk.jmc.joverflow.descriptors.CollectionInstanceDescriptor;
import org.openjdk.jmc.joverflow.heap.model.JavaClass;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaInt;
import org.openjdk.jmc.joverflow.heap.model.JavaObject;
import org.openjdk.jmc.joverflow.heap.model.JavaObjectArray;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.heap.model.UnresolvedObject;
import org.openjdk.jmc.joverflow.support.Constants;

public class ConcurrentHashMapDescriptor
extends AbstractCollectionDescriptor
implements CollectionInstanceDescriptor.CapacityDifferentFromSize,
Constants {
    private final Factory factory;
    private int cachedNumElements = -1;
    private int cachedTotalCapacity = -1;

    private ConcurrentHashMapDescriptor(JavaObject col, Factory factory) {
        super(col);
        this.factory = factory;
    }

    @Override
    public int getNumElements() {
        JavaHeapObject[] segs;
        if (this.cachedNumElements != -1) {
            return this.cachedNumElements;
        }
        int result = 0;
        JavaThing segmentField = this.fields[this.factory.segmentsFieldIdx];
        if (segmentField == null || !(segmentField instanceof JavaObjectArray)) {
            return 0;
        }
        JavaObjectArray segments = (JavaObjectArray)segmentField;
        JavaHeapObject[] javaHeapObjectArray = segs = segments.getElements();
        int n = segs.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject segThing = javaHeapObjectArray[n2];
            if (segThing != null && segThing instanceof JavaObject) {
                JavaObject seg = (JavaObject)segThing;
                result += this.getNumElementsInSegment(seg);
            }
            ++n2;
        }
        this.cachedNumElements = result;
        return result;
    }

    private int getNumElementsInSegment(JavaObject seg) {
        return ((JavaInt)seg.getField(this.factory.segLengthFieldIdx)).getValue();
    }

    @Override
    public int doGetImplSize() {
        JavaHeapObject[] segs;
        this.col.setVisitedAsCollectionImpl();
        int result = this.col.getSize();
        JavaThing segmentField = this.fields[this.factory.segmentsFieldIdx];
        if (segmentField == null || !(segmentField instanceof JavaObjectArray)) {
            return result;
        }
        JavaObjectArray segments = (JavaObjectArray)segmentField;
        segments.setVisitedAsCollectionImpl();
        result += segments.getSize();
        JavaHeapObject[] javaHeapObjectArray = segs = segments.getElements();
        int n = segs.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject segThing = javaHeapObjectArray[n2];
            if (segThing != null && segThing instanceof JavaObject) {
                JavaThing segTableThing;
                JavaObject seg = (JavaObject)segThing;
                seg.setVisitedAsCollectionImpl();
                result += seg.getSize();
                JavaThing segSyncField = seg.getField(this.factory.segSyncFieldIdx);
                if (segSyncField != null && !(segSyncField instanceof UnresolvedObject)) {
                    JavaObject segSync = (JavaObject)segSyncField;
                    segSync.setVisitedAsCollectionImpl();
                    result += segSync.getSize();
                }
                if ((segTableThing = seg.getField(this.factory.segTableFieldIdx)) != null && segTableThing instanceof JavaObjectArray) {
                    JavaObjectArray segTable = (JavaObjectArray)segTableThing;
                    segTable.setVisitedAsCollectionImpl();
                    result += segTable.getSize();
                    int nElsInSeg = this.getNumElementsInSegment(seg);
                    if (nElsInSeg != 0) {
                        result += this.getSegmentEntriesSize(segTable);
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    private int getSegmentEntriesSize(JavaObjectArray entriesArray) {
        JavaThing[] entries = entriesArray.getElements();
        int nextFieldIdx = this.factory.getEntryNextFieldIdx(entries);
        JavaThing[] entryFields = null;
        int size = 0;
        JavaThing[] javaThingArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            JavaThing entryThing = javaThingArray[n2];
            if (entryThing != null && entryThing instanceof JavaObject) {
                JavaObject prevEntry;
                JavaThing entryThing1;
                JavaObject entry = (JavaObject)entryThing;
                do {
                    entry.setVisitedAsCollectionImpl();
                    size += entry.getSize();
                    entryFields = entry.getFields(entryFields);
                    prevEntry = entry;
                } while ((entryThing1 = entryFields[nextFieldIdx]) != null && entryThing1 instanceof JavaObject && (entry = (JavaObject)entryThing1) != prevEntry);
            }
            ++n2;
        }
        return size;
    }

    @Override
    public int getSparsenessOverhead(int ptrSize) {
        JavaHeapObject[] segs;
        int totalEls = 0;
        int totalCapacity = 0;
        int emptySegOverhead = 0;
        JavaThing segsThing = this.fields[this.factory.segmentsFieldIdx];
        if (segsThing == null || !(segsThing instanceof JavaObjectArray)) {
            return 0;
        }
        JavaObjectArray segments = (JavaObjectArray)segsThing;
        JavaHeapObject[] javaHeapObjectArray = segs = segments.getElements();
        int n = segs.length;
        int n2 = 0;
        while (n2 < n) {
            JavaObject seg;
            JavaThing segTableField;
            JavaHeapObject segThing = javaHeapObjectArray[n2];
            if (segThing != null && segThing instanceof JavaObject && (segTableField = (seg = (JavaObject)segThing).getField(this.factory.segTableFieldIdx)) != null && !(segTableField instanceof UnresolvedObject)) {
                int nElsInSeg = this.getNumElementsInSegment(seg);
                totalEls += nElsInSeg;
                JavaObjectArray segTable = (JavaObjectArray)segTableField;
                totalCapacity += segTable.getLength();
                if (nElsInSeg == 0) {
                    emptySegOverhead += seg.getSize() + segTable.getSize();
                }
            }
            ++n2;
        }
        this.cachedTotalCapacity = totalCapacity;
        if (totalEls >= totalCapacity / 2) {
            return -1;
        }
        return (totalCapacity - totalEls) * ptrSize + emptySegOverhead;
    }

    @Override
    public int getDefaultCapacity() {
        return 256;
    }

    @Override
    public int getCapacity() {
        JavaHeapObject[] segs;
        if (this.cachedTotalCapacity != -1) {
            return this.cachedTotalCapacity;
        }
        int totalCapacity = 0;
        JavaThing segsThing = this.fields[this.factory.segmentsFieldIdx];
        if (segsThing == null || !(segsThing instanceof JavaObjectArray)) {
            this.cachedTotalCapacity = 0;
            return this.cachedTotalCapacity;
        }
        JavaObjectArray segments = (JavaObjectArray)segsThing;
        JavaHeapObject[] javaHeapObjectArray = segs = segments.getElements();
        int n = segs.length;
        int n2 = 0;
        while (n2 < n) {
            JavaThing segTableField;
            JavaHeapObject segThing = javaHeapObjectArray[n2];
            if (segThing != null && segThing instanceof JavaObject && (segTableField = ((JavaObject)segThing).getField(this.factory.segTableFieldIdx)) != null && !(segTableField instanceof UnresolvedObject)) {
                JavaObjectArray segTable = (JavaObjectArray)segTableField;
                totalCapacity += segTable.getLength();
            }
            ++n2;
        }
        this.cachedTotalCapacity = totalCapacity;
        return totalCapacity;
    }

    @Override
    public void iterateList(CollectionInstanceDescriptor.ListIteratorCallback cb) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void iterateMap(CollectionInstanceDescriptor.MapIteratorCallback cb) {
        JavaHeapObject[] segs;
        JavaThing segsThing = this.fields[this.factory.segmentsFieldIdx];
        if (segsThing == null || !(segsThing instanceof JavaObjectArray)) {
            return;
        }
        JavaObjectArray segments = (JavaObjectArray)segsThing;
        if (!cb.scanImplementationObject(segments)) {
            return;
        }
        JavaHeapObject[] javaHeapObjectArray = segs = segments.getElements();
        int n = segs.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject seg = javaHeapObjectArray[n2];
            if (seg != null) {
                cb.scanImplementationObject(seg);
            }
            ++n2;
        }
        int numElements = this.getNumElements();
        if (numElements == 0) {
            return;
        }
        int keyFieldIdx = -1;
        int valueFieldIdx = -1;
        JavaHeapObject[] javaHeapObjectArray2 = segs;
        int n3 = segs.length;
        int n4 = 0;
        while (n4 < n3) {
            int nElsInSeg;
            JavaObjectArray segTable;
            JavaObject seg;
            JavaThing segTableField;
            JavaHeapObject segThing = javaHeapObjectArray2[n4];
            if (segThing != null && segThing instanceof JavaObject && (segTableField = (seg = (JavaObject)segThing).getField(this.factory.segTableFieldIdx)) != null && !(segTableField instanceof UnresolvedObject) && cb.scanImplementationObject(segTable = (JavaObjectArray)segTableField) && (nElsInSeg = this.getNumElementsInSegment(seg)) != 0) {
                JavaThing[] table = segTable.getElements();
                int nextFieldIdx = this.factory.getEntryNextFieldIdx(table);
                JavaThing[] entryFields = null;
                JavaThing[] javaThingArray = table;
                int n5 = table.length;
                int n6 = 0;
                block2: while (n6 < n5) {
                    JavaThing entryThing = javaThingArray[n6];
                    if (entryThing != null && entryThing instanceof JavaObject) {
                        JavaObject entry = (JavaObject)entryThing;
                        while (cb.scanImplementationObject(entry)) {
                            if (keyFieldIdx == -1) {
                                keyFieldIdx = this.factory.getKeyFieldIdx(entry);
                                valueFieldIdx = this.factory.getValueFieldIdx(entry);
                            }
                            entryFields = entry.getFields(entryFields);
                            JavaThing keyThing = entryFields[keyFieldIdx];
                            JavaThing valueThing = entryFields[valueFieldIdx];
                            JavaHeapObject key = null;
                            JavaHeapObject value = null;
                            if (keyThing instanceof JavaHeapObject) {
                                key = (JavaHeapObject)keyThing;
                            }
                            if (valueThing instanceof JavaHeapObject) {
                                value = (JavaHeapObject)valueThing;
                            }
                            if (!cb.scanMapEntry(key, value)) break block2;
                            JavaObject prevEntry = entry;
                            JavaThing entryThing1 = entryFields[nextFieldIdx];
                            if (entryThing1 != null && entryThing1 instanceof JavaObject && (entry = (JavaObject)entryThing1) != prevEntry) continue;
                        }
                    }
                    ++n6;
                }
            }
            ++n4;
        }
    }

    @Override
    public long getModCount() {
        JavaThing segsThing = this.fields[this.factory.segmentsFieldIdx];
        if (segsThing == null || !(segsThing instanceof JavaObjectArray)) {
            return 0L;
        }
        JavaObjectArray segments = (JavaObjectArray)segsThing;
        JavaHeapObject[] segs = segments.getElements();
        int result = 0;
        JavaHeapObject[] javaHeapObjectArray = segs;
        int n = segs.length;
        int n2 = 0;
        while (n2 < n) {
            JavaHeapObject segThing = javaHeapObjectArray[n2];
            if (segThing != null && segThing instanceof JavaObject) {
                JavaObject seg = (JavaObject)segThing;
                result += ((JavaInt)seg.getField(this.factory.segModCountFieldIdx)).getValue();
            }
            ++n2;
        }
        return result;
    }

    @Override
    AbstractCollectionDescriptor.Factory getFactory() {
        return this.factory;
    }

    /* synthetic */ ConcurrentHashMapDescriptor(JavaObject javaObject, Factory factory, ConcurrentHashMapDescriptor concurrentHashMapDescriptor) {
        this(javaObject, factory);
    }

    static class Factory
    extends AbstractCollectionDescriptor.Factory {
        private static final String SEGMENTS_FIELD_NAME = "segments";
        private final int segmentsFieldIdx;
        private final int segLengthFieldIdx;
        private final int segTableFieldIdx;
        private final int segSyncFieldIdx;
        private final int segModCountFieldIdx;

        Factory(JavaClass mapClazz, JavaClass segmentClazz, JavaClass[] allImplClasses) {
            super(mapClazz, true, allImplClasses, null, false, new String[]{SEGMENTS_FIELD_NAME});
            this.segmentsFieldIdx = mapClazz.getInstanceFieldIndex(SEGMENTS_FIELD_NAME);
            this.segLengthFieldIdx = segmentClazz.getInstanceFieldIndex("count");
            this.segTableFieldIdx = segmentClazz.getInstanceFieldIndex("table");
            this.segSyncFieldIdx = segmentClazz.getInstanceFieldIndex("sync");
            this.segModCountFieldIdx = segmentClazz.getInstanceFieldIndex("modCount");
        }

        private Factory(JavaClass clazz, AbstractCollectionDescriptor.Factory superclassFactory) {
            super(clazz, superclassFactory);
            this.segmentsFieldIdx = ((Factory)superclassFactory).segmentsFieldIdx;
            this.segLengthFieldIdx = ((Factory)superclassFactory).segLengthFieldIdx;
            this.segTableFieldIdx = ((Factory)superclassFactory).segTableFieldIdx;
            this.segSyncFieldIdx = ((Factory)superclassFactory).segSyncFieldIdx;
            this.segModCountFieldIdx = ((Factory)superclassFactory).segModCountFieldIdx;
        }

        @Override
        AbstractCollectionDescriptor.Factory cloneForSubclass(JavaClass clazz) {
            return new Factory(clazz, this);
        }

        @Override
        CollectionInstanceDescriptor get(JavaObject col) {
            return new ConcurrentHashMapDescriptor(col, this, null);
        }

        @Override
        protected boolean setModCountFieldIdx(JavaClass clazz) {
            return true;
        }
    }
}

