/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui;

import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.Node;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.Value;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;

final class SettingNode
extends Node {
    private final XMLModel m_model;
    private final XMLTagInstance m_settingElement;
    private Node m_source;

    public SettingNode(XMLModel model, XMLTagInstance settingElement) {
        this.m_model = model;
        this.m_settingElement = settingElement;
    }

    @Override
    protected void addTransmitter(Node transmitter) {
        super.addTransmitter(transmitter);
        this.setSource(transmitter);
    }

    private void setSource(Node source) {
        this.m_source = source;
    }

    @Override
    protected void onChange() {
        this.update();
    }

    public void update() {
        String newStringValue;
        Value newValue;
        String currentValue = this.m_settingElement.getContent();
        if (this.m_source != null && (newValue = this.m_source.getValue()) != null && !newValue.isNull() && !(newStringValue = newValue.toString()).equals(currentValue)) {
            this.m_settingElement.setContent(newStringValue);
            this.m_model.markDirty();
        }
    }

    @Override
    Value getValue() {
        throw new UnsupportedOperationException("Not implemented!");
    }
}

