/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.rjmx.services.IAttribute;
import org.openjdk.jmc.rjmx.services.IAttributeInfo;
import org.openjdk.jmc.rjmx.services.IOperation;
import org.openjdk.jmc.rjmx.services.IReadOnlyAttribute;
import org.openjdk.jmc.rjmx.services.IllegalOperandException;
import org.openjdk.jmc.rjmx.ui.attributes.AttributeTreeBuilder;
import org.openjdk.jmc.rjmx.ui.attributes.ChangeValueAction;
import org.openjdk.jmc.rjmx.ui.attributes.ValueColumnLabelProvider;
import org.openjdk.jmc.rjmx.ui.celleditors.AttributeEditingSupport;
import org.openjdk.jmc.rjmx.ui.internal.InsertArrayElementMenuAction;
import org.openjdk.jmc.rjmx.ui.internal.RemoveArrayElementMenuAction;
import org.openjdk.jmc.rjmx.ui.operations.Messages;
import org.openjdk.jmc.rjmx.ui.operations.OperationsLabelProvider;
import org.openjdk.jmc.rjmx.util.internal.DefaultAttribute;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.MementoToolkit;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;

public class InvocatorBuilderForm {
    private List<IAttribute> attributes;
    private final TableViewer operationsPart;
    private final InvocatorUpdateListener invocatorUpdatedListener;
    private Set<IAttributeInfo> invalidValues = Collections.emptySet();
    private final ColumnManager paramsColumnManager;

    public InvocatorBuilderForm(SashForm parent, FormToolkit formToolkit, boolean showOperationReturnType, TableSettings tableSettings, InvocatorUpdateListener invocatorUpdatedListener) {
        this.invocatorUpdatedListener = invocatorUpdatedListener;
        parent.setBackground(formToolkit.getColors().getBackground());
        this.operationsPart = InvocatorBuilderForm.createIOperationList((Composite)parent, showOperationReturnType);
        this.operationsPart.getTable().setHeaderVisible(true);
        Tree paramsTree = new Tree((Composite)parent, 68354);
        final TreeViewer parametersViewer = new TreeViewer(paramsTree);
        parametersViewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)parametersViewer);
        IColumn valueColumn = new ColumnBuilder(org.openjdk.jmc.rjmx.ui.attributes.Messages.AttributeInspector_VALUE_COLUMN_HEADER, "value", AttributeTreeBuilder.VALUE_CELL_ACCESSOR).labelProvider((ColumnLabelProvider)new ValueLabelProvider()).editingSupport((org.eclipse.jface.viewers.EditingSupport)new EditingSupport((ColumnViewer)parametersViewer)).build();
        List<IColumn> paramColumns = Arrays.asList(AttributeTreeBuilder.NAME, valueColumn, AttributeTreeBuilder.TYPE, AttributeTreeBuilder.DESCRIPTION);
        this.paramsColumnManager = ColumnManager.build((TreeViewer)parametersViewer, paramColumns, (TableSettings)tableSettings);
        MCContextMenuManager paramsMenu = MCContextMenuManager.create((Control)paramsTree, null);
        ColumnMenusFactory.addDefaultMenus((ColumnManager)this.paramsColumnManager, (MCContextMenuManager)paramsMenu);
        paramsMenu.add((IAction)new ChangeValueAction((ColumnViewer)parametersViewer, this.paramsColumnManager, valueColumn));
        paramsMenu.add((IContributionItem)InsertArrayElementMenuAction.createInsertArrayElementMenuActionContribution((IMenuManager)paramsMenu, this.paramsColumnManager, valueColumn, false));
        paramsMenu.add((IContributionItem)InsertArrayElementMenuAction.createInsertArrayElementMenuActionContribution((IMenuManager)paramsMenu, this.paramsColumnManager, valueColumn, true));
        paramsMenu.add((IContributionItem)RemoveArrayElementMenuAction.createRemoveArrayElementMenuActionContribution((IMenuManager)paramsMenu, this.paramsColumnManager, valueColumn));
        IAction delAction = ActionToolkit.forListSelection((StructuredViewer)parametersViewer, null, (boolean)true, (int)1, selection -> {
            selection.stream().forEach(a -> a.setValue(null));
            this.evaluateOperation(this.getSelectedOperation());
        });
        ActionToolkit.convertToCommandAction((IAction)delAction, (String)"org.eclipse.ui.edit.delete");
        paramsMenu.appendToGroup("group.edit", delAction);
        InFocusHandlerActivator.install((Control)paramsTree, (IAction)delAction);
        parent.setWeights(new int[]{1, 2});
        this.operationsPart.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IOperation operation = InvocatorBuilderForm.this.getSelectedOperation();
                InvocatorBuilderForm.this.attributes = new ArrayList();
                if (operation != null) {
                    for (IAttributeInfo valueInfo : operation.getSignature()) {
                        InvocatorBuilderForm.this.attributes.add(new ArgumentAttribute(operation, valueInfo));
                    }
                }
                InvocatorBuilderForm.this.evaluateOperation(operation);
                parametersViewer.setInput((Object)InvocatorBuilderForm.this.attributes.toArray());
            }
        });
    }

    private static TableViewer createIOperationList(Composite parent, boolean showReturns) {
        TableViewer tableViewer = new TableViewer(new Composite(parent, 0), 67588);
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof IOperation) {
                    return ((IOperation)element).getImpact().ordinal();
                }
                return 0;
            }
        });
        TableColumn tvc = new TableColumn(tableViewer.getTable(), 0);
        tvc.setText(Messages.OperationsSectionPart_TITLE);
        TableColumnLayout l = new TableColumnLayout();
        tableViewer.getTable().getParent().setLayout((Layout)l);
        l.setColumnData((Widget)tvc, (ColumnLayoutData)new ColumnWeightData(1));
        tableViewer.setLabelProvider((IBaseLabelProvider)new OperationsLabelProvider(showReturns));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        return tableViewer;
    }

    public void setOperations(Collection<? extends IOperation> input) {
        this.operationsPart.setInput(input);
    }

    private void evaluateOperation(IOperation operation) {
        try {
            Callable invocator = operation == null ? null : operation.getInvocator(this.getValues());
            this.invocatorUpdatedListener.onInvocatorUpdated(operation, invocator);
            this.invalidValues = Collections.emptySet();
        }
        catch (IllegalOperandException e) {
            this.invalidValues = e.getInvalidValues();
            this.invocatorUpdatedListener.onInvocatorUpdated(operation, null);
        }
    }

    private Object[] getValues() {
        Object[] values = new Object[this.attributes.size()];
        int i = 0;
        while (i < values.length) {
            values[i] = this.attributes.get(i).getValue();
            ++i;
        }
        return values;
    }

    public IOperation getSelectedOperation() {
        IStructuredSelection str;
        ISelection selection = this.operationsPart.getSelection();
        if (!selection.isEmpty() && (str = (IStructuredSelection)selection).getFirstElement() instanceof IOperation) {
            return (IOperation)str.getFirstElement();
        }
        return null;
    }

    public void saveState(IMemento state) {
        this.paramsColumnManager.getSettings().saveState(MementoToolkit.asWritableState((IMemento)state));
    }

    private class ArgumentAttribute
    extends DefaultAttribute {
        private final IOperation operation;

        public ArgumentAttribute(IOperation operation, IAttributeInfo info) {
            super(info);
            this.operation = operation;
        }

        public void setValue(Object value) {
            super.setValue(value);
            InvocatorBuilderForm.this.evaluateOperation(this.operation);
        }
    }

    private class EditingSupport
    extends AttributeEditingSupport<IAttribute> {
        public EditingSupport(ColumnViewer viewer) {
            super(viewer, IAttribute.class);
        }

        @Override
        protected void setValue(Object element, Object value) {
            super.setValue(element, value);
            InvocatorBuilderForm.this.evaluateOperation(InvocatorBuilderForm.this.getSelectedOperation());
            this.getViewer().refresh(element);
        }
    }

    public static interface InvocatorUpdateListener {
        public void onInvocatorUpdated(IOperation var1, Callable<?> var2);
    }

    private class ValueLabelProvider
    extends ValueColumnLabelProvider {
        private ValueLabelProvider() {
        }

        @Override
        protected Color getForegroundTyped(IReadOnlyAttribute value) {
            if (InvocatorBuilderForm.this.invalidValues.contains(value.getInfo())) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return super.getForegroundTyped(value);
        }

        @Override
        protected String getToolTipTextTyped(IReadOnlyAttribute attribute) {
            if (InvocatorBuilderForm.this.invalidValues.contains(attribute.getInfo())) {
                return NLS.bind((String)Messages.InvocatorBuilderForm_ILLEGAL_OPERAND, (Object)TypeHandling.simplifyType((String)attribute.getInfo().getType()));
            }
            return super.getToolTipTextTyped(attribute);
        }

        protected Color getBackgroundTyped(IReadOnlyAttribute element) {
            return Display.getDefault().getSystemColor(29);
        }
    }
}

