/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.management.ObjectName;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadata;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataProvider;
import org.openjdk.jmc.rjmx.subscription.IMRIMetadataService;
import org.openjdk.jmc.rjmx.subscription.MRI;
import org.openjdk.jmc.rjmx.subscription.MRIMetadataToolkit;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectionContentModel;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectionViewModel;
import org.openjdk.jmc.rjmx.ui.internal.MBeanPropertiesOrderer;
import org.openjdk.jmc.rjmx.ui.internal.MBeanTreeLabelProvider;
import org.openjdk.jmc.rjmx.ui.internal.MBeanTreeSorter;
import org.openjdk.jmc.rjmx.ui.internal.Messages;
import org.openjdk.jmc.rjmx.ui.internal.TreeNodeBuilder;
import org.openjdk.jmc.rjmx.ui.internal.TreeNodeFilter;
import org.openjdk.jmc.ui.common.tree.ITreeNode;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;

public class AttributeSelectorComponent
extends Composite {
    private static final int MAX_ATTRIBUTES_SYNC_FILTER = 5000;
    private Text filterText;
    private TreeViewer mbeanTreeViewer;
    private final AttributeSelectionViewModel m_viewModel;
    private AttributeSelectionContentModel m_selectorModel;
    private final ListenerList<ISelectionChangedListener> selectionChangedListeners;

    public AttributeSelectorComponent(Composite parent, int style, AttributeSelectionViewModel viewModel) {
        super(parent, style);
        this.m_viewModel = viewModel;
        this.selectionChangedListeners = new ListenerList();
        this.initComponent();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Iterator iterator = this.selectionChangedListeners.iterator();
        while (iterator.hasNext()) {
            ISelectionChangedListener listener;
            final ISelectionChangedListener l = listener = (ISelectionChangedListener)iterator.next();
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
        }
    }

    public MRI[] getSelection() {
        if (this.m_selectorModel == null) {
            return new MRI[0];
        }
        return this.m_selectorModel.getSelectedAttributes();
    }

    /*
     * WARNING - void declaration
     */
    public void setInput(AttributeSelectionContentModel selectorModel) {
        int n;
        int n2;
        MBeanPropertiesOrderer.Property[] propertyArray;
        this.m_selectorModel = selectorModel;
        IMRIMetadataService mds = selectorModel.getMetadataService();
        TreeNodeBuilder root = new TreeNodeBuilder();
        int mriCount = 0;
        for (MRI mri : selectorModel.getAvailableAttributes()) {
            void var9_9;
            MBeanPropertiesOrderer.Property[] properties;
            ObjectName bean = mri.getObjectName();
            IMRIMetadata md = mds.getMetadata(mri);
            if (this.m_viewModel.isNumericalOnly() && !MRIMetadataToolkit.isNumerical((IMRIMetadata)md)) continue;
            TreeNodeBuilder treeNodeBuilder = root.getUniqueChild(bean.getDomain());
            propertyArray = properties = MBeanPropertiesOrderer.getOrderedProperties(bean);
            n2 = properties.length;
            n = 0;
            while (n < n2) {
                void var9_11;
                MBeanPropertiesOrderer.Property p = propertyArray[n];
                TreeNodeBuilder treeNodeBuilder2 = var9_11.get(p.getStringRepresentation());
                if (p instanceof MBeanPropertiesOrderer.PropertyWithMBean || treeNodeBuilder2.getValue() == null) {
                    treeNodeBuilder2.setValue(p);
                }
                ++n;
            }
            propertyArray = mri.getParentMRIs();
            n2 = propertyArray.length;
            n = 0;
            while (n < n2) {
                MBeanPropertiesOrderer.Property parentMri = propertyArray[n];
                TreeNodeBuilder treeNodeBuilder3 = var9_9.get(parentMri, mds.getMetadata((MRI)parentMri));
                ++n;
            }
            var9_9.get(mri, md);
            ++mriCount;
        }
        ITreeNode[] tree = root.getChildren(null);
        this.mbeanTreeViewer.setInput((Object)tree);
        ArrayList<ITreeNode> selectList = new ArrayList<ITreeNode>();
        ArrayList<ITreeNode> expandList = new ArrayList<ITreeNode>();
        ArrayList<ITreeNode> search = new ArrayList<ITreeNode>();
        search.addAll(Arrays.asList(tree));
        while (!search.isEmpty()) {
            ITreeNode[] children;
            ITreeNode iTreeNode = (ITreeNode)search.remove(0);
            if (iTreeNode.getUserData() instanceof IMRIMetadata) {
                MRI mri = ((IMRIMetadata)iTreeNode.getUserData()).getMRI();
                propertyArray = selectorModel.getInitialExpandedAttributes();
                n2 = propertyArray.length;
                n = 0;
                while (n < n2) {
                    MBeanPropertiesOrderer.Property e = propertyArray[n];
                    if (mri.equals((Object)e)) {
                        expandList.add(iTreeNode);
                    }
                    ++n;
                }
                propertyArray = selectorModel.getSelectedAttributes();
                n2 = propertyArray.length;
                n = 0;
                while (n < n2) {
                    MBeanPropertiesOrderer.Property s = propertyArray[n];
                    if (mri.equals((Object)s)) {
                        selectList.add(iTreeNode);
                    }
                    ++n;
                }
            }
            if ((children = iTreeNode.getChildren()) == null) continue;
            search.addAll(Arrays.asList(children));
        }
        if (!selectList.isEmpty()) {
            this.mbeanTreeViewer.setSelection((ISelection)new StructuredSelection(selectList), true);
        }
        for (ITreeNode iTreeNode : expandList) {
            this.mbeanTreeViewer.expandToLevel((Object)iTreeNode, 0);
        }
        TreeNodeFilter.install(this.mbeanTreeViewer, this.filterText, mriCount > 5000);
    }

    protected int getTreeStyle() {
        int style = 2048;
        style = this.m_viewModel.isMultiSelectionAllowed() ? (style |= 2) : (style |= 4);
        return style;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, this.getTreeStyle());
        viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MBeanTreeLabelProvider(this.m_viewModel.getContentType()));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        return viewer;
    }

    private void initComponent() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        this.setLayout((Layout)layout);
        Composite filterAreaComposite = new Composite((Composite)this, 0);
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginWidth = 0;
        filterLayout.marginHeight = 0;
        filterAreaComposite.setLayout((Layout)filterLayout);
        filterAreaComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Label filterLabel = new Label(filterAreaComposite, 0);
        filterLabel.setText(Messages.AttributeSelectorDialog_LABEL_FILTER_TEXT);
        filterLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.filterText = new Text(filterAreaComposite, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mbeanTreeViewer = this.createTreeViewer(this);
        this.mbeanTreeViewer.setUseHashlookup(true);
        this.mbeanTreeViewer.setComparator((ViewerComparator)new MBeanTreeSorter());
        this.mbeanTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList<IMRIMetadata> addList = new ArrayList<IMRIMetadata>();
                ArrayList<MRI> selectedAttributes = new ArrayList<MRI>();
                for (Object o : ((IStructuredSelection)event.getSelection()).toList()) {
                    Object e = ((ITreeNode)o).getUserData();
                    if (!(e instanceof IMRIMetadata)) continue;
                    addList.add((IMRIMetadata)e);
                }
                int i = 0;
                while (i < addList.size()) {
                    IMRIMetadata metadata = (IMRIMetadata)addList.get(i);
                    if (!MRIMetadataToolkit.isComposite((IMRIMetadataProvider)metadata)) {
                        String unitString = metadata.getUnitString();
                        if (AttributeSelectorComponent.this.m_viewModel.getContentType() == null || unitString == null || AttributeSelectorComponent.this.m_viewModel.getContentType().equals((Object)UnitLookup.getContentType((String)unitString))) {
                            selectedAttributes.add(metadata.getMRI());
                        }
                    } else if (AttributeSelectorComponent.this.m_viewModel.isMultiSelectionAllowed()) {
                        for (MRI child : AttributeSelectorComponent.this.m_selectorModel.getAvailableAttributes()) {
                            if (!metadata.getMRI().isChild(child)) continue;
                            IMRIMetadata childMd = AttributeSelectorComponent.this.m_selectorModel.getMetadataService().getMetadata(child);
                            if (AttributeSelectorComponent.this.m_viewModel.isNumericalOnly() && !MRIMetadataToolkit.isNumerical((IMRIMetadata)childMd)) continue;
                            addList.add(childMd);
                        }
                    }
                    ++i;
                }
                AttributeSelectorComponent.this.m_selectorModel.setSelectedAttributes(selectedAttributes.toArray(new MRI[selectedAttributes.size()]));
                AttributeSelectorComponent.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AttributeSelectorComponent.this.mbeanTreeViewer, (ISelection)new StructuredSelection((Object[])AttributeSelectorComponent.this.getSelection())));
            }
        });
        this.mbeanTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                AttributeSelectorComponent.this.mbeanTreeViewer.setExpandedState(element, !AttributeSelectorComponent.this.mbeanTreeViewer.getExpandedState(element));
            }
        });
        this.mbeanTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
    }
}

