/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.attributes;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.rjmx.services.IReadOnlyAttribute;
import org.openjdk.jmc.rjmx.ui.attributes.Messages;
import org.openjdk.jmc.ui.misc.TypedLabelProvider;

public class ValueColumnLabelProvider
extends TypedLabelProvider<IReadOnlyAttribute> {
    private static final String FIXED_TEXT_FONT = "org.openjdk.jmc.fixedtextfont";

    public ValueColumnLabelProvider() {
        super(IReadOnlyAttribute.class);
    }

    protected Color getForegroundTyped(IReadOnlyAttribute attribute) {
        return this.isValid(attribute) ? null : JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
    }

    protected Font getFontTyped(IReadOnlyAttribute attribute) {
        if (!JFaceResources.getFontRegistry().hasValueFor(FIXED_TEXT_FONT)) {
            this.createFixedSizeTextFont();
        }
        if (this.isValid(attribute)) {
            return JFaceResources.getFontRegistry().get(FIXED_TEXT_FONT);
        }
        return JFaceResources.getFontRegistry().getItalic(FIXED_TEXT_FONT);
    }

    private void createFixedSizeTextFont() {
        FontRegistry registry = JFaceResources.getFontRegistry();
        int defaultHeight = registry.get("org.eclipse.jface.defaultfont").getFontData()[0].getHeight();
        FontDescriptor textFontDesc = registry.getDescriptor("org.eclipse.jface.textfont").setHeight(defaultHeight);
        registry.put(FIXED_TEXT_FONT, textFontDesc.getFontData());
    }

    protected String getToolTipTextTyped(IReadOnlyAttribute attribute) {
        return attribute.getValue() == null ? Messages.AttributeInspector_VALUE_IS_NULL : null;
    }

    protected String getTextTyped(IReadOnlyAttribute attribute) {
        if (attribute.getValue() == null) {
            return String.valueOf('<') + TypeHandling.simplifyType((String)attribute.getInfo().getType()) + '>';
        }
        return TypeHandling.getValueString((Object)this.getValue(attribute));
    }

    protected Object getValue(IReadOnlyAttribute attribute) {
        return attribute.getValue();
    }

    protected boolean isValid(IReadOnlyAttribute attribute) {
        return attribute.getValue() != null;
    }
}

