/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class LowOnPhysicalMemoryRule
implements IRule {
    private static final String RESULT_ID = "LowOnPhysicalMemory";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.PhysicalMemory"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.PhysicalMemory"});
        }
        IQuantity total = (IQuantity)items.getAggregate(JdkAggregators.MIN_TOTAL_MEMORY);
        IQuantity used = (IQuantity)items.getAggregate(JdkAggregators.MAX_USED_MEMORY);
        double safeUsage = 0.85;
        double warningLimit = 0.95;
        double usage = used.ratioTo(total);
        double score = RulesToolkit.mapExp100((double)(usage - safeUsage), (double)0.0, (double)(warningLimit - safeUsage));
        if (score > 0.0) {
            String usageString = UnitLookup.PERCENT_UNITY.quantity(usage).displayUsing("auto");
            String message = MessageFormat.format(Messages.getString("LowOnPhysicalMemoryFactory_TEXT_INFO"), usageString);
            String longMessage = MessageFormat.format(Messages.getString("LowOnPhysicalMemoryFactory_TEXT_INFO_LONG"), used.displayUsing("auto"), usageString, total.displayUsing("auto"));
            return new Result((IRule)this, score, message, longMessage);
        }
        return new Result((IRule)this, 0.0, Messages.getString("LowOnPhysicalMemoryFactory_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return LowOnPhysicalMemoryRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("LowOnPhysicalMemoryFactory_RULE_NAME");
    }

    public String getTopic() {
        return "heap";
    }
}

