/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class GcLockerRule
implements IRule {
    private static final String GC_LOCKER_RESULT_ID = "GcLocker";
    public static final TypedPreference<IQuantity> GC_LOCKER_RATIO_LIMIT = new TypedPreference("gc.locker.info.limit", Messages.getString("GcLockerRule_CONFIG_WARNING_LIMIT"), Messages.getString("GcLockerRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.1));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(GC_LOCKER_RATIO_LIMIT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.GarbageCollection"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.GarbageCollection"});
        }
        GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)items.getAggregate(GarbageCollectionsInfo.GC_INFO_AGGREGATOR);
        if (aggregate != null) {
            return this.getGcLockerResult(aggregate.getGcLockers(), aggregate.getGcCount(), (IQuantity)valueProvider.getPreferenceValue(GC_LOCKER_RATIO_LIMIT));
        }
        return new Result((IRule)this, -1.0, Messages.getString("GcLockerRule_TEXT_NA"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return GcLockerRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    private Result getGcLockerResult(double gcLockers, double totalCcCount, IQuantity limit) {
        if (gcLockers > 0.0) {
            double ratio = gcLockers / totalCcCount;
            double score = RulesToolkit.mapExp74((double)ratio, (double)limit.doubleValue());
            String message = MessageFormat.format(Messages.getString("GcLockerRuleFactory_TEXT_INFO"), UnitLookup.PERCENT_UNITY.quantity(ratio).displayUsing("auto"));
            return new Result((IRule)this, score, message, Messages.getString("GcLockerRuleFactory_TEXT_INFO_LONG"), JdkQueries.GARBAGE_COLLECTION);
        }
        return new Result((IRule)this, 0.0, Messages.getString("GcLockerRuleFactory_TEXT_OK"), null, JdkQueries.GARBAGE_COLLECTION);
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return GC_LOCKER_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("GcLockerRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }
}

