/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.HashMap;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.IPredicate;
import org.openjdk.jmc.common.collection.SimpleArray;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFormatToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;
import org.owasp.encoder.Encode;

public class AutoBoxingRule
extends AbstractRule {
    private static final String VALUE_OF_METHOD_NAME = "valueOf";
    private static final String SHORT = "java.lang.Short";
    private static final String LONG = "java.lang.Long";
    private static final String INTEGER = "java.lang.Integer";
    private static final String FLOAT = "java.lang.Float";
    private static final String DOUBLE = "java.lang.Double";
    private static final String CHARACTER = "java.lang.Character";
    private static final String BYTE = "java.lang.Byte";
    private static final String BOOLEAN = "java.lang.Boolean";
    private static final IPredicate<IMCMethod> IS_AUTOBOXED_PREDICATE = new IPredicate<IMCMethod>(){

        public boolean evaluate(IMCMethod method) {
            String type = method.getType().getFullName();
            if (AutoBoxingRule.VALUE_OF_METHOD_NAME.equals(method.getMethodName())) {
                if (AutoBoxingRule.BYTE.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.CHARACTER.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.DOUBLE.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.FLOAT.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.INTEGER.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.LONG.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.SHORT.equals(type)) {
                    return true;
                }
                if (AutoBoxingRule.BOOLEAN.equals(type)) {
                    return true;
                }
            }
            return false;
        }
    };
    private static final TypedPreference<IQuantity> AUTOBOXING_RATIO_INFO_LIMIT = new TypedPreference("autoboxing.ratio.info.limit", Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_INFO_LIMIT"), Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_INFO_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(20L));
    private static final TypedPreference<IQuantity> AUTOBOXING_RATIO_WARNING_LIMIT = new TypedPreference("autoboxing.ratio.warning.limit", Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_WARNING_LIMIT"), Messages.getString("AutoboxingRule_AUTOBOXING_RATIO_WARNING_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(80L));

    public AutoBoxingRule() {
        super("PrimitiveToObjectConversion", Messages.getString("AutoboxingRule_RULE_NAME"), "heap", new TypedPreference[]{AUTOBOXING_RATIO_INFO_LIMIT, AUTOBOXING_RATIO_WARNING_LIMIT});
    }

    protected Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        RulesToolkit.EventAvailability allocAvail = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
        if (allocAvail != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)allocAvail, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
        }
        double autoboxingRatioInfoLimit = ((IQuantity)vp.getPreferenceValue(AUTOBOXING_RATIO_INFO_LIMIT)).doubleValue();
        double autoboxingRatioWarningLimit = ((IQuantity)vp.getPreferenceValue(AUTOBOXING_RATIO_WARNING_LIMIT)).doubleValue();
        IItemCollection allocationItems = items.apply(JdkFilters.ALLOC_ALL);
        FrameSeparator sep = new FrameSeparator(FrameSeparator.FrameCategorization.LINE, false);
        StacktraceModel model = new StacktraceModel(false, sep, allocationItems);
        HashMap<IMCType, ITypedQuantity> allocationSizeByType = new HashMap<IMCType, ITypedQuantity>();
        ITypedQuantity sizeOfAllBoxedAllocations = UnitLookup.BYTE.quantity(0L);
        ITypedQuantity largestAllocatedByType = UnitLookup.BYTE.quantity(0L);
        IMCType largestAllocatedType = null;
        String secondFrameFromMostAllocated = "";
        for (StacktraceFrame stacktraceFrame : model.getRootFork().getFirstFrames()) {
            IMCMethod method = stacktraceFrame.getFrame().getMethod();
            if (!IS_AUTOBOXED_PREDICATE.evaluate((Object)method)) continue;
            SimpleArray itemArray = stacktraceFrame.getItems();
            ITypedQuantity total = UnitLookup.BYTE.quantity(0L);
            for (IItem item : itemArray) {
                total = total.add((IQuantity)RulesToolkit.getValue((IItem)item, (IAccessorFactory)JdkAttributes.TOTAL_ALLOCATION_SIZE));
            }
            sizeOfAllBoxedAllocations = sizeOfAllBoxedAllocations.add((IQuantity)total);
            if (total.compareTo((Object)largestAllocatedByType) > 0) {
                largestAllocatedByType = total;
                largestAllocatedType = method.getType();
                StacktraceFrame secondFrame = null;
                StacktraceModel.Branch firstBranch = stacktraceFrame.getBranch();
                if (firstBranch.getTailFrames().length > 0) {
                    secondFrame = firstBranch.getTailFrames()[0];
                } else if (firstBranch.getEndFork().getBranchCount() > 0) {
                    secondFrame = firstBranch.getEndFork().getBranch(0).getFirstFrame();
                }
                secondFrameFromMostAllocated = StacktraceFormatToolkit.formatFrame((IMCFrame)secondFrame.getFrame(), (FrameSeparator)sep, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false);
            }
            allocationSizeByType.put(method.getType(), total);
        }
        if (allocationSizeByType.size() == 0) {
            return new Result((IRule)this, 0.0, Messages.getString("AutoboxingRule_RESULT_NO_AUTOBOXING"));
        }
        IQuantity totalAllocationSize = (IQuantity)allocationItems.getAggregate(JdkAggregators.ALLOCATION_TOTAL);
        double possibleAutoboxingRatio = sizeOfAllBoxedAllocations.ratioTo(totalAllocationSize) * 100.0;
        double score = RulesToolkit.mapExp100((double)possibleAutoboxingRatio, (double)autoboxingRatioInfoLimit, (double)autoboxingRatioWarningLimit);
        String mostAllocatedTypeInfo = "";
        String mostAllocatedTypeInfoLong = "";
        if (largestAllocatedType != null) {
            String fullName = Encode.forHtml((String)largestAllocatedType.getFullName());
            mostAllocatedTypeInfo = " " + MessageFormat.format(Messages.getString("AutoboxingRule_RESULT_MOST_AUTOBOXED_TYPE"), fullName);
            mostAllocatedTypeInfoLong = "<p>" + MessageFormat.format(Messages.getString("AutoboxingRule_RESULT_MOST_AUTOBOXED_TYPE_LONG"), fullName, largestAllocatedByType.displayUsing("auto"), secondFrameFromMostAllocated);
        }
        String shortIntro = MessageFormat.format(Messages.getString("AutoboxingRule_RESULT_AUTOBOXING_RATIO"), Math.round(possibleAutoboxingRatio), sizeOfAllBoxedAllocations.displayUsing("auto"));
        String shortMessage = shortIntro + mostAllocatedTypeInfo;
        String longMessage = shortIntro + mostAllocatedTypeInfoLong + "<p>" + Messages.getString("AutoboxingRule_RESULT_LONG");
        return new Result((IRule)this, score, shortMessage, longMessage);
    }
}

