/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.collection.MapToolkit;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.StacktraceDataProvider;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;
import org.owasp.encoder.Encode;

public class AllocationByThreadRule
implements IRule {
    private static final String THREAD_RESULT_ID = "Allocations.thread";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailabilityOutside;
        RulesToolkit.EventAvailability eventAvailabilityInside = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB"});
        if (!RulesToolkit.isEventsEnabled((RulesToolkit.EventAvailability[])new RulesToolkit.EventAvailability[]{eventAvailabilityInside, eventAvailabilityOutside = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationOutsideTLAB"})})) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)RulesToolkit.getLeastAvailable((RulesToolkit.EventAvailability[])new RulesToolkit.EventAvailability[]{eventAvailabilityInside, eventAvailabilityOutside}), (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
        }
        if (eventAvailabilityInside != RulesToolkit.EventAvailability.AVAILABLE && eventAvailabilityOutside != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (String)MessageFormat.format(Messages.getString("General_RULE_REQUIRES_EVENTS_FROM_ONE_OF_MANY"), "jdk.ObjectAllocationInNewTLAB, jdk.ObjectAllocationOutsideTLAB"));
        }
        List entries = RulesToolkit.calculateGroupingScore((IItemCollection)items.apply(JdkFilters.ALLOC_ALL), (IAccessorFactory)JfrAttributes.EVENT_THREAD);
        double balance = RulesToolkit.calculateBalanceScore((List)entries);
        MapToolkit.IntEntry mostSignificant = (MapToolkit.IntEntry)entries.get(entries.size() - 1);
        double relevance = RulesToolkit.mapExp100Y((double)mostSignificant.getValue(), (double)1000.0, (double)50.0);
        double score = balance * relevance * 0.74;
        IItemFilter significantFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.ALLOC_ALL, ItemFilters.equals((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD, (Object)mostSignificant.getKey())});
        StacktraceModel stacktraceModel = new StacktraceModel(false, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false), items.apply(significantFilter));
        StacktraceModel.Fork rootFork = stacktraceModel.getRootFork();
        String relevantTraceHtmlList = rootFork.getBranchCount() == 0 ? Messages.getString("General_NO_STACK_TRACE_AVAILABLE") : StacktraceDataProvider.getRelevantTraceHtmlList(rootFork.getBranch(0), rootFork.getItemsInFork());
        String message = MessageFormat.format(Messages.getString("AllocationByThreadRule_TEXT_MESSAGE"), Encode.forHtml((String)((IMCThread)mostSignificant.getKey()).getThreadName()), relevantTraceHtmlList);
        String longMessage = message + "<p>" + Messages.getString("AllocationRuleFactory_TEXT_THREAD_INFO_LONG");
        return new Result((IRule)this, score, message, longMessage, JdkQueries.ALLOC_INSIDE_TLAB_BY_THREAD);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return AllocationByThreadRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return THREAD_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("AllocationByThreadRule_RULE_NAME");
    }

    public String getTopic() {
        return "java_application";
    }
}

