/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.io;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.jdk.io.SocketReadRule;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class SocketWriteRule
implements IRule {
    private static final String RESULT_ID = "SocketWrite";
    public static final TypedPreference<IQuantity> WRITE_INFO_LIMIT = new TypedPreference("io.socket.write.info.limit", Messages.getString("SocketWriteRule_CONFIG_INFO_LIMIT"), Messages.getString("SocketWriteRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(275L));
    public static final TypedPreference<IQuantity> WRITE_WARNING_LIMIT = new TypedPreference("io.socket.write.warning.limit", Messages.getString("SocketWriteRule_CONFIG_WARNING_LIMIT"), Messages.getString("SocketWriteRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(2000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WRITE_INFO_LIMIT, WRITE_WARNING_LIMIT);

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider vp) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return SocketWriteRule.this.evaluate(items, (IQuantity)vp.getPreferenceValue(WRITE_INFO_LIMIT), (IQuantity)vp.getPreferenceValue(WRITE_WARNING_LIMIT));
            }
        });
        return evaluationTask;
    }

    private Result evaluate(IItemCollection items, IQuantity infoLimit, IQuantity warningLimit) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.SocketWrite"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.SocketWrite"});
        }
        IItem longestEvent = (IItem)items.apply(JdkFilters.NO_RMI_SOCKET_WRITE).getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        if (longestEvent == null) {
            String shortMessage = Messages.getString("SocketWriteRuleFactory_TEXT_NO_EVENTS");
            String longMessage = shortMessage + "<p>" + Messages.getString("SocketWriteRuleFactory_TEXT_RMI_NOTE");
            return new Result((IRule)this, 0.0, shortMessage, longMessage, JdkQueries.NO_RMI_SOCKET_WRITE);
        }
        IQuantity maxDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        String peakDuration = maxDuration.displayUsing("auto");
        double score = RulesToolkit.mapExp100((double)maxDuration.doubleValueIn((IUnit)UnitLookup.SECOND), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECOND), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECOND));
        if (Severity.get((double)score) == Severity.WARNING || Severity.get((double)score) == Severity.INFO) {
            String address = SocketReadRule.sanitizeAddress((String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_ADDRESS));
            String amountWritten = ((IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_SOCKET_BYTES_WRITTEN)).displayUsing("auto");
            String shortMessage = MessageFormat.format(Messages.getString("SocketWriteRuleFactory_TEXT_WARN"), peakDuration);
            String longMessage = MessageFormat.format(Messages.getString("SocketWriteRuleFactory_TEXT_WARN_LONG"), peakDuration, address, amountWritten) + " " + Messages.getString("SocketWriteRuleFactory_TEXT_RMI_NOTE");
            return new Result((IRule)this, score, shortMessage, longMessage);
        }
        String shortMessage = MessageFormat.format(Messages.getString("SocketWriteRuleFactory_TEXT_OK"), peakDuration);
        String longMessage = shortMessage + "<p>" + Messages.getString("SocketWriteRuleFactory_TEXT_RMI_NOTE");
        return new Result((IRule)this, score, shortMessage, longMessage, JdkQueries.NO_RMI_SOCKET_WRITE);
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("SocketWriteRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "socket_io";
    }
}

