/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.io;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.jdk.JdkQueries;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.jdk.io.FileReadRule;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class FileWriteRule
implements IRule {
    public static final TypedPreference<IQuantity> WRITE_WARNING_LIMIT = new TypedPreference("io.file.write.warning.limit", Messages.getString("FileWriteRule_CONFIG_WARNING_LIMIT"), Messages.getString("FileWriteRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(4000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WRITE_WARNING_LIMIT);
    private static final String RESULT_ID = "FileWrite";

    private Result getResult(IItemCollection items, IPreferenceValueProvider vp) {
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(WRITE_WARNING_LIMIT);
        IQuantity infoLimit = warningLimit.multiply(0.5);
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.FileWrite"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.FileWrite"});
        }
        IItem longestEvent = (IItem)items.apply(JdkFilters.FILE_WRITE).getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        if (longestEvent == null) {
            return new Result((IRule)this, 0.0, Messages.getString("FileWriteRuleFactory_TEXT_NO_EVENTS"), null, JdkQueries.FILE_WRITE);
        }
        IQuantity maxDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        String peakDuration = maxDuration.displayUsing("auto");
        double score = RulesToolkit.mapExp100((double)maxDuration.doubleValueIn((IUnit)UnitLookup.SECOND), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECOND), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECOND));
        if (Severity.get((double)score) == Severity.WARNING || Severity.get((double)score) == Severity.INFO) {
            String amountWritten = ((IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_FILE_BYTES_WRITTEN)).displayUsing("auto");
            String fileName = FileReadRule.sanitizeFileName((String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_PATH));
            return new Result((IRule)this, score, MessageFormat.format(Messages.getString("FileWriteRuleFactory_TEXT_WARN"), peakDuration), MessageFormat.format(Messages.getString("FileWriteRuleFactory_TEXT_WARN_LONG"), peakDuration, fileName, amountWritten), JdkQueries.FILE_WRITE);
        }
        return new Result((IRule)this, score, MessageFormat.format(Messages.getString("FileWriteRuleFactory_TEXT_OK"), peakDuration), null, JdkQueries.FILE_WRITE);
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return FileWriteRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("FileWriteRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "file_io";
    }
}

