/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class VerifyNoneRule
implements IRule {
    private static final String VERIFYNONE_RESULT_ID = "BytecodeVerification";

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.JVMInformation"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.JVMInformation"});
        }
        String verifyNone = RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JVM_ARGUMENTS, (String)"\\-Xverify:none", (boolean)false);
        String noVerify = RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JVM_ARGUMENTS, (String)"\\-noverify*", (boolean)false);
        if (verifyNone != null || noVerify != null) {
            String wls = RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JAVA_ARGUMENTS, (String)"weblogic.Server", (boolean)false);
            if (wls != null) {
                return new Result((IRule)this, 1.0, Messages.getString("VerifyNoneRule_WLS_TEXT_INFO"), Messages.getString("VerifyNoneRule_WLS_TEXT_INFO_LONG"));
            }
            return new Result((IRule)this, 100.0, Messages.getString("VerifyNoneRule_TEXT_INFO"), Messages.getString("VerifyNoneRule_TEXT_INFO_LONG"));
        }
        return new Result((IRule)this, 0.0, Messages.getString("VerifyNoneRule_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return VerifyNoneRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return VERIFYNONE_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("VerifyNoneRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }
}

