/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class FlightRecordingSupportRule
implements IRule {
    private static final String RESULT_ID = "FlightRecordingSupport";
    private static final JavaVersion JDK_7_U_40 = new JavaVersion(new int[]{7, 0, 40});

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.JVMInformation"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.JVMInformation"});
        }
        Result versionResult = this.getVersionResult(items);
        Result timeConversionResult = this.getTimeConversionResult(items);
        double versionScore = versionResult.getScore();
        double timeConversionScore = timeConversionResult.getScore();
        if (versionScore > 0.0 || timeConversionScore > 0.0) {
            return versionResult.getScore() > timeConversionResult.getScore() ? versionResult : timeConversionResult;
        }
        return versionScore < timeConversionScore ? versionResult : timeConversionResult;
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return FlightRecordingSupportRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("FlightRecordingSupportRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }

    private Result getVersionResult(String versionString) {
        JavaVersion usedVersion = RulesToolkit.getJavaVersion((String)versionString);
        if (usedVersion == null) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (String)Messages.getString("General_TEXT_COULD_NOT_DETERMINE_JAVA_VERSION"));
        }
        if (!usedVersion.isGreaterOrEqualThan(JDK_7_U_40)) {
            return new Result((IRule)this, 100.0, Messages.getString("FlightRecordingSupportRule_UNSUPPORTED_TEXT_WARN_SHORT"), MessageFormat.format(Messages.getString("FlightRecordingSupportRule_UNSUPPORTED_TEXT_WARN_LONG"), Encode.forHtml((String)versionString)));
        }
        if (usedVersion.isEarlyAccess()) {
            return new Result((IRule)this, 80.0, Messages.getString("FlightRecordingSupportRule_EA_TEXT_WARN_SHORT"), MessageFormat.format(Messages.getString("FlightRecordingSupportRule_EA_TEXT_WARN_LONG"), Encode.forHtml((String)versionString)));
        }
        return new Result((IRule)this, 0.0, Messages.getString("FlightRecordingSupportRule_TEXT_OK"));
    }

    private Result getVersionResult(IItemCollection items) {
        String jvmVersion = (String)items.getAggregate(Aggregators.distinctAsString((String)"jdk.JVMInformation", (IAttribute)JdkAttributes.JVM_VERSION));
        if (jvmVersion != null) {
            return this.getVersionResult(jvmVersion);
        }
        return RulesToolkit.getNotApplicableResult((IRule)this, (String)Messages.getString("FlightRecordingSupportRule_NO_JVM_VERSION_EVENTS_TEXT"));
    }

    private Result getTimeConversionResult(IItemCollection items) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.CPUTimeStampCounter"});
        if (eventAvailability != RulesToolkit.EventAvailability.AVAILABLE) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.CPUTimeStampCounter"});
        }
        IItemCollection timeConversionItems = items.apply(JdkFilters.TIME_CONVERSION);
        IQuantity conversionFactor = (IQuantity)timeConversionItems.getAggregate(Aggregators.max((IAttribute)Attribute.attr((String)"fastTimeConversionAdjustments", null, (ContentType)UnitLookup.NUMBER)));
        Boolean fastTimeEnabled = (Boolean)timeConversionItems.getAggregate(Aggregators.and((String)"jdk.CPUTimeStampCounter", (IAttribute)Attribute.attr((String)"fastTimeEnabled", null, (ContentType)UnitLookup.FLAG)));
        if (conversionFactor != null && fastTimeEnabled.booleanValue() && conversionFactor.longValue() != 0L) {
            String shortMessage = Messages.getString("FasttimeRule_TEXT_WARN");
            String longMessage = shortMessage + " " + Messages.getString("FasttimeRule_TEXT_WARN_LONG");
            return new Result((IRule)this, 100.0, shortMessage, longMessage);
        }
        return new Result((IRule)this, 0.0, Messages.getString("FlightRecordingSupportRule_TEXT_OK"));
    }
}

