/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemQueryBuilder;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class DumpReasonRule
implements IRule {
    private static final String DUMP_REASON_RESULT_ID = "DumpReason";
    public static final TypedPreference<IQuantity> CRASH_SCORE = new TypedPreference("crash.score", Messages.getString("DumpReasonRule_CRASH_SCORE"), Messages.getString("DumpReasonRule_CRASH_SCORE_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(100L));
    public static final TypedPreference<IQuantity> COREDUMP_SCORE = new TypedPreference("coredump.score", Messages.getString("DumpReasonRule_COREDUMP_SCORE"), Messages.getString("DumpReasonRule_COREDUMP_SCORE_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(90L));
    public static final TypedPreference<IQuantity> OOM_SCORE = new TypedPreference("oom.score", Messages.getString("DumpReasonRule_OOM_SCORE"), Messages.getString("DumpReasonRule_OOM_SCORE_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(80L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(CRASH_SCORE, COREDUMP_SCORE, OOM_SCORE);

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        String eventType = "jdk.DumpReason";
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{eventType});
        if (eventAvailability == RulesToolkit.EventAvailability.AVAILABLE) {
            String longDescription;
            double score;
            String reasonsLower;
            IQuantity crashScore = (IQuantity)valueProvider.getPreferenceValue(CRASH_SCORE);
            IQuantity coredumpScore = (IQuantity)valueProvider.getPreferenceValue(COREDUMP_SCORE);
            IQuantity oomScore = (IQuantity)valueProvider.getPreferenceValue(OOM_SCORE);
            IItemFilter itemFilter = ItemFilters.type((String)eventType);
            IItemCollection filtered = items.apply(itemFilter);
            String reasons = (String)filtered.getAggregate(Aggregators.distinctAsString((String)"jdk.DumpReason", (IAttribute)JdkAttributes.DUMP_REASON));
            String shortDescription = Messages.getString("DumpReasonRule_TEXT_INFO");
            String string = reasonsLower = reasons != null ? reasons.toLowerCase() : "";
            if (reasonsLower.contains("crash")) {
                score = crashScore.doubleValue();
                longDescription = Messages.getString("DumpReasonRule_TEXT_LONG_CRASH");
            } else if (reasonsLower.contains("core dump")) {
                score = coredumpScore.doubleValue();
                longDescription = Messages.getString("DumpReasonRule_TEXT_LONG_COREDUMP");
            } else if (reasonsLower.contains("out of memory")) {
                score = oomScore.doubleValue();
                longDescription = Messages.getString("DumpReasonRule_TEXT_LONG_OOM");
            } else {
                score = 10.0;
                shortDescription = Messages.getString("DumpReasonRule_TEXT_INFO_UNKNOWN");
                longDescription = MessageFormat.format(Messages.getString("DumpReasonRule_TEXT_LONG_UNKNOWN"), Encode.forHtml((String)reasons));
            }
            return new Result((IRule)this, score, shortDescription, longDescription, ItemQueryBuilder.fromWhere((IItemFilter)itemFilter).build());
        }
        if (eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{eventType});
        }
        return new Result((IRule)this, 0.0, Messages.getString("DumpReasonRule_TEXT_OK"));
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return DumpReasonRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return DUMP_REASON_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DumpReason_RULE_NAME");
    }

    public String getTopic() {
        return "recording";
    }
}

