/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemQueryBuilder;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ClassEntry;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ColumnInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.IItemResultSet;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ItemResultSetException;
import org.openjdk.jmc.flightrecorder.rules.jdk.util.ItemResultSetFactory;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public final class ClassLeakingRule
implements IRule {
    private static final String RESULT_ID = "ClassLeak";
    private static final String COUNT_AGGREGATOR_ID = "count";
    public static final TypedPreference<IQuantity> WARNING_LIMIT = new TypedPreference("classLeaking.warning.limit", Messages.getString("ClassLeakingRule_CONFIG_WARNING_LIMIT"), Messages.getString("ClassLeakingRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(25L));
    public static final TypedPreference<IQuantity> MAX_NUMBER_OF_CLASSES_TO_REPORT = new TypedPreference("classLeaking.classesToReport.limit", Messages.getString("General_CONFIG_CLASS_LIMIT"), Messages.getString("General_CONFIG_CLASS_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(5L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WARNING_LIMIT, MAX_NUMBER_OF_CLASSES_TO_REPORT);

    private Result getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        RulesToolkit.EventAvailability eventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.ClassLoad", "jdk.ClassUnload"});
        if (eventAvailability == RulesToolkit.EventAvailability.UNKNOWN || eventAvailability == RulesToolkit.EventAvailability.DISABLED) {
            return RulesToolkit.getEventAvailabilityResult((IRule)this, (IItemCollection)items, (RulesToolkit.EventAvailability)eventAvailability, (String[])new String[]{"jdk.ClassLoad", "jdk.ClassUnload"});
        }
        int warningLimit = (int)((IQuantity)valueProvider.getPreferenceValue(WARNING_LIMIT)).longValue();
        ItemQueryBuilder queryLoad = ItemQueryBuilder.fromWhere((IItemFilter)JdkFilters.CLASS_LOAD);
        queryLoad.groupBy(JdkAttributes.CLASS_LOADED);
        queryLoad.select(JdkAttributes.CLASS_LOADED);
        queryLoad.select(Aggregators.count((String)COUNT_AGGREGATOR_ID, (String)"classesLoaded"));
        Map<String, ClassEntry> entriesLoad = this.extractClassEntriesFromQuery(items, queryLoad.build());
        ItemQueryBuilder queryUnload = ItemQueryBuilder.fromWhere((IItemFilter)ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.CLASS_UNLOAD, ClassLeakingRule.createClassAttributeFilter((IAttribute<IMCType>)JdkAttributes.CLASS_UNLOADED, entriesLoad)}));
        queryUnload.groupBy(JdkAttributes.CLASS_UNLOADED);
        queryUnload.select(JdkAttributes.CLASS_UNLOADED);
        queryUnload.select(Aggregators.count((String)COUNT_AGGREGATOR_ID, (String)"classesUnloaded"));
        Map<String, ClassEntry> entriesUnload = this.extractClassEntriesFromQuery(items, queryUnload.build());
        Map<String, ClassEntry> diff = this.diff(entriesLoad, entriesUnload);
        ArrayList<ClassEntry> entries = new ArrayList<ClassEntry>(diff.values());
        if (entries.size() > 0) {
            StringBuilder longText = new StringBuilder();
            int classLimit = Math.min((int)((IQuantity)valueProvider.getPreferenceValue(MAX_NUMBER_OF_CLASSES_TO_REPORT)).longValue(), entries.size());
            longText.append(MessageFormat.format(Messages.getString("ClassLeakingRule_TEXT_WARN_LONG"), String.valueOf(classLimit)));
            int maxCount = 0;
            Collections.sort(entries);
            longText.append("<p><ul>");
            for (int i = 0; i < classLimit; ++i) {
                ClassEntry entry = (ClassEntry)entries.get(i);
                longText.append("<li>");
                longText.append(entry);
                longText.append("</li>");
                maxCount = Math.max(entry.getCount(), maxCount);
            }
            longText.append("</ul></p>");
            double maxScore = RulesToolkit.mapExp100((double)maxCount, (double)warningLimit) * 0.75;
            ClassEntry worst = (ClassEntry)entries.get(0);
            return new Result((IRule)this, maxScore, MessageFormat.format(Messages.getString("ClassLeakingRule_TEXT_WARN"), Encode.forHtml((String)worst.getType().getFullName()), worst.getCount()), longText.toString());
        }
        return new Result((IRule)this, 0.0, Messages.getString("ClassLeakingRule_TEXT_OK"));
    }

    private static IItemFilter createClassAttributeFilter(IAttribute<IMCType> attribute, Map<String, ClassEntry> entries) {
        ArrayList<IItemFilter> allowedClasses = new ArrayList<IItemFilter>();
        for (ClassEntry entry : entries.values()) {
            allowedClasses.add(ItemFilters.equals(attribute, (Object)entry.getType()));
        }
        return ItemFilters.or((IItemFilter[])allowedClasses.toArray(new IItemFilter[0]));
    }

    private Map<String, ClassEntry> diff(Map<String, ClassEntry> entriesLoad, Map<String, ClassEntry> entriesUnload) {
        if (entriesUnload.isEmpty()) {
            return entriesLoad;
        }
        HashMap<String, ClassEntry> diffMap = new HashMap<String, ClassEntry>(entriesLoad.size());
        for (Map.Entry<String, ClassEntry> mapEntryLoad : entriesLoad.entrySet()) {
            ClassEntry classEntryUnload = entriesUnload.get(mapEntryLoad.getKey());
            if (classEntryUnload != null) {
                diffMap.put(mapEntryLoad.getKey(), new ClassEntry(mapEntryLoad.getValue().getType(), mapEntryLoad.getValue().getCount() - classEntryUnload.getCount()));
                continue;
            }
            diffMap.put(mapEntryLoad.getKey(), mapEntryLoad.getValue());
        }
        return diffMap;
    }

    private Map<String, ClassEntry> extractClassEntriesFromQuery(IItemCollection items, IItemQuery query) {
        HashMap<String, ClassEntry> entries = new HashMap<String, ClassEntry>();
        IItemResultSet resultSet = new ItemResultSetFactory().createResultSet(items, query);
        ColumnInfo countColumn = resultSet.getColumnMetadata().get(COUNT_AGGREGATOR_ID);
        ColumnInfo classColumn = resultSet.getColumnMetadata().get(query.getGroupBy().getIdentifier());
        while (resultSet.next()) {
            try {
                IQuantity countObject = (IQuantity)resultSet.getValue(countColumn.getColumn());
                if (countObject == null) continue;
                int count = (int)countObject.longValue();
                IMCType type = (IMCType)resultSet.getValue(classColumn.getColumn());
                if (type == null) continue;
                ClassEntry entry = new ClassEntry(type, count);
                entries.put(entry.getType().getFullName(), entry);
            }
            catch (ItemResultSetException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to extract class entries from query!", e);
            }
        }
        return entries;
    }

    public RunnableFuture<Result> evaluate(final IItemCollection items, final IPreferenceValueProvider valueProvider) {
        FutureTask<Result> evaluationTask = new FutureTask<Result>(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                return ClassLeakingRule.this.getResult(items, valueProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ClassLeakingRule_NAME");
    }

    public String getTopic() {
        return "classloading";
    }
}

