/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.polling;

import java.util.Vector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PollManager
implements Runnable,
IPropertyChangeListener {
    private final Vector<Pollable> m_pollableObjects = new Vector();
    private volatile int m_pollingInterval = 0;
    private volatile boolean m_keepAlive = false;
    private final String m_propertyName;

    public PollManager(int pollingInterval, String propertyName) {
        this.m_pollingInterval = pollingInterval;
        this.m_propertyName = propertyName;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(this.m_propertyName)) {
            this.m_pollingInterval = (Integer)event.getNewValue();
        }
    }

    public synchronized void addPollee(Pollable pollee) {
        if (!this.m_pollableObjects.contains(pollee)) {
            this.m_pollableObjects.add(pollee);
            this.updatePollThread();
            this.notifyAll();
        }
    }

    public synchronized void removePollee(Pollable pollee) {
        if (this.m_pollableObjects.remove(pollee)) {
            this.updatePollThread();
        }
    }

    public synchronized void resume() {
        this.updatePollThread();
    }

    public synchronized void pause() {
        this.stopIfNotStopped();
    }

    public synchronized void stop() {
        this.m_pollableObjects.clear();
        this.updatePollThread();
    }

    private void updatePollThread() {
        if (this.m_pollableObjects.size() > 0) {
            this.startIfNotStarted();
        } else {
            this.stopIfNotStopped();
        }
    }

    private void startIfNotStarted() {
        if (!this.m_keepAlive) {
            this.m_keepAlive = true;
            new Thread((Runnable)this, "Polling Thread").start();
        }
    }

    private void stopIfNotStopped() {
        if (this.m_keepAlive) {
            this.m_keepAlive = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.m_keepAlive) {
            try {
                this.pollAllPollees();
                PollManager pollManager = this;
                synchronized (pollManager) {
                    this.wait(this.m_pollingInterval);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void pollAllPollees() {
        Object[] pollees;
        Object[] objectArray = pollees = this.m_pollableObjects.toArray();
        int n = pollees.length;
        int n2 = 0;
        while (n2 < n) {
            Object pollee = objectArray[n2];
            Pollable pollableObject = (Pollable)pollee;
            if (!pollableObject.poll()) {
                this.m_pollableObjects.remove(pollableObject);
            }
            ++n2;
        }
    }

    public synchronized void poll() {
        this.notifyAll();
    }

    public static interface Pollable {
        public boolean poll();
    }
}

