/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.column;

import java.util.Comparator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Listener;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.misc.DelegatingLabelProvider;
import org.openjdk.jmc.ui.misc.OptimisticComparator;

public class ColumnBuilder {
    private static final ColumnLabelProvider DEFAULT_LP = new ColumnLabelProvider(){

        public String getText(Object element) {
            return element == null ? "" : TypeHandling.getValueString((Object)element);
        }

        public String getToolTipText(Object element) {
            return element == null ? "null" : TypeHandling.getVerboseString((Object)element);
        }

        public Font getToolTipFont(Object element) {
            return element == null ? JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont") : super.getToolTipFont(element);
        }

        public Font getFont(Object element) {
            return JFaceResources.getDefaultFont();
        }
    };
    private Column column;

    public ColumnBuilder(String name, String id, ColumnLabelProvider labelProvider) {
        this.column = new Column(name, id);
        this.column.labelProvider = labelProvider;
    }

    public <T> ColumnBuilder(String name, String id, IMemberAccessor<?, T> cellAccessor) {
        this.column = new Column(name, id);
        this.column.cellAccessor = cellAccessor;
        this.column.labelProvider = new DelegatingLabelProvider(ColumnBuilder.DEFAULT_LP, this.column.cellAccessor);
        this.column.comparator = new OptimisticComparator(this.column.cellAccessor, (ILabelProvider)this.column.labelProvider);
    }

    private Column getColumn() {
        if (this.column == null) {
            throw new IllegalStateException("Column already built. ColumnBuilder cannot be reused.");
        }
        return this.column;
    }

    public ColumnBuilder description(String description) {
        this.getColumn().description = description;
        return this;
    }

    public ColumnBuilder style(int style) {
        this.getColumn().style = style;
        return this;
    }

    public ColumnBuilder labelProvider(ColumnLabelProvider labelProvider) {
        this.getColumn().labelProvider = labelProvider;
        return this;
    }

    public ColumnBuilder comparator(Comparator<Object> comparator) {
        this.getColumn().comparator = comparator;
        return this;
    }

    public ColumnBuilder editingSupport(EditingSupport editingSupport) {
        this.getColumn().editingSupport = editingSupport;
        return this;
    }

    public ColumnBuilder columnDrawer(Listener drawer) {
        this.getColumn().columnDrawer = drawer;
        return this;
    }

    public IColumn build() {
        Column col = this.column;
        this.column = null;
        return col;
    }

    private static class Column
    implements IColumn {
        private ColumnLabelProvider labelProvider;
        private EditingSupport editingSupport;
        private IMemberAccessor<?, Object> cellAccessor;
        private final String name;
        private String description;
        private final String id;
        private int style = 0;
        private Comparator<Object> comparator;
        private Listener columnDrawer;

        public Column(String name, String id) {
            this.name = name;
            this.id = id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public int getStyle() {
            return this.style;
        }

        @Override
        public ColumnLabelProvider getLabelProvider() {
            return this.labelProvider;
        }

        @Override
        public EditingSupport getEditingSupport() {
            return this.editingSupport;
        }

        @Override
        public Comparator<Object> getComparator() {
            return this.comparator;
        }

        @Override
        public IMemberAccessor<?, Object> getCellAccessor() {
            return this.cellAccessor;
        }

        @Override
        public Listener getColumnDrawer() {
            return this.columnDrawer;
        }
    }
}

