/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;

final class TemplateLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private boolean displayVersion;

    public TemplateLabelProvider(boolean displayVersion) {
        this.displayVersion = displayVersion;
    }

    public String getText(Object element) {
        IEventConfiguration rt = (IEventConfiguration)element;
        String text = rt.getName();
        String location = rt.getLocationInfo();
        if (location != null) {
            text = String.valueOf(text) + " - " + location;
        }
        if (this.displayVersion) {
            String version = rt.getVersion().getDescription();
            text = String.valueOf(text) + " (" + version + ")";
        }
        return text;
    }

    public StyledString getStyledText(Object element) {
        IEventConfiguration rt = (IEventConfiguration)element;
        StyledString styled = new StyledString(rt.getName());
        String location = rt.getLocationInfo();
        if (location != null) {
            styled.append(" - " + location, StyledString.DECORATIONS_STYLER);
        }
        if (this.displayVersion) {
            String version = rt.getVersion().getDescription();
            styled.append(" (" + version + ")", StyledString.QUALIFIER_STYLER);
        }
        return styled;
    }

    public Image getImage(Object element) {
        return ControlPanel.getDefault().getImage("jfr_template.png");
    }
}

