/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.RecordingProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.jobs.UpdateRecordingJob;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizard;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class EditRecordingWizard
extends RecordingWizard {
    private final RecordingProvider recording;

    public EditRecordingWizard(RecordingProvider recording, RecordingWizardModel model) {
        super(model);
        this.recording = recording;
    }

    @Override
    public boolean performFinish() {
        boolean superFinish = super.performFinish();
        if (!superFinish) {
            return false;
        }
        this.editRecording(this.getModel());
        return true;
    }

    private void editRecording(RecordingWizardModel wizardModel) {
        try {
            IConstrainedMap<String> recordingOptions = wizardModel.buildOptions();
            this.recording.setDumpToFile(wizardModel.getPath());
            UpdateRecordingJob updateJob = new UpdateRecordingJob(this.recording.getServerHandle(), this.recording.getRecordingDescriptor(), recordingOptions, wizardModel.getAndSaveEventSettings());
            updateJob.schedule();
        }
        catch (IllegalArgumentException | QuantityConversionException e) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.FLIGHT_RECORDING_OPTIONS_PROBLEM_TITLE, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

