/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.model;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IMutableConstrainedMap;
import org.openjdk.jmc.common.unit.IOptionDescriptor;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.SimpleConstrainedMap;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.configuration.ConfigurationToolkit;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeID;
import org.openjdk.jmc.flightrecorder.configuration.events.SchemaVersion;
import org.openjdk.jmc.flightrecorder.configuration.internal.CommonConstraints;
import org.openjdk.jmc.flightrecorder.configuration.spi.IConfigurationStorageDelegate;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.IXMLValidator;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.JFCGrammar;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.JFCXMLValidator;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLAttribute;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTag;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.VolatileStorageDelegate;
import org.openjdk.jmc.rjmx.services.jfr.IEventTypeInfo;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class EventConfiguration
implements IEventConfiguration {
    private XMLModel xmlModel;
    private final IConfigurationStorageDelegate storageDelegate;
    private final SchemaVersion version;
    private final IEventConfiguration original;

    public static void validate(InputStream xmlStream, String streamName, SchemaVersion version) throws ParseException, IOException {
        block6: {
            InputStream schemaStream = version.createSchemaStream();
            if (schemaStream != null) {
                try {
                    try {
                        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                        XMLModel.validate((InputStream)xmlStream, (String)streamName, (Schema)schemaFactory.newSchema(new StreamSource(schemaStream)));
                        break block6;
                    }
                    catch (SAXException e) {
                        throw new IOException("Trouble parsing schema for version " + version, e);
                    }
                }
                finally {
                    IOToolkit.closeSilently((Closeable)schemaStream);
                }
            }
            throw new IOException("Could not locate schema for version " + version);
        }
    }

    public static IEventConfiguration createEmpty(IConfigurationStorageDelegate delegate, SchemaVersion version) {
        Map<String, String> attributes = Collections.singletonMap(JFCGrammar.ATTRIBUTE_VERSION.getName(), version.attributeValue());
        XMLModel model = XMLModel.createEmpty((IXMLValidator)JFCXMLValidator.getValidator(), attributes);
        EventConfiguration config = new EventConfiguration(model, delegate, null);
        config.setName(Messages.RECORDING_TEMPLATE_NEW_NAME);
        return config;
    }

    public static XMLModel createModel(String xmlText) throws ParseException, IOException {
        return XMLModel.create((InputSource)new InputSource(new StringReader(xmlText)), (IXMLValidator)JFCXMLValidator.getValidator());
    }

    public static XMLModel createModel(File file) throws FileNotFoundException, IOException, ParseException {
        return EventConfiguration.createModel(new FileInputStream(file));
    }

    public static XMLModel createModel(InputStream inStream) throws IOException, ParseException {
        XMLModel model;
        try {
            model = XMLModel.create((InputSource)new InputSource(inStream), (IXMLValidator)JFCXMLValidator.getValidator());
        }
        finally {
            IOToolkit.closeSilently((Closeable)inStream);
        }
        return model;
    }

    public EventConfiguration(XMLModel xml) {
        this(xml, VolatileStorageDelegate.getWorkingCopyDelegate(), null);
    }

    public EventConfiguration(IConfigurationStorageDelegate delegate) throws IOException, ParseException {
        this(EventConfiguration.createModel(delegate.getContents()), delegate, null);
    }

    public EventConfiguration(XMLModel xml, IConfigurationStorageDelegate storageDelegate) {
        this(xml, storageDelegate, null);
    }

    public EventConfiguration(XMLModel xml, IConfigurationStorageDelegate storageDelegate, IEventConfiguration original) {
        this.xmlModel = xml;
        this.storageDelegate = storageDelegate;
        this.original = original;
        this.version = SchemaVersion.fromBeanVersion((String)this.getRoot().getValue(JFCGrammar.ATTRIBUTE_VERSION));
        if (this.version == null) {
            throw new IllegalArgumentException("Schema version cannot be null");
        }
    }

    boolean replaceWithContentsFrom(IEventConfiguration workingCopy) {
        if (workingCopy.getOriginal() == this && workingCopy instanceof EventConfiguration) {
            this.xmlModel = ((EventConfiguration)workingCopy).getXMLModel().deepClone();
            return true;
        }
        return false;
    }

    private XMLTagInstance getRoot() {
        return this.xmlModel.getRoot();
    }

    public String getName() {
        if (this.getRoot().getTag() == JFCGrammar.TAG_CONFIGURATION_V1) {
            return this.getRoot().getValue(JFCGrammar.ATTRIBUTE_NAME);
        }
        return this.getRoot().getValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY);
    }

    public void setName(String name) {
        if (this.getRoot().getTag() == JFCGrammar.TAG_CONFIGURATION_V1) {
            this.getRoot().setValue(JFCGrammar.ATTRIBUTE_NAME, name);
        } else {
            this.getRoot().setValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY, name);
        }
    }

    public String getDescription() {
        return this.getRoot().getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.getRoot().setValue(JFCGrammar.ATTRIBUTE_DESCRIPTION, description);
    }

    public SchemaVersion getVersion() {
        return this.version;
    }

    public IConstrainedMap<EventOptionID> getEventOptions(IMutableConstrainedMap<EventOptionID> options) {
        switch (this.version) {
            case V1: {
                for (XMLTagInstance producer : this.getRoot().getTagsInstances(JFCGrammar.TAG_PRODUCER)) {
                    String producerURI = producer.getValue(JFCGrammar.ATTRIBUTE_URI);
                    for (XMLTagInstance event : producer.getTagsInstances(JFCGrammar.TAG_EVENTTYPE_V1)) {
                        String eventPath = event.getValue(JFCGrammar.ATTRIBUTE_PATH);
                        IEventTypeID eventTypeID = ConfigurationToolkit.createEventTypeID((String)producerURI, (String)eventPath);
                        this.getOptionsFromEventTo(eventTypeID, event, options);
                    }
                }
                break;
            }
            case V2: {
                this.getNestedEventOptions(this.getRoot(), options);
                break;
            }
        }
        return options;
    }

    private void getNestedEventOptions(XMLTagInstance element, IMutableConstrainedMap<EventOptionID> options) {
        for (XMLTagInstance child : element.getTagsInstances()) {
            XMLTag childTag = child.getTag();
            if (childTag == JFCGrammar.TAG_EVENTTYPE_V2) {
                String eventName = child.getValue(JFCGrammar.ATTRIBUTE_NAME);
                IEventTypeID eventTypeID = ConfigurationToolkit.createEventTypeID((String)eventName);
                this.getOptionsFromEventTo(eventTypeID, child, options);
                continue;
            }
            if (childTag != JFCGrammar.TAG_CATEGORY) continue;
            this.getNestedEventOptions(child, options);
        }
    }

    private void getOptionsFromEventTo(IEventTypeID eventTypeID, XMLTagInstance event, IMutableConstrainedMap<EventOptionID> options) {
        for (XMLTagInstance option : event.getTagsInstances(JFCGrammar.TAG_SETTING)) {
            EventOptionID optionID = new EventOptionID(eventTypeID, option.getValue(JFCGrammar.ATTRIBUTE_NAME));
            String contentType = option.getExplicitValue(JFCGrammar.ATTRIBUTE_CONTENT_TYPE);
            try {
                if (contentType != null) {
                    IConstraint constraint = CommonConstraints.forContentTypeV2((String)contentType);
                    options.putPersistedString((Object)optionID, constraint, option.getContent());
                    continue;
                }
                options.putPersistedString((Object)optionID, option.getContent());
            }
            catch (IllegalArgumentException | QuantityConversionException e) {
                ControlPanel.getDefault().getLogger().log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    public String getPersistableString(EventOptionID optionID) {
        XMLTagInstance settingElement = this.findOption(optionID, false);
        return settingElement != null ? settingElement.getContent() : null;
    }

    public boolean hasOption(EventOptionID eventOptionID) {
        return this.findOption(eventOptionID, false) != null;
    }

    private XMLTagInstance findProducer(String producerURI, boolean create) {
        XMLTagInstance producer = this.getRoot().findTagWithAttribute(JFCGrammar.TAG_PRODUCER, JFCGrammar.ATTRIBUTE_URI, producerURI);
        if (create && producer == null) {
            producer = this.getRoot().create(JFCGrammar.TAG_PRODUCER);
            producer.setValue(JFCGrammar.ATTRIBUTE_URI, producerURI);
        }
        return producer;
    }

    private XMLTagInstance findCategory(XMLTagInstance parent, String category, boolean create) {
        XMLTagInstance categoryInstance = parent.findTagWithAttribute(JFCGrammar.TAG_CATEGORY, JFCGrammar.ATTRIBUTE_LABEL_MANDATORY, category);
        if (categoryInstance == null) {
            for (XMLTagInstance subcategory : parent.getTagsInstances(JFCGrammar.TAG_CATEGORY)) {
                categoryInstance = this.findCategory(subcategory, category, false);
                if (categoryInstance == null) continue;
                return categoryInstance;
            }
        }
        if (create && categoryInstance == null) {
            categoryInstance = parent.create(JFCGrammar.TAG_CATEGORY);
            categoryInstance.setValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY, category);
        }
        return categoryInstance;
    }

    public boolean hasEvent(IEventTypeID eventTypeID) {
        return this.findEvent(eventTypeID, false) != null;
    }

    XMLTagInstance findEvent(IEventTypeID eventTypeID, boolean create) {
        XMLTagInstance eventType;
        XMLAttribute keyAttribute;
        XMLTag eventTag;
        XMLTagInstance origin;
        if (eventTypeID.getProducerKey() != null) {
            origin = this.findProducer(eventTypeID.getProducerKey(), create);
            eventTag = JFCGrammar.TAG_EVENTTYPE_V1;
            keyAttribute = JFCGrammar.ATTRIBUTE_PATH;
            eventType = origin != null ? origin.findTagWithAttribute(eventTag, keyAttribute, eventTypeID.getRelativeKey()) : null;
        } else {
            origin = this.getRoot();
            eventTag = JFCGrammar.TAG_EVENTTYPE_V2;
            keyAttribute = JFCGrammar.ATTRIBUTE_NAME;
            eventType = origin.findNestedTagWithAttribute(JFCGrammar.TAG_CATEGORY, eventTag, keyAttribute, eventTypeID.getRelativeKey());
        }
        if (create && eventType == null) {
            eventType = origin.create(eventTag);
            eventType.setValue(keyAttribute, eventTypeID.getRelativeKey());
        }
        return eventType;
    }

    private XMLTagInstance findOption(EventOptionID eventOptionID, boolean create) {
        XMLTagInstance option;
        XMLTagInstance eventType = this.findEvent(eventOptionID.getEventTypeID(), create);
        XMLTagInstance xMLTagInstance = option = eventType != null ? eventType.findTagWithAttribute(JFCGrammar.TAG_SETTING, JFCGrammar.ATTRIBUTE_NAME, eventOptionID.getOptionKey()) : null;
        if (create && option == null) {
            option = eventType.create(JFCGrammar.TAG_SETTING);
            option.setValue(JFCGrammar.ATTRIBUTE_NAME, eventOptionID.getOptionKey());
        }
        return option;
    }

    public void putPersistedString(EventOptionID optionID, String persisted) {
        XMLTagInstance optionTag = this.findOption(optionID, true);
        optionTag.setContent(persisted);
    }

    public void removeOption(EventOptionID optionID) {
        XMLTagInstance optionTag = this.findOption(optionID, false);
        if (optionTag != null) {
            optionTag.getParent().remove(optionTag);
        }
    }

    public boolean isCloneable() {
        return true;
    }

    public IEventConfiguration createClone() {
        return this.createCloneWithStorage(this.storageDelegate);
    }

    public IEventConfiguration createCloneWithStorage(IConfigurationStorageDelegate storageDelegate) {
        return new EventConfiguration(this.xmlModel.deepClone(), storageDelegate, this.original);
    }

    public IEventConfiguration createWorkingCopy() {
        return new EventConfiguration(this.xmlModel.deepClone(), VolatileStorageDelegate.getWorkingCopyDelegate(), this);
    }

    public IEventConfiguration getOriginal() {
        return this.original;
    }

    public boolean isExportable() {
        return true;
    }

    public void exportToFile(File file) throws IOException {
        this.xmlModel.saveToFile(file);
    }

    public boolean hasControlElements() {
        XMLTagInstance root = this.getRoot();
        for (XMLTagInstance producerTag : root.getTagsInstances(JFCGrammar.TAG_PRODUCER)) {
            if (producerTag.getTagsInstances(JFCGrammar.TAG_CONTROL).size() <= 0) continue;
            return true;
        }
        return root.getTagsInstances(JFCGrammar.TAG_CONTROL).size() > 0;
    }

    public boolean removeControlElements() {
        boolean changed = false;
        XMLTagInstance root = this.getRoot();
        switch (this.version) {
            case V1: {
                for (XMLTagInstance producerElement : root.getTagsInstances(JFCGrammar.TAG_PRODUCER)) {
                    for (XMLTagInstance controlElement : producerElement.getTagsInstances(JFCGrammar.TAG_CONTROL)) {
                        producerElement.remove(controlElement);
                        changed = true;
                    }
                    for (XMLTagInstance eventElement : producerElement.getTagsInstances(JFCGrammar.TAG_EVENTTYPE_V1)) {
                        for (XMLTagInstance settingElement : eventElement.getTagsInstances(JFCGrammar.TAG_SETTING)) {
                            changed |= settingElement.setValue(JFCGrammar.ATTRIBUTE_CONTROL_REFERENCE, null);
                        }
                    }
                }
                break;
            }
            case V2: {
                for (XMLTagInstance controlElement : root.getTagsInstances(JFCGrammar.TAG_CONTROL)) {
                    root.remove(controlElement);
                    changed = true;
                }
                changed |= this.removeNestedControlReferences(root);
                break;
            }
        }
        return changed;
    }

    private boolean removeNestedControlReferences(XMLTagInstance parent) {
        boolean changed = false;
        for (XMLTagInstance child : parent.getTagsInstances()) {
            XMLTag childTag = child.getTag();
            if (childTag == JFCGrammar.TAG_EVENTTYPE_V2) {
                for (XMLTagInstance settingElement : child.getTagsInstances(JFCGrammar.TAG_SETTING)) {
                    changed |= settingElement.setValue(JFCGrammar.ATTRIBUTE_CONTROL_REFERENCE, null);
                }
                continue;
            }
            if (childTag != JFCGrammar.TAG_CATEGORY) continue;
            changed |= this.removeNestedControlReferences(child);
        }
        return changed;
    }

    public XMLModel getXMLModel() {
        return this.xmlModel;
    }

    public String getLocationPath() {
        return this.storageDelegate.getLocationPath();
    }

    public String getLocationInfo() {
        return this.storageDelegate.getLocationInfo();
    }

    public boolean isDeletable() {
        return this.storageDelegate.isDeletable();
    }

    public boolean delete() {
        return this.storageDelegate.delete();
    }

    public boolean isSaveable() {
        return this.storageDelegate.isSaveable();
    }

    public boolean save() {
        StringWriter writer = new StringWriter(2000);
        if (this.xmlModel.writeTo((Writer)writer)) {
            try {
                return this.storageDelegate.save(((Object)writer).toString());
            }
            catch (IOException e) {
                ControlPanel.getDefault().getLogger().log(Level.WARNING, "Cannot save configuration.", e);
            }
        }
        return false;
    }

    public boolean equalSettings(IEventConfiguration other) {
        if (other == this) {
            return true;
        }
        SimpleConstrainedMap ourOptions = new SimpleConstrainedMap((IConstraint)UnitLookup.PLAIN_TEXT.getPersister());
        this.getEventOptions((IMutableConstrainedMap<EventOptionID>)ourOptions);
        for (EventOptionID key : ourOptions.keySet()) {
            if (ourOptions.getPersistableString((Object)key).equals(other.getPersistableString(key))) continue;
            return false;
        }
        return ourOptions.keySet().size() == other.getEventOptions(ourOptions.emptyWithSameConstraints()).keySet().size();
    }

    public Set<IEventTypeID> getConfigEventTypes() {
        HashSet<IEventTypeID> eventTypes = new HashSet<IEventTypeID>();
        this.collectConfigEventTypes(this.getRoot(), eventTypes);
        return eventTypes;
    }

    private void collectConfigEventTypes(XMLTagInstance tagInstance, Set<IEventTypeID> eventTypes) {
        for (XMLTagInstance childCategory : tagInstance.getTagsInstances(JFCGrammar.TAG_CATEGORY)) {
            this.collectConfigEventTypes(childCategory, eventTypes);
        }
        for (XMLTagInstance childCategory : tagInstance.getTagsInstances(JFCGrammar.TAG_PRODUCER)) {
            this.collectConfigEventTypes(childCategory, eventTypes);
        }
        XMLTag eventTag = SchemaVersion.V2.equals((Object)this.version) ? JFCGrammar.TAG_EVENTTYPE_V2 : JFCGrammar.TAG_EVENTTYPE_V1;
        for (XMLTagInstance event : tagInstance.getTagsInstances(eventTag)) {
            IEventTypeID eventTypeID = this.createEventTypeID(event);
            eventTypes.add(eventTypeID);
        }
    }

    private IEventTypeID createEventTypeID(XMLTagInstance event) {
        if (event.getParent().getTag().equals(JFCGrammar.TAG_PRODUCER)) {
            return ConfigurationToolkit.createEventTypeID((String)event.getParent().getValue(JFCGrammar.ATTRIBUTE_URI), (String)event.getValue(JFCGrammar.ATTRIBUTE_PATH));
        }
        return ConfigurationToolkit.createEventTypeID((String)event.getValue(JFCGrammar.ATTRIBUTE_NAME));
    }

    public String[] getEventCategory(IEventTypeID eventTypeID) {
        ArrayList<String> categories = new ArrayList<String>();
        XMLTagInstance eventTagInstance = this.findEvent(eventTypeID, false);
        if (eventTagInstance != null) {
            XMLTagInstance current = eventTagInstance.getParent();
            while (current.getTag().equals(JFCGrammar.TAG_CATEGORY)) {
                categories.add(0, current.getValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY));
                current = current.getParent();
            }
        }
        return categories.toArray(new String[categories.size()]);
    }

    public String getEventLabel(IEventTypeID eventTypeID) {
        XMLTagInstance eventTagInstance = this.findEvent(eventTypeID, false);
        return eventTagInstance != null ? eventTagInstance.getExplicitValue(JFCGrammar.ATTRIBUTE_LABEL) : null;
    }

    public String getEventDescription(IEventTypeID eventTypeID) {
        XMLTagInstance eventTagInstance = this.findEvent(eventTypeID, false);
        return eventTagInstance != null ? eventTagInstance.getExplicitValue(JFCGrammar.ATTRIBUTE_DESCRIPTION) : null;
    }

    public Set<EventOptionID> getOptionIDs(IEventTypeID eventTypeID) {
        XMLTagInstance eventType = this.findEvent(eventTypeID, false);
        HashSet<EventOptionID> options = new HashSet<EventOptionID>();
        if (eventType != null) {
            for (XMLTagInstance setting : eventType.getTagsInstances(JFCGrammar.TAG_SETTING)) {
                EventOptionID optionID = new EventOptionID(eventTypeID, setting.getExplicitValue(JFCGrammar.ATTRIBUTE_NAME));
                options.add(optionID);
            }
        }
        return options;
    }

    public String getConfigOptionLabel(EventOptionID eventOptionID) {
        XMLTagInstance option = this.findOption(eventOptionID, false);
        return option != null ? option.getExplicitValue(JFCGrammar.ATTRIBUTE_LABEL) : null;
    }

    public String getConfigOptionDescription(EventOptionID eventOptionID) {
        XMLTagInstance option = this.findOption(eventOptionID, false);
        return option != null ? option.getExplicitValue(JFCGrammar.ATTRIBUTE_DESCRIPTION) : null;
    }

    public String getConfigOptionContentType(EventOptionID eventOptionID) {
        XMLTagInstance option = this.findOption(eventOptionID, false);
        return option != null ? option.getExplicitValue(JFCGrammar.ATTRIBUTE_CONTENT_TYPE) : null;
    }

    void populateOption(EventOptionID optionKey, IOptionDescriptor<?> serverOptionInfo, String value, boolean override) {
        XMLTagInstance configOption = this.findOption(optionKey, true);
        if (override || configOption.getExplicitValue(JFCGrammar.ATTRIBUTE_LABEL) == null) {
            configOption.setValue(JFCGrammar.ATTRIBUTE_LABEL, serverOptionInfo.getName());
        }
        if (override || configOption.getExplicitValue(JFCGrammar.ATTRIBUTE_DESCRIPTION) == null) {
            configOption.setValue(JFCGrammar.ATTRIBUTE_DESCRIPTION, serverOptionInfo.getDescription());
        }
        if (override || configOption.getExplicitValue(JFCGrammar.ATTRIBUTE_CONTENT_TYPE) == null) {
            configOption.setValue(JFCGrammar.ATTRIBUTE_CONTENT_TYPE, CommonConstraints.toMatchingContentTypeV2((IConstraint)serverOptionInfo.getConstraint()));
        }
        if (configOption.getContent() == null || configOption.getContent().length() == 0) {
            configOption.setContent(value);
        }
    }

    void populateEventMetadata(IEventTypeID eventTypeID, IEventTypeInfo serverEventTypeInfo, boolean override) {
        XMLTagInstance event = this.findEvent(eventTypeID, true);
        String configEventLabel = this.getEventLabel(eventTypeID);
        String configEventDescription = this.getEventLabel(eventTypeID);
        if (override || configEventLabel == null) {
            event.setValue(JFCGrammar.ATTRIBUTE_LABEL, serverEventTypeInfo.getName());
        }
        if (override || configEventDescription == null) {
            event.setValue(JFCGrammar.ATTRIBUTE_DESCRIPTION, serverEventTypeInfo.getDescription());
        }
    }

    void putEventInCategory(IEventTypeID eventTypeID, String[] categories) {
        XMLTagInstance categoryParent = this.getRoot();
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            categoryParent = this.findCategory(categoryParent, category, true);
            ++n2;
        }
        XMLTagInstance event = this.findEvent(eventTypeID, false);
        if (event != null) {
            categoryParent.adopt(event);
        } else {
            event = categoryParent.create(JFCGrammar.TAG_EVENTTYPE_V2);
            event.setValue(JFCGrammar.ATTRIBUTE_NAME, eventTypeID.getFullKey());
        }
    }
}

