/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IPredicate;
import org.openjdk.jmc.common.collection.EntryHashMap;
import org.openjdk.jmc.common.collection.IteratorToolkit;
import org.openjdk.jmc.common.collection.MapToolkit;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.LabeledIdentifier;
import org.openjdk.jmc.common.util.PredicateToolkit;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Result;
import org.openjdk.jmc.flightrecorder.rules.RuleRegistry;
import org.openjdk.jmc.flightrecorder.rules.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.tree.Range;
import org.openjdk.jmc.flightrecorder.rules.tree.TimeRangeFilter;
import org.openjdk.jmc.flightrecorder.rules.tree.TimeRangeThreadFilter;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFormatToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceFrame;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;

public class RulesToolkit {
    private static final String REC_SETTING_NAME_ENABLED = "enabled";
    private static final String REC_SETTING_NAME_THRESHOLD = "threshold";
    public static final String REC_SETTING_NAME_PERIOD = "period";
    public static final String REC_SETTING_PERIOD_EVERY_CHUNK = "everyChunk";
    private static final IAccessorFactory<String> TYPE_NAME_ACCESSOR_FACTORY = new IAccessorFactory<String>(){

        public <T> IMemberAccessor<String, T> getAccessor(final IType<T> type) {
            final IMemberAccessor ta = JdkAttributes.REC_SETTING_FOR.getAccessor(type);
            return new IMemberAccessor<String, T>(){

                public String getMember(T inObject) {
                    LabeledIdentifier labeledIdentifier = (LabeledIdentifier)ta.getMember(inObject);
                    return labeledIdentifier == null ? type.getIdentifier() : labeledIdentifier.getName();
                }
            };
        }
    };
    private static final LinearUnit MEBIBYTES = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.MEBI);
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*?JRE \\((\\d+(?:\\.\\d+(?:\\.\\d+(?:[\\._]\\d+)?)?)?(?:-ea)?).*");

    public static double leastSquareMemory(Iterator<? extends IItem> items, IMemberAccessor<IQuantity, IItem> timeField, IMemberAccessor<IQuantity, IItem> memField) {
        double sumX = 0.0;
        double sumY = 0.0;
        double sumX2 = 0.0;
        double sumXY = 0.0;
        double num = 0.0;
        double startTime = 0.0;
        while (items.hasNext()) {
            IItem item = items.next();
            long time = ((IQuantity)timeField.getMember((Object)item)).clampedLongValueIn((IUnit)UnitLookup.EPOCH_S);
            long mem = ((IQuantity)memField.getMember((Object)item)).clampedLongValueIn((IUnit)MEBIBYTES);
            if (num == 0.0) {
                startTime = time;
            }
            time = (long)((double)time - startTime);
            sumX += (double)time;
            sumY += (double)mem;
            sumX2 += (double)(time * time);
            sumXY += (double)(time * mem);
            num += 1.0;
        }
        double value = (num * sumXY - sumX * sumY) / (num * sumX2 - sumX * sumX);
        return Double.isNaN(value) ? 0.0 : value;
    }

    public static String findMatches(String typeId, IItemCollection items, IAttribute<String> attribute, String match, boolean ignoreCase) {
        String regexp = ".*(" + (ignoreCase ? "?i:" : "") + match + ").*";
        return (String)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.distinctAsString((String)typeId, attribute), (IItemFilter)ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)typeId), ItemFilters.matches(attribute, (String)regexp)})));
    }

    public static <T> T getValue(IItem item, IAccessorFactory<T> attribute) {
        IType itemType = ItemToolkit.getItemType((IItem)item);
        IMemberAccessor accessor = attribute.getAccessor(itemType);
        if (accessor == null) {
            throw new IllegalArgumentException("The accessor factory could not build accessor for type " + itemType.getIdentifier() + ". This is likely due to an old unsupported recording where an attribute has changed name.");
        }
        return (T)accessor.getMember((Object)item);
    }

    public static IItemFilter getSettingsFilter(String settingsName, String ... typeIds) {
        final HashSet<String> types = new HashSet<String>(Arrays.asList(typeIds));
        IItemFilter typeFilter = new IItemFilter(){

            public IPredicate<IItem> getPredicate(IType<IItem> type) {
                final IMemberAccessor ma = JdkAttributes.REC_SETTING_FOR.getAccessor(type);
                if (ma != null) {
                    return new IPredicate<IItem>(){

                        public boolean evaluate(IItem o) {
                            LabeledIdentifier eventType = (LabeledIdentifier)ma.getMember((Object)o);
                            return eventType != null && types.contains(eventType.getInterfaceId());
                        }
                    };
                }
                return PredicateToolkit.falsePredicate();
            }
        };
        return ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.RECORDING_SETTING, typeFilter, ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.REC_SETTING_NAME, (Object)settingsName)});
    }

    public static IQuantity getSettingMaxPeriod(IItemCollection items, String ... typeIds) {
        Set<String> values = RulesToolkit.getPeriodSettings(items, typeIds);
        return values == null || values.isEmpty() ? null : RulesToolkit.getSettingMaxPeriod(values);
    }

    public static String getPeriodIfGreaterThan(IItemCollection items, IQuantity minPeriod, String ... typeIds) {
        Set<String> values = RulesToolkit.getPeriodSettings(items, typeIds);
        if (values != null && !values.isEmpty()) {
            IQuantity max = RulesToolkit.getSettingMaxPeriod(values);
            if (max == null) {
                return Messages.getString("RulesToolkit_EVERY_CHUNK");
            }
            if (max.compareTo((Object)minPeriod) > 0) {
                return max.displayUsing("auto");
            }
        }
        return null;
    }

    public static IQuantity parsePersistedJvmTimespan(String persistedValue) throws QuantityConversionException {
        if (persistedValue.endsWith("m")) {
            persistedValue = persistedValue + "in";
        }
        return UnitLookup.TIMESPAN.parsePersisted(persistedValue);
    }

    public static String getTypesWithZeroThreshold(IItemCollection items, String ... typeIds) {
        IItemFilter f = new IItemFilter(){

            public IPredicate<IItem> getPredicate(IType<IItem> type) {
                final IMemberAccessor accessor = JdkAttributes.REC_SETTING_VALUE.getAccessor(type);
                return new IPredicate<IItem>(){

                    public boolean evaluate(IItem o) {
                        try {
                            String thresholdValue = (String)accessor.getMember((Object)o);
                            return RulesToolkit.parsePersistedJvmTimespan(thresholdValue).longValue() == 0L;
                        }
                        catch (QuantityConversionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
        IItemFilter filter = ItemFilters.and((IItemFilter[])new IItemFilter[]{RulesToolkit.getSettingsFilter(REC_SETTING_NAME_THRESHOLD, typeIds), f});
        return RulesToolkit.getEventTypeNames(items.apply(filter));
    }

    public static boolean isEventsEnabled(IItemCollection items, String ... typeIds) {
        IQuantity aggregate = (IQuantity)items.apply(RulesToolkit.createEnablementFilter(true, typeIds)).getAggregate(Aggregators.count());
        return aggregate != null && aggregate.longValue() == (long)typeIds.length;
    }

    public static boolean isEventsEnabled(EventAvailability ... eventAvailabilities) {
        for (EventAvailability availability : eventAvailabilities) {
            if (availability != EventAvailability.DISABLED && availability != EventAvailability.UNKNOWN) continue;
            return false;
        }
        return true;
    }

    private static boolean isEventsDisabled(IItemCollection items, String ... typeIds) {
        IQuantity aggregate = (IQuantity)items.apply(RulesToolkit.createEnablementFilter(false, typeIds)).getAggregate(Aggregators.count());
        return aggregate != null && aggregate.longValue() == (long)typeIds.length;
    }

    public static EventAvailability getEventAvailability(IItemCollection items, String ... typeIds) {
        if (RulesToolkit.hasEvents(items, typeIds)) {
            return EventAvailability.AVAILABLE;
        }
        if (RulesToolkit.isEventsEnabled(items, typeIds)) {
            return EventAvailability.ENABLED;
        }
        if (RulesToolkit.isEventsDisabled(items, typeIds)) {
            return EventAvailability.DISABLED;
        }
        if (RulesToolkit.isEventsKnown(items, typeIds)) {
            return EventAvailability.NONE;
        }
        return EventAvailability.UNKNOWN;
    }

    public static EventAvailability getLeastAvailable(EventAvailability ... availabilites) {
        EventAvailability lowest = EventAvailability.AVAILABLE;
        for (EventAvailability availability : availabilites) {
            if (!availability.isLessAvailableThan(lowest)) continue;
            lowest = availability;
        }
        return lowest;
    }

    private static boolean isEventsKnown(IItemCollection items, String ... typeIds) {
        Set<String> availableTypes = RulesToolkit.getAvailableTypeIds(items);
        return availableTypes.containsAll(Arrays.asList(typeIds));
    }

    private static boolean hasEvents(IItemCollection items, String ... typeIds) {
        for (String typeId : typeIds) {
            if (RulesToolkit.internalHasEvents(items, typeId)) continue;
            return false;
        }
        return true;
    }

    public static Result getEventAvailabilityResult(IRule rule, IItemCollection items, EventAvailability eventAvailability, String ... typeIds) {
        switch (eventAvailability) {
            case ENABLED: 
            case NONE: {
                String requiredEventsTypeNames = RulesToolkit.getEventTypeNames(items, typeIds);
                return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_EVENTS"), requiredEventsTypeNames), MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_EVENTS_LONG"), rule.getName(), requiredEventsTypeNames));
            }
            case DISABLED: {
                String disabledEventTypeNames = RulesToolkit.getDisabledEventTypeNames(items, typeIds);
                return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_EVENT_TYPE"), disabledEventTypeNames), MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_EVENT_TYPE_LONG"), rule.getName(), disabledEventTypeNames));
            }
            case UNKNOWN: {
                ArrayList<String> quotedTypeIds = new ArrayList<String>();
                for (String typeId : typeIds) {
                    quotedTypeIds.add("'" + typeId + "'");
                }
                Collections.sort(quotedTypeIds);
                String unavailableTypeNames = StringToolkit.join(quotedTypeIds, (String)", ");
                return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_UNAVAILABLE_EVENT_TYPE"), rule.getName(), unavailableTypeNames), MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_UNAVAILABLE_EVENT_TYPE_LONG"), rule.getName(), unavailableTypeNames));
            }
            case AVAILABLE: {
                String availableEventTypeNames = RulesToolkit.getEventTypeNames(items, typeIds);
                return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_EVENT_TYPE_NOT_AVAILABLE"), availableEventTypeNames), MessageFormat.format("RulesToolkit_RULE_REQUIRES_EVENT_TYPE_NOT_AVAILABLE_LONG", rule.getName(), availableEventTypeNames));
            }
        }
        throw new IllegalArgumentException("Unsupported event availability: " + (Object)((Object)eventAvailability));
    }

    public static Result getTooFewEventsResult(IRule rule) {
        return RulesToolkit.getNotApplicableResult(rule, Messages.getString("RulesToolkit_TOO_FEW_EVENTS"));
    }

    public static Result getNotApplicableResult(IRule rule, String message) {
        return RulesToolkit.getNotApplicableResult(rule, message, null);
    }

    private static Result getNotApplicableResult(IRule rule, String shortMessage, String longMessage) {
        return new Result(rule, -1.0, shortMessage, longMessage);
    }

    public static Result getRuleRequiresAtLeastOneEventTypeResult(IRule rule, String ... typeIds) {
        return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_RULE_REQUIRES_SOME_EVENTS"), rule.getName(), StringToolkit.join((Object[])typeIds, (String)", ")));
    }

    public static String getEnabledEventTypesRecommendation(IItemCollection items, String ... typeIds) {
        return MessageFormat.format(Messages.getString("RulesToolkit_RULE_RECOMMENDS_EVENTS"), RulesToolkit.getDisabledEventTypeNames(items, typeIds));
    }

    public static JavaVersion getJavaSpecVersion(IItemCollection items) {
        IItemCollection versionProperties = items.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.SYSTEM_PROPERTIES, ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.ENVIRONMENT_KEY, (Object)"java.vm.specification.version")}));
        Set vmSpecificationVersions = (Set)versionProperties.getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.ENVIRONMENT_VALUE));
        if (vmSpecificationVersions != null && vmSpecificationVersions.size() >= 1) {
            return new JavaVersion((String)vmSpecificationVersions.iterator().next());
        }
        JavaVersion jvmVersion = RulesToolkit.getJavaVersion(items);
        if (jvmVersion != null) {
            return new JavaVersion(new int[]{jvmVersion.getMajorVersion()});
        }
        return null;
    }

    public static JavaVersion getJavaVersion(IItemCollection items) {
        String jvmVersion = (String)items.getAggregate(JdkAggregators.JVM_VERSION);
        return RulesToolkit.getJavaVersion(jvmVersion);
    }

    public static double mapExp74(double value, double x1) {
        return RulesToolkit.mapExp(value, 74.0, x1, 25.0);
    }

    public static double mapExp100(double value, double x1) {
        return RulesToolkit.mapExp(value, 100.0, x1, 75.0);
    }

    public static double mapExp100Y(double value, double x1, double y1) {
        return RulesToolkit.mapExp(value, 100.0, x1, y1);
    }

    public static double mapExp100(double value, double x1, double x2) {
        return RulesToolkit.mapExp(value, 100.0, x1, 25.0, x2, 75.0);
    }

    public static double mapExp(double value, double ceiling, double x1, double y1) {
        if (value < 0.0) {
            return 0.0;
        }
        double k = Math.log(1.0 - y1 / ceiling) / x1;
        return ceiling * (1.0 - Math.exp(k * value));
    }

    private static double mapExp(double value, double ceiling, double x1, double y1, double x2, double y2) {
        if (value < 0.0) {
            return 0.0;
        }
        if (value < x1) {
            return y1 / x1 * value;
        }
        return y1 + RulesToolkit.mapExp(value - x1, ceiling - y1, x2 - x1, y2 - y1);
    }

    public static double mapLin100(double value, double x1, double x2) {
        if (value <= 0.0) {
            return 0.0;
        }
        if (value >= 1.0) {
            return 1.0;
        }
        if (value <= x1) {
            return value * 25.0 / x1;
        }
        if (value <= x2) {
            return 25.0 + (value - x1) * 50.0 / (x2 - x1);
        }
        return 75.0 + (value - x2) * 25.0 / (1.0 - x2);
    }

    public static <T> List<MapToolkit.IntEntry<T>> calculateGroupingScore(IItemCollection items, IAccessorFactory<T> accessorFactory) {
        EntryHashMap map = MapToolkit.createIntMap((int)1000, (float)0.5f);
        for (IItemIterable ii : items) {
            IMemberAccessor accessor = accessorFactory.getAccessor(ii.getType());
            if (accessor == null) continue;
            for (IItem item : ii) {
                Object member = accessor.getMember((Object)item);
                if (member == null) continue;
                MapToolkit.IntEntry entry = (MapToolkit.IntEntry)map.get(member, true);
                entry.setValue(entry.getValue() + 1);
            }
        }
        List array = IteratorToolkit.toList((Iterator)map.iterator(), (int)map.size());
        Collections.sort(array);
        return array;
    }

    public static <T> double calculateBalanceScore(List<MapToolkit.IntEntry<T>> array) {
        int totalCount = 0;
        for (MapToolkit.IntEntry<T> e : array) {
            totalCount += e.getValue();
        }
        double score = 0.0;
        for (int i = array.size() - 1; i >= 0; --i) {
            int index = array.size() - i;
            score += (double)array.get(i).getValue() / (double)totalCount / (double)index;
        }
        return score;
    }

    public static IQuantity getDurationInWindow(IQuantity windowStart, IQuantity windowEnd, IItem item) {
        IQuantity start = RulesToolkit.getStartTime(item);
        IQuantity end = RulesToolkit.getEndTime(item);
        IQuantity startCapped = start.compareTo((Object)windowStart) > 0 ? start : windowStart;
        IQuantity endCapped = end.compareTo((Object)windowEnd) > 0 ? windowEnd : end;
        IQuantity durationCapped = endCapped.subtract(startCapped);
        return durationCapped;
    }

    public static double mapSigmoid(double input, double minimum, double maximum, double lowCurveFit, double inflectionPoint, double highCurveFit) {
        double g = Math.exp(lowCurveFit * (inflectionPoint - input));
        double h = Math.exp(highCurveFit * (inflectionPoint - input));
        return minimum + maximum / (1.0 + g + h);
    }

    private static IQuantity getSettingMaxPeriod(Iterable<String> settingsValues) {
        IQuantity maxPeriod = null;
        for (String s : settingsValues) {
            try {
                if (REC_SETTING_PERIOD_EVERY_CHUNK.equals(s)) {
                    return null;
                }
                IQuantity p = RulesToolkit.parsePersistedJvmTimespan(s);
                if (maxPeriod != null && maxPeriod.compareTo((Object)p) >= 0) continue;
                maxPeriod = p;
            }
            catch (QuantityConversionException e) {
                throw new RuntimeException(e);
            }
        }
        return maxPeriod;
    }

    private static Set<String> getPeriodSettings(IItemCollection items, String ... typeIds) {
        IItemFilter filter = RulesToolkit.getSettingsFilter(REC_SETTING_NAME_PERIOD, typeIds);
        return (Set)items.apply(filter).getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.REC_SETTING_VALUE));
    }

    private static String getDisabledEventTypeNames(IItemCollection items, String ... typeIds) {
        return RulesToolkit.getEventTypeNames(items.apply(RulesToolkit.createEnablementFilter(false, typeIds)));
    }

    private static String getEventTypeNames(IItemCollection items, String ... typeIds) {
        return RulesToolkit.getEventTypeNames(items.apply(RulesToolkit.getSettingsFilter(REC_SETTING_NAME_ENABLED, typeIds)));
    }

    private static String getEventTypeNames(IItemCollection items) {
        Set names = (Set)items.getAggregate(Aggregators.distinct((String)"", TYPE_NAME_ACCESSOR_FACTORY));
        if (names == null) {
            return null;
        }
        ArrayList<String> quotedNames = new ArrayList<String>();
        for (String name : names) {
            quotedNames.add("'" + name + "'");
        }
        Collections.sort(quotedNames);
        return StringToolkit.join(quotedNames, (String)", ");
    }

    private static IItemFilter createEnablementFilter(boolean enabled, String ... typeIds) {
        IItemFilter settingsFilter = RulesToolkit.getSettingsFilter(REC_SETTING_NAME_ENABLED, typeIds);
        IItemFilter enabledFilter = ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.REC_SETTING_VALUE, (Object)(enabled ? Boolean.TRUE.toString() : Boolean.FALSE.toString()));
        IItemFilter enablementFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{settingsFilter, enabledFilter});
        return enablementFilter;
    }

    private static boolean internalHasEvents(IItemCollection items, String typeId) {
        return items.apply(ItemFilters.type((String)typeId)).hasItems();
    }

    private static Set<String> getAvailableTypeIds(IItemCollection items) {
        HashSet<String> ids = new HashSet<String>();
        for (IItemIterable iterable : items) {
            ids.add(iterable.getType().getIdentifier());
        }
        return ids;
    }

    public static JavaVersion getJavaVersion(String vmInfoVersionString) {
        Matcher versionMatcher;
        if (vmInfoVersionString != null && (versionMatcher = VERSION_PATTERN.matcher(vmInfoVersionString)).matches()) {
            String versionString = versionMatcher.group(1);
            return new JavaVersion(versionString);
        }
        return null;
    }

    public static IType<IItem> getType(IItemCollection items, String typeId) {
        for (IItemIterable iter : items) {
            if (!iter.getType().getIdentifier().equals(typeId)) continue;
            return iter.getType();
        }
        return null;
    }

    public static Result getMissingAttributeResult(IRule rule, IType<IItem> type, IAttribute<?> attribute) {
        return RulesToolkit.getNotApplicableResult(rule, MessageFormat.format(Messages.getString("RulesToolkit_ATTRIBUTE_NOT_FOUND"), attribute.getIdentifier(), type.getIdentifier()), MessageFormat.format(Messages.getString("RulesToolkit_ATTRIBUTE_NOT_FOUND_LONG"), attribute.getIdentifier(), type.getIdentifier()));
    }

    public static TimeRangeThreadFilter createThreadsAndRangesFilter(IItemCollection items) {
        HashMap<IMCThread, Range> rangeMap = new HashMap<IMCThread, Range>();
        for (IItemIterable iter : items) {
            for (IItem item : iter) {
                IMCThread thread = RulesToolkit.getThread(item);
                if (thread == null) continue;
                if (!rangeMap.containsKey(thread)) {
                    rangeMap.put(thread, new Range(RulesToolkit.getStartTime(item), RulesToolkit.getEndTime(item)));
                    continue;
                }
                Range r = (Range)rangeMap.get(thread);
                IQuantity startTime = RulesToolkit.getStartTime(item);
                IQuantity endTime = RulesToolkit.getEndTime(item);
                if (startTime.compareTo((Object)r.startTime) >= 0 && endTime.compareTo((Object)r.endTime) <= 0) continue;
                IQuantity newStartTime = startTime.compareTo((Object)r.startTime) < 0 ? startTime : r.startTime;
                IQuantity newEndTime = endTime.compareTo((Object)r.endTime) > 0 ? endTime : r.endTime;
                rangeMap.put(thread, new Range(newStartTime, newEndTime));
            }
        }
        return new TimeRangeThreadFilter(rangeMap);
    }

    public static IItemFilter createRangeFilter(IItem item) {
        return new TimeRangeFilter(new Range(RulesToolkit.getStartTime(item), RulesToolkit.getEndTime(item)));
    }

    public static IQuantity getStartTime(IItem item) {
        return (IQuantity)RulesToolkit.getValue(item, JfrAttributes.START_TIME);
    }

    public static IQuantity getEndTime(IItem item) {
        return (IQuantity)RulesToolkit.getValue(item, JfrAttributes.END_TIME);
    }

    public static IQuantity getDuration(IItem item) {
        return (IQuantity)RulesToolkit.getValue(item, JfrAttributes.DURATION);
    }

    public static IMCThread getThread(IItem item) {
        return (IMCThread)RulesToolkit.getOptionalValue(item, JfrAttributes.EVENT_THREAD);
    }

    private static <T> T getOptionalValue(IItem item, IAccessorFactory<T> attribute) {
        IType itemType = ItemToolkit.getItemType((IItem)item);
        IMemberAccessor accessor = attribute.getAccessor(itemType);
        if (accessor == null) {
            return null;
        }
        return (T)accessor.getMember((Object)item);
    }

    public static IQuantity toRatioPercent(IQuantity antecedent, IQuantity consequent) {
        return UnitLookup.PERCENT.quantity(antecedent.ratioTo(consequent) * 100.0);
    }

    public static String toRatioPercentString(IQuantity antecedent, IQuantity consequent) {
        return RulesToolkit.toRatioPercent(antecedent, consequent).displayUsing("auto");
    }

    public static Collection<String> getAllTopics() {
        HashSet<String> topics = new HashSet<String>();
        for (IRule r : RuleRegistry.getRules()) {
            topics.add(r.getTopic());
        }
        return topics;
    }

    public static Map<IRule, Future<Result>> evaluateParallel(Collection<IRule> rules, IItemCollection items, IPreferenceValueProvider preferences, int nThreads) {
        if (preferences == null) {
            preferences = IPreferenceValueProvider.DEFAULT_VALUES;
        }
        if (nThreads < 1) {
            nThreads = Runtime.getRuntime().availableProcessors();
        }
        HashMap<IRule, Future<Result>> resultFutures = new HashMap<IRule, Future<Result>>();
        ConcurrentLinkedQueue<RunnableFuture<Result>> futureQueue = new ConcurrentLinkedQueue<RunnableFuture<Result>>();
        for (IRule rule : rules) {
            RunnableFuture<Result> resultFuture = rule.evaluate(items, preferences);
            resultFutures.put(rule, resultFuture);
            futureQueue.add(resultFuture);
        }
        for (int i = 0; i < nThreads; ++i) {
            RuleEvaluator re = new RuleEvaluator(futureQueue);
            Thread t = new Thread(re);
            t.start();
        }
        return resultFutures;
    }

    public static String getSecondFrameInMostCommonTrace(IItemCollection items) {
        FrameSeparator sep = new FrameSeparator(FrameSeparator.FrameCategorization.LINE, false);
        StacktraceModel stacktraceModel = new StacktraceModel(false, sep, items);
        StacktraceModel.Branch firstBranch = stacktraceModel.getRootFork().getBranch(0);
        StacktraceFrame secondFrame = null;
        if (firstBranch.getTailFrames().length > 0) {
            secondFrame = firstBranch.getTailFrames()[0];
        } else if (firstBranch.getEndFork().getBranchCount() > 0) {
            secondFrame = firstBranch.getEndFork().getBranch(0).getFirstFrame();
        } else {
            return null;
        }
        return StacktraceFormatToolkit.formatFrame((IMCFrame)secondFrame.getFrame(), (FrameSeparator)sep, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    public static Map<String, String> getFlightRecorderOptions(IItemCollection items) {
        IItemFilter optionsFilter;
        HashMap<String, String> options = new HashMap<String, String>();
        IItemFilter stringFlagsFilter = ItemFilters.type((String)"jdk.StringFlag");
        IItemCollection optionsFlag = items.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{stringFlagsFilter, optionsFilter = ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (String)"FlightRecorderOptions")}));
        Set optionsValues = (Set)optionsFlag.getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.FLAG_VALUE_TEXT));
        if (optionsValues != null && optionsValues.size() > 0) {
            String[] allOptions;
            String optionsValue = (String)optionsValues.iterator().next();
            for (String optionAndValue : allOptions = optionsValue.split(",")) {
                String[] optionAndValueSplit = optionAndValue.split("=");
                if (optionAndValueSplit.length >= 2) {
                    options.put(optionAndValueSplit[0], optionAndValueSplit[1]);
                    continue;
                }
                options.put(optionAndValue, "");
            }
        }
        return options;
    }

    public static String getShortRecordingInfo(IItemCollection items, IQuantity shortRecordingLimit) {
        boolean shortRecording;
        IQuantity recordingDuration = RulesToolkit.getItemRange(items);
        boolean bl = shortRecording = recordingDuration.compareTo((Object)shortRecordingLimit) < 0;
        if (shortRecording) {
            return MessageFormat.format(Messages.getString("Result_SHORT_RECORDING"), recordingDuration.displayUsing("auto"), shortRecordingLimit.displayUsing("auto"));
        }
        return null;
    }

    private static IQuantity getItemRange(IItemCollection items) {
        IQuantity first = (IQuantity)items.getAggregate(JdkAggregators.FIRST_ITEM_START);
        IQuantity last = (IQuantity)items.getAggregate(JdkAggregators.LAST_ITEM_END);
        return last.subtract(first);
    }

    public static Map<String, Integer> sortMap(Map<String, Integer> map, final boolean sortAscending) {
        ArrayList<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                if (sortAscending) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : entries) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }

    private static class RuleEvaluator
    implements Runnable {
        private Queue<RunnableFuture<Result>> futureQueue;

        public RuleEvaluator(Queue<RunnableFuture<Result>> futureQueue) {
            this.futureQueue = futureQueue;
        }

        @Override
        public void run() {
            RunnableFuture<Result> resultFuture;
            while ((resultFuture = this.futureQueue.poll()) != null) {
                resultFuture.run();
            }
        }
    }

    public static enum EventAvailability {
        AVAILABLE(4),
        ENABLED(3),
        DISABLED(2),
        NONE(1),
        UNKNOWN(0);

        private final int availabilityScore;

        private EventAvailability(int availabilityScore) {
            this.availabilityScore = availabilityScore;
        }

        public boolean isLessAvailableThan(EventAvailability availability) {
            return this.availabilityScore < availability.availabilityScore;
        }
    }
}

