/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree;

import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeNode;
import org.openjdk.jmc.flightrecorder.rules.tree.ITreeVisitor;

public class TreeNode<T>
implements ITreeNode<T> {
    private TreeNode<T> parent;
    private List<ITreeNode<T>> children = new ArrayList<ITreeNode<T>>();
    private boolean hasDuration;
    private IQuantity startTime;
    private IQuantity endTime;
    private IMCThread thread;
    private T item;

    public TreeNode(T item) {
        this.item = item;
    }

    public TreeNode(T item, boolean hasDuration, IQuantity startTime, IQuantity endTime, IMCThread thread) {
        this.item = item;
        this.hasDuration = hasDuration;
        this.startTime = startTime;
        this.endTime = endTime;
        this.thread = thread;
    }

    @Override
    public ITreeNode<T> getParent() {
        return this.parent;
    }

    @Override
    public List<ITreeNode<T>> getChildren() {
        return this.children;
    }

    @Override
    public T getValue() {
        return this.item;
    }

    public boolean hasDuration() {
        return this.hasDuration;
    }

    public IQuantity getStartTime() {
        return this.startTime;
    }

    public IQuantity getEndTime() {
        return this.endTime;
    }

    public IMCThread getThread() {
        return this.thread;
    }

    @Override
    public void accept(ITreeVisitor<T> visitor) {
        visitor.visit(this);
    }

    public void addChild(TreeNode<T> node) {
        this.children.add(node);
        node.parent = this;
    }

    void removeChild(TreeNode<T> node) {
        this.children.remove(node);
        node.parent = null;
    }

    public String toString() {
        return "TreeNode: " + String.valueOf(this.item);
    }

    public void detach() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }
}

