/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.tree;

import org.openjdk.jmc.common.IPredicate;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.rules.tree.Range;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class TimeRangeFilter
implements IItemFilter {
    private Range range;

    public TimeRangeFilter(Range range) {
        this.range = range;
    }

    public IPredicate<IItem> getPredicate(IType<IItem> type) {
        return new TimeRangePredicate();
    }

    public String toString() {
        return "TimeRangeFilter " + this.toString(this.range);
    }

    private String toString(Range range) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(String.format("Range: %s", range));
        builder.append("]");
        return builder.toString();
    }

    private class TimeRangePredicate
    implements IPredicate<IItem> {
        private TimeRangePredicate() {
        }

        public boolean evaluate(IItem o) {
            return this.intersects(o, TimeRangeFilter.this.range);
        }

        private boolean intersects(IItem o, Range range) {
            IQuantity startTime = RulesToolkit.getStartTime(o);
            IQuantity endTime = RulesToolkit.getStartTime(o);
            if (range.isInside(startTime) || range.isInside(endTime)) {
                return true;
            }
            return range.isBefore(startTime) && range.isAfter(endTime);
        }
    }
}

