/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.configuration.internal;

import java.util.regex.Pattern;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeID;

public final class EventTypeIDV2
implements IEventTypeID {
    private static final Pattern PACKAGE_SPLIT_REGEX = Pattern.compile("\\.");
    private final String eventName;

    public EventTypeIDV2(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public String getProducerKey() {
        return null;
    }

    @Override
    public String getRelativeKey() {
        return this.eventName;
    }

    @Override
    public String[] getFallbackHierarchy() {
        return PACKAGE_SPLIT_REGEX.split(this.eventName);
    }

    @Override
    public String getFullKey() {
        return this.eventName;
    }

    @Override
    public String getFullKey(String optionKey) {
        return String.valueOf(this.eventName) + '#' + optionKey;
    }

    public boolean equals(Object other) {
        if (other instanceof EventTypeIDV2) {
            EventTypeIDV2 otherID = (EventTypeIDV2)other;
            return this.eventName.equals(otherID.eventName);
        }
        return false;
    }

    public int hashCode() {
        return this.eventName.hashCode();
    }

    public String toString() {
        return this.eventName;
    }
}

