/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.configuration.internal;

import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeID;
import org.openjdk.jmc.flightrecorder.internal.EventAppearance;

public final class EventTypeIDV1
implements IEventTypeID {
    private final String producerURI;
    private final String eventURI;
    private final String eventPath;
    private String[] cachedFallbackHierarchy;

    public EventTypeIDV1(String producerURI, String eventPath) {
        this(String.valueOf(producerURI) + eventPath, producerURI.length());
    }

    public EventTypeIDV1(String eventURI, int producerEndPos) {
        this.eventURI = eventURI;
        this.eventPath = eventURI.substring(producerEndPos);
        this.producerURI = eventURI.substring(0, producerEndPos);
    }

    @Override
    public String getProducerKey() {
        return this.producerURI;
    }

    @Override
    public String getRelativeKey() {
        return this.eventPath;
    }

    @Override
    public String[] getFallbackHierarchy() {
        if (this.cachedFallbackHierarchy == null) {
            this.cachedFallbackHierarchy = EventAppearance.getHumanSegmentArray((String)this.eventPath);
        }
        return this.cachedFallbackHierarchy;
    }

    @Override
    public String getFullKey() {
        return this.eventURI;
    }

    @Override
    public String getFullKey(String optionKey) {
        return String.valueOf(this.eventURI) + ':' + optionKey;
    }

    public boolean equals(Object other) {
        if (other instanceof EventTypeIDV1) {
            EventTypeIDV1 otherID = (EventTypeIDV1)other;
            return this.eventURI.equals(otherID.eventURI) && this.eventPath.equals(otherID.eventPath);
        }
        return false;
    }

    public int hashCode() {
        return this.eventURI.hashCode();
    }

    public String toString() {
        return this.eventURI;
    }
}

