(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14327,        539]
NotebookOptionsPosition[     10676,        402]
NotebookOutlinePosition[     11087,        418]
CellTagsIndexPosition[     11044,        415]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "New in: ",
 Cell["6.1", "HistoryData",
  CellTags->"New"],
 " | Modified in: ",
 Cell[" ", "HistoryData",
  CellTags->"Modified"],
 " | Obsolete in: ",
 Cell[" ", "HistoryData",
  CellTags->"Obsolete"],
 " | Excised in: ",
 Cell[" ", "HistoryData",
  CellTags->"Excised"]
}], "History",
 CellChangeTimes->{{3.39358269310471*^9, 3.3935826934279337`*^9}},
 CellID->1247902091],

Cell[CellGroupData[{

Cell["Categorization", "CategorizationSection",
 CellID->1122911449],

Cell["Tutorial", "Categorization",
 CellLabel->"Entity Type",
 CellID->686433507],

Cell["Transmogrify", "Categorization",
 CellChangeTimes->{{3.393582700784326*^9, 3.3935827102021093`*^9}},
 CellLabel->"Paclet Name",
 CellID->605800465],

Cell["Transmogrify`", "Categorization",
 CellChangeTimes->{{3.393582711752283*^9, 3.393582712197106*^9}},
 CellLabel->"Context",
 CellID->468444828],

Cell["Transmogrify/tutorial/TransmogrifySyntax", "Categorization",
 CellChangeTimes->{{3.4159844961815557`*^9, 3.415984506105856*^9}},
 CellLabel->"URI",
 CellID->130212647]
}, Closed]],

Cell[CellGroupData[{

Cell["Synonyms", "SynonymsSection",
 CellID->1427418553],

Cell["XXXX", "Synonyms",
 CellID->1251652828]
}, Open  ]],

Cell[CellGroupData[{

Cell["Keywords", "KeywordsSection",
 CellID->1427428552],

Cell["XXXX", "Keywords",
 CellID->1251852827]
}, Closed]],

Cell[CellGroupData[{

Cell["Details", "DetailsSection",
 CellID->362531892],

Cell["XXXX", "Details",
 CellLabel->"Developers",
 CellID->662402305],

Cell["XXXX", "Details",
 CellLabel->"Comments",
 CellID->440314087]
}, Closed]],

Cell["Transmogrify Syntax", "Title",
 CellChangeTimes->{{3.393582578934505*^9, 3.393582593495398*^9}, {
  3.393582894688936*^9, 3.393582896405136*^9}},
 CellID->509267359],

Cell[CellGroupData[{

Cell["XMLTransform Basics", "Section",
 CellID->303142783],

Cell[CellGroupData[{

Cell["\<\
Transmogrify uses XMLTransforms to determine how to convert a notebook into \
XML.  The XMLTransform structure is designed to be easy to use by providing \
an abstraction layer over the underlying notebook structure.  An XMLTransform \
is essentially a list of rules which convert specific Box/Cell styles into \
SymbolicXML.  A typical rule would look like this:\
\>", "Text",
 CellChangeTimes->{{3.393582765505002*^9, 3.393582770550523*^9}},
 CellID->1089543197],

Cell["\<\
{Cell, All, All}:> 
XMLElement[\"p\",{\"class\" -> GetStyle[]}, Recurse[] ]\
\>", "Program",
 CellChangeTimes->{{3.393582811137711*^9, 3.3935828209512033`*^9}},
 CellID->359454010]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The left hand side of the rule is the selector.  It selects any Cell box with \
any style in any screen style environment.  The right hand side specifies the \
output, which looks like\
\>", "Text",
 CellID->472047059],

Cell[TextData[{
 "<p class=\"",
 StyleBox["style", "TI"],
 "\">",
 StyleBox["content", "TI"],
 "</p>"
}], "Program",
 CellID->890328595]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
An XMLTransform is just a collection of these rules and possibly some options \
to control certain aspects of the conversion.  XMLTransform expressions have \
the form\
\>", "Text",
 CellID->86643869],

Cell[TextData[{
 "XMLTransform[{\n   ",
 StyleBox["selector1 ", "TI"],
 ":> ",
 StyleBox["output1", "TI"],
 ",\n   ",
 StyleBox["selector2 ", "TI"],
 ":> ",
 StyleBox["output2", "TI"],
 ",\n   \[VerticalEllipsis]\n   ",
 StyleBox["selectorN ", "TI"],
 ":> ",
 StyleBox["outputN", "TI"],
 "\n}, ",
 StyleBox["options", "TI"],
 " ]"
}], "Program",
 CellID->229593617]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
When Transmogrify is called on a notebook, it locates the appropriate \
XMLTransform and performs the conversion.  The conversion process is fairly \
straight-forward.  First, a rule is found for converting the notebook.  This \
might look something like\
\>", "Text",
 CellID->1899290907],

Cell["\<\
{Notebook, All, All}:> XMLObject[\"Document\"][{},
   XMLElement[\"html\", {}, {
      XMLElement[\"head\", {}, Transmogrify[
         SelectImmediateDescendants[Cell, \"Title\"]]
      ]],
      XMLElement[\"body\", {}, Transmogrify[
         SelectImmediateDescendants[Cell, \"Section\"]]
      ]]
   }],
{}]\
\>", "Program",
 CellID->1185344941]
}, Open  ]],

Cell[TextData[{
 "This simply provides the XML output for the notebook expression, and \
specifies where the converted content of the notebook should go.  The call to \
",
 StyleBox["Transmogrify", "MR"],
 " within the rule specifies that content should be converted and inserted in \
that location.  This will typically be called on the results of a selector \
function, such as ",
 StyleBox["SelectImmediateDescendants", "MR"],
 " in this example."
}], "Text",
 CellID->2034113815],

Cell[TextData[{
 "When ",
 StyleBox["Transmogrify", "MR"],
 " is called on selected content, the same process is performed on those \
selected expressions.  For each expression, an appropriate rule is found, and \
conversion is performed according to that rule."
}], "Text",
 CellID->1558712112]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rule Selectors", "Section",
 CellID->121456631],

Cell[TextData[{
 "The selectors used on the left-hand side of rules in the ",
 "XMLTransform",
 " are lists with at most three elements.  These specify the expression type \
(e.g. ",
 StyleBox["Cell", "MR"],
 " or ",
 StyleBox["StyleBox", "MR"],
 "), the expression style (e.g. ",
 StyleBox["\"Section\"", "MR"],
 " or ",
 StyleBox["\"Text\"", "MR"],
 ") and the screen style environment (e.g. ",
 StyleBox["\"Working\"", "MR"],
 " or ",
 StyleBox["\"Presentation\"", "MR"],
 ").  Each of these can do more than just specify a single value.  They can \
be an ",
 StyleBox["Alternatives", "MR"],
 " expression (using the ",
 StyleBox["|", "MR"],
 " infix operator) or the symbol ",
 StyleBox["All", "MR"],
 ".  Additionally, the style and screen style environment can use the symbol \
",
 StyleBox["None", "MR"],
 "."
}], "Text",
 CellID->1212132567],

Cell[CellGroupData[{

Cell[TextData[{
 "For instance, the following rule selects all ",
 StyleBox["StyleBox", "MR"],
 " and ",
 StyleBox["ButtonBox", "MR"],
 " expressions with no style, and only when the screen style environment is \
set to ",
 StyleBox["\"Working\"", "MR"],
 "."
}], "Text",
 CellID->1282178127],

Cell[TextData[{
 "{StyleBox | ButtonBox, None, \"Working\"}:> ",
 StyleBox["output", "TI"]
}], "Program",
 CellID->1716866491]
}, Open  ]],

Cell["\<\
Clearly, since selectors needn't be very specific, there is a chance that two \
or more selectors will match the same box structure.  In fact, this will be \
very common in most XMLTransforms.  The Transmogrify utility determines which \
rule to apply by computing a specificity number for each selector.  Selectors \
with larger specificities are preferred over those with lower specificities.  \
In case of a tie, the rule which appeared earliest among those of the maximal \
specificity is used.\
\>", "Text",
 CellID->1784833145],

Cell[TextData[{
 "The specificity is very simple.  A value of zero, one, or two is assigned \
to each element of the selector.  Two is assigned if the element is a \
specific string or symbol, or if it is the special symbol ",
 StyleBox["None", "MR"],
 ".  One is assigned for expressions using ",
 StyleBox["Alternatives", "MR"],
 ".  Zero is assigned for the special symbol ",
 StyleBox["All", "MR"],
 ".  The sum of these three numbers is the specificity of the selector.  \
Thus, the specificity of the above selector is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "2", "+", "2"}], ")"}], "=", "5"}], 
   TraditionalForm]]],
 "."
}], "Text",
 CellID->1639086719],

Cell[TextData[{
 "As a notational convenience, selectors can drop either just the screen \
style environment or both the box style and screen style environment.  These \
will default to ",
 StyleBox["All", "MR"],
 " if not present."
}], "Text",
 CellID->210262517]
}, Open  ]],

Cell[CellGroupData[{

Cell["Selector Functions", "Section",
 CellID->1271523904],

Cell["\<\
The core of the functionality is selecting content and converting it.  To do \
this, Transmogrify provides a number of functions which select content \
relative to the current expression.  These selector functions allow you to \
work with a notebook in an essentially DOM-like manner, selecting parents, \
siblings, descendants, etc.\
\>", "Text",
 CellID->892483231],

Cell[CellGroupData[{

Cell["\<\
Like most of the functions supplied by Transmogrify, the selector functions \
have a context node.  For instance, suppose we have the following rule:\
\>", "Text",
 CellID->1939872769],

Cell["\<\
{StyleBox, \"MR\"}:> XMLElement[\"font\", {\"class\"->\"MR\"},
   Transmogrify[ SelectChildren[] ] ]\
\>", "Program",
 CellID->344899829]
}, Open  ]],

Cell[TextData[{
 "When a StyleBox expression is being converted by this rule, that StyleBox \
is in context when ",
 StyleBox["SelectChildren[]", "MR"],
 " is called.  Consequently, the children of that ",
 StyleBox["StyleBox", "MR"],
 " are selected.  However, if a selector is passed an expression or list of \
expressions as its first argument, it will select relative to the expression \
or expressions given."
}], "Text",
 CellID->673062750],

Cell[CellGroupData[{

Cell["\<\
The following rule selects the children of the first child of the context \
expression.\
\>", "Text",
 CellID->1369270501],

Cell["\<\
{CellGroupData, \"Title\"}:> XMLElement[\"title\", {},
   Transmogrify[SelectChildren[ First[SelectChildren[]] ]] ]\
\>", "Program",
 CellID->894549055]
}, Open  ]],

Cell[CellGroupData[{

Cell["More About", "TutorialMoreAboutSection",
 CellID->23220180],

Cell["XXXX", "TutorialMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[CellGroupData[{

Cell["Related Tutorials", "RelatedTutorialsSection",
 CellID->415694126],

Cell["XXXX", "RelatedTutorials",
 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["Related Wolfram Education Group Courses", "TutorialRelatedLinksSection",
 CellID->415694148],

Cell["XXXX", "TutorialRelatedLinks",
 CellID->415694149]
}, Open  ]]
}, Open  ]]
},
WindowSize->{700, 770},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.1 for Mac OS X x86 (32-bit) (March 24, 2008)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "TutorialPageStyles.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 392, 15, 23, "History",
 CellID->1247902091],
Cell[CellGroupData[{
Cell[962, 39, 68, 1, 27, "CategorizationSection",
 CellID->1122911449],
Cell[1033, 42, 81, 2, 30, "Categorization",
 CellID->686433507],
Cell[1117, 46, 153, 3, 30, "Categorization",
 CellID->605800465],
Cell[1273, 51, 148, 3, 30, "Categorization",
 CellID->468444828],
Cell[1424, 56, 173, 3, 30, "Categorization",
 CellID->130212647]
}, Closed]],
Cell[CellGroupData[{
Cell[1634, 64, 56, 1, 17, "SynonymsSection",
 CellID->1427418553],
Cell[1693, 67, 45, 1, 17, "Synonyms",
 CellID->1251652828]
}, Open  ]],
Cell[CellGroupData[{
Cell[1775, 73, 56, 1, 27, "KeywordsSection",
 CellID->1427428552],
Cell[1834, 76, 45, 1, 17, "Keywords",
 CellID->1251852827]
}, Closed]],
Cell[CellGroupData[{
Cell[1916, 82, 53, 1, 17, "DetailsSection",
 CellID->362531892],
Cell[1972, 85, 69, 2, 30, "Details",
 CellID->662402305],
Cell[2044, 89, 67, 2, 30, "Details",
 CellID->440314087]
}, Closed]],
Cell[2126, 94, 171, 3, 104, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[2322, 101, 58, 1, 41, "Section",
 CellID->303142783],
Cell[CellGroupData[{
Cell[2405, 106, 474, 8, 66, "Text",
 CellID->1089543197],
Cell[2882, 116, 190, 5, 56, "Program",
 CellID->359454010]
}, Open  ]],
Cell[CellGroupData[{
Cell[3109, 126, 228, 5, 36, "Text",
 CellID->472047059],
Cell[3340, 133, 136, 7, 40, "Program",
 CellID->890328595]
}, Open  ]],
Cell[CellGroupData[{
Cell[3513, 145, 210, 5, 36, "Text",
 CellID->86643869],
Cell[3726, 152, 365, 17, 118, "Program",
 CellID->229593617]
}, Open  ]],
Cell[CellGroupData[{
Cell[4128, 174, 299, 6, 51, "Text",
 CellID->1899290907],
Cell[4430, 182, 358, 12, 179, "Program",
 CellID->1185344941]
}, Open  ]],
Cell[4803, 197, 483, 11, 68, "Text",
 CellID->2034113815],
Cell[5289, 210, 295, 7, 52, "Text",
 CellID->1558712112]
}, Open  ]],
Cell[CellGroupData[{
Cell[5621, 222, 53, 1, 41, "Section",
 CellID->121456631],
Cell[5677, 225, 849, 28, 101, "Text",
 CellID->1212132567],
Cell[CellGroupData[{
Cell[6551, 257, 292, 10, 38, "Text",
 CellID->1282178127],
Cell[6846, 269, 126, 4, 40, "Program",
 CellID->1716866491]
}, Open  ]],
Cell[6987, 276, 543, 9, 81, "Text",
 CellID->1784833145],
Cell[7533, 287, 704, 19, 83, "Text",
 CellID->1639086719],
Cell[8240, 308, 264, 7, 37, "Text",
 CellID->210262517]
}, Open  ]],
Cell[CellGroupData[{
Cell[8541, 320, 58, 1, 41, "Section",
 CellID->1271523904],
Cell[8602, 323, 377, 7, 66, "Text",
 CellID->892483231],
Cell[CellGroupData[{
Cell[9004, 334, 194, 4, 36, "Text",
 CellID->1939872769],
Cell[9201, 340, 147, 4, 56, "Program",
 CellID->344899829]
}, Open  ]],
Cell[9363, 347, 446, 10, 68, "Text",
 CellID->673062750],
Cell[CellGroupData[{
Cell[9834, 361, 132, 4, 21, "Text",
 CellID->1369270501],
Cell[9969, 367, 162, 4, 56, "Program",
 CellID->894549055]
}, Open  ]],
Cell[CellGroupData[{
Cell[10168, 376, 65, 1, 71, "TutorialMoreAboutSection",
 CellID->23220180],
Cell[10236, 379, 54, 1, 20, "TutorialMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[CellGroupData[{
Cell[10327, 385, 72, 1, 71, "RelatedTutorialsSection",
 CellID->415694126],
Cell[10402, 388, 52, 1, 20, "RelatedTutorials",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[10491, 394, 98, 1, 71, "TutorialRelatedLinksSection",
 CellID->415694148],
Cell[10592, 397, 56, 1, 20, "TutorialRelatedLinks",
 CellID->415694149]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
