(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15087,        452]
NotebookOptionsPosition[     11542,        359]
NotebookOutlinePosition[     15126,        453]
CellTagsIndexPosition[     15083,        450]
WindowTitle->Special Formatting
WindowFrame->Palette*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[GridBox[{
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Special", " ", "Characters"}],
      BaseStyle->"BoldButton",
      ButtonFunction:>NotebookOpen["SpecialCharacters.nb"]],
     "Open special characters palette.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Shift", 
       StyleBox[
        RowBox[{"+", " ", "\[SelectionPlaceholder]"}],
        FontSize->14]}],
      BaseStyle->"MediumButton",
      ButtonFunction:>(If[NotebookRead[
           InputNotebook[]] === {}, 
         FrontEndExecute[
          FrontEnd`FrontEndToken[
           InputNotebook[], "SelectPrevious"]]]; NotebookApply[
         InputNotebook[], 
         TextData[{
           StyleBox["Shift", "KeyEvent"], 
           StyleBox["+", "KeyEventDelimiter"], 
           StyleBox["\[SelectionPlaceholder]", "KeyEvent"]}]])],
     "Shift keyboard form.\nAutoselects previous character if there is no \
selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Ctrl", 
       StyleBox[
        RowBox[{"+", " ", "\[SelectionPlaceholder]"}],
        FontSize->14]}],
      BaseStyle->"MediumButton",
      ButtonFunction:>(If[NotebookRead[
           InputNotebook[]] === {}, 
         FrontEndExecute[
          FrontEnd`FrontEndToken[
           InputNotebook[], "SelectPrevious"]]]; NotebookApply[
         InputNotebook[], 
         TextData[{
           StyleBox["Ctrl", "KeyEvent"], 
           StyleBox["+", "KeyEventDelimiter"], 
           StyleBox["\[SelectionPlaceholder]", "KeyEvent"]}]])],
     "Control keyboard form.\nAutoselects previous character if there is no \
selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Option", 
       StyleBox[
        RowBox[{"+", " ", "\[SelectionPlaceholder]"}],
        FontSize->14]}],
      BaseStyle->"MediumButton",
      ButtonFunction:>(If[NotebookRead[
           InputNotebook[]] === {}, 
         FrontEndExecute[
          FrontEnd`FrontEndToken[
           InputNotebook[], "SelectPrevious"]]]; NotebookApply[
         InputNotebook[], 
         TextData[{
           StyleBox["Option", "KeyEvent"], 
           StyleBox["+", "KeyEventDelimiter"], 
           StyleBox["\[SelectionPlaceholder]", "KeyEvent"]}]])],
     "Option keyboard form.\nAutoselects previous character if there is no \
selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Alt", 
       StyleBox[
        RowBox[{"+", " ", "\[SelectionPlaceholder]"}],
        FontSize->14]}],
      BaseStyle->"MediumButton",
      ButtonFunction:>(If[NotebookRead[
           InputNotebook[]] === {}, 
         FrontEndExecute[
          FrontEnd`FrontEndToken[
           InputNotebook[], "SelectPrevious"]]]; NotebookApply[
         InputNotebook[], 
         TextData[{
           StyleBox["Alt", "KeyEvent"], 
           StyleBox["+", "KeyEventDelimiter"], 
           StyleBox["\[SelectionPlaceholder]", "KeyEvent"]}]])],
     "Alt keyboard form.\nAutoselects previous character if there is no \
selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      DynamicBox[ToBoxes[
        If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
       ImageSizeCache->{30., {0., 8.}}],
      BaseStyle->{"MediumButton", ShowStringCharacters -> False},
      ButtonFunction:>NotebookWrite[
        InputNotebook[], 
        Cell[
         BoxData[
          FormBox[
           StyleBox[
            DynamicBox[
             ToBoxes[
              If[$OperatingSystem === "MacOSX", "Return", "Enter"], 
              StandardForm], ImageSizeCache -> {43.125, 9.}], "KeyEvent"], 
           TraditionalForm]], NotebookDefault, ShowStringCharacters -> 
         False]]],
     "Enter/Return keyboard form.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{
       StyleBox["Shift", "KeyEvent"], 
       StyleBox["+",
        FontSize->14], 
       DynamicBox[ToBoxes[
         If[$OperatingSystem === "MacOSX", "Return", "Enter"], StandardForm],
        ImageSizeCache->{30., {0., 8.}}]}],
      BaseStyle->{"MediumButton", ShowStringCharacters -> False},
      ButtonFunction:>NotebookWrite[
        InputNotebook[], 
        Cell[
         BoxData[
          FormBox[
           RowBox[{
             StyleBox["Shift", "KeyEvent"], 
             StyleBox["+", "KeyEventDelimiter"], 
             StyleBox[
              DynamicBox[
               ToBoxes[
                If[$OperatingSystem === "MacOSX", "Return", "Enter"], 
                StandardForm], ImageSizeCache -> {38., 9.}], "KeyEvent"]}], 
           TraditionalForm]], NotebookDefault, ShowStringCharacters -> 
         False]]],
     "Shift+Enter/Return keyboard form.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      StyleBox["\[EscapeKey]",
       FontSize->15],
      BaseStyle->"MediumButton",
      ButtonFunction:>NotebookWrite[
        InputNotebook[], 
        TextData[
         StyleBox["Esc", "KeyEvent"]]]],
     "Esc keyboard form.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{
       StyleBox["\[EscapeKey]",
        FontSize->15], 
       RowBox[{
       "\[VeryThinSpace]", "\[SelectionPlaceholder]", "\[VeryThinSpace]"}], 
       StyleBox["\[EscapeKey]",
        FontSize->15]}],
      BaseStyle->"MediumButton",
      ButtonFunction:>(If[NotebookRead[
           InputNotebook[]] === {}, 
         FrontEndExecute[
          FrontEnd`FrontEndToken[
           InputNotebook[], "SelectPreviousWord"]]]; NotebookApply[
         InputNotebook[], 
         TextData[{
           StyleBox["Esc", "KeyEvent"], 
           StyleBox[
           "\[ThinSpace]\[SelectionPlaceholder]\[ThinSpace]", "InlineCode"], 
           StyleBox["Esc", "KeyEvent"]}]])],
     "Esc sequence template.\nAutoselects previous character if there is no \
selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{
      "\[AliasIndicator]", "\[MediumSpace]", "\[SelectionPlaceholder]", 
       "\[MediumSpace]", "\[AliasIndicator]"}],
      BaseStyle->"MediumButton",
      ButtonFunction:>(If[NotebookRead[
           InputNotebook[]] === {}, 
         FrontEndExecute[
          FrontEnd`FrontEndToken[
           InputNotebook[], "SelectPreviousWord"]]]; NotebookApply[
         InputNotebook[], 
         "\[AliasIndicator] \[SelectionPlaceholder] \[AliasIndicator]"])],
     "Escape key template for special characters.\nAutoselects previous \
character if there is no selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Menu", "  ", "Item"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocuTools`StyleApply["MenuName"]]],
     "Style selection as menu item.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{
      "xxxx", "  ", "\[FilledRightTriangle]", "  ", 
       "\[SelectionPlaceholder]"}],
      BaseStyle->"MediumButton",
      ButtonFunction:>(If[NotebookRead[
           InputNotebook[]] === {}, 
         FrontEndExecute[
          FrontEnd`FrontEndToken[
           InputNotebook[], "SelectPreviousWord"]]]; NotebookApply[
         InputNotebook[], 
         TextData[{
           StyleBox["xxxx", "MenuName"], 
           StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"], 
           StyleBox["\[SelectionPlaceholder]", "MenuName"]}]])],
     "Menu item template.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Pointer", "  ", "Event"}],
      BaseStyle->"MediumButton",
      ButtonData:>Hold[
        DocuTools`StyleApply["PointerEvent"]]],
     "Style selection as pointer or action event item.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"xxxx", 
       StyleBox[
        RowBox[{"\[NegativeVeryThinSpace]", "+"}],
        FontSize->14], 
       RowBox[{
       "\[VeryThinSpace]", "\[SelectionPlaceholder]", "\[VeryThinSpace]"}]}],
      BaseStyle->"MediumButton",
      ButtonFunction:>(If[NotebookRead[
           InputNotebook[]] === {}, 
         FrontEndExecute[
          FrontEnd`FrontEndToken[
           InputNotebook[], "SelectPrevious"]]]; NotebookApply[
         InputNotebook[], 
         TextData[{
           StyleBox["xxxx", "PointerEvent"], 
           StyleBox["+", "PointerEventDelimiter"], 
           StyleBox["\[SelectionPlaceholder]", "PointerEvent"]}]])],
     "Pointer event template for click+drag.\nAutoselects previous character \
if there is no selection.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      SuperscriptBox["\[SelectionPlaceholder]", "st"],
      BaseStyle->"MediumButton",
      ButtonFunction:>DocuTools`RaisedOrdinal["st"]],
     "Adds st as superscript to selection or word ahead of cursor.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      SuperscriptBox["\[SelectionPlaceholder]", "nd"],
      BaseStyle->"MediumButton",
      ButtonFunction:>DocuTools`RaisedOrdinal["nd"]],
     "Adds nd as superscript to selection or word ahead of cursor.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      SuperscriptBox["\[SelectionPlaceholder]", "rd"],
      BaseStyle->"MediumButton",
      ButtonFunction:>DocuTools`RaisedOrdinal["rd"]],
     "Adds rd as superscript to selection or word ahead of cursor.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      SuperscriptBox["\[SelectionPlaceholder]", "th"],
      BaseStyle->"MediumButton",
      ButtonFunction:>DocuTools`RaisedOrdinal["th"]],
     "Adds th as superscript to selection or word ahead of cursor.",
     TooltipDelay->0.35]},
   {
    TooltipBox[
     ButtonBox[
      RowBox[{"Line", "  ", "Separator"}],
      BaseStyle->"MediumButton",
      ButtonFunction:>NotebookApply[
        InputNotebook[], "\[LineSeparator]"]],
     "Equivalent to soft carriage return. Shortcut: esc-ls-esc.",
     TooltipDelay->0.35]}
  }]], "PaletteGridCell",
 FontFamily->"Verdana",
 GridBoxOptions->{ColumnsEqual->True,
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], 
     Offset[0.4], 
     Offset[0.4], 
     Offset[0.], 
     Offset[0.], 
     Offset[0.], 
     Offset[0.], 
     Offset[0.], 
     Offset[0.], 
     Offset[0.], 
     Offset[0.], 
     Offset[0.4], 
     Offset[0.], 
     Offset[0.4], 
     Offset[0.], 
     Offset[0.4], 
     Offset[0.], 
     Offset[0.], 
     Offset[0.], 
     Offset[0.4], {
      Offset[0.]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell["\<\
 
\
\>", "Spacer"]
},
ClosingAutoSave->True,
Editable->False,
Saveable->False,
WindowToolbars->{},
Selectable->False,
WindowSize->{152, FitAll},
WindowMargins->{{Automatic, 152}, {Automatic, 0}},
WindowFrame->"Palette",
WindowElements->{},
WindowFrameElements->"CloseBox",
WindowClickSelect->False,
WindowTitle->"Special Formatting",
ScrollingOptions->{"PagewiseDisplay"->True,
"PagewiseScrolling"->True,
"VerticalScrollRange"->Fit},
ShowCellBracket->False,
CellMargins->{{0, 0}, {0, 0}},
Active->True,
AutoMultiplicationSymbol->False,
FontProperties->{"ScreenResolution"->72},
Background->GrayLevel[0.7],
ButtonBoxOptions->{ButtonFunction:>(FrontEnd`MessagesToConsole[
 Needs["DocuTools`"]; Function[$CellContext`e, 
    ReleaseHold[
     If[
      StringQ[$CellContext`e], 
      ToExpression[$CellContext`e], $CellContext`e][]], HoldFirst][#2][]]& )},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData["PaletteTabCell"], CellFrame -> {{0, 0}, {1, 0}}, 
    CellMargins -> {{0, 0}, {-1, 0}}, PageBreakAbove -> True, 
    CellFrameMargins -> -1, FontSize -> 9, Background -> GrayLevel[0.7]], 
   Cell[
    StyleData["PaletteTab"], FontFamily -> "Verdana", FontWeight -> "Bold", 
    FontColor -> GrayLevel[1], 
    ButtonBoxOptions -> {
     Active -> True, Appearance -> {Automatic, "Palette"}, Background -> 
      GrayLevel[0.7], ButtonFunction :> (FrontEndExecute[{
         NotebookLocate[#2]}]& ), ButtonMargins -> 2}], 
   Cell[
    StyleData["PaletteTabSelected"], FontFamily -> "Verdana", FontWeight -> 
    "Bold", FontColor -> GrayLevel[0.5], 
    ButtonBoxOptions -> {
     Active -> False, Appearance -> {Automatic, "Palette"}, Background -> 
      GrayLevel[0], ButtonFunction :> None, ButtonMargins -> 2}], 
   Cell[
    StyleData["PaletteGridCell"], PageWidth -> 153, 
    CellMargins -> {{0, 0}, {0, -1}}, FontSize -> 11, FontWeight -> "Plain", 
    FontColor -> GrayLevel[0.7], 
    ButtonBoxOptions -> {
     Appearance -> {Automatic, "Palette"}, Evaluator -> Automatic, Method -> 
      "Preemptive"}], 
   Cell[
    StyleData["ButtonGroupHead"], FontSize -> 9, FontWeight -> "Bold", 
    FontColor -> GrayLevel[1], 
    ButtonBoxOptions -> {
     Active -> False, Background -> GrayLevel[0.5], ButtonFunction :> None, 
      ButtonMargins -> 1}], 
   Cell[
    StyleData["BoldButton"], FontSize -> 10, FontWeight -> "Bold", FontColor -> 
    GrayLevel[1], 
    ButtonBoxOptions -> {Background -> GrayLevel[0], ButtonMargins -> 6}], 
   Cell[
    StyleData["BigButton"], FontFamily -> "Verdana", FontSize -> 16, 
    FontColor -> GrayLevel[0], ButtonBoxOptions -> {ButtonMargins -> 4}], 
   Cell[
    StyleData["MediumButton"], FontFamily -> "Verdana", FontSize -> 11, 
    FontColor -> GrayLevel[0], 
    ButtonBoxOptions -> {
     ButtonMargins -> 3, Evaluator -> Automatic, Method -> "Preemptive"}], 
   Cell[
    StyleData["MediumButtonHighlight"], FontSize -> 10, FontColor -> 
    RGBColor[0.6, 0.1, 0.1]], 
   Cell[
    StyleData["SmallButton"], FontFamily -> "Verdana", FontSize -> 10, 
    FontColor -> GrayLevel[0], ButtonBoxOptions -> {ButtonMargins -> 1}], 
   Cell[
    StyleData["Spacer"], CellMargins -> {{0, 0}, {0, 0}}, 
    CellElementSpacings -> {"CellMinHeight" -> 2}, FontSize -> 2]}, Visible -> 
  False, FrontEndVersion -> 
  "7.0 for Microsoft Windows (32-bit) (February 18, 2009)", StyleDefinitions -> 
  "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[578, 21, 10929, 331, 378, "PaletteGridCell"],
Cell[11510, 354, 28, 3, 5, "Spacer"]
}
]
*)

(* End of internal cache information *)

