(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    326834,       6537]
NotebookOptionsPosition[    323249,       6420]
NotebookOutlinePosition[    323592,       6435]
CellTagsIndexPosition[    323549,       6432]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
In the palettes' ButtonBoxOptions, FrontEnd`MessagesToConsole inside of which \
is a custom release hold function was used as general wrapper for button \
functions. When a button box had Method -> \"Queued\", the Hold was removed, \
the \[RuleDelayed] was changed to \[Rule] and the rhs was changed to a \
string. In other situations Method \[Rule] \"Preemptive\" was added to \
ButtonBoxOptions in style definitions as needed. These changes were needed so \
that when clicking a button and a kernel message results, it does not get \
written to the palettes. In particular shadowing messages do not get written \
into a palette should they arise. 
\
\>", "Text",
 CellChangeTimes->{{3.445100099585635*^9, 3.4451001073513594`*^9}, {
   3.445100152930068*^9, 3.445100192102444*^9}, {3.4451002583064165`*^9, 
   3.445100291478716*^9}, {3.445100395464422*^9, 3.4451004060583076`*^9}, 
   3.445101130536331*^9, {3.4451011731932735`*^9, 3.445101335134919*^9}, {
   3.4451013936989183`*^9, 3.4451014100430865`*^9}}],

Cell[CellGroupData[{

Cell["Option Settings", "Section",
 CellChangeTimes->{{3.4433689715659876`*^9, 3.4433689725503883`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"palOpts", "=", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ClosingAutoSave", "\[Rule]", "True"}], ",", 
      RowBox[{"Editable", "\[Rule]", "False"}], ",", 
      RowBox[{"WindowToolbars", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"WindowSize", "->", 
       RowBox[{"{", 
        RowBox[{"152", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"WindowMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"WindowFrame", "\[Rule]", "\"\<Palette\>\""}], ",", 
      RowBox[{"WindowElements", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"WindowFrameElements", "\[Rule]", "\"\<CloseBox\>\""}], ",", 
      RowBox[{"WindowTitle", "\[Rule]", "\"\<DocumentationTools\>\""}], ",", 
      RowBox[{"WindowClickSelect", "\[Rule]", "False"}], ",", " ", 
      RowBox[{"Selectable", "\[Rule]", "False"}], ",", 
      RowBox[{"ScrollingOptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<PagewiseScrolling\>\"", "\[Rule]", "False"}], ",", 
         RowBox[{"\"\<PagewiseDisplay\>\"", "\[Rule]", "True"}], ",", 
         RowBox[{"\"\<VerticalScrollRange\>\"", "\[Rule]", "Fit"}]}], "}"}]}],
       ",", 
      RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
      RowBox[{"CellMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Active", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Background", "\[Rule]", 
       RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ButtonBoxOptions", "\[Rule]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{"ButtonFunction", "\[RuleDelayed]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"FrontEnd`MessagesToConsole", "[", 
            RowBox[{"CompoundExpression", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"Needs", "[", "\"\<DocumentationTools`\>\"", "]"}], ",",
               "\[IndentingNewLine]", 
              RowBox[{"DocumentationTools`DocuToolsLoader", "[", "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{"e", ",", 
                  RowBox[{"ReleaseHold", "[", 
                   RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "e", "]"}], ",", 
                    RowBox[{"ToExpression", "[", "e", "]"}], ",", "e"}], 
                    "]"}], "[", "]"}], "]"}], ",", "HoldFirst"}], "]"}], "[", 
                "#2", "]"}], "[", "]"}]}], "]"}], "]"}], "&"}], ")"}]}], 
        "}"}]}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{"AutoMultiplicationSymbol", "\[Rule]", "False"}], ",", 
      RowBox[{"Saveable", "\[Rule]", "False"}], ",", " ", 
      RowBox[{"FontProperties", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<ScreenResolution\>\"", "\[Rule]", "72"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"NotebookDynamicExpression", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"SetOptions", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Notebooks", "[", "\"\<DocumentationTools\>\"", "]"}], 
            "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"WindowMargins", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Automatic", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"StringMatchQ", "[", 
                   RowBox[{"$System", ",", 
                    RowBox[{"\"\<Linux\>\"", "~~", "___"}]}], "]"}], ",", 
                  "100", ",", "0"}], "]"}], ",", "0"}], "}"}]}], "}"}]}]}], 
          "]"}], ";", 
         RowBox[{"Needs", "[", "\"\<DocumentationTools`\>\"", "]"}]}], 
        ")"}]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.36432154151216*^9, 3.36432203822879*^9, 3.376862239022422*^9, {
   3.379536422192342*^9, 3.379536429966998*^9}, {3.404060662556377*^9, 
   3.4040606727546053`*^9}, {3.407200381323001*^9, 3.4072003990941668`*^9}, {
   3.407270081486638*^9, 3.407270166877689*^9}, {3.407270237743065*^9, 
   3.407270270163331*^9}, {3.4072810547062607`*^9, 3.407281074538068*^9}, {
   3.415907434128942*^9, 3.415907489353154*^9}, {3.442792230849286*^9, 
   3.442792244079032*^9}, {3.443207179821451*^9, 3.4432071855090966`*^9}, 
   3.4432075793004274`*^9, {3.4432921448309784`*^9, 3.4432921709722724`*^9}, 
   3.4432927552059784`*^9, 3.4432931653258524`*^9, 3.4609991608753405`*^9, {
   3.4610053989534655`*^9, 3.4610054030940905`*^9}, 3.462205940184631*^9, {
   3.462206093842848*^9, 3.4622061154056234`*^9}, 3.4641199987432327`*^9, {
   3.4641207693578825`*^9, 3.4641207698258915`*^9}, {3.46644178196049*^9, 
   3.4664417908669114`*^9}, 3.466443372256648*^9, {3.4664582310419316`*^9, 
   3.4664582316513186`*^9}, {3.466458288652413*^9, 3.4664583679664354`*^9}, 
   3.466458504750312*^9, {3.4664586195650163`*^9, 3.4664586685503316`*^9}, {
   3.4664601495006404`*^9, 3.4664602108299427`*^9}, {3.4664603307541203`*^9, 
   3.466460343394988*^9}, {3.4695419054636707`*^9, 3.469541910666896*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"CellGrouping", "\[Rule]", "Manual"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"styDefs", "=", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<PaletteTabCell\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"CellFrame", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"CellFrameMargins", "\[Rule]", 
         RowBox[{"-", "1"}]}], ",", 
        RowBox[{"PageWidth", "\[Rule]", "153"}], ",", 
        RowBox[{"FontSize", "\[Rule]", "9"}], ",", 
        RowBox[{"Background", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
        RowBox[{"PageBreakAbove", "\[Rule]", "True"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<PaletteTab\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", " ", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonFunction", "\[RuleDelayed]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"FrontEndExecute", "[", 
               RowBox[{"{", 
                RowBox[{"NotebookLocate", "[", "#2", "]"}], "}"}], "]"}], 
              "&"}], ")"}]}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "2"}], ",", 
           RowBox[{"Active", "\[Rule]", "True"}], ",", " ", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", " ", 
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}]}], "}"}]}]}],
        "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<PaletteTabSelected\>\"", "]"}], ",", 
        " ", "\[IndentingNewLine]", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonFunction", "\[RuleDelayed]", "Null"}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "2"}], ",", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", " ", 
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}]}], "}"}]}]}],
        "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<PaletteGridCell\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", 
        RowBox[{"PageWidth", "\[Rule]", "153"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Plain\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"Evaluator", "\[Rule]", "Automatic"}]}], "}"}]}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<ButtonGroupHead\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"PageWidth", "\[Rule]", "153"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "9"}], ",", " ", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "ButtonData", "\[RuleDelayed]", 
            "DocumentationTools`CellGroupToggle"}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "2"}], ",", 
           RowBox[{"Active", "\[Rule]", "True"}], ",", " ", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<ButtonGroupHeadNonToggle\>\"", "]"}], 
        ",", " ", "\[IndentingNewLine]", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"PageWidth", "\[Rule]", "153"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "9"}], ",", " ", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "2"}], ",", 
           RowBox[{"Active", "\[Rule]", "True"}], ",", " ", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}]}], "}"}]}]}],
        "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<ButtonSubGroupHead\>\"", "]"}], ",", 
        " ", "\[IndentingNewLine]", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"PageWidth", "\[Rule]", "153"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "9"}], ",", " ", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "ButtonData", "\[RuleDelayed]", 
            "DocumentationTools`CellGroupToggle"}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "1"}], ",", 
           RowBox[{"Active", "\[Rule]", "True"}], ",", " ", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.6", "]"}]}], ",", 
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<BoldButton\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "6"}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<BigButton\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "5"}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"Appearance", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", "\"\<FramedPalette\>\""}], "}"}]}]}], 
          "}"}]}]}], "]"}], ",", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<BigButton2\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "3.5"}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"Appearance", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", "\"\<FramedPalette\>\""}], "}"}]}]}], 
          "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<MediumButton\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "3.5"}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"Appearance", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", "\"\<FramedPalette\>\""}], "}"}]}]}], 
          "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<MediumButtonDark\>\"", "]"}], ",", " ",
         "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", " ", 
        RowBox[{"FontSize", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "3.5"}], ",", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.2", "]"}]}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<SmallButton\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "2"}], ",", " ", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"Appearance", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", "\"\<FramedPalette\>\""}], "}"}]}]}], 
          "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<SmallButtonDark\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", " ", 
        RowBox[{"FontSize", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "1"}], ",", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.2", "]"}]}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<TinyButton\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "9"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "1"}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"Appearance", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", "\"\<FramedPalette\>\""}], "}"}]}]}], 
          "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<TinyButtonDark\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", " ", 
        RowBox[{"FontSize", "\[Rule]", "9"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "0"}], ",", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.4", "]"}]}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<NotchButton\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "8"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "1"}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"Appearance", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", "\"\<FramedPalette\>\""}], "}"}]}]}], 
          "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<NotchButtonDark\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "8"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "1"}], ",", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<NotchButtonTiny\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "8"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "0"}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<GrayText\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<ScrollToggle\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
           "ButtonData", "\[RuleDelayed]", 
            "DocumentationTools`ScrollBarToggle"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "2"}], ",", 
           RowBox[{"Active", "\[Rule]", "True"}], ",", " ", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", " ", 
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<PaletteHelpExt\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonFunction", "\[RuleDelayed]", 
            RowBox[{"NotebookOpen", "[", 
             RowBox[{"ToFileName", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "DocumentationTools`$DocuToolsDir", ",", 
                 "\"\<Documentation\>\"", ",", "\"\<English\>\"", ",", 
                 "\"\<Guides\>\""}], "}"}], ",", 
               "\"\<AuthoringUsingDocumentationTools.nb\>\""}], "]"}], 
             "]"}]}], ",", 
           RowBox[{"Evaluator", "\[Rule]", "Automatic"}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "2"}], ",", 
           RowBox[{"Active", "\[Rule]", "True"}], ",", " ", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", " ", 
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<Spacer\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontSize", "\[Rule]", "2"}], ",", 
        RowBox[{"CellElementSpacings", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<CellMinHeight\>\"", "\[Rule]", "2"}], "}"}]}], ",", 
        " ", "\[IndentingNewLine]", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0"}], "}"}]}], "}"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<FunctionField\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontSize", "\[Rule]", "9"}], ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}]}], "]"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.35326884562607*^9, {3.35898465931882*^9, 3.35898466646241*^9}, {
   3.36432269256148*^9, 3.36432269609667*^9}, {3.36554595277046*^9, 
   3.36554597375417*^9}, {3.36554613620255*^9, 3.36554614037896*^9}, {
   3.36554617223518*^9, 3.36554619936664*^9}, {3.3656389997436*^9, 
   3.36563900228739*^9}, {3.36563947740426*^9, 3.36563948324294*^9}, {
   3.3696759418805017`*^9, 3.369675958245723*^9}, {3.3696760363946238`*^9, 
   3.369676041830852*^9}, {3.369676199245801*^9, 3.369676223871188*^9}, {
   3.370298843558712*^9, 3.370298844420945*^9}, {3.3970937204545717`*^9, 
   3.397093730982717*^9}, {3.397095175648163*^9, 3.397095201100823*^9}, 
   3.397095342358794*^9, {3.397095749670683*^9, 3.397095758858182*^9}, {
   3.397095824231646*^9, 3.397095843129127*^9}, 3.397095926014514*^9, {
   3.397096397655736*^9, 3.397096447549597*^9}, {3.397096588301849*^9, 
   3.3970966016846867`*^9}, {3.397096765644627*^9, 3.397096795839769*^9}, {
   3.404001543569523*^9, 3.404001545066737*^9}, {3.404006261682428*^9, 
   3.4040062694710484`*^9}, {3.406163759263051*^9, 3.406163778351685*^9}, {
   3.406164204774147*^9, 3.406164229627932*^9}, {3.4061643317534857`*^9, 
   3.406164406496893*^9}, 3.406164448760396*^9, {3.406164496378769*^9, 
   3.4061645076223087`*^9}, {3.4061645483782587`*^9, 3.406164552458544*^9}, {
   3.406164864768965*^9, 3.406164873920395*^9}, {3.406164952485797*^9, 
   3.406164964453659*^9}, 3.406165026477232*^9, 3.406165062942033*^9, {
   3.406165127911848*^9, 3.4061651305706463`*^9}, {3.430258075091*^9, 
   3.430258075908*^9}, {3.443207250041999*^9, 3.443207251229529*^9}, {
   3.4432072819021893`*^9, 3.443207282995967*^9}, {3.443207377748393*^9, 
   3.443207378264031*^9}, {3.443207411608635*^9, 3.443207473500844*^9}, {
   3.443293944205166*^9, 3.443293947189617*^9}, {3.4432939889250607`*^9, 
   3.443293990190718*^9}, {3.4559766316669264`*^9, 3.4559766355889015`*^9}, {
   3.4559766822932224`*^9, 3.4559766864808292`*^9}, 3.4559769944418383`*^9, 
   3.45597703631791*^9, 3.4561757864991817`*^9, {3.456176118320176*^9, 
   3.456176119742088*^9}, {3.4610001529534655`*^9, 3.4610001539065905`*^9}, {
   3.4610002230315905`*^9, 3.4610002239534655`*^9}, {3.4610003276253405`*^9, 
   3.4610003286565905`*^9}, {3.4610003951878405`*^9, 
   3.4610003964378405`*^9}, {3.4610007522190905`*^9, 
   3.4610007531565905`*^9}, {3.4610012290315905`*^9, 
   3.4610012300472155`*^9}, {3.4622061189056683`*^9, 3.462206126687018*^9}, 
   3.462207755223488*^9, {3.464115650315611*^9, 3.464115675806501*^9}, {
   3.4641157297679386`*^9, 3.464115763838994*^9}, 3.4641158690162163`*^9, 
   3.4641159149278994`*^9, 3.4641160325073605`*^9, {3.464117159036224*^9, 
   3.464117177990588*^9}, {3.464117289002323*^9, 3.4641172892831287`*^9}, 
   3.4641173412165275`*^9, 3.4641173833373375`*^9, {3.464118711156872*^9, 
   3.4641187161177673`*^9}, {3.464119133909402*^9, 3.464119141241543*^9}, {
   3.464549969325595*^9, 3.464549983638278*^9}, {3.466443457695789*^9, 
   3.46644346218025*^9}, {3.466443564682218*^9, 3.4664436279803085`*^9}, {
   3.4664436582465143`*^9, 3.466443676824996*^9}, {3.4664437811707497`*^9, 
   3.4664437863896*^9}, {3.466443827187258*^9, 3.4664438277185183`*^9}, {
   3.4664447990965433`*^9, 3.466444800409068*^9}, {3.466444922770793*^9, 
   3.466444923661435*^9}, {3.466445069289231*^9, 3.466445069867367*^9}, {
   3.4664452218234096`*^9, 3.466445239667502*^9}, {3.466445495500539*^9, 
   3.466445496188052*^9}, {3.4664457265205994`*^9, 3.46644574686474*^9}, {
   3.4664550009799156`*^9, 3.4664550140426664`*^9}, {3.4664550527152843`*^9, 
   3.4664550635748672`*^9}, 3.466455205202587*^9, 3.4664577221102853`*^9, {
   3.466457839534415*^9, 3.466457857925393*^9}, {3.466460849623458*^9, 
   3.466460854014167*^9}, 3.4664611120347457`*^9, 3.466461319335601*^9, 
   3.4664613495393057`*^9, {3.468784135000737*^9, 3.4687841432977715`*^9}, 
   3.4687842397839985`*^9, {3.469803835275545*^9, 3.469803846244506*^9}, 
   3.469804010341406*^9, 3.469805236755578*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["tabGridOptsExt",
    CellMargins->{{12, 12}, {12, 12}}], "=", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ColumnSpacings", "\[Rule]", "0"}], ",", 
      RowBox[{"ColumnWidths", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "0.285", ",", "0.285", ",", "0.17", ",", "0.11"}],
         "}"}]}], ",", 
      RowBox[{"RowSpacings", "\[Rule]", "0"}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35655885365722*^9, 3.35655885649337*^9}, 
   3.3565588957942*^9, {3.4007962353137827`*^9, 3.400796291222375*^9}, {
   3.403999058513513*^9, 3.403999059821238*^9}, {3.4040004106372623`*^9, 
   3.404000413359248*^9}, {3.464119945749014*^9, 3.46411996481258*^9}, {
   3.4734282317660275`*^9, 3.4734282494852314`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"timeStamp", ":=", 
   RowBox[{"\"\<Date of palette creation \[LongRightArrow] \>\"", "<>", 
    RowBox[{"StringDrop", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"BoxForm`Intercalate", "[", 
        RowBox[{
         RowBox[{"ToString", "/@", 
          RowBox[{"ToDate", "[", 
           RowBox[{"IntegerPart", "@", 
            RowBox[{"AbsoluteTime", "[", "]"}]}], "]"}]}], ",", "\"\<:\>\""}],
         "]"}], "]"}], ",", 
      RowBox[{"-", "1"}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{3.4159086200952487`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Source", "Section"],

Cell[CellGroupData[{

Cell["General", "Subsection",
 CellChangeTimes->{{3.35110849687039*^9, 3.35110850220804*^9}}],

Cell[CellGroupData[{

Cell["Notes group", "Subsubsection",
 CellChangeTimes->{{3.35110860865315*^9, 3.35110861164624*^9}, {
  3.461512045096426*^9, 3.461512046299551*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"notesTablesExt", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Notes  \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Choices for inserting notes table templates.\\nUse Text \
button to insert table with pure text format inline cells as \
elements.\\nSelect the entire inline cell element and delete to restore \
normal input format placeholder.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "100"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "101"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "101"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Note\>\"", ",", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", "\"\<Notes\>\"", 
                    "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", 
                 "\"\<Insert Notes cell or apply Notes style to \
selection.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Options Table\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`OptionsTableCreate\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                   ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<A dialog lets you select options in table inserted in \
the notes area.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<TableTools\>\"", ",", 
                   RowBox[{"BaseStyle", "->", "\"\<ButtonSubGroupHead\>\""}], 
                   ",", 
                   RowBox[{"Active", "\[Rule]", "False"}]}], "]"}], ",", 
                 "\[IndentingNewLine]", 
                 "\"\<Various tools for table construction.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"GridBox", "[", 
                RowBox[{
                 RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<1 Col\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`TableInsert", "[", 
                    RowBox[{"2", ",", 
                    RowBox[{"DocumentationTools`PlaceholderObject", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<      \>\"", ",", "\"\<ModInfo\>\""}], "]"}],
                     ",", "\"\<XXXX\>\""}], "}"}]}]}], "]"}], "]"}]}], ",", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], "]"}],
                     ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<1 Text\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`TableInsert", "[", "2", "]"}],
                     "]"}]}], ",", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], 
                    "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<2 Col\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`TableInsert", "[", "3", "]"}],
                     "]"}]}], ",", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], "]"}],
                     ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<2 Text\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`TableInsert", "[", 
                    RowBox[{"3", ",", " ", 
                    RowBox[{"DocumentationTools`PlaceholderObject", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<      \>\"", ",", "\"\<ModInfo\>\""}], "]"}],
                     ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<TableText\>\""}], 
                    "]"}]}], "}"}]}]}], "]"}], "]"}]}], ",", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], 
                    "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<3 Col\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`TableInsert", "[", "4", "]"}],
                     "]"}]}], ",", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], "]"}],
                     ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<3 Text\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`TableInsert", "[", 
                    RowBox[{"4", ",", " ", 
                    RowBox[{"DocumentationTools`PlaceholderObject", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<      \>\"", ",", "\"\<ModInfo\>\""}], "]"}],
                     ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<TableText\>\""}], 
                    "]"}]}], "}"}]}]}], "]"}], "]"}]}], ",", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                 RowBox[{"ColumnSpacings", "\[Rule]", "0"}], ",", 
                 RowBox[{"ColumnWidths", "\[Rule]", 
                  RowBox[{"{", "0.5`", "}"}]}], ",", 
                 RowBox[{"RowSpacings", "\[Rule]", "0"}], ",", 
                 RowBox[{"RowLines", "\[Rule]", "True"}], ",", 
                 RowBox[{"ColumnLines", "\[Rule]", "True"}]}], "]"}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Insert Custom Table\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TableInsertDialog", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Insert a table with user specified number of \
rows.\\nAlso indicate whether text only and 2 or 3 columns.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Add Row\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TableAddRow", "]"}]}], 
                   ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Adds new rows maintaining the same structure.\\nTo add \
new row before first row, position the cursor at the beginning of the entire \
cell contents, or before all the contents of the first row.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Add Column\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TableAddColumn", "]"}]}],
                    ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Adds new column maintaining the same structure of \
nearest column.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Span First Column\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TableSpanToggle", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Select row to convert to spanning first column, or \
select spanning element and row to convert back to single row.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Switch Format\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TableInlineCellsToggle", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Toggles selection within table from plain input style \
to inline text format and back.\\nSelect one element or a column, row, or \
parts of either.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Sort Table\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TableSort", "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Sorts on the first column of a table.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Merge Tables\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TableMerge", "]"}]}], 
                   ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Combines two table cells into one.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
               "}"}]}], "}"}], "]"}], "]"}], ",", "\"\<PaletteGridCell\>\"", 
          ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "101"}], 
            "}"}]}], ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnSpacings", "\[Rule]", 
              RowBox[{"-", "0.1"}]}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
               "1", ",", "1.5", ",", ".5", ",", "0.5", ",", "0.5", ",", "0.5",
                 ",", "0.5", ",", "0.5", ",", "0.5"}], "}"}]}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
       "}"}], ",", "Closed"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35655753270616*^9, 3.35655753456009*^9}, 
   3.35655800284891*^9, {3.35655902812994*^9, 3.35655902893651*^9}, {
   3.35656145435573*^9, 3.35656145706045*^9}, {3.35656152512144*^9, 
   3.35656152577525*^9}, {3.35656158406221*^9, 3.3565615846485*^9}, {
   3.36432295436577*^9, 3.36432295837165*^9}, {3.36432308704051*^9, 
   3.36432309012504*^9}, {3.36432312178151*^9, 3.3643231285915*^9}, {
   3.3664775060175*^9, 3.36647750657833*^9}, 3.3795456117293754`*^9, {
   3.40088516389743*^9, 3.400885166178709*^9}, {3.4039991359752607`*^9, 
   3.403999136338163*^9}, {3.410720278576038*^9, 3.410720290199119*^9}, {
   3.454175231968547*^9, 3.454175234937373*^9}, 3.454175293329493*^9, {
   3.4615036563015194`*^9, 3.461503660551846*^9}, {3.461587497357711*^9, 
   3.461587498420224*^9}, {3.461588659825715*^9, 3.461588672935258*^9}, 
   3.4615891764260774`*^9, {3.461589247114482*^9, 3.4615893381937733`*^9}, 
   3.461599232514474*^9, {3.4615992639523764`*^9, 3.4615992741087565`*^9}, {
   3.461599413204287*^9, 3.4615994255794454`*^9}, {3.4615994612986526`*^9, 
   3.461599492408426*^9}, {3.4615995388152695`*^9, 3.4615995438622093`*^9}, {
   3.461600001086812*^9, 3.4616000343372374`*^9}, {3.461600078431552*^9, 
   3.4616001695889683`*^9}, {3.4616002185427203`*^9, 3.461600224855301*^9}, {
   3.462206128655793*^9, 3.462206156062394*^9}, 3.4759338254183617`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Example group", "Subsubsection",
 CellChangeTimes->{{3.35110859593494*^9, 3.35110860059826*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"examplesExt", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Examples  \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Templates and formatting tools for creating examples.\>\
\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "99"}], 
            "}"}]}]}], "]"}], ",", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "100"}], 
            "}"}]}]}], "]"}], ",", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Insert Delimiter\>\"", ",", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`DocDelimiter", "]"}]}], 
                   ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], 
                  "]"}], ",", 
                 "\"\<This divides example groups and resets the input \
history. Shortcut key is control+y on Windows.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Insert Text\>\"", ",", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", 
                    "\"\<ExampleText\>\"", "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], 
                  "]"}], ",", 
                 "\"\<\\\"Optional text for examples. Style menu shortcut \
number 5.\\\"\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Insert Needs\>\"", ",", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`NeedsStatementInsert", "[", 
                    RowBox[{
                    "DocumentationTools`Deemphasis", "\[Rule]", "False"}], 
                    "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", 
                 "\"\<Inserts needs statement with context pulled from \
metadata.\\nFor package function pages primarily.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"GridBox", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<Section\>\"", ",", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", 
                    "\"\<ExampleSection\>\"", "]"}], "]"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}],
                     "]"}], ",", "\"\<Section heading for examples.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<Subsec\>\"", ",", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", 
                    "\"\<ExampleSubsection\>\"", "]"}], "]"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}],
                     "]"}], ",", "\"\<Subheading for examples.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<Subsub\>\"", ",", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", 
                    "\"\<ExampleSubsubsection\>\"", "]"}], "]"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}],
                     "]"}], ",", "\"\<Subsubheading for examples.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                   "}"}], "}"}], ",", 
                 RowBox[{"ColumnWidths", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"0.35", ",", "0.33"}], "}"}]}]}], "]"}], "}"}], 
              ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Options for Function\>\"", ",", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`OptionsInspector\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}], 
                   ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\"\<Compares current listed options in Options section \
of a function page to\\nthose returned by Options[] for the function being \
documented.\\nA dialog lets you select any missing options to add.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
               "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], "]"}], ",", 
          "\"\<PaletteGridCell\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "100"}], 
            "}"}]}], ",", 
          RowBox[{"CellMargins", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
             RowBox[{"ColumnSpacings", "\[Rule]", 
              RowBox[{"-", "0.1"}]}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"1", ",", "0.5", ",", "0.5", ",", "0.5", ",", "1"}], 
               "}"}]}], ",", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "Open"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.35898425699091*^9, 3.35898427102989*^9}, {
   3.35898431404594*^9, 3.35898432461374*^9}, {3.35898435539486*^9, 
   3.35898437464189*^9}, 3.36432297357396*^9, 3.36432387064071*^9, 
   3.36432391432484*^9, {3.36432398239475*^9, 3.36432401072634*^9}, {
   3.36554413570459*^9, 3.36554438177068*^9}, {3.36554442227459*^9, 
   3.36554451037298*^9}, {3.36554464938481*^9, 3.36554465677297*^9}, {
   3.36554470519425*^9, 3.36554473786385*^9}, {3.36554482403694*^9, 
   3.36554482652428*^9}, {3.36554496786795*^9, 3.36554497675416*^9}, {
   3.365545018668*^9, 3.36554503151269*^9}, {3.36554506784051*^9, 
   3.36554506965632*^9}, {3.36554511557684*^9, 3.36554519806159*^9}, {
   3.36554523858954*^9, 3.36554524611546*^9}, {3.36554528444283*^9, 
   3.36554531685111*^9}, {3.36554534939342*^9, 3.36554536578733*^9}, {
   3.36554551739476*^9, 3.36554569505238*^9}, 3.36554575286451*^9, {
   3.3655457840292*^9, 3.36554581423812*^9}, {3.36554601908938*^9, 
   3.36554602830669*^9}, {3.36554610125522*^9, 3.36554612392224*^9}, {
   3.36554621095453*^9, 3.36554621854184*^9}, {3.36554794659677*^9, 
   3.36554798714094*^9}, {3.36554802061128*^9, 3.36554803309041*^9}, {
   3.36554809630745*^9, 3.36554814922464*^9}, {3.36554962280852*^9, 
   3.36554963887238*^9}, {3.3664775066284*^9, 3.36647750727937*^9}, {
   3.36648649495509*^9, 3.36648652737167*^9}, {3.369675839858639*^9, 
   3.3696758483183537`*^9}, {3.369675979169773*^9, 3.369675988702566*^9}, {
   3.370479552801792*^9, 3.370479687634026*^9}, {3.370479820626938*^9, 
   3.370479928415024*^9}, {3.3704800270863934`*^9, 3.37048002721667*^9}, {
   3.3704800944093857`*^9, 3.370480094515126*^9}, {3.3704818627585945`*^9, 
   3.3704819314394073`*^9}, {3.370481996324649*^9, 3.3704819971959276`*^9}, {
   3.3704828606633615`*^9, 3.3704829120087285`*^9}, {3.3704829555426292`*^9, 
   3.370482972387355*^9}, {3.3708728255731745`*^9, 3.370872851440628*^9}, {
   3.37087292871251*^9, 3.3708729308556128`*^9}, {3.3708765316191607`*^9, 
   3.3708765712164936`*^9}, {3.3708766154805837`*^9, 3.370876655348308*^9}, {
   3.3708767070631857`*^9, 3.370876707844317*^9}, {3.3708793704895625`*^9, 
   3.3708793875843143`*^9}, {3.370879453099173*^9, 3.370879490132794*^9}, {
   3.370881495556448*^9, 3.3708816363803473`*^9}, {3.370881711088517*^9, 
   3.370881733520997*^9}, {3.377560132502762*^9, 3.377560135745555*^9}, {
   3.3775601799830437`*^9, 3.377560192870899*^9}, {3.377560231752358*^9, 
   3.3775603049072227`*^9}, {3.377560340841069*^9, 3.3775603718942432`*^9}, {
   3.377560421422377*^9, 3.3775605139620047`*^9}, {3.3775606074925013`*^9, 
   3.37756066100379*^9}, {3.377903441022187*^9, 3.377903532565765*^9}, {
   3.3779037607226753`*^9, 3.377903779890326*^9}, {3.377903828737464*^9, 
   3.377903835602343*^9}, 3.377903896498431*^9, 3.377903965472817*^9, {
   3.3779040070901747`*^9, 3.3779040611865664`*^9}, {3.377904172491024*^9, 
   3.377904178033868*^9}, {3.377904389091135*^9, 3.377904393077553*^9}, {
   3.377904440013822*^9, 3.377904440154356*^9}, {3.377904493949355*^9, 
   3.3779045317338543`*^9}, {3.3779047633574667`*^9, 
   3.3779047685651627`*^9}, {3.377904802495305*^9, 3.3779049143005323`*^9}, 
   3.377904948871622*^9, {3.3779049855358047`*^9, 3.377905055178724*^9}, {
   3.3779050891288958`*^9, 3.37790512045519*^9}, {3.3779052273431506`*^9, 
   3.3779052363865147`*^9}, {3.377905277867817*^9, 3.377905306490115*^9}, {
   3.377991439657877*^9, 3.377991467748033*^9}, 3.3779915440817823`*^9, {
   3.377992526282256*^9, 3.377992535806617*^9}, {3.3816218250872307`*^9, 
   3.381621923047707*^9}, {3.381621994022684*^9, 3.381622014054473*^9}, {
   3.3816224120440035`*^9, 3.381622428157817*^9}, {3.381782460032514*^9, 
   3.381782460829019*^9}, {3.381782538762939*^9, 3.3817825390782747`*^9}, 
   3.381782638393963*^9, {3.400795723451136*^9, 3.400795783504614*^9}, {
   3.4008850590210876`*^9, 3.400885073208769*^9}, {3.400885311024313*^9, 
   3.4008853247432384`*^9}, {3.400885389822197*^9, 3.4008853942597537`*^9}, {
   3.403999166010806*^9, 3.403999166431065*^9}, {3.409869232739173*^9, 
   3.409869241239657*^9}, {3.409869479217093*^9, 3.409869539503525*^9}, {
   3.409869598220709*^9, 3.4098695986646357`*^9}, {3.4100361765932217`*^9, 
   3.4100361780895767`*^9}, {3.410036211891704*^9, 3.410036245652755*^9}, {
   3.410036320578685*^9, 3.410036325083806*^9}, 3.410118306009692*^9, {
   3.410118376700163*^9, 3.410118415253695*^9}, {3.410118446725786*^9, 
   3.410118524297922*^9}, {3.410118794515123*^9, 3.410118823208838*^9}, {
   3.410118866002536*^9, 3.410118877527083*^9}, {3.410119448379036*^9, 
   3.41011945721761*^9}, {3.4104798853013983`*^9, 3.410479908614291*^9}, {
   3.4104799685346613`*^9, 3.4104800650329437`*^9}, {3.4104805116569777`*^9, 
   3.410480517109297*^9}, {3.4104817491845503`*^9, 3.410481757016694*^9}, {
   3.4433622174243364`*^9, 3.443362224752649*^9}, {3.4615036619582043`*^9, 
   3.4615036665991855`*^9}, {3.461509087533926*^9, 3.461509101518301*^9}, {
   3.461510359877676*^9, 3.461510394940176*^9}, {3.461510429221426*^9, 
   3.461510430252676*^9}, {3.461510588830801*^9, 3.461510590705801*^9}, {
   3.461510624174551*^9, 3.461510624862051*^9}, {3.461510686080801*^9, 
   3.461510686955801*^9}, {3.461511054096426*^9, 3.461511062752676*^9}, {
   3.461511145362051*^9, 3.461511184987051*^9}, {3.461588888500517*^9, 
   3.4615889376886463`*^9}, {3.461601005709046*^9, 3.461601079053735*^9}, {
   3.4616011338044357`*^9, 3.461601134460694*^9}, {3.4616112686032553`*^9, 
   3.46161131077567*^9}, {3.4622061575155373`*^9, 3.462206169359439*^9}, 
   3.4837057297450967`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Links group", "Subsubsection",
 CellChangeTimes->{{3.35110861911147*^9, 3.35110862059834*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"linksExt", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Links  \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Choices for setting selection as hyperlink.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "96"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "97"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "97"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"GridBox", "[", 
                RowBox[{
                 RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    "\"\<Link to Guide\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`CustomLink[\\\"guide\\\",\
Interactive\[Rule]False,DocumentationTools`LinkBase\[Rule]DocumentationTools`$\
LinkBase]\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Create guide page link of the selection.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<B\[VeryThinSpace]\>\"", ",", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`CustomLink[\\\"PacletDocSelect\\\"\
,\\\"guide\\\"]\>\""}], ",", "\[IndentingNewLine]", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Browse for a file to be hyperlinked from your \
selection as a guide page link.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                   "}"}], "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ColumnWidths", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"0.84", ",", "0.14"}], "}"}]}], ",", 
                 RowBox[{"RowAlignments", "\[Rule]", "Center"}], ",", 
                 RowBox[{"ColumnSpacings", "\[Rule]", "0.1"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"GridBox", "[", 
                RowBox[{
                 RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    "\"\<Link to Tutorial\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`CustomLink[\\\"tutorial\\\",\
Interactive\[Rule]False,DocumentationTools`LinkBase\[Rule]DocumentationTools`$\
LinkBase]\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Create tutorial link of the selection.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<\[VeryThinSpace]B\>\"", ",", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`CustomLink[\\\"PacletDocSelect\\\"\
,\\\"tutorial\\\"]\>\""}], ",", "\[IndentingNewLine]", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Browse for a file to be hyperlinked from your \
selection as a tutorial link.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                   "}"}], "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ColumnWidths", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"0.84", ",", "0.14"}], "}"}]}], ",", 
                 RowBox[{"RowAlignments", "\[Rule]", "Center"}], ",", 
                 RowBox[{"ColumnSpacings", "\[Rule]", "0.1"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"GridBox", "[", 
                RowBox[{
                 RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    "\"\<Link to Symbol\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`CustomLink[\\\"ref\\\",\
Interactive\[Rule]False,DocumentationTools`LinkBase\[Rule]DocumentationTools`$\
LinkBase]\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Create function page link of the selection.\>\"", 
                    ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<B\[VeryThinSpace]\>\"", ",", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`CustomLink[\\\"PacletDocSelect\\\"\
,\\\"ref\\\"]\>\""}], ",", "\[IndentingNewLine]", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Browse for a file to be hyperlinked from your \
selection as a function page link.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                   "}"}], "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ColumnWidths", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"0.84", ",", "0.14"}], "}"}]}], ",", 
                 RowBox[{"RowAlignments", "\[Rule]", "Center"}], ",", 
                 RowBox[{"ColumnSpacings", "\[Rule]", "0.1"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Link to URL\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`CustomLink[DocumentationTools`\
Target->\\\"URL\\\"]\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Insert URL to be hyperlinked from your selection.\>\"", 
                 ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Edit Link\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`ButtonEdit\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                   ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<\\\"Use this to edit the contents of a link if it can't \
be edited inline.\\nPlace the cursor after the link before applying.\\\"\>\"",
                  ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
               "}"}]}], "}"}], "]"}], "]"}], ",", "\"\<PaletteGridCell\>\"", 
          ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "99"}], 
            "}"}]}], ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"0.5", ",", "0.5", ",", "1"}], "}"}]}], ",", " ", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "97"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"CellGroupData", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cell", "[", 
              RowBox[{
               RowBox[{"BoxData", "[", 
                RowBox[{"GridBox", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    "\"\<More Link Tools \[FilledDownTriangle]\>\"", ",", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<ButtonSubGroupHead\>\""}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    "\"\<Choices for setting selection as specific type of \
hyperlink.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    "}"}], "}"}], ",", 
                  RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}],
                ",", "\"\<ButtonSubGroupHead\>\"", ",", "\[IndentingNewLine]", 
               RowBox[{"CellGroupingRules", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "98"}], 
                 "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Cell", "[", 
              RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
               RowBox[{"CellGroupingRules", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "98"}], 
                 "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Cell", "[", 
              RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
               RowBox[{"CellGroupingRules", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "98"}], 
                 "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Cell", "[", 
              RowBox[{
               RowBox[{"BoxData", "[", 
                RowBox[{"GridBox", "[", 
                 RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"GridBox", "[", 
                    RowBox[{
                    RowBox[{"{", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    "\"\<Make Sel\[ThinSpace]\>\"", ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`InsertLink", "[", 
                    RowBox[{
                    "\"\<PreserveSelectionContent\>\"", "\[Rule]", "True"}], 
                    "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], "]"}],
                     ",", "\[IndentingNewLine]", 
                    "\"\<Creates a link to the selected cell and saves the \
data in a form that can be used by the button to the right of this one. First \
select a cell in a saved notebook and then use the button to the right of \
this one to make selected text in a notebook into a link using the data \
obtained.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    "\"\<Make Link\[ThinSpace]\>\"", ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`LinkSelection\>\""}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], "]"}],
                     ",", "\[IndentingNewLine]", 
                    "\"\<Inserts a link over selected text. Use the button to \
the left of this one first.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                    "}"}], "}"}], ",", 
                    RowBox[{"ColumnWidths", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"0.49", ",", "0.49"}], "}"}]}], ",", " ", 
                    RowBox[{"ColumnSpacings", "\[Rule]", "0.1"}]}], "]"}], 
                    "}"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"{", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    "\"\<Link to Document\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{
                    "ButtonData", "->", 
                    "\"\<DocumentationTools`CustomLink[\\\"PacletDocSelect\\\"\
]\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Browse your package layout for a notebook or PDF \
file to be linked from your selection.\\nRelies on $ApplicationName, and \
target documents can reside in any directory under Documentation/$Language.\>\
\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    "}"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"{", 
                    RowBox[{"GridBox", "[", 
                    RowBox[{
                    RowBox[{"{", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<Custom URI\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`CustomLink[DocumentationTools`\
PacletInteractive\[Rule]True]\>\""}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Creates a link based on the paclet URI you provide \
interactively.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<A\[VeryThinSpace]\>\"", ",", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`CustomLink[DocumentationTools`\
PacletInteractive -> Automatic]\>\""}], ",", "\[IndentingNewLine]", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}]}],
                     "]"}], ",", "\[IndentingNewLine]", 
                    "\"\<Apply preset paclet URI automatically.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<S\[VeryThinSpace]\>\"", ",", 
                    RowBox[{
                    "ButtonData", "->", 
                    "\"\<DocumentationTools`Set$PacletURI\>\""}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Preset a paclet URI by entering it directly. If the \
paclet URI is not the same as the directory location, you can set the \
directory location separately using $TargetDocumentDir.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<B\[VeryThinSpace]\>\"", ",", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`Set$PacletURI[\\\"Browse\\\"]\>\"\
"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Browse to preset paclet URI. If URI is not the same \
as the directory location, you can set the directory location separately \
using $TargetDocumentDir.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                    "\[IndentingNewLine]", "}"}], "}"}], ",", 
                    RowBox[{"ColumnWidths", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"0.77", ",", "0.07"}], "}"}]}], ",", " ", 
                    RowBox[{"ColumnSpacings", "\[Rule]", "0.2"}], ",", 
                    RowBox[{"RowAlignments", "\[Rule]", "Center"}]}], "]"}], 
                    "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], "]"}], ",", 
               "\"\<PaletteGridCell\>\"", ",", 
               RowBox[{"CellGroupingRules", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "98"}], 
                 "}"}]}], ",", 
               RowBox[{"GridBoxOptions", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
                  RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
                  RowBox[{"ColumnSpacings", "\[Rule]", 
                   RowBox[{"-", "0.1"}]}], ",", 
                  RowBox[{"RowSpacings", "\[Rule]", 
                   RowBox[{"{", "0.5", "}"}]}], ",", " ", 
                  RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], 
              "]"}]}], "}"}], ",", "Closed"}], "]"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "Closed"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.35326887006243*^9, {3.35334399209939*^9, 3.35334401676584*^9}, {
   3.35336228167523*^9, 3.35336239638475*^9}, {3.35336242945362*^9, 
   3.35336244478628*^9}, 3.35336248521603*^9, {3.35337102259945*^9, 
   3.3533711166439*^9}, {3.35655746247214*^9, 3.35655752041112*^9}, 
   3.35655798823453*^9, {3.35655901413676*^9, 3.356559015342*^9}, {
   3.35655999881437*^9, 3.35656000044265*^9}, {3.35656140884775*^9, 
   3.35656143743327*^9}, 3.35656152215816*^9, 3.35656158200772*^9, {
   3.36001145414262*^9, 3.36001145994186*^9}, {3.36001149060792*^9, 
   3.36001150642716*^9}, {3.36001154722137*^9, 3.36001158748994*^9}, {
   3.36001166278185*^9, 3.36001172057814*^9}, {3.36001179784588*^9, 
   3.36001179953104*^9}, {3.36052983709004*^9, 3.36052995003483*^9}, {
   3.36053002441169*^9, 3.36053004114966*^9}, {3.3643229264548*^9, 
   3.36432293534785*^9}, {3.36432360491066*^9, 3.364323607865*^9}, {
   3.36647748870191*^9, 3.36647750586728*^9}, {3.374347906891006*^9, 
   3.3743479074117756`*^9}, {3.4008851904915204`*^9, 
   3.4008852029291797`*^9}, {3.403999105160472*^9, 3.403999105535956*^9}, {
   3.406162851559039*^9, 3.406162855712023*^9}, {3.406162901822657*^9, 
   3.406162925161886*^9}, {3.40616298385425*^9, 3.406162997834923*^9}, {
   3.40616302993677*^9, 3.4061630430421343`*^9}, {3.406163207655795*^9, 
   3.406163208572221*^9}, {3.4061632462331676`*^9, 3.406163272510742*^9}, {
   3.406163880695804*^9, 3.406163888339305*^9}, {3.406163927924568*^9, 
   3.4061639319534473`*^9}, {3.40616396657201*^9, 3.406163977156066*^9}, {
   3.406164044349661*^9, 3.406164050208693*^9}, {3.406164130379727*^9, 
   3.4061641401309233`*^9}, 3.406164181331522*^9, {3.406237182194765*^9, 
   3.406237209773802*^9}, {3.406237274445633*^9, 3.40623727529278*^9}, {
   3.406311943701379*^9, 3.4063119445827093`*^9}, {3.406312011236314*^9, 
   3.406312040073164*^9}, {3.4063152694844933`*^9, 3.406315291703246*^9}, 
   3.406386912370824*^9, {3.406408151744178*^9, 3.4064081670145407`*^9}, 
   3.407034619753313*^9, {3.407034656794396*^9, 3.407034661619382*^9}, 
   3.4104816309907017`*^9, {3.410720166073435*^9, 3.410720221710147*^9}, {
   3.413244549736434*^9, 3.4132445548079653`*^9}, {3.4132445916420717`*^9, 
   3.4132446339353933`*^9}, {3.413244732954495*^9, 3.413244737437621*^9}, {
   3.413244808393939*^9, 3.413244831921713*^9}, {3.413251729472744*^9, 
   3.413251737726667*^9}, {3.4432986278820086`*^9, 3.443298641366729*^9}, {
   3.443298745572521*^9, 3.443298848684536*^9}, {3.443298895232602*^9, 
   3.443298950484017*^9}, {3.4432989905475426`*^9, 3.443298999329017*^9}, {
   3.4432990628931446`*^9, 3.4432991175039177`*^9}, {3.443299148082825*^9, 
   3.443299177099193*^9}, {3.443357631672672*^9, 3.443357645391773*^9}, {
   3.461503630783935*^9, 3.4615036405346837`*^9}, {3.461511736830801*^9, 
   3.461511787205801*^9}, {3.461512284205801*^9, 3.461512290065176*^9}, {
   3.4615234627443743`*^9, 3.461523552386147*^9}, 3.461599939086018*^9, {
   3.4616166002652493`*^9, 3.4616166095934935`*^9}, {3.4622061802502036`*^9, 
   3.4622062167350454`*^9}, {3.4641213900938196`*^9, 
   3.4641214876580954`*^9}, {3.464121531432537*^9, 3.46412161893462*^9}, {
   3.4641216729116583`*^9, 3.4641219900501566`*^9}, {3.464123141352297*^9, 
   3.464123216296138*^9}, {3.4641232681134977`*^9, 3.4641232726375847`*^9}, {
   3.4641233550939336`*^9, 3.464123411981792*^9}, {3.4641235356389346`*^9, 
   3.464123607466445*^9}, {3.4641236504608717`*^9, 3.464123656404586*^9}, {
   3.4641236908432117`*^9, 3.4641237724815083`*^9}, 3.464123824695712*^9, {
   3.4641239199043427`*^9, 3.4641239356762466`*^9}, {3.464124315337884*^9, 
   3.464124317537526*^9}, {3.4687840456865225`*^9, 3.4687840660150375`*^9}, {
   3.4688609999726763`*^9, 3.4688610748803644`*^9}, {3.4688612368522243`*^9, 
   3.468861247508679*^9}, {3.46886128221247*^9, 3.468861322885126*^9}, {
   3.468861469028557*^9, 3.46886147752872*^9}, {3.468861595437234*^9, 
   3.4688615959216185`*^9}, {3.4688631228026285`*^9, 3.468863184491313*^9}, {
   3.468863259945887*^9, 3.468863267305403*^9}, {3.4688633177438717`*^9, 
   3.4688633182595067`*^9}, {3.4688633761356177`*^9, 3.468863379448181*^9}, {
   3.4688634168238993`*^9, 3.468863419589577*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Formatting group", "Subsubsection",
 CellChangeTimes->{{3.35110861911147*^9, 3.35110862059834*^9}, {
   3.35655592732375*^9, 3.35655593104015*^9}, 3.461508154830801*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"formattingExt", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Formatting  \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Choices for formatting and special characters.\>\"", 
                 ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "95"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "96"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "96"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Special Formatting\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`DocumentSample", "[", 
                    "\"\<SpecialForms.nb\>\"", "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<A palette of additional input forms.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Default Format\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`RestoreDefault", "]"}]}],
                    ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Use this to return to the default format of the current \
cell while typing, or to remove formatting on the selection.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Literal Input\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`FunctionTemplate", "[", 
                    "\"\<Plain\>\"", "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Use this for literal Mathematica input format in text. \
Same as doing CTRL+9 (for inline cell).\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Code Cell\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", "\"\<Code\>\"", 
                    "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Use this for code examples in stand\[Hyphen]alone \
cells.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Code Inline\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", 
                    "\"\<InlineCode\>\"", "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Use this for code or other computer voice elements \
inline in text.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Italic Input\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", "\"\<TI\>\"", "]"}],
                     "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Use this to make italics in function templates only \
(e.g. for function arguments)\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Plain Text\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", "\"\<TR\>\"", "]"}],
                     "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Use this to make plain text in function templates only \
(e.g. for function arguments).\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Traditional Math\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TraditionalFormCell", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Use this to begin or apply Mathematica TraditionalForm.\
\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Converted TeX\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`ConvertTeX", "]"}]}], 
                   ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Use this to make math from TeX input, with $ $ \
delimiters.\\nRefer to bottom of format menu for shortcut.\\nUse shortcut \
after typing for autoselection.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"CheckboxBox", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", 
                    RowBox[{"DocumentationTools`UndeploymentSetting", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "True", ",", 
                    RowBox[{"Blank", "[", "]"}]}], "}"}]}], "]"}], ",", 
                    "\"\<\[ThickSpace]\[ThickSpace]\>\"", ",", 
                    "\"\<Undeploy\>\""}], "}"}], "]"}], ",", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"DocumentationTools`UndeploymentSetter", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", 
                 "\"\<Toggle setting of input notebook to be left untouched \
by documentation build processes.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Tentative\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "->", 
                    "\"\<DocumentationTools`StyleAppend[\\\"TentativeExample\\\
\"]\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButton\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"Background", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.6", ",", "0.9", ",", "0.95"}], "]"}]}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Mark cells waiting for confirmation to add to the \
current documentation build.\\nToggles setting on/off.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"GridBox", "[", 
                RowBox[{
                 RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<Annotate\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`AnnotationInsert", "[", "]"}],
                     "]"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButton\>\""}], 
                    ",", 
                    RowBox[{"Background", "->", 
                    RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    "\"\<Dialog for annotating a cell or editing a cell's \
annotation.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<\[FilledDownTriangle]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "9"}]}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`AnnotationSearch", "[", 
                    "\"\<Down\>\"", "]"}], "]"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}]}],
                     "]"}], ",", "\[IndentingNewLine]", 
                    "\"\<Searches down in the input notebook for the next \
annotation cell.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<\[FilledUpTriangle]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "9"}]}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`AnnotationSearch", "[", "\"\<Up\>\"", 
                    "]"}], "]"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}]}],
                     "]"}], ",", "\[IndentingNewLine]", 
                    "\"\<Searches up in the input notebook for the next \
annotation cell.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<D\[VeryThinSpace]\>\"", ",", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`AnnotationRemove", "[", "]"}],
                     "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}], 
                    ",", 
                    RowBox[{"Background", "->", 
                    RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    "\"\<Remove a cell's annotation.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                   "}"}], "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"ColumnWidths", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"0.75", ",", "0.07"}], "}"}]}], ",", " ", 
                 RowBox[{"ColumnSpacings", "\[Rule]", 
                  RowBox[{"{", "0.1", "}"}]}], ",", " ", 
                 RowBox[{"RowAlignments", "\[Rule]", "Center"}]}], "]"}], 
               "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], "]"}], ",", 
          "\"\<PaletteGridCell\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "96"}], 
            "}"}]}], ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
             RowBox[{"ColumnSpacings", "\[Rule]", 
              RowBox[{"-", "0.1"}]}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
               "0.5", ",", "1", ",", "0.5", ",", "1", ",", "0.5", ",", "1", 
                ",", "0.5", ",", "0.5", ",", "1", ",", "1", ",", "0.5"}], 
               "}"}]}], ",", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
       "}"}], ",", "Closed"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.35326887006243*^9, {3.35334399209939*^9, 3.35334401676584*^9}, {
   3.35336228167523*^9, 3.35336239638475*^9}, {3.35336242945362*^9, 
   3.35336244478628*^9}, 3.35336248521603*^9, {3.35337102259945*^9, 
   3.3533711166439*^9}, {3.35655592187312*^9, 3.35655595410893*^9}, {
   3.35655598413025*^9, 3.35655602004708*^9}, 3.35655630923744*^9, 
   3.35655634036431*^9, {3.35655638923654*^9, 3.35655657461047*^9}, {
   3.35655660479646*^9, 3.35655661281216*^9}, {3.35655665567903*^9, 
   3.35655670612059*^9}, 3.35655676002837*^9, {3.35655735281578*^9, 
   3.35655735612017*^9}, {3.3565577083666*^9, 3.35655771153863*^9}, 
   3.35655801494114*^9, {3.35655905346241*^9, 3.35655905434984*^9}, {
   3.35655911486022*^9, 3.35655916145503*^9}, {3.35656121998961*^9, 
   3.35656124411512*^9}, {3.35656130175342*^9, 3.3565613172237*^9}, {
   3.35656135177645*^9, 3.3565613838717*^9}, {3.35656146806099*^9, 
   3.35656146994853*^9}, {3.35656152661491*^9, 3.35656152712517*^9}, {
   3.35656158543759*^9, 3.35656158617971*^9}, 3.36432298023374*^9, {
   3.36587915331084*^9, 3.3658791998171*^9}, {3.36587935593416*^9, 
   3.36587941215525*^9}, {3.36594940020765*^9, 3.36594940648686*^9}, {
   3.36594946699568*^9, 3.365949467897*^9}, {3.36596123225597*^9, 
   3.36596123274258*^9}, {3.36622558741656*^9, 3.36622561783571*^9}, 
   3.36622578749753*^9, {3.36647750745963*^9, 3.36647750771*^9}, {
   3.370729227852676*^9, 3.3707292513856897`*^9}, {3.3707328170423317`*^9, 
   3.3707328302722797`*^9}, {3.375120427320462*^9, 3.3751204507953873`*^9}, {
   3.3829836692084093`*^9, 3.382983747832563*^9}, {3.382983788402977*^9, 
   3.3829837919109287`*^9}, {3.4008850880839596`*^9, 3.400885115693688*^9}, {
   3.403999191377946*^9, 3.403999191810452*^9}, {3.4233511299559298`*^9, 
   3.423351130045059*^9}, 3.423351455751807*^9, 3.423351571879228*^9, 
   3.423352308927532*^9, 3.423352606304367*^9, 3.423353106288513*^9, 
   3.423353464517489*^9, {3.443362550714118*^9, 3.443362558854952*^9}, {
   3.4615036673023643`*^9, 3.4615036778500495`*^9}, {3.461508139205801*^9, 
   3.461508144252676*^9}, {3.461511317252676*^9, 3.461511334205801*^9}, {
   3.461516367940176*^9, 3.461516379580801*^9}, {3.461517236799551*^9, 
   3.461517250143301*^9}, {3.46158348048724*^9, 3.4615834815653787`*^9}, {
   3.461585386310974*^9, 3.4615853875765743`*^9}, {3.4615854203415704`*^9, 
   3.4615854211853046`*^9}, 3.4615856670876074`*^9, {3.46158736721542*^9, 
   3.461587383871883*^9}, 3.4615891476757097`*^9, {3.4616195353028173`*^9, 
   3.461619542709162*^9}, {3.462206219078826*^9, 3.4622062389384546`*^9}, 
   3.4641209162659073`*^9, 3.4641209469984984`*^9, {3.4641210307409086`*^9, 
   3.4641211112228565`*^9}, 3.464121156260923*^9, {3.4641211870403147`*^9, 
   3.4641212899866943`*^9}, {3.4641230806827297`*^9, 3.464123110978513*^9}, 
   3.4667911160944157`*^9, {3.4669437278556747`*^9, 3.466943737183979*^9}, {
   3.4669439115154505`*^9, 3.4669439514537177`*^9}, {3.4669440422210855`*^9, 
   3.466944049236845*^9}, {3.466944641638844*^9, 3.466944642935744*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Utilities group", "Subsubsection",
 CellChangeTimes->{{3.35110861911147*^9, 3.35110862059834*^9}, {
  3.406314516445716*^9, 3.4063145201946297`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"utilsExtF", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Utilities  \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Choices for setting selection as hyperlink.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "94"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "95"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "95"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Generate Function Pages\>\"", ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`CreateReferencePages\>\""}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton2\>\""}], 
                   ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Generate function pages in the selected directory for \
all symbols with usage messages in the application.\\nAny existing notebooks \
are placed in the OriginalReferencePages directory within the selected \
directory.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Fix Links to Symbols\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`ApplicationSymbolsLinkFix\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Add button data to application symbol buttons as needed \
in all notebooks in a directory.\\nOriginal  notebooks are placed in the \
OriginalNotebooks directory within the selected directory.\\nUse either \
$IncludedApplicationSymbols or $ExcludedApplicationSymbols if not all package \
sysmbols are to be handled automatically.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Replace Paclet Base\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`ReplacePacletBase\>\""}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Change the package name, context and uri in metadata as \
well as the link base used in button data in all notebooks in a \
directory.\\nOriginal notebooks are placed in the OriginalNotebooks directory \
within the selected directory.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
               "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], "]"}], ",", 
          "\"\<PaletteGridCell\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "94"}], 
            "}"}]}], ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
             RowBox[{"ColumnSpacings", "\[Rule]", 
              RowBox[{"-", "0.1"}]}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"2", ",", "0.5"}], "}"}]}], ",", " ", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
       "}"}], ",", "Closed"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.35326887006243*^9, {3.35334399209939*^9, 3.35334401676584*^9}, {
   3.35336228167523*^9, 3.35336239638475*^9}, {3.35336242945362*^9, 
   3.35336244478628*^9}, 3.35336248521603*^9, {3.35337102259945*^9, 
   3.3533711166439*^9}, {3.35655746247214*^9, 3.35655752041112*^9}, 
   3.35655798823453*^9, {3.35655901413676*^9, 3.356559015342*^9}, {
   3.35655999881437*^9, 3.35656000044265*^9}, {3.35656140884775*^9, 
   3.35656143743327*^9}, 3.35656152215816*^9, 3.35656158200772*^9, {
   3.36001145414262*^9, 3.36001145994186*^9}, {3.36001149060792*^9, 
   3.36001150642716*^9}, {3.36001154722137*^9, 3.36001158748994*^9}, {
   3.36001166278185*^9, 3.36001172057814*^9}, {3.36001179784588*^9, 
   3.36001179953104*^9}, {3.36052983709004*^9, 3.36052995003483*^9}, {
   3.36053002441169*^9, 3.36053004114966*^9}, {3.3643229264548*^9, 
   3.36432293534785*^9}, {3.36432360491066*^9, 3.364323607865*^9}, {
   3.36647748870191*^9, 3.36647750586728*^9}, {3.374347906891006*^9, 
   3.3743479074117756`*^9}, {3.4008851904915204`*^9, 
   3.4008852029291797`*^9}, {3.403999105160472*^9, 3.403999105535956*^9}, {
   3.406162851559039*^9, 3.406162855712023*^9}, {3.406162901822657*^9, 
   3.406162925161886*^9}, {3.40616298385425*^9, 3.406162997834923*^9}, {
   3.40616302993677*^9, 3.4061630430421343`*^9}, {3.406163207655795*^9, 
   3.406163208572221*^9}, {3.4061632462331676`*^9, 3.406163272510742*^9}, {
   3.406163880695804*^9, 3.406163888339305*^9}, {3.406163927924568*^9, 
   3.4061639319534473`*^9}, {3.40616396657201*^9, 3.406163977156066*^9}, {
   3.406164044349661*^9, 3.406164050208693*^9}, {3.406164130379727*^9, 
   3.4061641401309233`*^9}, 3.406164181331522*^9, {3.406237182194765*^9, 
   3.406237209773802*^9}, {3.406237274445633*^9, 3.40623727529278*^9}, {
   3.406311943701379*^9, 3.4063119445827093`*^9}, {3.406312011236314*^9, 
   3.406312040073164*^9}, {3.4063145357524977`*^9, 3.40631466489509*^9}, 
   3.4063147007319098`*^9, {3.406314853608334*^9, 3.4063149021638403`*^9}, 
   3.406315032039068*^9, {3.406315489266222*^9, 3.406315616978566*^9}, {
   3.407027164577574*^9, 3.407027197487178*^9}, {3.407027233582823*^9, 
   3.4070274491405582`*^9}, {3.407027480524601*^9, 3.4070275710597897`*^9}, {
   3.426275435653532*^9, 3.4262754667957582`*^9}, {3.4433576784238687`*^9, 
   3.4433577335815306`*^9}, {3.443357792161155*^9, 3.44335779917696*^9}, {
   3.4615036412691154`*^9, 3.4615036441443357`*^9}, 3.461511447143301*^9, {
   3.461513144674551*^9, 3.461513150127676*^9}, {3.461517167643301*^9, 
   3.461517181315176*^9}, {3.461616235135576*^9, 3.4616162362137146`*^9}, {
   3.4616171921478252`*^9, 3.4616172225544643`*^9}, {3.462206240204096*^9, 
   3.4622062425791264`*^9}, 3.4638548409312367`*^9, 3.4687841080783453`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"utilsExtG", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Utilities  \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Choices for setting selection as hyperlink.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "94"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "95"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "95"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Fix Links to Symbols\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`ApplicationSymbolsLinkFix\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Add button data to application symbol buttons as needed \
in all notebooks in a directory.\\nResulting  notebooks are placed in \
NotebooksWithModifiedButtons directory within the selected directory.\\nUse \
either $IncludedApplicationSymbols or $ExcludedApplicationSymbols if not all \
package sysmbols are to be handled automatically.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Replace Paclet Base\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`ReplacePacletBase\>\""}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Change the context and package name in metadata as well \
as the application name used in button data in all notebooks in a \
directory.\\nResulting  notebooks are placed in \
NotebooksWithPacletBaseReplaced directory within the selected directory.\>\"",
                  ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
               "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], "]"}], ",", 
          "\"\<PaletteGridCell\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "94"}], 
            "}"}]}], ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
             RowBox[{"ColumnSpacings", "\[Rule]", 
              RowBox[{"-", "0.1"}]}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", 
              RowBox[{"{", "0.5", "}"}]}], ",", " ", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
       "}"}], ",", "Closed"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.35326887006243*^9, {3.35334399209939*^9, 3.35334401676584*^9}, {
   3.35336228167523*^9, 3.35336239638475*^9}, {3.35336242945362*^9, 
   3.35336244478628*^9}, 3.35336248521603*^9, {3.35337102259945*^9, 
   3.3533711166439*^9}, {3.35655746247214*^9, 3.35655752041112*^9}, 
   3.35655798823453*^9, {3.35655901413676*^9, 3.356559015342*^9}, {
   3.35655999881437*^9, 3.35656000044265*^9}, {3.35656140884775*^9, 
   3.35656143743327*^9}, 3.35656152215816*^9, 3.35656158200772*^9, {
   3.36001145414262*^9, 3.36001145994186*^9}, {3.36001149060792*^9, 
   3.36001150642716*^9}, {3.36001154722137*^9, 3.36001158748994*^9}, {
   3.36001166278185*^9, 3.36001172057814*^9}, {3.36001179784588*^9, 
   3.36001179953104*^9}, {3.36052983709004*^9, 3.36052995003483*^9}, {
   3.36053002441169*^9, 3.36053004114966*^9}, {3.3643229264548*^9, 
   3.36432293534785*^9}, {3.36432360491066*^9, 3.364323607865*^9}, {
   3.36647748870191*^9, 3.36647750586728*^9}, {3.374347906891006*^9, 
   3.3743479074117756`*^9}, {3.4008851904915204`*^9, 
   3.4008852029291797`*^9}, {3.403999105160472*^9, 3.403999105535956*^9}, {
   3.406162851559039*^9, 3.406162855712023*^9}, {3.406162901822657*^9, 
   3.406162925161886*^9}, {3.40616298385425*^9, 3.406162997834923*^9}, {
   3.40616302993677*^9, 3.4061630430421343`*^9}, {3.406163207655795*^9, 
   3.406163208572221*^9}, {3.4061632462331676`*^9, 3.406163272510742*^9}, {
   3.406163880695804*^9, 3.406163888339305*^9}, {3.406163927924568*^9, 
   3.4061639319534473`*^9}, {3.40616396657201*^9, 3.406163977156066*^9}, {
   3.406164044349661*^9, 3.406164050208693*^9}, {3.406164130379727*^9, 
   3.4061641401309233`*^9}, 3.406164181331522*^9, {3.406237182194765*^9, 
   3.406237209773802*^9}, {3.406237274445633*^9, 3.40623727529278*^9}, {
   3.406311943701379*^9, 3.4063119445827093`*^9}, {3.406312011236314*^9, 
   3.406312040073164*^9}, {3.4063145357524977`*^9, 3.40631466489509*^9}, 
   3.4063147007319098`*^9, {3.406314853608334*^9, 3.406314896723461*^9}, 
   3.4063150428769484`*^9, {3.406315117380772*^9, 3.406315123807167*^9}, {
   3.406315490270726*^9, 3.406315515407012*^9}, 3.406315629370158*^9, 
   3.407027680883329*^9, {3.443357812036664*^9, 3.4433578331622047`*^9}, {
   3.461503644831889*^9, 3.461503646206994*^9}, {3.461525039016471*^9, 
   3.4615250528760233`*^9}, {3.4622062436885157`*^9, 3.4622062447822795`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"utilsExtT", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Utilities  \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Choices for setting selection as hyperlink.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "93"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "94"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "94"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"GridBox", "[", 
                RowBox[{
                 RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    "\"\<Extract Tutorials\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`DivideTutorials\>\""}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], 
                    ",", " ", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Generate tutorial files from a collection of \
documentation files.\\nResulting  notebooks are placed in Tutorials directory \
within the selected directory.\\nAn overview for the new notebooks is also \
created.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<I\[ThinSpace]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "8.5"}]}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                    "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`DivideTutorials[\
DocumentationTools`DivideTutorialsScope\[Rule]File]\>\""}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}], 
                    ",", " ", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    "\"\<Generate tutorial files from input notebook.\>\"", 
                    ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                   "}"}], "}"}], ",", 
                 RowBox[{"ColumnWidths", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"0.9", ",", "0.08"}], "}"}]}], ",", 
                 RowBox[{"ColumnSpacings", "\[Rule]", "0.1"}], ",", 
                 RowBox[{"RowAlignments", "\[Rule]", "Center"}]}], "]"}], 
               "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Fix Table Formatting\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`GenerateTransformedTable\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Select a table cell in a tutorial. This function \
attempts to fix table formatting.\\nA reformatted table is provided in a \
separate notebook for replacement of the original table.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Fix Links to Symbols\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`ApplicationSymbolsLinkFix\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Add button data to application symbol buttons as needed \
in all notebooks in a directory.\\nResulting  notebooks are placed in \
NotebooksWithModifiedButtons directory within the selected directory.\\nUse \
either $IncludedApplicationSymbols or $ExcludedApplicationSymbols if not all \
package sysmbols are to be handled automatically.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Replace Paclet Base\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`ReplacePacletBase\>\""}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Change the context and package name in metadata as well \
as the application name used in button data in all notebooks in a \
directory.\\nResulting  notebooks are placed in \
NotebooksWithPacletBaseReplaced directory within the selected directory.\>\"",
                  ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
               "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], "]"}], ",", 
          "\"\<PaletteGridCell\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "93"}], 
            "}"}]}], ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
             RowBox[{"ColumnSpacings", "\[Rule]", 
              RowBox[{"-", "0.1"}]}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"2", ",", "2", ",", "0.5"}], "}"}]}], ",", " ", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
       "}"}], ",", "Closed"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.35326887006243*^9, {3.35334399209939*^9, 3.35334401676584*^9}, {
   3.35336228167523*^9, 3.35336239638475*^9}, {3.35336242945362*^9, 
   3.35336244478628*^9}, 3.35336248521603*^9, {3.35337102259945*^9, 
   3.3533711166439*^9}, {3.35655746247214*^9, 3.35655752041112*^9}, 
   3.35655798823453*^9, {3.35655901413676*^9, 3.356559015342*^9}, {
   3.35655999881437*^9, 3.35656000044265*^9}, {3.35656140884775*^9, 
   3.35656143743327*^9}, 3.35656152215816*^9, 3.35656158200772*^9, {
   3.36001145414262*^9, 3.36001145994186*^9}, {3.36001149060792*^9, 
   3.36001150642716*^9}, {3.36001154722137*^9, 3.36001158748994*^9}, {
   3.36001166278185*^9, 3.36001172057814*^9}, {3.36001179784588*^9, 
   3.36001179953104*^9}, {3.36052983709004*^9, 3.36052995003483*^9}, {
   3.36053002441169*^9, 3.36053004114966*^9}, {3.3643229264548*^9, 
   3.36432293534785*^9}, {3.36432360491066*^9, 3.364323607865*^9}, {
   3.36647748870191*^9, 3.36647750586728*^9}, {3.374347906891006*^9, 
   3.3743479074117756`*^9}, {3.4008851904915204`*^9, 
   3.4008852029291797`*^9}, {3.403999105160472*^9, 3.403999105535956*^9}, {
   3.406162851559039*^9, 3.406162855712023*^9}, {3.406162901822657*^9, 
   3.406162925161886*^9}, {3.40616298385425*^9, 3.406162997834923*^9}, {
   3.40616302993677*^9, 3.4061630430421343`*^9}, {3.406163207655795*^9, 
   3.406163208572221*^9}, {3.4061632462331676`*^9, 3.406163272510742*^9}, {
   3.406163880695804*^9, 3.406163888339305*^9}, {3.406163927924568*^9, 
   3.4061639319534473`*^9}, {3.40616396657201*^9, 3.406163977156066*^9}, {
   3.406164044349661*^9, 3.406164050208693*^9}, {3.406164130379727*^9, 
   3.4061641401309233`*^9}, 3.406164181331522*^9, {3.406237182194765*^9, 
   3.406237209773802*^9}, {3.406237274445633*^9, 3.40623727529278*^9}, {
   3.406311943701379*^9, 3.4063119445827093`*^9}, {3.406312011236314*^9, 
   3.406312040073164*^9}, {3.4063145357524977`*^9, 3.40631466489509*^9}, 
   3.4063147007319098`*^9, {3.406314853608334*^9, 3.4063148917589483`*^9}, {
   3.406314969116712*^9, 3.4063150083283873`*^9}, 3.4063150996156816`*^9, {
   3.406315492306752*^9, 3.4063155168361883`*^9}, 3.4063156342980413`*^9, {
   3.407027602137454*^9, 3.4070276500421953`*^9}, 3.407027690849093*^9, 
   3.41072023853423*^9, {3.4433578486313505`*^9, 3.4433579428837633`*^9}, 
   3.4494936144360037`*^9, 3.449493725842967*^9, {3.451323118040607*^9, 
   3.4513231514631233`*^9}, {3.4513232074954495`*^9, 
   3.4513232146674623`*^9}, {3.4615036471914454`*^9, 
   3.4615036503635635`*^9}, {3.461525062751149*^9, 3.461525072001268*^9}, {
   3.461617235320253*^9, 3.461617245070378*^9}, {3.462206246001045*^9, 
   3.4622062518292446`*^9}, {3.4641221752257175`*^9, 
   3.4641222295459623`*^9}, {3.464123013164632*^9, 3.464123027298504*^9}, {
   3.4643775708127337`*^9, 3.464377589422347*^9}, {3.4643777123301706`*^9, 
   3.464377721220909*^9}, {3.465675584675321*^9, 3.4656757903654537`*^9}, {
   3.465675926476571*^9, 3.4656759292266064`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Overview group", "Subsubsection",
 CellChangeTimes->{{3.35110861911147*^9, 3.35110862059834*^9}, {
  3.449413979279579*^9, 3.4494139823108487`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"overviewExtT", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Overview Tools  \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Construct overviews one cell at a time.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "94"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "95"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "95"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Generate Overview\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`GenerateOverviewDialog\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], ",",
                    " ", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Create an overview page of a selected list of tutorial \
files.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<New Overview Page\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[Rule]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`CreateNewPageDialog", "[", 
                    "\"\<Overview\>\"", "]"}], "]"}]}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Start new Overview page.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<TOCChapter\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[Rule]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"StyleApply", "[", "\"\<TOCChapter\>\"", "]"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                   ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Insert TOCChapter cell or apply style to a cell.\>\"", 
                 ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<TOCSection\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[Rule]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"StyleApply", "[", "\"\<TOCSection\>\"", "]"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                   ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Insert TOCSection cell or apply style to a cell.\>\"", 
                 ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<TOCSubsection\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[Rule]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"StyleApply", "[", "\"\<TOCSubsection\>\"", "]"}],
                     "]"}]}], ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                   ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Insert TOCSubsection cell or apply style to a \
cell.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<TOCSubsubsection\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[Rule]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "StyleApply", "[", "\"\<TOCSubsubsection\>\"", "]"}], 
                    "]"}]}], ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                   ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Insert TOCSubsubsection cell or apply style to a \
cell.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
               "}"}]}], "}"}], "]"}], "]"}], ",", "\"\<PaletteGridCell\>\"", 
          ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "400"}], 
            "}"}]}], ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
             RowBox[{"ColumnSpacings", "\[Rule]", "0"}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"1", ",", "1", ",", ".2"}], "}"}]}], ",", " ", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "400"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"CellGroupData", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cell", "[", 
              RowBox[{
               RowBox[{"BoxData", "[", 
                RowBox[{"GridBox", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<TOC Link Tools\>\"", ",", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<ButtonSubGroupHead\>\""}], 
                    ",", 
                    RowBox[{"Active", "\[Rule]", "False"}]}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    "\"\<Link cells in an overview to tutorial cells.\>\"", 
                    ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    "}"}], "}"}], ",", 
                  RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}],
                ",", "\"\<ButtonSubGroupHead\>\"", ",", "\[IndentingNewLine]", 
               RowBox[{"CellGroupingRules", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "401"}], 
                 "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Cell", "[", 
              RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
               RowBox[{"CellGroupingRules", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "401"}], 
                 "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Cell", "[", 
              RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
               RowBox[{"CellGroupingRules", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "401"}], 
                 "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Cell", "[", 
              RowBox[{
               RowBox[{"BoxData", "[", 
                RowBox[{"GridBox", "[", 
                 RowBox[{
                  RowBox[{"{", "\[IndentingNewLine]", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<1\[VeryThinSpace]\>\"", ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                    ",", 
                    RowBox[{"Active", "\[Rule]", "False"}]}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<Browse\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`BrowseToTutorialAndOpen",
                     "]"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\"\<Browse for a tutorial to link to its \
headings.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                    "}"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<2\>\"", ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                    ",", 
                    RowBox[{"Active", "\[Rule]", "False"}]}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<Select Cell\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`CopyTutorialCellData", 
                    "]"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\"\<Select a cell bracket in the browsed for \
tutorial and then click this button.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                    "}"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<3\[VeryThinSpace]\>\"", ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                    ",", 
                    RowBox[{"Active", "\[Rule]", "False"}]}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<Paste\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`PasteTutorialCell", 
                    "]"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                    ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                    ",", "\"\<Click on a cell bracket or between cells in the \
overview being constructed and then click this button.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                    "}"}]}], "}"}], ",", 
                  RowBox[{"ColumnWidths", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{"0.1", ",", "0.88"}], "}"}]}], ",", 
                  RowBox[{"RowAlignments", "\[Rule]", "Center"}], ",", 
                  RowBox[{"ColumnSpacings", "\[Rule]", "0.1"}], ",", " ", 
                  RowBox[{"RowLines", "\[Rule]", "True"}], ",", 
                  RowBox[{"RowSpacings", "\[Rule]", "0.2"}]}], "]"}], "]"}], 
               ",", "\"\<PaletteGridCell\>\"", ",", 
               RowBox[{"CellGroupingRules", "\[Rule]", 
                RowBox[{"{", 
                 RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "401"}], 
                 "}"}]}]}], "]"}]}], "}"}], ",", "Open"}], "]"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], ",", "Closed"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.449414473907745*^9, 3.449414497095393*^9}, {
   3.4494147629252195`*^9, 3.4494147638002253`*^9}, {3.449414832175663*^9, 
   3.449414837081944*^9}, {3.449415026739408*^9, 3.4494150268644085`*^9}, {
   3.44941513645886*^9, 3.449415143974533*^9}, {3.4494159193544955`*^9, 
   3.4494159305889425`*^9}, {3.4494161442153096`*^9, 3.449416166965455*^9}, {
   3.4494162330440035`*^9, 3.449416250575365*^9}, {3.4494164370296836`*^9, 
   3.4494164813424673`*^9}, {3.449416518170828*^9, 3.449416624374633*^9}, {
   3.44941672004712*^9, 3.4494167568911057`*^9}, {3.4494933571218567`*^9, 
   3.4494933626531425`*^9}, {3.449493632889247*^9, 3.449493647139338*^9}, {
   3.4494936787801657`*^9, 3.449493680670803*^9}, {3.449493777593298*^9, 
   3.449493783999589*^9}, 3.4495070853585443`*^9, {3.461503611360568*^9, 
   3.4615036184079847`*^9}, {3.461601526740303*^9, 3.461601539021003*^9}, {
   3.4616015766911907`*^9, 3.4616015834565125`*^9}, {3.4616170151143093`*^9, 
   3.4616170188643575`*^9}, {3.4616175199020205`*^9, 3.461617522511429*^9}, {
   3.462206253001135*^9, 3.4622062586574574`*^9}, {3.464122524298031*^9, 
   3.4641225346878304`*^9}, {3.464122618227437*^9, 3.464122759425752*^9}, 
   3.464122798738508*^9, {3.4641228444941883`*^9, 3.4641228790020514`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Spacer", "Subsubsection",
 CellChangeTimes->{{3.3511091008264*^9, 3.35110910148183*^9}, {
   3.35110923339872*^9, 3.35110925234666*^9}, 3.35111766335623*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpacerCell", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"\"\< \>\"", "<>", 
     RowBox[{"StringJoin", "@@", 
      RowBox[{"Table", "[", 
       RowBox[{"\"\<\\n\>\"", ",", 
        RowBox[{"{", "n", "}"}]}], "]"}]}]}], ",", "\"\<Spacer\>\""}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.35110910484454*^9, 3.35110910858804*^9}, {
  3.3511173285188*^9, 3.35111734751682*^9}, {3.35111750557147*^9, 
  3.35111752060066*^9}, {3.35111756873463*^9, 3.35111756914041*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Clusters", "Subsubsection",
 CellChangeTimes->{{3.37029732287167*^9, 3.370297332614922*^9}, {
  3.370872859312025*^9, 3.3708728609443884`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"exampleLinksExt", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Example  Links  \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonSubGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Linking to examples.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonSubGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "900"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "901"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "901"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Create Link\>\"", ",", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"DocumentationTools`ClearLink", "[", "]"}], ";", 
                    RowBox[{
                    "DocumentationTools`InsertLink", "[", "\"\<Example\>\"", 
                    "]"}]}], ")"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", 
                 "\"\<Creates a link to the selected example then puts it on \
the clipboard. Paste where the link is desired.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Copy Link\>\"", ",", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`InsertLink", "[", "\"\<Example\>\"", 
                    "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", 
                 "\"\<Copies link information from an existing link target \
and puts it on the clipboard. Paste where the link is desired.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Clear Link\>\"", ",", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`ClearLink", "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", 
                 "\"\<Removes link target info and backlink from a target \
cell.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
               "}"}]}], "}"}], "]"}], "]"}], ",", "\"\<PaletteGridCell\>\"", 
          ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "901"}], 
            "}"}]}], ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
             RowBox[{"ColumnSpacings", "\[Rule]", "0"}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", "0"}], ",", " ", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
       "}"}], ",", "Closed"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.410479736248143*^9, 3.410479817303577*^9}, {
   3.4104802050041428`*^9, 3.410480210417035*^9}, {3.410480246968474*^9, 
   3.410480252995227*^9}, {3.410480287467496*^9, 3.41048029290895*^9}, {
   3.410480399413534*^9, 3.4104804033700657`*^9}, {3.410480440059515*^9, 
   3.4104804427034893`*^9}, {3.4104805708484993`*^9, 3.410480579328444*^9}, {
   3.410481810959934*^9, 3.410481814724947*^9}, {3.410481873058508*^9, 
   3.4104818769201393`*^9}, 3.4104820211728973`*^9, {3.410482173610198*^9, 
   3.4104821776779623`*^9}, {3.410482212160883*^9, 3.4104822155758553`*^9}, {
   3.4615036787876215`*^9, 3.4615036804439983`*^9}, 3.461587550592767*^9, {
   3.4622062601418514`*^9, 3.462206263970025*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"elementStatusTaggingExt", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Special Flags \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonSubGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Various cell status tags.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonSubGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "700"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "701"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "701"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Tentative\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "->", 
                    "\"\<DocumentationTools`StyleAppend[\\\"TentativeExample\\\
\"]\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButton\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"Background", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.6", ",", "0.9", ",", "0.95"}], "]"}]}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Mark cells waiting for confirmation to add to the \
current documentation build.\\nToggles setting on/off.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Future\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "->", 
                    "\"\<DocumentationTools`StyleAppend[\\\"FutureExample\\\"]\
\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButton\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"Background", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0.6", ",", "0.7"}], "]"}]}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Mark cells for future use that should not be included \
in the current documentation build.\\nToggles setting on/off.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Excluded\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "->", 
                    "\"\<DocumentationTools`StyleAppend[\\\"ExcludedMaterial\\\
\"]\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButton\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"Background", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.8", ",", "0.8", ",", "0.6"}], "]"}]}]}], "]"}],
                  ",", "\[IndentingNewLine]", 
                 "\"\<Mark cells that should be excluded from the current \
documentation build.\\nToggles setting on/off.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"GridBox", "[", 
                RowBox[{
                 RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<Annotate\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`AnnotationInsert", "[", "]"}],
                     "]"}]}], ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButton\>\""}], 
                    ",", 
                    RowBox[{"Background", "->", 
                    RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    "\"\<Dialog for annotating a cell or editing a cell's \
annotation.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{"\"\<D\[VeryThinSpace]\>\"", ",", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`AnnotationRemove", "[", "]"}],
                     "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    "BaseStyle", "\[Rule]", "\"\<NotchButtonDark\>\""}]}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    "\"\<Remove a cell's annotation.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                   "}"}], "}"}], ",", 
                 RowBox[{"ColumnWidths", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"0.91", ",", "0.09"}], "}"}]}], ",", 
                 RowBox[{"RowLines", "\[Rule]", "0"}]}], "]"}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Special Conversion\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "->", 
                    "\"\<DocumentationTools`StyleAppend[\\\"ConversionSpecial\
\\\"]\>\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButton\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"Background", "->", 
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.8", ",", "0.7", ",", "1"}], "]"}]}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Mark cells requiring special conversion processing for \
animation or Flash.\\nToggles setting on/off.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<De\[Hyphen]emphasis\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "->", 
                    "\"\<DocumentationTools`StyleAppend[\\\"Deemphasis\\\"]\>\
\""}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButton\>\""}], 
                   ",", "\[IndentingNewLine]", 
                   RowBox[{"Background", "->", 
                    RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}], ",", 
                 "\[IndentingNewLine]", 
                 "\"\<Use this on input cells that function as service \
commands for setting up an example, such as Needs[...] et al.\\nToggles \
setting on/off.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
               "}"}]}], "}"}], "]"}], "]"}], ",", "\"\<PaletteGridCell\>\"", 
          ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "701"}], 
            "}"}]}], ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
             RowBox[{"ColumnSpacings", "\[Rule]", "0"}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", "0"}], ",", " ", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
       "}"}], ",", "Closed"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.410114869836198*^9, 3.410114883102646*^9}, 
   3.410114913561125*^9, {3.410118089819901*^9, 3.410118162670074*^9}, 
   3.410118199158643*^9, {3.410118332408806*^9, 3.410118351351515*^9}, {
   3.41048020006706*^9, 3.410480203048601*^9}, {3.410480279591151*^9, 
   3.410480284452469*^9}, {3.410480394068308*^9, 3.410480397449512*^9}, {
   3.4104818284955072`*^9, 3.4104818331420116`*^9}, {3.4104819360760927`*^9, 
   3.4104819414191227`*^9}, {3.41048218192064*^9, 3.410482201975685*^9}, {
   3.4432922072700768`*^9, 3.443292215676542*^9}, {3.44329303065053*^9, 
   3.443293033853737*^9}, {3.443293331923867*^9, 3.4432934185823355`*^9}, {
   3.45597686932926*^9, 3.455976874782525*^9}, {3.456176665302929*^9, 
   3.4561766759594517`*^9}, {3.4615036857569065`*^9, 3.461503690491645*^9}, {
   3.462206285095296*^9, 3.462206293032897*^9}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function tab", "Subsection",
 CellChangeTimes->{{3.35110711331214*^9, 3.35110711815878*^9}}],

Cell[CellGroupData[{

Cell["Function header", "Subsubsection",
 CellChangeTimes->{{3.35110863129932*^9, 3.35110863619862*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"headerExtF", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", 
      RowBox[{"GridBox", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<F      \>\"", ",", "\[IndentingNewLine]", 
               RowBox[{
               "ButtonData", "\[RuleDelayed]", "\"\<FunctionsExternal\>\""}], 
               ",", 
               RowBox[{
               "BaseStyle", "\[Rule]", "\"\<PaletteTabSelected\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Function page features.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<G       \>\"", ",", "\[IndentingNewLine]", 
               RowBox[{
               "ButtonData", "\[RuleDelayed]", "\"\<GuidesExternal\>\""}], 
               ",", 
               RowBox[{"BaseStyle", "\[Rule]", "\"\<PaletteTab\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Guide page features.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<T       \>\"", ",", "\[IndentingNewLine]", 
               RowBox[{
               "ButtonData", "\[RuleDelayed]", "\"\<TutorialsExternal\>\""}], 
               ",", 
               RowBox[{"BaseStyle", "\[Rule]", "\"\<PaletteTab\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Tutorial page features.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<\[UpDownArrow]\>\"", ",", 
               RowBox[{"BaseStyle", "\[Rule]", "\"\<ScrollToggle\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Turn vertical scroll bar on or off.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], "}"}], 
         "}"}], ",", " ", 
        StyleBox["tabGridOptsExt",
         CellMargins->{{12, 12}, {12, 12}}]}], "]"}], "]"}], ",", " ", 
     "\"\<PaletteTabCell\>\"", ",", " ", 
     RowBox[{"CellTags", "\[Rule]", "\"\<FunctionsExternal\>\""}], ",", " ", 
     RowBox[{"PageBreakAbove", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.3511071265559*^9, 3.3511071378327*^9}, {
   3.35110802495206*^9, 3.35110802904149*^9}, {3.35111692835971*^9, 
   3.35111692963147*^9}, {3.36647750773003*^9, 3.36647750776008*^9}, {
   3.3970952808323603`*^9, 3.397095281332781*^9}, 3.40079618166744*^9, {
   3.403999238831884*^9, 3.403999284235812*^9}, {3.403999553909333*^9, 
   3.403999556342609*^9}, {3.404000382846184*^9, 3.4040003919670258`*^9}, 
   3.4040005556865263`*^9, {3.40616368763099*^9, 3.406163688001896*^9}, {
   3.4615036911166935`*^9, 3.4615036929605846`*^9}, 3.46220788077197*^9, {
   3.4641198799157476`*^9, 3.4641199077310824`*^9}, {3.473428361394346*^9, 
   3.4734283622381177`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Function cell group 1", "Subsubsection",
 CellChangeTimes->{{3.35110864553801*^9, 3.35110865507265*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"cellExtF1", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", 
      RowBox[{"GridBox", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<New Function Page\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{
                "DocumentationTools`CreateNewPageDialog", "[", 
                 "\"\<Reference\>\"", "]"}], "]"}]}], ",", " ", 
              "\[IndentingNewLine]", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BoldButton\>\""}], ",", 
              RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], ",", 
            "\"\<Start new function document.\\nSet version number string \
using $MVersion.\\n\\\nUse FunctionPageForSymbol to create function page \
templates programmatically.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<Sample Function Page\[VeryThinSpace]\>\"", ",", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{"NotebookOpen", "[", 
                 RowBox[{"ToFileName", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"$DocuToolsDir", ",", "\"\<Examples\>\""}], "}"}],
                    ",", "\"\<FunctionExample.nb\>\""}], "]"}], "]"}], 
                "]"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButtonDark\>\""}]}], 
             "]"}], ",", "\"\<Sample function page.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"GridBox", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Set Paclet Name & Path\>\"", ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`DocumentationDirSelect[\\\"\
Interactive\\\"\[Rule]True]\>\""}], ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButtonDark\>\""}],
                    ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Use this to select the paclet (application pack) \
directory containing your working documentation source file layout.\\nYour \
selection is stored in the front end init.m as $DocumentationDirectory, from \
which $ApplicationName is derived for configuring the link base in hyperlinks \
to other documents in the same paclet layout.\\nThe paclet's parent directory \
also becomes part of $DocumentationPath to support links to documents in \
other paclet projects on the path.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<M\>\"", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
                    RowBox[{"FontColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "0.7", "]"}]}]}], "]"}], ",", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`SetPacletVariables\>\""}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButtonDark\>\""}],
                    ",", 
                   RowBox[{"Background", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "0.4", "]"}]}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\"\<Use this to configure $ApplicationName and \
$LinkBase manually, primarily when the link base is not the same as your \
application name.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
              "}"}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"ColumnWidths", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"0.9", ",", "0.09"}], "}"}]}], ",", " ", 
            RowBox[{"ColumnSpacings", "\[Rule]", 
             RowBox[{"{", "0.05", "}"}]}], ",", 
            RowBox[{"ColumnAlignments", "\[Rule]", "Center"}]}], "]"}], "}"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<Double Usage Line\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", ":>", 
               RowBox[{
               "Hold", "[", "DocumentationTools`DoubleUsageLinesInsert", 
                "]"}]}], ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            "\"\<Use this to insert a new usage message template directly \
after the cursor position.\\nEsc\[Dash]ls\[Dash]Esc inserts a line separator \
(soft carriage return)\\nwhich separates the function template from the \
second line of text.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<Template Input\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{
               "Hold", "[", "DocumentationTools`FunctionTemplateToggle", 
                "]"}]}], ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            "\"\<Use this for function templates. Lower case words will be \
italic.\\nxxx$yyy makes yyy a subscript. $$ gives ...\\nFunction names will \
become links when appropriate.\\nRefer to format menu for shortcut (custom \
menu items are in brackets).\\nUse shortcut after typing for \
autoselection.\\nApplying this in series toggles formatted and raw template \
text.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{
             "\"\<Inline Listing Toggle\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{"DocumentationTools`InlineListingToggle", "[", 
                 RowBox[{"\"\<TargetStyle\>\"", "\[Rule]", "Automatic"}], 
                 "]"}], "]"}]}], ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            "\"\<Toggles formatting back and forth between plain text and \
inline listing with hyperlinks and formatted delimiters appropriate for the \
cell the selection is in.\\nTo make a link to a function page for a symbol in \
another application, list it along with the other symbols to be linked as \
otherapplicationlinkbase/ref/symbol.\\nInsertion between cells creates See \
Also listing template.\\nUse space.space to indicate delimiters.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}]}], 
        "}"}], "]"}], "]"}], ",", "\"\<PaletteGridCell\>\"", ",", 
     RowBox[{"GridBoxOptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
        RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
        RowBox[{"ColumnSpacings", "\[Rule]", 
         RowBox[{"-", "0.1"}]}], ",", 
        RowBox[{"RowSpacings", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{".3", ",", "0", ",", "2", ",", "0.5", ",", "1"}], "}"}]}], 
        ",", 
        RowBox[{"RowLines", "\[Rule]", "True"}], ",", 
        RowBox[{"ColumnLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.35655607419917*^9, 3.35655612954139*^9}, {
   3.35655677343798*^9, 3.35655684510252*^9}, {3.35655688192505*^9, 
   3.35655698201643*^9}, {3.35655702461748*^9, 3.35655714266828*^9}, {
   3.35655717829463*^9, 3.35655722568766*^9}, 3.35655740987339*^9, {
   3.35655891739163*^9, 3.35655892022918*^9}, {3.35655935292167*^9, 
   3.35655938237316*^9}, {3.35655942527694*^9, 3.35655942949308*^9}, {
   3.356559468239*^9, 3.35655958103273*^9}, {3.35655962134174*^9, 
   3.35655963955299*^9}, {3.35655967254065*^9, 3.35655967336062*^9}, {
   3.35656020745066*^9, 3.35656021215847*^9}, {3.35733879932781*^9, 
   3.35733880967269*^9}, 3.3589841532256*^9, {3.35898422241125*^9, 
   3.3589842233375*^9}, {3.35898440634431*^9, 3.35898441930254*^9}, 
   3.35898451302903*^9, {3.36432277328998*^9, 3.36432280128106*^9}, 
   3.36432319817364*^9, {3.36432324227838*^9, 3.36432336499851*^9}, {
   3.36563622081916*^9, 3.36563623019311*^9}, {3.36563626192031*^9, 
   3.36563629862492*^9}, 3.36563913689766*^9, {3.36563920921525*^9, 
   3.36563922731217*^9}, {3.36563927793749*^9, 3.36563935307929*^9}, {
   3.36563938405537*^9, 3.36563943359908*^9}, {3.36563954093878*^9, 
   3.36563958751808*^9}, {3.36563965431747*^9, 3.36563968054649*^9}, {
   3.36563971828263*^9, 3.36563972353044*^9}, {3.36563975464673*^9, 
   3.36563985644819*^9}, {3.36563989971256*^9, 3.36563998649167*^9}, {
   3.36564080269894*^9, 3.36564084099591*^9}, {3.3656409100186*^9, 
   3.36564091008871*^9}, 3.36564101869028*^9, {3.36564107260049*^9, 
   3.36564112899439*^9}, {3.36564118554853*^9, 3.36564136446472*^9}, {
   3.36647750781015*^9, 3.36647750866141*^9}, {3.36648654004705*^9, 
   3.36648657551436*^9}, {3.36648662172062*^9, 3.36648675561328*^9}, {
   3.370297436743819*^9, 3.3702974425277987`*^9}, {3.374351300165631*^9, 
   3.3743514095372615`*^9}, {3.379545551154084*^9, 3.3795455606174088`*^9}, {
   3.388253087323757*^9, 3.3882531328485727`*^9}, {3.4007954574797573`*^9, 
   3.400795468025236*^9}, {3.400798599851246*^9, 3.400798624938457*^9}, {
   3.4007986640046253`*^9, 3.4007987099515467`*^9}, 3.40079878027031*^9, {
   3.4008847405170107`*^9, 3.4008847407357635`*^9}, {3.400893844172735*^9, 
   3.400893950672543*^9}, {3.40089399139552*^9, 3.400893994098072*^9}, {
   3.400894044157686*^9, 3.4008940446822042`*^9}, {3.401024817804576*^9, 
   3.4010248196249037`*^9}, {3.4039993134292107`*^9, 3.40399931402987*^9}, {
   3.404012392313793*^9, 3.404012392730871*^9}, {3.406163143202159*^9, 
   3.406163162866866*^9}, {3.4061633496652184`*^9, 3.406163379953412*^9}, {
   3.406163424537635*^9, 3.4061634263748617`*^9}, {3.406163456389483*^9, 
   3.406163458799765*^9}, {3.4061642578138657`*^9, 3.406164258253111*^9}, {
   3.406164583220911*^9, 3.406164624316209*^9}, {3.406164665211199*^9, 
   3.406164692426353*^9}, {3.406164841585662*^9, 3.406164843397587*^9}, {
   3.406164891995059*^9, 3.406164935296536*^9}, {3.406242180339275*^9, 
   3.406242235166395*^9}, {3.406242269532625*^9, 3.4062422818491907`*^9}, {
   3.40624232921949*^9, 3.4062423857580147`*^9}, {3.4062424345416737`*^9, 
   3.406242438119872*^9}, {3.406242473176763*^9, 3.4062425021878633`*^9}, {
   3.4062425623218327`*^9, 3.406242628002578*^9}, 3.40624270719322*^9, {
   3.4062427548621073`*^9, 3.406242763235196*^9}, {3.406242808835349*^9, 
   3.406242903786868*^9}, {3.4063112600161657`*^9, 3.406311444453718*^9}, {
   3.4063116524002542`*^9, 3.406311823312426*^9}, {3.4063149294426413`*^9, 
   3.406314942539296*^9}, {3.406408196156846*^9, 3.406408197411747*^9}, {
   3.407027766953933*^9, 3.4070277687554893`*^9}, {3.407027818218506*^9, 
   3.407027841111616*^9}, {3.407028540060701*^9, 3.40702854087008*^9}, {
   3.407031636568598*^9, 3.407031691542585*^9}, {3.40703178441005*^9, 
   3.407031829678032*^9}, {3.407031863095994*^9, 3.4070322012285137`*^9}, 
   3.4070322548602037`*^9, {3.41324489351541*^9, 3.41324503733228*^9}, {
   3.413245094481146*^9, 3.413245109657116*^9}, 3.413245198696629*^9, {
   3.413245316137478*^9, 3.4132453180166893`*^9}, {3.4132456091141653`*^9, 
   3.413245612647625*^9}, {3.413245649022752*^9, 3.413245668462945*^9}, 
   3.4132457060963287`*^9, 3.413246110512465*^9, 3.413251787005774*^9, {
   3.426277178244627*^9, 3.426277186503937*^9}, {3.44329466448923*^9, 
   3.4432946805052648`*^9}, {3.443294836681138*^9, 3.4432948622599173`*^9}, {
   3.443362690389569*^9, 3.4433627037024097`*^9}, {3.4433627570944014`*^9, 
   3.4433627676102953`*^9}, 3.4482880934298162`*^9, {3.4482881356811686`*^9, 
   3.448288136946834*^9}, {3.461503517813656*^9, 3.46150356285384*^9}, {
   3.4615036936481376`*^9, 3.4615036984922595`*^9}, {3.4615039292890987`*^9, 
   3.4615039298047366`*^9}, {3.4615040213695803`*^9, 
   3.4615041129969263`*^9}, {3.4615041786861076`*^9, 3.4615041823112006`*^9}, 
   3.4615042228896866`*^9, {3.461586978694822*^9, 3.4615869803042173`*^9}, {
   3.461616314683469*^9, 3.4616163261523657`*^9}, {3.4622062989860983`*^9, 
   3.4622063062518167`*^9}, {3.4639296362402253`*^9, 3.463929675068847*^9}, {
   3.4639297211163116`*^9, 3.4639297250851126`*^9}, {3.463929765976261*^9, 
   3.4639298217894754`*^9}, {3.463929858352443*^9, 3.4639299040561533`*^9}, {
   3.463929992541661*^9, 3.46393002177641*^9}, 3.463930250435587*^9, {
   3.463930342171136*^9, 3.463930342655517*^9}, {3.4639376151363993`*^9, 
   3.4639376272147565`*^9}, {3.4641156171181726`*^9, 3.464115626915161*^9}, {
   3.4641156944956603`*^9, 3.4641157143860426`*^9}, 3.4641157868182354`*^9, {
   3.4641158175040255`*^9, 3.4641158181436377`*^9}, {3.4641187409534445`*^9, 
   3.4641187864595203`*^9}, {3.4641190173283596`*^9, 
   3.4641190174687624`*^9}, {3.4641190501825914`*^9, 
   3.4641191134106073`*^9}, {3.4641191605235133`*^9, 3.464119161131925*^9}, {
   3.464119194625769*^9, 3.464119216996599*^9}, {3.464119501639673*^9, 
   3.4641195183007936`*^9}, 3.464119627159687*^9, {3.464119725363576*^9, 
   3.464119755550156*^9}, {3.4641197879363785`*^9, 3.464119837701336*^9}, {
   3.464124596709485*^9, 3.464124614353424*^9}, 3.4641246979866323`*^9, {
   3.464124842785108*^9, 3.464124862403449*^9}, {3.4650487562930717`*^9, 
   3.4650487606681275`*^9}, 3.472488756470915*^9, 3.475933846012376*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Function cell group 2", "Subsubsection",
 CellChangeTimes->{{3.35110866429797*^9, 3.3511086790507*^9}, 
   3.35110873135645*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"cellExtF2", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{"CellGroupData", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Main  Usage  \[FilledDownTriangle]\>\"", ",", 
                   RowBox[{
                   "BaseStyle", "\[Rule]", "\"\<ButtonGroupHead\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Usage content tools.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               "}"}], ",", 
             RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "]"}], 
          ",", "\"\<ButtonGroupHead\>\"", ",", "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "200"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "201"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{"\"\< \>\"", ",", "\"\<Spacer\>\"", ",", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "201"}], 
            "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Insert Syntax Template\>\"", ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`SyntaxTemplateInsert", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Derives syntax template automatically from function \
page.\\nTemplate is inserted at top of syntax template group.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Inspect Syntax Templates\>\"", ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`SyntaxTemplatesInspector\>\""}], 
                   ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}], 
                   ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Displays function examples used to automatically derive \
templates from function page.\\nAllows fine tuning of choices, and new master \
template is inserted at top of syntax template group.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Arguments Patt. Override\>\"", ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`SyntaxTemplateException", "[", 
                    "\"\<Exclusion\>\"", "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Tag usage example to not be used for deriving syntax \
templating information.\\nPlace cursor anywhere within function inline cell \
and this button toggles the setting.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Inferred Arguments Patt.\>\"", ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`SyntaxTemplateException", "[", 
                    "\"\<Inclusion\>\"", "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Tag notes example to be used for deriving syntax \
templating information.\\nPlace cursor anywhere within function inline cell \
and this button toggles the setting.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"DynamicModuleBox", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"u", ",", 
                   RowBox[{
                   "i", "=", "\"\<Additional Function Templates\>\""}]}], 
                  "}"}], ",", "\[IndentingNewLine]", 
                 RowBox[{"GridBox", "[", 
                  RowBox[{
                   RowBox[{"{", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"DynamicBox", "[", 
                    RowBox[{"ButtonBox", "[", 
                    RowBox[{
                    "\"\<Template Labeling\>\"", ",", "\[IndentingNewLine]", 
                    RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SameQ", "[", 
                    RowBox[{
                    RowBox[{"DocumentationTools`CellInfo", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
                    "$Failed"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"NotebookWrite", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<Template\>\"", ",", 
                    RowBox[{"CellLabel", "\[Rule]", "i"}]}], "]"}], ",", 
                    "All"}], "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"SelectionMove", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", "All", ",", 
                    "CellContents"}], "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                    "DocumentationTools`VersionAnnotate", "[", "i", "]"}]}], 
                    "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
                    RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<SmallButton\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}], ",", 
                    " ", 
                    RowBox[{"ImageSize", "->", 
                    RowBox[{"{", 
                    RowBox[{"144", ",", "15"}], "}"}]}], ",", 
                    RowBox[{"Evaluator", "\[Rule]", "Automatic"}], ",", 
                    RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}]}], 
                    "]"}], "]"}], ",", 
                    "\"\<Insert template cell with label choice applied, or \
apply label choice to selected cell.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"TooltipBox", "[", 
                    RowBox[{
                    RowBox[{"PopupMenuBox", "[", 
                    RowBox[{
                    RowBox[{"Dynamic", "[", "i", "]"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\<Additional Function Template\>\"", "\[Rule]", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Additional Function Template\>\"", ",", 
                    RowBox[{"FontColor", " ", "->", " ", 
                    RowBox[{"GrayLevel", "[", "0", "]"}]}]}], "]"}]}], ",", 
                    RowBox[{"\"\<Arguments Pattern\>\"", "\[Rule]", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Arguments Pattern\>\"", ",", 
                    RowBox[{"FontColor", " ", "->", " ", 
                    RowBox[{"GrayLevel", "[", "0", "]"}]}]}], "]"}]}], ",", 
                    RowBox[{"\"\<Local Variables\>\"", "\[Rule]", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Local Variables\>\"", ",", 
                    RowBox[{"FontColor", " ", "->", " ", 
                    RowBox[{"GrayLevel", "[", "0", "]"}]}]}], "]"}]}], ",", 
                    RowBox[{"\"\<Color Equal Signs\>\"", "\[Rule]", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Color Equal Signs\>\"", ",", 
                    RowBox[{"FontColor", " ", "->", " ", 
                    RowBox[{"GrayLevel", "[", "0", "]"}]}]}], "]"}]}], ",", 
                    RowBox[{"\"\<Hidden Options\>\"", "\[Rule]", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Hidden Options\>\"", ",", 
                    RowBox[{"FontColor", " ", "->", " ", 
                    RowBox[{"GrayLevel", "[", "0", "]"}]}]}], "]"}]}]}], 
                    "}"}], ",", "\[IndentingNewLine]", "\"\<\>\"", ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"ButtonBox", "[", " ", 
                    RowBox[{"\"\<L\>\"", ",", 
                    RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}], 
                    ",", " ", 
                    RowBox[{"ImageSize", "->", 
                    RowBox[{"{", 
                    RowBox[{"10", ",", "15"}], "}"}]}]}], "]"}]}], "]"}], ",",
                     "\[IndentingNewLine]", 
                    "\"\<Set template label choice.\>\"", ",", 
                    RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
                    "}"}], "}"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ColumnWidths", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"0.92", ",", "0.08"}], "}"}]}]}], "]"}]}], "]"}], 
               "}"}]}], "}"}], "]"}], "]"}], ",", "\"\<PaletteGridCell\>\"", 
          ",", 
          RowBox[{"GridBoxOptions", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
             RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
             RowBox[{"ColumnSpacings", "\[Rule]", "0"}], ",", 
             RowBox[{"RowSpacings", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"0.5", ",", "1", ",", "0.5", ",", "1", ",", "0.5"}], 
               "}"}]}], ",", " ", 
             RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"CellGroupingRules", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<GroupTogetherNestedGrouping\>\"", ",", "201"}], 
            "}"}]}]}], "]"}]}], "}"}], ",", "Closed"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.35336939555033*^9, 3.35336943009701*^9}, {
   3.35337068092576*^9, 3.3533706918712*^9}, {3.35655898684808*^9, 
   3.35655899165162*^9}, {3.35656148350043*^9, 3.35656148510894*^9}, {
   3.35656152799846*^9, 3.35656152854966*^9}, {3.35656158727973*^9, 
   3.35656158793439*^9}, {3.35898448221772*^9, 3.35898449576218*^9}, {
   3.35898458533711*^9, 3.35898459067346*^9}, 3.36432283705357*^9, 
   3.36432372267352*^9, {3.36647750869145*^9, 3.36647750911207*^9}, {
   3.36648677270272*^9, 3.36648681608972*^9}, {3.4008847549390707`*^9, 
   3.4008847675954823`*^9}, {3.403999339431076*^9, 3.403999339849703*^9}, {
   3.443363146557496*^9, 3.4433631544326982`*^9}, {3.4615036991798124`*^9, 
   3.461503703523896*^9}, {3.46220630734558*^9, 3.462206313798788*^9}, {
   3.4641208494498224`*^9, 3.4641208496994276`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Function cell group 3", "Subsubsection",
 CellChangeTimes->{{3.35111677859117*^9, 3.3511167828409*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"cellExtF3", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", 
      RowBox[{"GridBox", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"TooltipBox", "[", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<Paclet Monitor\>\"", ",", "\"\<GrayText\>\""}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 RowBox[{
                 "ButtonData", "\[Rule]", 
                  "\"\<DocumentationTools`CurrentPacletMonitorOpen\>\""}], 
                 ",", 
                 RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}], ",", 
                 RowBox[{"ButtonFrame", "\[Rule]", "None"}], ",", 
                 RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
               ",", "\[IndentingNewLine]", 
               "\"\<Paclet Monitor is a small indicator tracking the current \
settings for $ApplicationName and $LinkBase.\>\"", ",", 
               RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"StyleBox", "[", 
              RowBox[{"\"\<|\>\"", ",", "\"\<GrayText\>\"", ",", 
               RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"TooltipBox", "[", 
              RowBox[{
               RowBox[{"ButtonBox", "[", 
                RowBox[{
                 RowBox[{"StyleBox", "[", 
                  RowBox[{"\"\<Prompt\>\"", ",", "\"\<GrayText\>\""}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 RowBox[{
                 "ButtonData", "\[Rule]", 
                  "\"\<DocumentationTools`PacletVariablesPromptRestore\>\""}],
                  ",", 
                 RowBox[{"BaseStyle", "\[Rule]", "\"\<SmallButton\>\""}], ",", 
                 RowBox[{"ButtonFrame", "\[Rule]", "None"}], ",", 
                 RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
               ",", "\[IndentingNewLine]", 
               "\"\<Activate prompt at start up of DocumentationTools for \
displaying the current settings for $ApplicationName and $LinkBase.\>\"", ",", 
               RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], "}"}],
            "]"}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"Cell", "[", 
             RowBox[{"\"\<Creation Date\>\"", ",", "\"\<GrayText\>\""}], 
             "]"}], ",", "timeStamp", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Cell", "[", 
           RowBox[{"\"\< \\n\\n\>\"", ",", "\"\<Spacer\>\""}], "]"}], "}"}]}],
         "}"}], "]"}], "]"}], ",", "\"\<PaletteGridCell\>\"", ",", 
     RowBox[{"Sequence", "[", 
      RowBox[{
       RowBox[{"CellMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"GridBoxOptions", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
          RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ColumnSpacings", "\[Rule]", "0"}], ",", 
          RowBox[{"RowSpacings", "\[Rule]", "5"}], ",", " ", 
          RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35110830632919*^9, 3.35110831057861*^9}, {
   3.351108345451*^9, 3.35110836287282*^9}, 3.35111677616266*^9, {
   3.35336967488055*^9, 3.35336969078539*^9}, {3.35337066529027*^9, 
   3.35337066774173*^9}, 3.35343145001079*^9, 3.36432284478492*^9, 
   3.36647750912209*^9, {3.403999372629627*^9, 3.40399937304774*^9}, 
   3.40400208304711*^9, {3.4040061262781363`*^9, 3.404006133297126*^9}, {
   3.404006280096676*^9, 3.4040062806330433`*^9}, {3.404006334829973*^9, 
   3.404006335565834*^9}, 3.404006396672483*^9, {3.4040065615229187`*^9, 
   3.404006575883791*^9}, 3.404007309473872*^9, {3.423700665889072*^9, 
   3.423700709279101*^9}, {3.431112774819392*^9, 3.4311129249991703`*^9}, {
   3.431112960919299*^9, 3.431113000872965*^9}, {3.431113045338469*^9, 
   3.431113139865247*^9}, 3.4311132235930767`*^9, 3.431113303787368*^9, {
   3.443363318015011*^9, 3.4433633609692354`*^9}, {3.4609998627347155`*^9, 
   3.4609998635159655`*^9}, {3.461503704477094*^9, 3.461503706789772*^9}, {
   3.462206315470684*^9, 3.4622063166113243`*^9}, 3.462207905928542*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Guide tab", "Subsection",
 CellChangeTimes->{{3.35110711331214*^9, 3.35110711815878*^9}, {
  3.3511071623953*^9, 3.35110716325426*^9}}],

Cell[CellGroupData[{

Cell["Guide header", "Subsubsection",
 CellChangeTimes->{{3.35110863129932*^9, 3.35110863619862*^9}, {
  3.35110883790592*^9, 3.35110883852805*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"headerExtG", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", "\[IndentingNewLine]", 
      RowBox[{"GridBox", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<F      \>\"", ",", "\[IndentingNewLine]", 
               RowBox[{
               "ButtonData", "\[RuleDelayed]", "\"\<FunctionsExternal\>\""}], 
               ",", 
               RowBox[{"BaseStyle", "\[Rule]", "\"\<PaletteTab\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Function page features.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<G       \>\"", ",", "\[IndentingNewLine]", 
               RowBox[{
               "ButtonData", "\[RuleDelayed]", "\"\<GuidesExternal\>\""}], 
               ",", 
               RowBox[{
               "BaseStyle", "\[Rule]", "\"\<PaletteTabSelected\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Guide page features.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<T       \>\"", ",", "\[IndentingNewLine]", 
               RowBox[{
               "ButtonData", "\[RuleDelayed]", "\"\<TutorialsExternal\>\""}], 
               ",", 
               RowBox[{"BaseStyle", "\[Rule]", "\"\<PaletteTab\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Tutorial page features.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<\[UpDownArrow]\>\"", ",", 
               RowBox[{"BaseStyle", "\[Rule]", "\"\<ScrollToggle\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Turn vertical scroll bar on or off.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], "}"}], 
         "}"}], ",", " ", 
        StyleBox["tabGridOptsExt",
         CellMargins->{{12, 12}, {12, 12}}]}], "]"}], "]"}], ",", 
     "\"\<PaletteTabCell\>\"", ",", 
     RowBox[{"CellTags", "\[Rule]", "\"\<GuidesExternal\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.3511071265559*^9, 3.3511071378327*^9}, {
   3.35110721482064*^9, 3.35110721548609*^9}, {3.3511084225862*^9, 
   3.35110842391464*^9}, {3.35111691784342*^9, 3.35111692062309*^9}, {
   3.36647750914212*^9, 3.36647750917216*^9}, 3.397095299385854*^9, 
   3.400796196715794*^9, {3.403999399061873*^9, 3.403999405336814*^9}, {
   3.403999563228661*^9, 3.4039995653808928`*^9}, {3.4040004349655457`*^9, 
   3.404000439966083*^9}, 3.40400057644165*^9, 3.404000747049192*^9, 
   3.4061637023264923`*^9, {3.4615037080086155`*^9, 3.461503710102526*^9}, 
   3.462207917272437*^9, {3.473428379910445*^9, 3.4734283807229657`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Guide cell group 1", "Subsubsection",
 CellChangeTimes->{{3.35110864553801*^9, 3.35110865507265*^9}, {
  3.35110881348975*^9, 3.35110881411193*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"cellExtG1", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", 
      RowBox[{"GridBox", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<New Guide Page\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{
                "DocumentationTools`CreateNewPageDialog", "[", 
                 "\"\<Guide\>\"", "]"}], "]"}]}], ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BoldButton\>\""}], ",", 
              RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], ",", 
            "\"\<Start guide page.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<Sample Guide Page\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{"NotebookOpen", "[", 
                 RowBox[{"ToFileName", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"$DocuToolsDir", ",", "\"\<Examples\>\""}], "}"}],
                    ",", "\"\<GuideExample.nb\>\""}], "]"}], "]"}], "]"}]}], 
              ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButtonDark\>\""}], 
              ",", 
              RowBox[{"ButtonMargins", "\[Rule]", "2"}]}], "]"}], ",", 
            "\"\<Sample guide page.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"GridBox", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Set Paclet Name & Path\>\"", ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`DocumentationDirSelect[\\\"\
Interactive\\\"\[Rule]True]\>\""}], ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButtonDark\>\""}],
                    ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Use this to select the paclet (application pack) \
directory containing your working documentation source file layout.\\nYour \
selection is stored in the front end init.m as $DocumentationDirectory, from \
which $ApplicationName is derived for configuring the link base in hyperlinks \
to other documents in the same paclet layout.\\nThe paclet's parent directory \
also becomes part of $DocumentationPath to support links to documents in \
other paclet projects on the path.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<M\>\"", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
                    RowBox[{"FontColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "0.7", "]"}]}]}], "]"}], ",", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`SetPacletVariables\>\""}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButtonDark\>\""}],
                    ",", 
                   RowBox[{"Background", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "0.4", "]"}]}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\"\<Use this to configure $ApplicationName and \
$LinkBase manually, primarily when the link base is not the same as your \
application name.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
              "}"}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"ColumnWidths", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"0.9", ",", "0.09"}], "}"}]}], ",", " ", 
            RowBox[{"ColumnSpacings", "\[Rule]", 
             RowBox[{"{", "0.1", "}"}]}], ",", 
            RowBox[{"ColumnAlignments", "\[Rule]", "Center"}]}], "]"}], "}"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{
             "\"\<1 Line Function Listing\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{
              "ButtonData", "\[Rule]", 
               "\"\<DocumentationTools`OneLineFunction\>\""}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            "\"\<Select between cells to insert a 1-line function \
template.\\n Toggles between formatted and unformatted states when used on or \
in text of a preexisting 1-line function cell.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<Delimiter\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{
               "Hold", "[", "DocumentationTools`DocDelimiter", "]"}]}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            "\"\<Item separator for function listing area.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{
             "\"\<Functions Inline Listing\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{"DocumentationTools`InlineListingToggle", "[", 
                 RowBox[{"\"\<TargetStyle\>\"", "\[Rule]", "Automatic"}], 
                 "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            "\"\<Use <space>.<space> to delimit elements. Function names will \
be autolinked.\\nTo make a link to a function page for a symbol in another \
application, list it along with the other symbols to be linked as \
otherapplicationlinkbase/ref/symbol.\\nToggles format on/off for easy \
editing. Use Plain Text button for comments that should not be bold or \
buttonized.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{
             "\"\<Insert Artwork Banner Cell\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{
               "Hold", "[", "DocumentationTools`BannerInsert", "]"}]}], ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            "\"\<Inserts a template cell for placement of product branding \
artwork.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<Subsection\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{
                "DocumentationTools`StyleApply", "[", 
                 "\"\<GuideFunctionsSubsection\>\"", "]"}], "]"}]}], ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            "\"\<Subsection heading for functions listing.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<GuideText\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", ":>", 
               RowBox[{"Hold", "[", 
                RowBox[{
                "DocumentationTools`StyleApply", "[", "\"\<GuideText\>\"", 
                 "]"}], "]"}]}], ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], 
             "]"}], ",", "\[IndentingNewLine]", "\"\<Guide text cell.\>\"", 
            ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}]}], 
        "\[IndentingNewLine]", "}"}], "]"}], "]"}], ",", 
     "\"\<PaletteGridCell\>\"", ",", 
     RowBox[{"GridBoxOptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
        RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
        RowBox[{"ColumnSpacings", "\[Rule]", "0"}], ",", 
        RowBox[{"RowSpacings", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          ".3", ",", "0", ",", "2", ",", "0.5", ",", "1", ",", "0.5", ",", 
           "0.5", ",", "1", ",", "0.5", ",", "0.5", ",", "2"}], "}"}]}], ",", 
        " ", 
        RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.35708137173241*^9, 3.35708139155802*^9}, 
   3.35733883215501*^9, {3.35920926985932*^9, 3.35920928664416*^9}, {
   3.36303275449565*^9, 3.36303281700055*^9}, {3.36303286943818*^9, 
   3.36303289178679*^9}, {3.36344926166008*^9, 3.36344926229247*^9}, {
   3.36344934295359*^9, 3.36344937052019*^9}, {3.36344950286567*^9, 
   3.36344950450085*^9}, 3.36432342440571*^9, {3.36647750920221*^9, 
   3.36647750990324*^9}, {3.36848733840449*^9, 3.36848738965319*^9}, {
   3.36849171134845*^9, 3.36849173695086*^9}, {3.370297545878624*^9, 
   3.370297563735087*^9}, {3.3708730095595684`*^9, 3.3708730615949106`*^9}, {
   3.374094497460855*^9, 3.374094627507839*^9}, {3.3740946834014893`*^9, 
   3.374094729290531*^9}, {3.37409476577936*^9, 3.374094768223207*^9}, {
   3.374097520089882*^9, 3.374097565331583*^9}, {3.375214357998106*^9, 
   3.375214380533153*^9}, {3.3752144674814053`*^9, 3.3752144729140472`*^9}, {
   3.375214528717757*^9, 3.3752145293565483`*^9}, 3.377991560437985*^9, {
   3.3811644889187*^9, 3.3811644930399923`*^9}, {3.3811649521643867`*^9, 
   3.3811649769322233`*^9}, {3.390929507360532*^9, 3.390929617368972*^9}, {
   3.390929729633308*^9, 3.390929729857305*^9}, {3.3982880619138107`*^9, 
   3.3982881187026*^9}, {3.400795935003047*^9, 3.400795998718169*^9}, {
   3.400884839596404*^9, 3.400884854424719*^9}, 3.403474261503182*^9, {
   3.4034745061552353`*^9, 3.403474614054947*^9}, {3.403474652181774*^9, 
   3.4034746853961363`*^9}, {3.403999608907693*^9, 3.4039996093574333`*^9}, {
   3.4040124090894012`*^9, 3.404012409520534*^9}, {3.406163600397355*^9, 
   3.406163610094603*^9}, 3.4061642718620377`*^9, 3.406242927537085*^9, {
   3.4063118549657307`*^9, 3.406311856209476*^9}, 3.406408208329405*^9, {
   3.407032305118773*^9, 3.407032307487626*^9}, 3.4132451496771593`*^9, 
   3.413245185476853*^9, 3.4132453367282887`*^9, {3.4132455039491243`*^9, 
   3.413245508348447*^9}, 3.413251761672154*^9, {3.4433635104418116`*^9, 
   3.4433635185513945`*^9}, {3.4433635587086725`*^9, 
   3.4433635681620393`*^9}, {3.443363665242649*^9, 3.4433636769148235`*^9}, 
   3.4469132954101677`*^9, {3.4482882591226187`*^9, 3.4482882752793856`*^9}, {
   3.4482886066962404`*^9, 3.4482886079931574`*^9}, {3.4609839481878405`*^9, 
   3.4609839719534655`*^9}, 3.4609872666409655`*^9, {3.4615037108838363`*^9, 
   3.4615037173530827`*^9}, {3.4615042814369364`*^9, 
   3.4615043573592973`*^9}, {3.4616163926219664`*^9, 
   3.4616163990907993`*^9}, {3.4616165552021723`*^9, 3.461616557061571*^9}, {
   3.4622063178769655`*^9, 3.4622063294552383`*^9}, {3.463930160543811*^9, 
   3.4639302154820147`*^9}, {3.46393035576506*^9, 3.463930356249441*^9}, {
   3.4639376520120487`*^9, 3.4639376584652567`*^9}, {3.464120134599408*^9, 
   3.464120161057517*^9}, 3.464120193209736*^9, {3.4641202453147373`*^9, 
   3.464120247795185*^9}, {3.464124203390131*^9, 3.46412420752421*^9}, {
   3.4641246252892346`*^9, 3.464124631669757*^9}, 3.4641247284159813`*^9, {
   3.4641247867386656`*^9, 3.464124823222332*^9}, 3.4650489017636833`*^9, {
   3.4724887833622284`*^9, 3.472488790393658*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tutorial tab", "Subsection",
 CellChangeTimes->{{3.35110711331214*^9, 3.35110711815878*^9}, {
  3.35110716523103*^9, 3.35110716704648*^9}}],

Cell[CellGroupData[{

Cell["Tutorial header", "Subsubsection",
 CellChangeTimes->{{3.35110864553801*^9, 3.35110865507265*^9}, {
  3.35110878688825*^9, 3.35110879308763*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"headerExtT", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", "\[IndentingNewLine]", 
      RowBox[{"GridBox", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<F      \>\"", ",", "\[IndentingNewLine]", 
               RowBox[{
               "ButtonData", "\[RuleDelayed]", "\"\<FunctionsExternal\>\""}], 
               ",", 
               RowBox[{"BaseStyle", "\[Rule]", "\"\<PaletteTab\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Function page features.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<G       \>\"", ",", "\[IndentingNewLine]", 
               RowBox[{
               "ButtonData", "\[RuleDelayed]", "\"\<GuidesExternal\>\""}], 
               ",", 
               RowBox[{"BaseStyle", "\[Rule]", "\"\<PaletteTab\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Guide page features.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<T       \>\"", ",", "\[IndentingNewLine]", 
               RowBox[{
               "ButtonData", "\[RuleDelayed]", "\"\<TutorialsExternal\>\""}], 
               ",", 
               RowBox[{
               "BaseStyle", "\[Rule]", "\"\<PaletteTabSelected\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Tutorial page features.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"TooltipBox", "[", 
            RowBox[{
             RowBox[{"ButtonBox", "[", 
              RowBox[{"\"\<\[UpDownArrow]\>\"", ",", 
               RowBox[{"BaseStyle", "\[Rule]", "\"\<ScrollToggle\>\""}]}], 
              "]"}], ",", "\[IndentingNewLine]", 
             "\"\<Turn vertical scroll bar on or off.\>\"", ",", 
             RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], "}"}], 
         "}"}], ",", " ", 
        StyleBox["tabGridOptsExt",
         CellMargins->{{12, 12}, {12, 12}}]}], "]"}], "]"}], ",", 
     "\"\<PaletteTabCell\>\"", ",", 
     RowBox[{"CellTags", "\[Rule]", "\"\<TutorialsExternal\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.3511071265559*^9, 3.3511071378327*^9}, {
   3.35110721806776*^9, 3.35110721840016*^9}, {3.35110899037728*^9, 
   3.35110899356339*^9}, {3.3511168965714*^9, 3.35111691235844*^9}, {
   3.36647750991326*^9, 3.36647750995332*^9}, 3.397095310250847*^9, 
   3.4007962084443197`*^9, {3.403999628875084*^9, 3.4039996524113483`*^9}, 
   3.40400044897676*^9, 3.4040005892233477`*^9, {3.4040007340948763`*^9, 
   3.404000735217074*^9}, 3.4061637102947617`*^9, {3.461503718759441*^9, 
   3.4615037205564537`*^9}, 3.4622079250225363`*^9, {3.4734283931607842`*^9, 
   3.4734283940358067`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Tutorial cell group 1", "Subsubsection",
 CellChangeTimes->{{3.35110864553801*^9, 3.35110865507265*^9}, {
  3.35110878231684*^9, 3.35110878396774*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"cellExtT1", "=", 
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{"BoxData", "[", 
      RowBox[{"GridBox", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<New Tutorial\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{
                "DocumentationTools`CreateNewPageDialog", "[", 
                 "\"\<Tutorial\>\"", "]"}], "]"}]}], ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BoldButton\>\""}], ",", 
              RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], ",", 
            "\"\<Start tutorial page.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{
             "\"\<Sample Tutorial Page\[VeryThinSpace]\>\"", ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{"NotebookOpen", "[", 
                 RowBox[{"ToFileName", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"$DocuToolsDir", ",", "\"\<Examples\>\""}], "}"}],
                    ",", "\"\<TutorialExample.nb\>\""}], "]"}], "]"}], 
                "]"}]}], ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButtonDark\>\""}], 
              ",", 
              RowBox[{"ButtonMargins", "\[Rule]", "2"}]}], "]"}], ",", 
            "\"\<Sample tutorial page.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"GridBox", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Set Paclet Name & Path\>\"", ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`DocumentationDirSelect[\\\"\
Interactive\\\"\[Rule]True]\>\""}], ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButtonDark\>\""}],
                    ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\[IndentingNewLine]", 
                 "\"\<Use this to select the paclet (application pack) \
directory containing your working documentation source file layout.\\nYour \
selection is stored in the front end init.m as $DocumentationDirectory, from \
which $ApplicationName is derived for configuring the link base in hyperlinks \
to other documents in the same paclet layout.\\nThe paclet's parent directory \
also becomes part of $DocumentationPath to support links to documents in \
other paclet projects on the path.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<M\>\"", ",", 
                    RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
                    RowBox[{"FontColor", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "0.7", "]"}]}]}], "]"}], ",", 
                   RowBox[{
                   "ButtonData", "\[Rule]", 
                    "\"\<DocumentationTools`SetPacletVariables\>\""}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<TinyButtonDark\>\""}],
                    ",", 
                   RowBox[{"Background", "\[Rule]", 
                    RowBox[{"GrayLevel", "[", "0.4", "]"}]}], ",", 
                   RowBox[{"Method", "\[Rule]", "\"\<Queued\>\""}]}], "]"}], 
                 ",", "\"\<Use this to configure $ApplicationName and \
$LinkBase manually, primarily when the link base is not the same as your \
application name.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
              "}"}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"ColumnWidths", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"0.9", ",", "0.09"}], "}"}]}], ",", " ", 
            RowBox[{"ColumnSpacings", "\[Rule]", 
             RowBox[{"{", "0.1", "}"}]}], ",", 
            RowBox[{"ColumnAlignments", "\[Rule]", "Center"}]}], "]"}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"GridBox", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"TooltipBox", "[", 
               RowBox[{
                RowBox[{"ButtonBox", "[", 
                 RowBox[{"\"\<Definition Boxes\>\"", ",", 
                  RowBox[{
                  "BaseStyle", "\[Rule]", "\"\<ButtonSubGroupHead\>\""}], ",", 
                  RowBox[{"Active", "\[Rule]", "False"}]}], "]"}], ",", 
                "\[IndentingNewLine]", 
                "\"\<Use the buttons in the row below to insert and work with \
definition boxes.\>\"", ",", 
                RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], 
             "}"}], ",", 
            RowBox[{"ColumnWidths", "\[Rule]", ".999"}]}], "]"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"GridBox", "[", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<2 Col\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"NotebookWrite", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"BoxData", "[", 
                    RowBox[{"GridBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"\<XXXX\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<TableText\>\""}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<XXXX\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<TableText\>\""}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<XXXX\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<TableText\>\""}], 
                    "]"}]}], "}"}]}], "}"}], "]"}], "]"}], ",", 
                    "\"\<DefinitionBox\>\""}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX.\>\"", ",", "\"\<Caption\>\""}], 
                    "]"}]}], "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Insert two column definition box. Use button at right \
to add row.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<3 Col\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"NotebookWrite", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"BoxData", "[", 
                    RowBox[{"GridBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<XXXX\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<TableText\>\""}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<XXXX\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<TableText\>\""}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<XXXX\>\"", ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<TableText\>\""}], 
                    "]"}]}], "}"}]}], "}"}], "]"}], "]"}], ",", 
                    "\"\<DefinitionBox3Col\>\""}], "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX.\>\"", ",", "\"\<Caption\>\""}], 
                    "]"}]}], "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Insert three column definition box. Use button at right \
to add row.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<A\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TableAddRow", "]"}]}], 
                   ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Adds new row of the same structure as the rest of the \
table or definition box.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<M\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TableMerge", "]"}]}], 
                   ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Combines two selected definition box cells into one \
cell.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<D\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{
                    "Hold", "[", "DocumentationTools`TablePartDelete", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Delete selection within definition box.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<T\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{"DocumentationTools`TableSpanToggle", "[", 
                    RowBox[{"\"\<StrictSelection\>\"", "\[Rule]", "True"}], 
                    "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<NotchButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Change selected row to spanning format, or restore \
spanning format to single row.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
              "}"}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"ColumnWidths", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"0.34", ",", "0.34", ",", "0.07"}], "}"}]}], ",", " ", 
            RowBox[{"ColumnSpacings", "\[Rule]", 
             RowBox[{"{", "0.1", "}"}]}], ",", " ", 
            RowBox[{"RowAlignments", "\[Rule]", "Center"}]}], "]"}], "}"}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"GridBox", "[", 
           RowBox[{
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Math Caption\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", 
                    "\"\<MathCaption\>\"", "]"}], "]"}]}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Begin math caption cell or change selection to math \
caption.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<I\[ThinSpace]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "8.5"}]}], "]"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"CompoundExpression", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"SelectionMove", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", "After", ",", 
                    "Cell"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"NotebookWrite", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"{", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"Cell", "[", 
                    RowBox[{"\"\<XXXX\>\"", ",", "\"\<MathCaption\>\""}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"BoxData", "[", 
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<2\>\"", ",", "\"\<+\>\"", ",", "\"\<2\>\""}],
                     "}"}], "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}]}], 
                    "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"SelectionMove", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", "Previous", ",",
                     "Cell"}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"SelectionMove", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", "All", ",", 
                    "CellContents"}], "]"}]}], "]"}]}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<NotchButton\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}]}], "]"}],
                  ",", "\[IndentingNewLine]", 
                 "\"\<\\\"Insert Input cell with MathCaption cell.\\\"\>\"", 
                 ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}]}], 
              "}"}], "}"}], ",", 
            RowBox[{"ColumnWidths", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"0.9", ",", "0.08"}], "}"}]}], ",", " ", 
            RowBox[{"ColumnSpacings", "\[Rule]", "0.1"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<Section\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{
                "DocumentationTools`StyleApply", "[", "\"\<Section\>\"", 
                 "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            "\"\<Insert Section or apply Section style to selection.\>\"", 
            ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<Subsection\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{
                "DocumentationTools`StyleApply", "[", "\"\<Subsection\>\"", 
                 "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            "\"\<Insert Subsection or apply Subsection style to \
selection.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<Text\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{"Hold", "[", 
                RowBox[{
                "DocumentationTools`StyleApply", "[", "\"\<Text\>\"", "]"}], 
                "]"}]}], ",", "\[IndentingNewLine]", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<BigButton\>\""}]}], "]"}], 
            ",", "\[IndentingNewLine]", 
            "\"\<Begin text cell or change selection to text.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"TooltipBox", "[", 
           RowBox[{
            RowBox[{"ButtonBox", "[", 
             RowBox[{"\"\<Template Input\>\"", ",", "\[IndentingNewLine]", 
              RowBox[{"ButtonData", "\[RuleDelayed]", 
               RowBox[{
               "Hold", "[", "DocumentationTools`FunctionTemplate", "]"}]}], 
              ",", 
              RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}], 
             "]"}], ",", "\[IndentingNewLine]", 
            "\"\<Use this for function templates. Lower case words will be \
italic.\\nxxx$yyy makes yyy a subscript. $$ gives ...\\nFunction names will \
become links when appropriate.\\nRefer to bottom of format menu for shortcut.\
\\nUse shortcut after typing for autoselection.\>\"", ",", 
            RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}]}], 
        "\[IndentingNewLine]", "}"}], "]"}], "]"}], ",", 
     "\"\<PaletteGridCell\>\"", ",", 
     RowBox[{"GridBoxOptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
        RowBox[{"RowSpacings", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          ".3", ",", "0", ",", "2", ",", ".1", ",", "2.5", ",", "0.5", ",", 
           "0.5", ",", "0.5", ",", "1", ",", "0.5"}], "}"}]}], ",", " ", 
        RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.35656081935537*^9, 3.3565608359582*^9}, {
   3.35656105347904*^9, 3.35656106448912*^9}, {3.35656113044581*^9, 
   3.3565611324377*^9}, 3.35920947297123*^9, 3.36432344188136*^9, {
   3.36622569058931*^9, 3.36622570923334*^9}, {3.36647751000339*^9, 
   3.36647751097483*^9}, {3.36648684717103*^9, 3.36648685628486*^9}, {
   3.3696761176002903`*^9, 3.369676147027075*^9}, 3.400796040864036*^9, {
   3.400796071649261*^9, 3.400796098774716*^9}, {3.400796478678279*^9, 
   3.40079648493635*^9}, {3.400798149418457*^9, 3.400798236527711*^9}, {
   3.400798275504531*^9, 3.400798277442605*^9}, {3.400798350266755*^9, 
   3.40079841272191*^9}, {3.400798458195822*^9, 3.400798516590967*^9}, {
   3.40079872448499*^9, 3.400798734293932*^9}, {3.4008848701905456`*^9, 
   3.4008848919876995`*^9}, {3.401024852827466*^9, 3.40102497581817*^9}, 
   3.401026251991259*^9, {3.401064150493946*^9, 3.401064154217824*^9}, {
   3.403999679725163*^9, 3.403999680111779*^9}, {3.404012421330559*^9, 
   3.404012421794943*^9}, {3.406163655004155*^9, 3.4061636623478813`*^9}, 
   3.406164281961327*^9, 3.4062429430235777`*^9, {3.406311867473411*^9, 
   3.4063118684680157`*^9}, {3.406315057360928*^9, 3.406315064194641*^9}, 
   3.406408222373427*^9, {3.407032326595789*^9, 3.407032328143323*^9}, {
   3.407278977609133*^9, 3.407278992860256*^9}, {3.407279173300313*^9, 
   3.4072791753629227`*^9}, {3.407279264592112*^9, 3.407279271201631*^9}, {
   3.40727932519598*^9, 3.407279378293387*^9}, {3.4132451623452587`*^9, 
   3.4132451703092117`*^9}, 3.4132453625488586`*^9, 3.413251774748509*^9, {
   3.4433639722817593`*^9, 3.4433639795163193`*^9}, {3.443365032308895*^9, 
   3.4433650398247128`*^9}, 3.446913303925847*^9, {3.4482883209058456`*^9, 
   3.448288339890828*^9}, {3.4615037213690166`*^9, 3.4615037302290716`*^9}, {
   3.4615043876719913`*^9, 3.461504430109763*^9}, {3.4615044641099806`*^9, 
   3.461504477000688*^9}, {3.461587007163936*^9, 3.461587007913946*^9}, {
   3.4616164259817686`*^9, 3.4616164640135055`*^9}, {3.4622063311583853`*^9, 
   3.4622063438460474`*^9}, {3.4641202045199533`*^9, 3.464120234410128*^9}, {
   3.4641205102592487`*^9, 3.464120565874318*^9}, 3.464120605539132*^9, 
   3.464120638611768*^9, {3.464122073542962*^9, 3.4641221349145427`*^9}, {
   3.464122269872738*^9, 3.464122315472415*^9}, {3.464122346220606*^9, 
   3.4641223908686647`*^9}, {3.464122932620283*^9, 3.464122974319885*^9}, {
   3.4641241568388357`*^9, 3.464124167010231*^9}, {3.4641246423559628`*^9, 
   3.464124649391698*^9}, 3.4641247371209483`*^9, 3.464124831708895*^9, 
   3.465049053421875*^9, {3.46634817053024*^9, 3.466348198812033*^9}, {
   3.4663483226894116`*^9, 3.4663483492211714`*^9}, {3.4663484486762056`*^9, 
   3.466348500317822*^9}, 3.4663486291796713`*^9, {3.4663487266815434`*^9, 
   3.46634873433794*^9}, {3.4664298619816313`*^9, 3.466429875013131*^9}, {
   3.4664299326079874`*^9, 3.4664299482801633`*^9}, {3.4664301707531843`*^9, 
   3.4664301717688293`*^9}, {3.466430548494812*^9, 3.4664305771203613`*^9}, {
   3.4664311741474495`*^9, 3.46643118225698*^9}, {3.466457111879819*^9, 
   3.466457130880184*^9}, {3.466457285930036*^9, 3.466457287789447*^9}, 
   3.4724888129411106`*^9, 3.47593367177577*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette assembly", "Subsection",
 CellChangeTimes->{{3.35110759540276*^9, 3.35110759866526*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"palNB", "=", 
   RowBox[{"NotebookPut", "@", 
    RowBox[{"Notebook", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
       "headerExtF", ",", "\[IndentingNewLine]", "cellExtF1", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"SpacerCell", "[", "8", "]"}], ",", "\[IndentingNewLine]", 
        "notesTablesExt", ",", "\[IndentingNewLine]", "examplesExt", ",", 
        "\[IndentingNewLine]", "linksExt", ",", "\[IndentingNewLine]", 
        "formattingExt", ",", "\[IndentingNewLine]", "utilsExtF", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"SpacerCell", "[", "12", "]"}], ",", "\[IndentingNewLine]", 
        "cellExtF3", ",", "\[IndentingNewLine]", "headerExtG", ",", 
        "\[IndentingNewLine]", "cellExtG1", ",", "\[IndentingNewLine]", 
        RowBox[{"SpacerCell", "[", "8", "]"}], ",", "\[IndentingNewLine]", 
        "linksExt", ",", "\[IndentingNewLine]", "formattingExt", ",", 
        "\[IndentingNewLine]", "utilsExtG", ",", "\[IndentingNewLine]", 
        RowBox[{"SpacerCell", "[", "12", "]"}], ",", "\[IndentingNewLine]", 
        "headerExtT", ",", "\[IndentingNewLine]", "cellExtT1", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"SpacerCell", "[", "8", "]"}], ",", "\[IndentingNewLine]", 
        "linksExt", ",", "\[IndentingNewLine]", "formattingExt", ",", 
        "\[IndentingNewLine]", "overviewExtT", ",", "\[IndentingNewLine]", 
        "utilsExtT", ",", "\[IndentingNewLine]", 
        RowBox[{"SpacerCell", "[", "12", "]"}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", "palOpts", ",", " ", 
      RowBox[{"StyleDefinitions", "\[Rule]", "styDefs"}]}], 
     "\[IndentingNewLine]", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FrontEndExecute", "[", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FrontEnd`SetOptions", "[", 
      RowBox[{"palNB", ",", 
       RowBox[{"Editable", "\[Rule]", "True"}], ",", 
       RowBox[{"WindowSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"152", ",", "Automatic"}], "}"}]}], ",", 
       RowBox[{"WindowFloating", "\[Rule]", "True"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrontEnd`SetOptions", "[", 
      RowBox[{"palNB", ",", 
       RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]}], "}"}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.35110760954119*^9, 3.3511076581381*^9}, {
   3.35111666144286*^9, 3.35111667841916*^9}, {3.35111673024564*^9, 
   3.35111675653869*^9}, {3.35111679087112*^9, 3.35111679564371*^9}, {
   3.35111684033025*^9, 3.35111710263775*^9}, {3.35111714066714*^9, 
   3.35111725119315*^9}, {3.35111798168735*^9, 3.35111799235961*^9}, {
   3.35111804567179*^9, 3.35111807621224*^9}, {3.35111810889924*^9, 
   3.351118168568*^9}, {3.3511182061429*^9, 3.35111820703568*^9}, {
   3.35111823707103*^9, 3.35111823746817*^9}, {3.35171708298127*^9, 
   3.3517171108716*^9}, {3.35337006269075*^9, 3.35337009422564*^9}, {
   3.35655603259026*^9, 3.35655603482865*^9}, {3.35655775088399*^9, 
   3.35655775701972*^9}, {3.3565578002004*^9, 3.35655780154582*^9}, {
   3.35656004039357*^9, 3.3565600683491*^9}, 3.35656086601556*^9, 
   3.35656102343034*^9, {3.36000952999897*^9, 3.36000953219003*^9}, {
   3.3600096246324*^9, 3.36000962683457*^9}, {3.36831850341782*^9, 
   3.36831850839446*^9}, {3.36831926060717*^9, 3.36831926356288*^9}, {
   3.3683658828723*^9, 3.36836590031624*^9}, 3.369676574119356*^9, 
   3.37029768896319*^9, {3.381109703243841*^9, 3.381109711030115*^9}, {
   3.39709565908849*^9, 3.3970956615087843`*^9}, {3.4040002128415127`*^9, 
   3.4040002923282223`*^9}, {3.404000625913761*^9, 3.404000638099855*^9}, {
   3.404002153943191*^9, 3.4040021590685043`*^9}, {3.4040124416587143`*^9, 
   3.404012442153391*^9}, 3.404060636185041*^9, {3.406315176921248*^9, 
   3.406315189153121*^9}, {3.406315220069528*^9, 3.406315249715145*^9}, {
   3.422743111128083*^9, 3.422743112860817*^9}, {3.423517712754795*^9, 
   3.423517727956768*^9}, {3.423703350707945*^9, 3.423703369003696*^9}, {
   3.423703512780208*^9, 3.423703530362352*^9}, 3.423703586548213*^9, {
   3.423704208044273*^9, 3.4237042112416162`*^9}, {3.430518212792706*^9, 
   3.430518216301753*^9}, {3.438119383413743*^9, 3.43811939205525*^9}, {
   3.443799576316305*^9, 3.443799586316625*^9}, {3.4437997054298115`*^9, 
   3.443799712305032*^9}, {3.4437998075893307`*^9, 3.443799808011219*^9}, {
   3.4438037429027567`*^9, 3.443803785826005*^9}, {3.4494140389987116`*^9, 
   3.4494140488737745`*^9}, {3.4609995231722155`*^9, 
   3.4609995454378405`*^9}, {3.461510934690176*^9, 3.461510961002676*^9}, {
   3.461524515558565*^9, 3.4615245490902443`*^9}, {3.4615256104456596`*^9, 
   3.46152561321132*^9}, {3.4615856742126074`*^9, 3.4615856816813574`*^9}, {
   3.461617045395947*^9, 3.4616170477084765`*^9}, 3.4622059458565784`*^9, 
   3.4622067040069075`*^9, {3.464120009117432*^9, 3.464120026262162*^9}, {
   3.4664568914849625`*^9, 3.466456891938096*^9}, {3.466457229819584*^9, 
   3.4664572573357368`*^9}, 3.46645747651182*^9, 3.4664582434640455`*^9, {
   3.466458379263528*^9, 3.4664583819042034`*^9}, {3.4664603192382746`*^9, 
   3.466460320753928*^9}, 3.469543106142973*^9}],

Cell["\<\
After closing various cell groups under each tab, use the following to save \
the palette first navigating to the desired directory:\
\>", "Text",
 CellChangeTimes->{{3.469545283606655*^9, 3.4695453987963667`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookSave", "[", 
   RowBox[{"palNB", ",", 
    RowBox[{"SystemDialogInput", "[", 
     RowBox[{"\"\<FileSave\>\"", ",", 
      RowBox[{"ToFileName", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "$PreferencesDirectory", ",", "\"\<Applications\>\"", ",", 
          "\"\<DocumentationTools\>\"", ",", "\"\<FrontEnd\>\"", ",", 
          "\"\<Palettes\>\""}], "}"}], ",", "\"\<DocumentationTools.nb\>\""}],
        "]"}]}], "]"}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.35110760954119*^9, 3.3511076581381*^9}, {
   3.35111666144286*^9, 3.35111667841916*^9}, {3.35111673024564*^9, 
   3.35111675653869*^9}, {3.35111679087112*^9, 3.35111679564371*^9}, {
   3.35111684033025*^9, 3.35111710263775*^9}, {3.35111714066714*^9, 
   3.35111725119315*^9}, {3.35111798168735*^9, 3.35111799235961*^9}, {
   3.35111804567179*^9, 3.35111807621224*^9}, {3.35111810889924*^9, 
   3.351118168568*^9}, {3.3511182061429*^9, 3.35111820703568*^9}, {
   3.35111823707103*^9, 3.35111823746817*^9}, {3.35171708298127*^9, 
   3.3517171108716*^9}, {3.35337006269075*^9, 3.35337009422564*^9}, {
   3.35655603259026*^9, 3.35655603482865*^9}, {3.35655775088399*^9, 
   3.35655775701972*^9}, {3.3565578002004*^9, 3.35655780154582*^9}, {
   3.35656004039357*^9, 3.3565600683491*^9}, 3.35656086601556*^9, 
   3.35656102343034*^9, {3.36000952999897*^9, 3.36000953219003*^9}, {
   3.3600096246324*^9, 3.36000962683457*^9}, {3.36831850341782*^9, 
   3.36831850839446*^9}, {3.36831926060717*^9, 3.36831926356288*^9}, {
   3.3683658828723*^9, 3.36836590031624*^9}, 3.369676574119356*^9, 
   3.37029768896319*^9, {3.381109703243841*^9, 3.381109711030115*^9}, {
   3.39709565908849*^9, 3.3970956615087843`*^9}, {3.4040002128415127`*^9, 
   3.4040002923282223`*^9}, {3.404000625913761*^9, 3.404000638099855*^9}, {
   3.404002153943191*^9, 3.4040021590685043`*^9}, {3.4040124416587143`*^9, 
   3.404012442153391*^9}, 3.404060636185041*^9, {3.406315176921248*^9, 
   3.406315189153121*^9}, {3.406315220069528*^9, 3.406315249715145*^9}, {
   3.422743111128083*^9, 3.422743112860817*^9}, {3.423517712754795*^9, 
   3.423517727956768*^9}, {3.423703350707945*^9, 3.423703369003696*^9}, {
   3.423703512780208*^9, 3.423703530362352*^9}, 3.423703586548213*^9, {
   3.423704208044273*^9, 3.4237042112416162`*^9}, {3.430518212792706*^9, 
   3.430518216301753*^9}, {3.438119383413743*^9, 3.43811939205525*^9}, {
   3.443799576316305*^9, 3.443799586316625*^9}, {3.4437997054298115`*^9, 
   3.443799712305032*^9}, {3.4437998075893307`*^9, 3.443799808011219*^9}, {
   3.4438037429027567`*^9, 3.443803785826005*^9}, {3.4494140389987116`*^9, 
   3.4494140488737745`*^9}, {3.4609995231722155`*^9, 
   3.4609995454378405`*^9}, {3.461510934690176*^9, 3.461510961002676*^9}, {
   3.461524515558565*^9, 3.4615245490902443`*^9}, {3.4615256104456596`*^9, 
   3.46152561321132*^9}, {3.4615856742126074`*^9, 3.4615856816813574`*^9}, {
   3.461617045395947*^9, 3.4616170477084765`*^9}, 3.4622059458565784`*^9, 
   3.4622067040069075`*^9, {3.464120009117432*^9, 3.464120026262162*^9}, {
   3.4664568914849625`*^9, 3.466456891938096*^9}, {3.466457229819584*^9, 
   3.4664572573357368`*^9}, 3.46645747651182*^9, 3.4664582434640455`*^9, {
   3.466458379263528*^9, 3.4664583819042034`*^9}, {3.4664603192382746`*^9, 
   3.466460320753928*^9}, 3.469543106142973*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Special Formatting Source", "Section",
 CellChangeTimes->{{3.4616196121163006`*^9, 3.4616196190382643`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"goodiesPalOpts", "=", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ClosingAutoSave", "\[Rule]", "True"}], ",", 
      RowBox[{"Editable", "\[Rule]", "False"}], ",", 
      RowBox[{"WindowToolbars", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"WindowSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"152", ",", "FitAll"}], "}"}]}], ",", 
      RowBox[{"WindowMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "160"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "0"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"WindowFrame", "\[Rule]", "\"\<Palette\>\""}], ",", 
      RowBox[{"WindowElements", "\[Rule]", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"WindowFrameElements", "\[Rule]", "\"\<CloseBox\>\""}], ",", 
      RowBox[{"WindowClickSelect", "\[Rule]", "False"}], ",", 
      RowBox[{"WindowTitle", "\[Rule]", "\"\<Special Formatting\>\""}], ",", 
      RowBox[{"WindowClickSelect", "\[Rule]", "False"}], ",", " ", 
      RowBox[{"Selectable", "\[Rule]", "False"}], ",", 
      RowBox[{"ScrollingOptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\"\<PagewiseScrolling\>\"", "\[Rule]", "True"}], ",", 
         RowBox[{"\"\<PagewiseDisplay\>\"", "\[Rule]", "True"}], ",", 
         RowBox[{"\"\<VerticalScrollRange\>\"", "\[Rule]", "Fit"}]}], "}"}]}],
       ",", 
      RowBox[{"ShowCellBracket", "\[Rule]", "False"}], ",", 
      RowBox[{"CellMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Active", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Background", "\[Rule]", 
       RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
      RowBox[{"AutoMultiplicationSymbol", "\[Rule]", "False"}], ",", 
      RowBox[{"Saveable", "\[Rule]", "False"}], ",", 
      RowBox[{"FontProperties", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<ScreenResolution\>\"", "\[Rule]", "72"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ButtonBoxOptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"ButtonFunction", "\[RuleDelayed]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"FrontEnd`MessagesToConsole", "[", 
            RowBox[{"CompoundExpression", "[", 
             RowBox[{
              RowBox[{"Needs", "[", "\"\<DocumentationTools`\>\"", "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{"e", ",", 
                  RowBox[{"ReleaseHold", "[", 
                   RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "e", "]"}], ",", 
                    RowBox[{"ToExpression", "[", "e", "]"}], ",", "e"}], 
                    "]"}], "[", "]"}], "]"}], ",", "HoldFirst"}], "]"}], "[", 
                "#2", "]"}], "[", "]"}]}], "]"}], "]"}], "&"}], ")"}]}], 
        "}"}]}]}], "}"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35110779910025*^9, 3.35110780390354*^9}, {
   3.3511200494388404`*^9, 3.3511200896839795`*^9}, {3.35112019944843*^9, 
   3.3511202234208803`*^9}, {3.3707300235849857`*^9, 
   3.3707300246622953`*^9}, {3.370809684008765*^9, 3.370809686051805*^9}, 
   3.379536443002289*^9, 3.3795366100648994`*^9, {3.443371896625242*^9, 
   3.4433719447514744`*^9}, {3.461619648569892*^9, 3.461619656523119*^9}, 
   3.4622063478148484`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"goodiesStyDefs", "=", 
   RowBox[{"Notebook", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<PaletteTabCell\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"CellFrame", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"CellFrameMargins", "\[Rule]", 
         RowBox[{"-", "1"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"FontSize", "\[Rule]", "9"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Background", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"PageBreakAbove", "\[Rule]", "True"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<PaletteTab\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", " ", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonFunction", "\[RuleDelayed]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"FrontEndExecute", "[", 
               RowBox[{"{", 
                RowBox[{"NotebookLocate", "[", "#2", "]"}], "}"}], "]"}], 
              "&"}], ")"}]}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "2"}], ",", 
           RowBox[{"Active", "\[Rule]", "True"}], ",", " ", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", " ", 
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}]}], "}"}]}]}],
        "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<PaletteTabSelected\>\"", "]"}], ",", 
        " ", "\[IndentingNewLine]", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.5", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonFunction", "\[RuleDelayed]", "None"}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "2"}], ",", 
           RowBox[{"Active", "\[Rule]", "False"}], ",", " ", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", " ", 
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}]}], "}"}]}]}],
        "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<PaletteGridCell\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PageWidth", "\[Rule]", "153"}], ",", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Plain\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0.7", "]"}]}], ",", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonFrame", "\[Rule]", "\"\<Palette\>\""}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"Evaluator", "\[Rule]", "Automatic"}]}], "}"}]}]}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<ButtonGroupHead\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "9"}], ",", " ", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonFunction", "\[RuleDelayed]", "None"}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "1"}], ",", 
           RowBox[{"Active", "\[Rule]", "False"}], ",", " ", 
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0.5", "]"}]}]}], "}"}]}]}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<BoldButton\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "1", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "10"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Background", "\[Rule]", 
            RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
           RowBox[{"ButtonMargins", "\[Rule]", "6"}]}], "}"}]}]}], "]"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<BigButton\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"ButtonMargins", "\[Rule]", "4"}], "}"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<MediumButton\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "11"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ButtonMargins", "\[Rule]", "3"}], ",", 
           RowBox[{"Method", "\[Rule]", "\"\<Preemptive\>\""}], ",", 
           RowBox[{"ButtonEvaluator", "\[Rule]", "Automatic"}]}], "}"}]}]}], 
       "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<MediumButtonHighlight\>\"", "]"}], ",",
         " ", "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"0.6", ",", "0.1", ",", "0.1"}], "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "10"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<SmallButton\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontColor", "\[Rule]", 
         RowBox[{"GrayLevel", "[", "0", "]"}]}], ",", 
        RowBox[{"FontSize", "\[Rule]", "10"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ButtonBoxOptions", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"ButtonMargins", "\[Rule]", "1"}], "}"}]}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"StyleData", "[", "\"\<Spacer\>\"", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"FontSize", "\[Rule]", "2"}], ",", 
        RowBox[{"CellElementSpacings", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<CellMinHeight\>\"", "\[Rule]", "2"}], "}"}]}], ",", 
        " ", "\[IndentingNewLine]", 
        RowBox[{"CellMargins", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "0"}], "}"}]}], "}"}]}]}], "]"}]}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.35110779910025*^9, 3.35110780390354*^9}, 
   3.3511200494388404`*^9, {3.3511200984347305`*^9, 3.3511201138071504`*^9}, {
   3.3643240402496696`*^9, 3.36432404205232*^9}, {3.4433720844894266`*^9, 
   3.443372086036341*^9}, 3.443372760428605*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"goodiesGridOpts", "=", 
   RowBox[{"Sequence", "@@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FontFamily", "\[Rule]", "\"\<Verdana\>\""}], ",", 
      RowBox[{"GridBoxOptions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColumnWidths", "\[Rule]", "0.999"}], ",", 
         RowBox[{"ColumnsEqual", "\[Rule]", "True"}], ",", 
         RowBox[{"RowSpacings", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
           "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
            ",", "0", ",", "0", ",", " ", "0", ",", "1", ",", "0", ",", "1", 
            ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
            "0"}], "}"}]}], ",", 
         RowBox[{"RowLines", "\[Rule]", "True"}]}], "}"}]}]}], "}"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.35343148845761*^9, 3.3534315061137*^9}, 
   3.3534315642696495`*^9, {3.36432405308852*^9, 3.3643240575751004`*^9}, {
   3.370730081091634*^9, 3.3707300911187887`*^9}, {3.370732651375845*^9, 
   3.370732651650012*^9}, 3.3707330166958017`*^9, {3.370733121388825*^9, 
   3.370733121664691*^9}, {3.370733163187195*^9, 3.370733164116776*^9}, {
   3.370793675841757*^9, 3.370793695928722*^9}, {3.375235722295746*^9, 
   3.3752357225096693`*^9}, {3.37529170348557*^9, 3.3752917036057463`*^9}, {
   3.3752923768739977`*^9, 3.375292377194468*^9}, {3.375292458644023*^9, 
   3.3752924818681126`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SpacerCell", "[", "n_Integer", "]"}], ":=", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{"\"\< \>\"", "<>", 
     RowBox[{"StringJoin", "@@", 
      RowBox[{"Table", "[", 
       RowBox[{"\"\<\\n\>\"", ",", 
        RowBox[{"{", "n", "}"}]}], "]"}]}]}], ",", "\"\<Spacer\>\""}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.35110910484454*^9, 3.35110910858804*^9}, {
  3.3511173285188*^9, 3.35111734751682*^9}, {3.35111750557147*^9, 
  3.35111752060066*^9}, {3.35111756873463*^9, 3.35111756914041*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"goodiesNB", "=", 
   RowBox[{"NotebookPut", "@", 
    RowBox[{"Notebook", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Cell", "[", 
         RowBox[{
          RowBox[{"BoxData", "[", 
           RowBox[{"GridBox", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Special Characters\>\"", ",", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{
                    "NotebookOpen", "[", "\"\<SpecialCharacters.nb\>\"", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<BoldButton\>\""}]}], 
                  "]"}], ",", "\"\<Open special characters palette.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Shift\>\"", ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<+ \[SelectionPlaceholder]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}]}], "}"}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"CompoundExpression", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SameQ", "[", 
                    RowBox[{
                    RowBox[{"NotebookRead", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"FrontEnd`FrontEndToken", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    "\"\<SelectPrevious\>\""}], "]"}], "]"}]}], "]"}], ",", 
                    RowBox[{"NotebookApply", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"TextData", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Shift\>\"", ",", "\"\<KeyEvent\>\""}], "]"}],
                     ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<+\>\"", ",", "\"\<KeyEventDelimiter\>\""}], 
                    "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\[SelectionPlaceholder]\>\"", ",", 
                    "\"\<KeyEvent\>\""}], "]"}]}], "}"}], "]"}]}], "]"}]}], 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Shift keyboard form.\\nAutoselects previous character \
if there is no selection.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Ctrl\>\"", ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<+ \[SelectionPlaceholder]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}]}], "}"}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"CompoundExpression", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SameQ", "[", 
                    RowBox[{
                    RowBox[{"NotebookRead", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"FrontEnd`FrontEndToken", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    "\"\<SelectPrevious\>\""}], "]"}], "]"}]}], "]"}], ",", 
                    RowBox[{"NotebookApply", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"TextData", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Ctrl\>\"", ",", "\"\<KeyEvent\>\""}], "]"}], 
                    ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<+\>\"", ",", "\"\<KeyEventDelimiter\>\""}], 
                    "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\[SelectionPlaceholder]\>\"", ",", 
                    "\"\<KeyEvent\>\""}], "]"}]}], "}"}], "]"}]}], "]"}]}], 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Control keyboard form.\\nAutoselects previous character \
if there is no selection.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Option\>\"", ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<+ \[SelectionPlaceholder]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}]}], "}"}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"CompoundExpression", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SameQ", "[", 
                    RowBox[{
                    RowBox[{"NotebookRead", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"FrontEnd`FrontEndToken", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    "\"\<SelectPrevious\>\""}], "]"}], "]"}]}], "]"}], ",", 
                    RowBox[{"NotebookApply", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"TextData", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Option\>\"", ",", "\"\<KeyEvent\>\""}], 
                    "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<+\>\"", ",", "\"\<KeyEventDelimiter\>\""}], 
                    "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\[SelectionPlaceholder]\>\"", ",", 
                    "\"\<KeyEvent\>\""}], "]"}]}], "}"}], "]"}]}], "]"}]}], 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Option keyboard form.\\nAutoselects previous character \
if there is no selection.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Alt\>\"", ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<+ \[SelectionPlaceholder]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}]}], "}"}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"CompoundExpression", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SameQ", "[", 
                    RowBox[{
                    RowBox[{"NotebookRead", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"FrontEnd`FrontEndToken", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    "\"\<SelectPrevious\>\""}], "]"}], "]"}]}], "]"}], ",", 
                    RowBox[{"NotebookApply", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"TextData", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Alt\>\"", ",", "\"\<KeyEvent\>\""}], "]"}], 
                    ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<+\>\"", ",", "\"\<KeyEventDelimiter\>\""}], 
                    "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\[SelectionPlaceholder]\>\"", ",", 
                    "\"\<KeyEvent\>\""}], "]"}]}], "}"}], "]"}]}], "]"}]}], 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Alt keyboard form.\\nAutoselects previous character if \
there is no selection.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"DynamicBox", "[", 
                    RowBox[{
                    RowBox[{"ToBoxes", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"$OperatingSystem", "===", "\"\<MacOSX\>\""}], 
                    ",", "\"\<Return\>\"", ",", "\"\<Enter\>\""}], "]"}], ",",
                     "StandardForm"}], "]"}], ",", 
                    RowBox[{"ImageSizeCache", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"43.125", ",", "9."}], "}"}]}]}], "]"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"NotebookWrite", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"BoxData", "[", 
                    RowBox[{"FormBox", "[", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    RowBox[{"DynamicBox", "[", 
                    RowBox[{
                    RowBox[{"ToBoxes", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"$OperatingSystem", "===", "\"\<MacOSX\>\""}], 
                    ",", "\"\<Return\>\"", ",", "\"\<Enter\>\""}], "]"}], ",",
                     "StandardForm"}], "]"}], ",", 
                    RowBox[{"ImageSizeCache", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"43.125", ",", "9."}], "}"}]}]}], "]"}], ",", 
                    "\"\<KeyEvent\>\""}], "]"}], ",", "TraditionalForm"}], 
                    "]"}], "]"}], ",", "NotebookDefault", ",", 
                    RowBox[{"ShowStringCharacters", "\[Rule]", "False"}]}], 
                    "]"}]}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<MediumButton\>\"", ",", 
                    RowBox[{"ShowStringCharacters", "\[Rule]", "False"}]}], 
                    "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Enter/Return keyboard form.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Shift\>\"", ",", "\"\<KeyEvent\>\""}], "]"}],
                     ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<+\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
                    RowBox[{"DynamicBox", "[", 
                    RowBox[{
                    RowBox[{"ToBoxes", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"$OperatingSystem", "===", "\"\<MacOSX\>\""}], 
                    ",", "\"\<Return\>\"", ",", "\"\<Enter\>\""}], "]"}], ",",
                     "StandardForm"}], "]"}], ",", 
                    RowBox[{"ImageSizeCache", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"38.", ",", "9."}], "}"}]}]}], "]"}]}], "}"}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"NotebookWrite", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"Cell", "[", 
                    RowBox[{
                    RowBox[{"BoxData", "[", 
                    RowBox[{"FormBox", "[", 
                    RowBox[{
                    RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Shift\>\"", ",", "\"\<KeyEvent\>\""}], "]"}],
                     ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<+\>\"", ",", "\"\<KeyEventDelimiter\>\""}], 
                    "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    RowBox[{"DynamicBox", "[", 
                    RowBox[{
                    RowBox[{"ToBoxes", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"$OperatingSystem", "===", "\"\<MacOSX\>\""}], 
                    ",", "\"\<Return\>\"", ",", "\"\<Enter\>\""}], "]"}], ",",
                     "StandardForm"}], "]"}], ",", 
                    RowBox[{"ImageSizeCache", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"38.", ",", "9."}], "}"}]}]}], "]"}], ",", 
                    "\"\<KeyEvent\>\""}], "]"}]}], "}"}], "]"}], ",", 
                    "TraditionalForm"}], "]"}], "]"}], ",", "NotebookDefault",
                     ",", 
                    RowBox[{"ShowStringCharacters", "\[Rule]", "False"}]}], 
                    "]"}]}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"\"\<MediumButton\>\"", ",", 
                    RowBox[{"ShowStringCharacters", "\[Rule]", "False"}]}], 
                    "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Shift+Enter/Return keyboard form.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<\[EscapeKey]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"NotebookWrite", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"TextData", "[", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Esc\>\"", ",", "\"\<KeyEvent\>\""}], "]"}], 
                    "]"}]}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Esc keyboard form.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<\[EscapeKey]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
                    "\"\<\[VeryThinSpace]\[SelectionPlaceholder]\
\[VeryThinSpace]\>\"", ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<\[EscapeKey]\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}], "}"}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"CompoundExpression", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SameQ", "[", 
                    RowBox[{
                    RowBox[{"NotebookRead", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"FrontEnd`FrontEndToken", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    "\"\<SelectPreviousWord\>\""}], "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"NotebookApply", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"TextData", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Esc\>\"", ",", "\"\<KeyEvent\>\""}], "]"}], 
                    ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\[ThinSpace]\[SelectionPlaceholder]\[ThinSpace]\>\"",
                     ",", "\"\<InlineCode\>\""}], "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<Esc\>\"", ",", "\"\<KeyEvent\>\""}], "]"}]}],
                     "}"}], "]"}]}], "]"}]}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Esc sequence template.\\nAutoselects previous character \
if there is no selection.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<\[AliasIndicator]\[MediumSpace]\[SelectionPlaceholder]\
\[MediumSpace]\[AliasIndicator]\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", " ", ":>", " ", 
                    RowBox[{"CompoundExpression", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SameQ", "[", 
                    RowBox[{
                    RowBox[{"NotebookRead", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"FrontEnd`FrontEndToken", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    "\"\<SelectPreviousWord\>\""}], "]"}], "]"}]}], "]"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"NotebookApply", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    "\"\<\[AliasIndicator] \[SelectionPlaceholder] \
\[AliasIndicator]\>\""}], "]"}]}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Escape key template for special \
characters.\\nAutoselects previous character if there is no selection.\>\"", 
                 ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{"\"\<Menu  Item\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", "\"\<MenuName\>\"", 
                    "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Style selection as menu item.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "\"\<xxxx\>\"", ",", "\"\<  \>\"", ",", 
                    "\"\<\[FilledRightTriangle]\>\"", ",", "\"\<  \>\"", ",", 
                    "\"\<\[SelectionPlaceholder]\>\""}], "}"}], "]"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", " ", ":>", " ", 
                    RowBox[{"CompoundExpression", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SameQ", "[", 
                    RowBox[{
                    RowBox[{"NotebookRead", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"FrontEnd`FrontEndToken", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    "\"\<SelectPreviousWord\>\""}], "]"}], "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"NotebookApply", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"TextData", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<xxxx\>\"", ",", "\"\<MenuName\>\""}], "]"}], 
                    ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\< \[FilledRightTriangle] \>\"", ",", 
                    "\"\<MenuNameDelimiter\>\""}], "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\[SelectionPlaceholder]\>\"", ",", 
                    "\"\<MenuName\>\""}], "]"}]}], "}"}], "]"}]}], "]"}]}], 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Menu item template.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Pointer  Event\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonData", "\[RuleDelayed]", 
                    RowBox[{"Hold", "[", 
                    RowBox[{
                    "DocumentationTools`StyleApply", "[", 
                    "\"\<PointerEvent\>\"", "]"}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Style selection as pointer or action event item.\>\"", 
                 ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"RowBox", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<xxxx\>\"", ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<\[NegativeVeryThinSpace]+\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", " ", 
                    "\"\<\[VeryThinSpace]\[SelectionPlaceholder]\
\[VeryThinSpace]\>\""}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", "\[RuleDelayed]", 
                    RowBox[{"CompoundExpression", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SameQ", "[", 
                    RowBox[{
                    RowBox[{"NotebookRead", "[", 
                    RowBox[{"InputNotebook", "[", "]"}], "]"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"FrontEndExecute", "[", 
                    RowBox[{"FrontEnd`FrontEndToken", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    "\"\<SelectPrevious\>\""}], "]"}], "]"}]}], "]"}], ",", 
                    RowBox[{"NotebookApply", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    RowBox[{"TextData", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"StyleBox", "[", 
                    RowBox[{"\"\<xxxx\>\"", ",", "\"\<PointerEvent\>\""}], 
                    "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<+\>\"", ",", "\"\<PointerEventDelimiter\>\""}], 
                    "]"}], ",", 
                    RowBox[{"StyleBox", "[", 
                    RowBox[{
                    "\"\<\[SelectionPlaceholder]\>\"", ",", 
                    "\"\<PointerEvent\>\""}], "]"}]}], "}"}], "]"}]}], 
                    "]"}]}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Pointer event template for click+drag.\\nAutoselects \
previous character if there is no selection.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"SuperscriptBox", "[", 
                    RowBox[{
                    "\"\<\[SelectionPlaceholder]\>\"", ",", "\"\<st\>\""}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", " ", ":>", " ", 
                    RowBox[{
                    "DocumentationTools`RaisedOrdinal", "[", "\"\<st\>\"", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Adds st as superscript to selection or word ahead of \
cursor.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"SuperscriptBox", "[", 
                    RowBox[{
                    "\"\<\[SelectionPlaceholder]\>\"", ",", "\"\<nd\>\""}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", " ", ":>", " ", 
                    RowBox[{
                    "DocumentationTools`RaisedOrdinal", "[", "\"\<nd\>\"", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Adds nd as superscript to selection or word ahead of \
cursor.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"SuperscriptBox", "[", 
                    RowBox[{
                    "\"\<\[SelectionPlaceholder]\>\"", ",", "\"\<rd\>\""}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", " ", ":>", " ", 
                    RowBox[{
                    "DocumentationTools`RaisedOrdinal", "[", "\"\<rd\>\"", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Adds rd as superscript to selection or word ahead of \
cursor.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                   RowBox[{"SuperscriptBox", "[", 
                    RowBox[{
                    "\"\<\[SelectionPlaceholder]\>\"", ",", "\"\<th\>\""}], 
                    "]"}], ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", " ", ":>", " ", 
                    RowBox[{
                    "DocumentationTools`RaisedOrdinal", "[", "\"\<th\>\"", 
                    "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Adds th as superscript to selection or word ahead of \
cursor.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], "}"}],
               ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"TooltipBox", "[", 
                RowBox[{
                 RowBox[{"ButtonBox", "[", 
                  RowBox[{
                  "\"\<Line  Separator\>\"", ",", "\[IndentingNewLine]", 
                   RowBox[{"ButtonFunction", " ", ":>", " ", 
                    RowBox[{"NotebookApply", "[", 
                    RowBox[{
                    RowBox[{"InputNotebook", "[", "]"}], ",", 
                    "\"\<\[LineSeparator]\>\""}], "]"}]}], ",", 
                   RowBox[{"BaseStyle", "\[Rule]", "\"\<MediumButton\>\""}]}],
                   "]"}], ",", "\[IndentingNewLine]", 
                 "\"\<Equivalent to soft carriage return. Shortcut: \
esc-ls-esc.\>\"", ",", 
                 RowBox[{"TooltipDelay", "\[Rule]", "0.35`"}]}], "]"}], 
               "}"}]}], "\[IndentingNewLine]", "}"}], "]"}], "]"}], ",", 
          "\"\<PaletteGridCell\>\"", ",", "goodiesGridOpts"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"SpacerCell", "[", "1", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", "goodiesPalOpts", ",", 
      RowBox[{"StyleDefinitions", "\[Rule]", "goodiesStyDefs"}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NotebookSave", "[", 
   RowBox[{"goodiesNB", ",", 
    RowBox[{"SystemDialogInput", "[", 
     RowBox[{"\"\<FileSave\>\"", ",", 
      RowBox[{"ToFileName", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "$PreferencesDirectory", ",", "\"\<Autoload\>\"", ",", 
          "\"\<DocumentationTools\>\"", ",", "\"\<FrontEnd\>\"", ",", 
          "\"\<TextResources\>\""}], "}"}], ",", "\"\<SpecialForms.nb\>\""}], 
       "]"}]}], "]"}]}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.3460283233376403`*^9, {3.34903019348166*^9, 3.34903019403246*^9}, {
   3.35112012346621*^9, 3.3511201359275303`*^9}, {3.3511201700493097`*^9, 
   3.35112018517749*^9}, {3.36647751228677*^9, 3.36647751263728*^9}, {
   3.3707299972842627`*^9, 3.370730011161285*^9}, {3.370730134360208*^9, 
   3.370730194744307*^9}, {3.370730364776104*^9, 3.37073036581514*^9}, {
   3.3707304979298286`*^9, 3.3707306381924057`*^9}, {3.37073119955643*^9, 
   3.370731263121764*^9}, {3.3707313279767017`*^9, 3.370731331132546*^9}, {
   3.370731430582089*^9, 3.37073145678706*^9}, {3.370731546024146*^9, 
   3.370731593587783*^9}, {3.370731703806817*^9, 3.370731704509554*^9}, {
   3.370731753315268*^9, 3.370731772530998*^9}, {3.3707318162727613`*^9, 
   3.370731826209317*^9}, {3.3707318735939713`*^9, 3.370731881686211*^9}, 
   3.370731927189989*^9, {3.370732251692761*^9, 3.370732302007121*^9}, {
   3.3707323627688828`*^9, 3.370732396983659*^9}, {3.3707324275681067`*^9, 
   3.370732604221386*^9}, 3.3707328653645077`*^9, {3.3707329090259733`*^9, 
   3.370732999118235*^9}, {3.3707330524050694`*^9, 3.370733058684692*^9}, {
   3.370733107040558*^9, 3.3707331095241327`*^9}, {3.3707332003958073`*^9, 
   3.370733396908045*^9}, 3.3707334869998093`*^9, {3.370793592091814*^9, 
   3.3707936431981564`*^9}, 3.3707939063717833`*^9, {3.3708099568146415`*^9, 
   3.370809964596219*^9}, {3.3708100139897056`*^9, 3.3708100208799567`*^9}, {
   3.3708100520863853`*^9, 3.3708100583757424`*^9}, {3.372866633954989*^9, 
   3.372866645921637*^9}, 3.372868321680811*^9, {3.375235230527969*^9, 
   3.375235322638685*^9}, {3.375235420739561*^9, 3.37523543212185*^9}, {
   3.375235468635757*^9, 3.375235495718441*^9}, {3.375235569008606*^9, 
   3.375235688690423*^9}, {3.3752357913221283`*^9, 3.375235796684967*^9}, {
   3.375235838239564*^9, 3.375235865949526*^9}, {3.375235913887414*^9, 
   3.3752359194432583`*^9}, {3.37529112263297*^9, 3.3752911527071133`*^9}, {
   3.3752911955700293`*^9, 3.3752912446520743`*^9}, {3.3752913177493696`*^9, 
   3.3752913344438744`*^9}, {3.3752913659801645`*^9, 
   3.3752914436942368`*^9}, {3.3752915005677185`*^9, 3.3752915976001463`*^9}, 
   3.375291636497241*^9, 3.375291667362547*^9, {3.3752917397788424`*^9, 
   3.3752917407402534`*^9}, {3.3752917805687156`*^9, 3.375291849429793*^9}, {
   3.375291956506965*^9, 3.375292056313465*^9}, {3.375292091935753*^9, 
   3.375292314272108*^9}, {3.3752923638649025`*^9, 3.3752923660981803`*^9}, {
   3.3752924163118863`*^9, 3.3752924455948687`*^9}, {3.3835941912633543`*^9, 
   3.383594199751157*^9}, {3.38456279936864*^9, 3.3845628028018513`*^9}, {
   3.387304004561418*^9, 3.387304106063387*^9}, {3.4583030159402504`*^9, 
   3.458303047365343*^9}, {3.4615037315572987`*^9, 3.4615037436363516`*^9}, {
   3.461619637163496*^9, 3.461619638163509*^9}, {3.462206352564909*^9, 
   3.462206357377471*^9}, 3.462206734897928*^9}]
}, Closed]]
},
WindowSize->{885, 831},
WindowMargins->{{2, Automatic}, {Automatic, 0}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 1020, 16, 101, "Text"],
Cell[CellGroupData[{
Cell[1590, 40, 104, 1, 71, "Section"],
Cell[1697, 43, 5677, 118, 352, "Input"],
Cell[7377, 163, 96, 2, 31, "Input"],
Cell[7476, 167, 26811, 547, 1952, "Input"],
Cell[34290, 716, 808, 18, 31, "Input"],
Cell[35101, 736, 585, 15, 52, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[35723, 756, 33, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[35781, 760, 93, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[35899, 765, 149, 2, 27, "Subsubsection"],
Cell[36051, 769, 17283, 334, 1392, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[53371, 1108, 102, 1, 21, "Subsubsection"],
Cell[53476, 1111, 14167, 259, 792, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[67680, 1375, 100, 1, 21, "Subsubsection"],
Cell[67783, 1378, 26890, 508, 2352, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[94710, 1891, 175, 2, 21, "Subsubsection"],
Cell[94888, 1895, 20355, 386, 1412, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[115280, 2286, 155, 2, 21, "Subsubsection"],
Cell[115438, 2290, 8876, 164, 672, "Input"],
Cell[124317, 2456, 7434, 138, 532, "Input"],
Cell[131754, 2596, 11705, 218, 932, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[143496, 2819, 154, 2, 21, "Subsubsection"],
Cell[143653, 2823, 16707, 328, 1412, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[160397, 3156, 163, 2, 21, "Subsubsection"],
Cell[160563, 3160, 541, 13, 31, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[161141, 3178, 149, 2, 21, "Subsubsection"],
Cell[161293, 3182, 5939, 122, 452, "Input"],
Cell[167235, 3306, 10736, 213, 912, "Input"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[178020, 3525, 98, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[178143, 3530, 104, 1, 27, "Subsubsection"],
Cell[178250, 3533, 3457, 72, 272, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[181744, 3610, 110, 1, 21, "Subsubsection"],
Cell[181857, 3613, 14987, 259, 1052, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[196881, 3877, 134, 2, 21, "Subsubsection"],
Cell[197018, 3881, 13332, 260, 1072, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[210387, 4146, 109, 1, 21, "Subsubsection"],
Cell[210499, 4149, 4927, 100, 332, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[215475, 4255, 141, 2, 28, "Subsection"],
Cell[CellGroupData[{
Cell[215641, 4261, 148, 2, 27, "Subsubsection"],
Cell[215792, 4265, 3366, 70, 292, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[219195, 4340, 154, 2, 21, "Subsubsection"],
Cell[219352, 4344, 13543, 257, 1152, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[232944, 4607, 145, 2, 28, "Subsection"],
Cell[CellGroupData[{
Cell[233114, 4613, 151, 2, 27, "Subsubsection"],
Cell[233268, 4617, 3331, 70, 292, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[236636, 4692, 157, 2, 21, "Subsubsection"],
Cell[236796, 4696, 24305, 471, 2012, "Input"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[261150, 5173, 102, 1, 28, "Subsection"],
Cell[261255, 5176, 5248, 87, 672, "Input"],
Cell[266506, 5265, 224, 4, 29, "Text"],
Cell[266733, 5271, 3364, 53, 72, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[270146, 5330, 114, 1, 41, "Section"],
Cell[270263, 5333, 3645, 80, 252, "Input"],
Cell[273911, 5415, 9202, 204, 832, "Input"],
Cell[283116, 5621, 1451, 29, 92, "Input"],
Cell[284570, 5652, 541, 13, 31, "Input"],
Cell[285114, 5667, 38119, 750, 2472, "Input"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
